from flask import Blueprint, render_template, session, redirect, url_for, flash, request
import requests
from decouple import config

dashboard_bp = Blueprint('dashboard', __name__)


POST_APPOINTMENT_URL = config('POST_APPOINTMENT_URL')

# Strona dashboard (dostępna tylko dla zalogowanych użytkowników)
@dashboard_bp.route('/dashboard')
def dashboard():
    view = request.args.get('view', 'home') 
    if 'token' not in session :
        flash('Musisz być zalogowany, aby zobaczyć tę stronę', 'danger')
        return redirect(url_for('login'))
    return render_template('dashboard.html', view=view)

@dashboard_bp.route('/add-appointment', methods = ['POST', 'GET'])
def addAppointment():
    appointmentData = {
        'User_ID':session['user']['User_ID'],
        'Appointment_ID': 'NULL',
        'Date_Time': request.form['appointmentDateTime'].replace('T',' ')+":00",
        'Client_Name': request.form['clientName'],
        'Client_Lastname': request.form['clientLastName'],
        'Phone_Number': request.form['phoneNumber'],
        'Service_Details': request.form['serviceDetails'],
    }
    headers={
        'auth':"Bearer "+session['token']
    }
    
    response = requests.post(POST_APPOINTMENT_URL,data=appointmentData, headers=headers)
    if response.status_code == 200:
        print("Zostało dodane")
        print("Response Text:", response.text)
    else:
        print("Nie zostało dodane.")
        print("Response Text:", response.text)


    return redirect(url_for('dashboard.dashboard', view='home'))