from flask import Blueprint, redirect, url_for, flash, session, render_template
from flask_dance.contrib.google import google
import requests
from decouple import config

google_login_bp = Blueprint('google_login', __name__)  # Tworzymy blueprint dla logowania Google

API_BASE = config('API_BASE')
LOGIN_URL = config('LOGIN_URL')
REGISTER_URL = config('REGISTER_URL')

@google_login_bp.route('/login_by_google')
def google_login():
    """
    Obsługa logowania przez Google OAuth.
    """
    # Sprawdza, czy użytkownik jest autoryzowany przez Google
    if not google.authorized:
        return redirect(url_for('google.login'))

    # Pobiera dane użytkownika z Google
    resp = google.get('/oauth2/v2/userinfo')
    if resp.ok:
        user_info = resp.json()
        email = user_info['email']

        # Pobierz numer telefonu z Google People API
        headers = {"Authorization": f"Bearer {google.token['access_token']}"}
        response_phone_number = requests.get(
            "https://people.googleapis.com/v1/people/me?personFields=phoneNumbers",
            headers=headers
        )
        phone_number = "NULL"  # Domyślny numer telefonu, jeśli nie można go pobrać
        if response_phone_number.status_code == 200:
            tel_info = response_phone_number.json()
            phone_number = tel_info.get("phoneNumbers", [{}])[0].get("value", "NULL")

        # Sprawdź, czy użytkownik istnieje w bazie danych
        response = requests.get(f"{API_BASE}/auth/check_user?email={email}")
        if response.status_code == 404:  # Użytkownik nie istnieje, rejestrujemy go
            user_data = {
                'User_ID': 'NULL',
                'Login': email,
                'Password': user_info.get('id'),  # Google ID jako hasło
                'Email': email,
                'Name': user_info.get('given_name', ''),
                'Lastname': user_info.get('family_name', ''),
                'Phone_Number': phone_number
            }
            register_response = requests.post(REGISTER_URL, data=user_data)
            if register_response.status_code != 200:
                flash("Nie udało się zarejestrować użytkownika", 'danger')
                return redirect(url_for('login.login'))

        # Logowanie użytkownika
        login_data = {
            "Login": email,
            "Password": user_info.get('id'),  # Google ID jako hasło
        }
        login_response = requests.post(LOGIN_URL, data=login_data)

        if login_response.status_code == 200:
            data = login_response.json()
            token = data.get('token')

            if token:
                session['token'] = token
                session['user'] = data.get('user')[0]
                flash('Zalogowano pomyślnie!', 'success')
                return redirect(url_for('dashboard.dashboard'))
            else:
                flash('Błąd logowania: Brak tokenu w odpowiedzi', 'danger')
        else:
            flash('Błędne dane logowania', 'danger')

    flash('Nie udało się zalogować przez Google.', 'danger')
    return redirect(url_for('login.login'))
    