from flask import Blueprint, render_template, request, redirect, url_for, flash, session
import requests
from flask_dance.contrib.google import google
from flask import current_app
from decouple import config
import json

login_bp = Blueprint('login', __name__)  # Tworzymy blueprint logowania

LOGIN_URL = config('LOGIN_URL')

@login_bp.route('/login', methods=['GET', 'POST'])
def login():
    """
    Funkcja obsługująca logowanie użytkownika.
    """
    if request.method == 'POST':
        login = request.form['login']
        password = request.form['password']

        # Wysłanie żądania POST do API logowania
        response = requests.post(LOGIN_URL, data={'Login': login, 'Password': password})
        
        if response.status_code == 200:
            data = response.json()
            token = data.get('token')

            if token:
                session['token'] = token
                session['user'] = data.get('user')[0]
                flash('Zalogowano pomyślnie!', 'success')
                return redirect(url_for('dashboard.dashboard'))
            else:
                flash('Błąd logowania: Brak tokenu w odpowiedzi', 'danger')
        else:
            flash('Błędny login lub hasło', 'danger')
    return render_template('login.html')

# Funkcja wylogowania
@login_bp.route('/logout')
def logout():
    # Wylogowanie z Google OAuth2 (czyszczenie tokena)
    if google.authorized:
        token = google.token["access_token"]
        requests.post("https://accounts.google.com/o/oauth2/revoke",
                      params={"token": token},
                      headers={"content-type": "application/x-www-form-urlencoded"})
        del google.token  # Usunięcie tokena z Flask-Dance
    session.clear()
    flash('Wylogowano pomyślnie', 'success')
    return redirect(url_for('login.login'))
