/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import * as icons from "../icons.js";
import { kebabCase, pascalCase } from "../utils/rename.js";
function getIconInfo(key) {
  const lowerName = key.toLowerCase();
  const iconName = Object.keys(icons).find((pascalName) => {
    const lowerIconName = pascalName.replace(/Icon$/, "").toLowerCase();
    return lowerIconName == lowerName || lowerIconName + "icon" == lowerName || kebabCase(lowerIconName) == lowerName || lowerIconName == pascalCase(lowerName);
  });
  return icons[iconName];
}
export {
  getIconInfo as default
};
