/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import getIconInfo from "./getIconInfo.js";
function replace(rootElm, config) {
  var _a, _b, _c, _d;
  if (!(window == null ? void 0 : window.document)) {
    throw new Error("proicons.replace() only works in a browser environment");
  }
  rootElm != null ? rootElm : rootElm = document.body;
  const useAttrs = (_a = config == null ? void 0 : config.useAttributes) != null ? _a : true;
  const attr = (_b = config == null ? void 0 : config.attributeName) != null ? _b : "proicon";
  for (const element of rootElm.querySelectorAll(`[${attr}]`)) {
    let toReplace;
    switch ((_c = config == null ? void 0 : config.overwrite) != null ? _c : "auto") {
      case true:
        toReplace = true;
        break;
      case false:
        toReplace = false;
        break;
      case "auto":
        toReplace = !element.hasChildNodes();
        break;
    }
    let iconName = element.getAttribute(attr).trim();
    const iconInfo = getIconInfo(iconName);
    if (!iconInfo) {
      continue;
    }
    let iconElement = document.createElement("svg");
    const propMap = {
      color: "color",
      "stroke-width": "strokeWidth",
      join: "strokeJoin",
      caps: "strokeCaps",
      "corner-radius": "cornerRadius",
      outline: "strokeFilledElements",
      size: "size"
    };
    const elementConfig = {};
    if (useAttrs) {
      for (const [htmlAttr, optionKey] of Object.entries(propMap)) {
        if (element.hasAttribute(htmlAttr)) {
          elementConfig[optionKey] = element.getAttribute(htmlAttr);
          element.removeAttribute(htmlAttr);
        }
      }
      for (const { name, value } of element.attributes) {
        if (!Object.hasOwn(propMap, name)) {
          (_d = elementConfig.attributes) != null ? _d : elementConfig.attributes = {};
          elementConfig.attributes[name] = value;
        }
      }
      Object.assign(structuredClone(config != null ? config : {}), elementConfig);
    }
    iconElement.innerHTML = getIconInfo(iconName).toSvg(elementConfig);
    iconElement = iconElement.children[0];
    iconElement.classList.add("proicon");
    iconElement.setAttribute("data-proicon-id", getIconInfo(iconName).kebabCase);
    toReplace == true ? element.replaceWith(iconElement) : element.insertBefore(iconElement, element.childNodes[0]);
  }
}
export {
  replace as default
};
