/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import * as icons from "../icons.js";
function search(query) {
  const mappedIcons = Object.values(icons);
  const filtered = mappedIcons.filter((item) => {
    return Object.entries(item).some(
      ([key, value]) => {
        if (!Array.isArray(value) && typeof value != "string" || key == "raw")
          return;
        return Array.isArray(value) ? value.some(
          (tag) => tag.toLowerCase().includes(query.toLowerCase())
        ) : value.toLowerCase().includes(query.toLowerCase());
      }
    );
  });
  return filtered;
}
export {
  search as default
};
