/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AirplaneTakeoffIcon = createIcon(
  {
    name: "Airplane Takeoff",
    tags: [
      "Aircraft",
      "Plane",
      "Aviation",
      "Jet",
      "Boeing",
      "Airbus",
      "Flight",
      "Aeroplane",
      "Airplane Mode",
      "Flight Mode",
      "Fly",
      "TO",
      "Climb"
    ],
    category: "Places & Transportation",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M2.75 20.75h18.5M18.575 6.299a1.783 1.783 0 0 1 1.783 3.089L11.31 14.61a4 4 0 0 1-1.377.49l-2.604.422a3.04 3.04 0 0 1-2.725-.948L2.91 12.723a.607.607 0 0 1 .145-.936l.391-.226a1.52 1.52 0 0 1 1.56.025l1.816 1.128c.19.118.43.122.624.01l3.6-2.078-4.404-5.12a.607.607 0 0 1 .156-.922l.378-.218c.326-.188.73-.18 1.047.02l6.506 4.113z"
      },
      []
    ]
  ]
);
export {
  AirplaneTakeoffIcon
};
