/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AppRemoveIcon = createIcon(
  {
    name: "App Remove",
    tags: ["Uninstall", "Delete App"],
    category: "Actions",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "matrix(1 0 0 -1 3.75 20.25)"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M20.25 20.25 17 17m0 0-3.25-3.25M17 17l-3.25 3.25M17 17l3.25-3.25"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "matrix(1 0 0 -1 3.75 10.25)"
      },
      []
    ],
    [
      "rect",
      {
        width: "6.5",
        height: "6.5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "matrix(1 0 0 -1 13.75 10.25)"
      },
      []
    ]
  ]
);
export {
  AppRemoveIcon
};
