/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const AppleIcon = createIcon(
  {
    name: "Apple",
    tags: [
      "iPhone",
      "iPad",
      "Mac",
      "iOS",
      "iPadOS",
      "watchOS",
      "Watch",
      "Tablet",
      "Phone",
      "Tim Cook",
      "Steve Jobs",
      "macOS",
      "Cupertino"
    ],
    category: "Logos & Brands",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M10.102 7.78a4 4 0 0 0-1.185-.161c-1.918 0-4.167 1.695-4.167 5.359 0 3.36 2.358 7.21 3.801 7.822.328.14.731.227 1.084.193.707-.07 1.348-.421 2.023-.622.228-.038.5-.074.719-.075.24-.002.51.06.774.12.715.164 1.505.65 2.255.577.267-.026.633-.187.746-.239l.07-.03c.85-.343 1.988-1.826 2.759-3.703.162-.396-.052-.833-.404-1.077-.999-.694-1.663-1.934-1.663-3.195 0-.969.313-1.854.907-2.523l.02-.023a8 8 0 0 1 .45-.5c.255-.248.326-.645.082-.904-.808-.854-1.832-1.277-2.764-1.277a3.6 3.6 0 0 0-1.106.156c-.138.033-.778.192-1.222.355-.257.071-.635.167-.81.21a.7.7 0 0 1-.192.023c-.735-.024-1.47-.303-2.177-.487Z",
        "clip-rule": "evenodd"
      },
      []
    ],
    [
      "path",
      {
        fill: "currentColor",
        stroke: "currentColor",
        "stroke-linejoin": "round",
        d: "M13.86 5.178c-.733.878-1.975 1.047-1.975 1.047s-.05-1.256.684-2.135 1.976-1.046 1.976-1.046.05 1.256-.684 2.134Z"
      },
      []
    ]
  ]
);
export {
  AppleIcon
};
