/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const ArrowUpDownIcon = createIcon(
  {
    name: "Arrow Up Down",
    tags: ["Up-Down", "Bidirectional", "Vertical", "Height", "Size"],
    category: "Arrows",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "m7 16.25 3.94 3.94c.292.292.676.439 1.06.439m5-4.379-3.94 3.94a1.5 1.5 0 0 1-1.06.439M7 7.75l3.94-3.94A1.5 1.5 0 0 1 12 3.371m5 4.379-3.94-3.94A1.5 1.5 0 0 0 12 3.372m0 0V20.63"
      },
      []
    ]
  ]
);
export {
  ArrowUpDownIcon
};
