/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const BellDotIcon = createIcon(
  {
    name: "Bell Dot",
    tags: ["New Notification", "Alert", "Unread"],
    category: "Status",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M18.477 9.75v3.64a3 3 0 0 0 .456 1.59l1.09 1.74a1 1 0 0 1-.849 1.53H4.826a1 1 0 0 1-.848-1.53l1.088-1.74a3 3 0 0 0 .457-1.59V9.226A6.477 6.477 0 0 1 14.52 3.26"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M10 21.25h4"
      },
      []
    ],
    ["circle", { cx: "18.5", cy: "5.5", r: "2.5", fill: "currentColor" }, []]
  ]
);
export {
  BellDotIcon
};
