/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const BranchPullRequestIcon = createIcon(
  {
    name: "Branch Pull Request",
    tags: ["Git"],
    category: "Development",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M8.25 5.5a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0m13 13a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0m-13 0a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0M5.5 8.25v7.5"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M18.5 15.75V8.5a3 3 0 0 0-3-3h-4.336M13.25 8l-1.793-1.793a1 1 0 0 1-.293-.707M13.25 3l-1.793 1.793a1 1 0 0 0-.293.707"
      },
      []
    ]
  ]
);
export {
  BranchPullRequestIcon
};
