/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const CalculatorIcon = createIcon(
  {
    name: "Calculator",
    tags: ["Solve", "Math"],
    category: "Math & Numbers",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "14.5",
        height: "18.5",
        x: "4.75",
        y: "2.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "rect",
      {
        width: "7.5",
        height: "3.75",
        x: "8.25",
        y: "6.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "1"
      },
      []
    ],
    ["circle", { cx: "8.5", cy: "13.5", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "12", cy: "13.5", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "15.5", cy: "13.5", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "8.5", cy: "17.5", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "12", cy: "17.5", r: "1", fill: "currentColor" }, []],
    ["circle", { cx: "15.5", cy: "17.5", r: "1", fill: "currentColor" }, []]
  ]
);
export {
  CalculatorIcon
};
