/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const CartIcon = createIcon(
  {
    name: "Cart",
    tags: ["Shopping", "Trolley", "Amazon", "Shopping Cart"],
    category: "Activities",
    deprecated: false
  },
  [
    [
      "circle",
      {
        cx: "9.549",
        cy: "19.049",
        r: "1.701",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5"
      },
      []
    ],
    [
      "circle",
      {
        cx: "16.96",
        cy: "19.049",
        r: "1.701",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "m5.606 5.555 2.01 6.364c.309.978.463 1.467.76 1.829.26.32.599.567.982.72.435.173.947.173 1.973.173h3.855c1.026 0 1.538 0 1.972-.173.384-.153.722-.4.983-.72.296-.362.45-.851.76-1.829l.409-1.296.24-.766.331-1.05a2.5 2.5 0 0 0-2.384-3.252zm0 0-.011-.037a7 7 0 0 0-.14-.42 2.92 2.92 0 0 0-2.512-1.84C2.84 3.25 2.727 3.25 2.5 3.25"
      },
      []
    ]
  ]
);
export {
  CartIcon
};
