/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const CenterHorizontalIcon = createIcon(
  {
    name: "Center Horizontal",
    tags: ["Stats", "Statistics", "Data", "Graph", "Chart"],
    category: "Organization",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M20.25 20.25V3.75m-16.5 16.5V3.75"
      },
      []
    ],
    [
      "rect",
      {
        width: "6",
        height: "13",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "matrix(-1 0 0 1 15 5.5)"
      },
      []
    ]
  ]
);
export {
  CenterHorizontalIcon
};
