/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const CenterVerticalIcon = createIcon(
  {
    name: "Center Vertical",
    tags: ["Stats", "Statistics", "Data", "Graph", "Chart"],
    category: "Organization",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M3.75 20.25h16.5M3.75 3.75h16.5"
      },
      []
    ],
    [
      "rect",
      {
        width: "6",
        height: "13",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "2",
        transform: "matrix(0 -1 -1 0 18.5 15)"
      },
      []
    ]
  ]
);
export {
  CenterVerticalIcon
};
