/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const ClipboardIcon = createIcon(
  { name: "Clipboard", tags: [""], category: "Layout", deprecated: false },
  [
    [
      "rect",
      {
        width: "16.5",
        height: "18.5",
        x: "3.75",
        y: "2.75",
        stroke: "currentColor",
        "stroke-width": "1.5",
        rx: "3.5"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-width": "1.5",
        d: "M8.25 2.75h7.5v2.5a2 2 0 0 1-2 2h-3.5a2 2 0 0 1-2-2z"
      },
      []
    ]
  ]
);
export {
  ClipboardIcon
};
