/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const ClipboardSearchIcon = createIcon(
  { name: "Clipboard Search", tags: [""], category: "Layout", deprecated: false },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M14.25 21.25h3a3.5 3.5 0 0 0 3.5-3.5V6.25a3.5 3.5 0 0 0-3.5-3.5h-9.5a3.5 3.5 0 0 0-3.5 3.5v4"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-width": "1.5",
        d: "M8.75 2.75h7.5v2.5a2 2 0 0 1-2 2h-3.5a2 2 0 0 1-2-2z"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M9.17 19.67a4.054 4.054 0 1 0-5.733-5.733A4.054 4.054 0 0 0 9.17 19.67m0 0 2.58 2.58"
      },
      []
    ]
  ]
);
export {
  ClipboardSearchIcon
};
