/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const ClosedCaptionsIcon = createIcon(
  {
    name: "Closed Captions",
    tags: [""],
    category: "System & Interface",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "18.5",
        height: "14.5",
        x: "2.75",
        y: "4.75",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "4"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M10.5 14.382a2.75 2.75 0 1 1 0-4.764m7.125 4.764a2.75 2.75 0 1 1 0-4.764"
      },
      []
    ]
  ]
);
export {
  ClosedCaptionsIcon
};
