/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const CompassIcon = createIcon(
  {
    name: "Compass",
    tags: ["Direction", "Explore", "Safari"],
    category: "Activities",
    deprecated: false
  },
  [
    [
      "circle",
      {
        cx: "12",
        cy: "12",
        r: "9.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M10.195 10.195q.221-.22.475-.404c.382-.275.835-.456 1.74-.818l2.357-.943c.632-.252.947-.379 1.148-.313.174.058.31.194.368.368.066.2-.06.517-.313 1.148l-.943 2.357c-.362.905-.543 1.358-.818 1.74q-.183.255-.404.475m-3.61-3.61a4 4 0 0 0-.404.475c-.275.382-.456.835-.818 1.74l-.943 2.357c-.252.632-.379.947-.313 1.148.058.174.194.31.368.368.2.066.516-.06 1.148-.313l2.357-.943c.905-.362 1.358-.543 1.74-.818q.255-.183.475-.404m-3.61-3.61 3.61 3.61"
      },
      []
    ]
  ]
);
export {
  CompassIcon
};
