/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const CreditCardIcon = createIcon(
  {
    name: "Credit Card",
    tags: ["Debit Card", "Payment"],
    category: "Security",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "18.5",
        height: "14",
        x: "2.75",
        y: "5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "path",
      { stroke: "currentColor", "stroke-width": "1.5", d: "M2.75 9.5h18.5" },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-width": "1.5",
        d: "M14.75 14.25h3"
      },
      []
    ]
  ]
);
export {
  CreditCardIcon
};
