/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const DoorIcon = createIcon(
  {
    name: "Door",
    tags: ["Closed"],
    category: "Places & Transportation",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M5.25 6.25a2.5 2.5 0 0 1 2.5-2.5h8.5a2.5 2.5 0 0 1 2.5 2.5v15H5.25zm-2.5 15h18.5"
      },
      []
    ],
    ["circle", { cx: "15.25", cy: "12.5", r: "1.5", fill: "currentColor" }, []]
  ]
);
export {
  DoorIcon
};
