/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const LockOpenIcon = createIcon(
  {
    name: "Lock Open",
    tags: ["Unlock", "Unsafe"],
    category: "Security",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "14.478",
        height: "12.87",
        x: "4.761",
        y: "8.38",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M8.783 8.38V5.967a3.217 3.217 0 0 1 6.132-1.363"
      },
      []
    ],
    ["circle", { cx: "12", cy: "14.815", r: "1.5", fill: "currentColor" }, []]
  ]
);
export {
  LockOpenIcon
};
