/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const MailIcon = createIcon(
  {
    name: "Mail",
    tags: ["Gmail", "Outlook", "Yahoo", "Inbox", "Unread", "Envelope"],
    category: "Communication & Cloud",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "18.5",
        height: "15.5",
        x: "2.75",
        y: "4.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "m2.75 8 8.415 3.866a2 2 0 0 0 1.67 0L21.25 8"
      },
      []
    ]
  ]
);
export {
  MailIcon
};
