/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const MentionIcon = createIcon(
  {
    name: "Mention",
    tags: ["@", "Tag", "@mention", "At"],
    category: "Communication & Cloud",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M16.625 20.01A9.25 9.25 0 1 1 21.25 12v1.5a2.5 2.5 0 0 1-2.5 2.5v0a2.5 2.5 0 0 1-2.5-2.5V12m0 0a4.25 4.25 0 1 1-8.5 0 4.25 4.25 0 0 1 8.5 0m0 0V7.75"
      },
      []
    ]
  ]
);
export {
  MentionIcon
};
