/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const MotherboardIcon = createIcon(
  {
    name: "Motherboard",
    tags: [
      "Computer Board",
      "Chip",
      "Components",
      "Transistor",
      "Silicon",
      "PC",
      "CPU"
    ],
    category: "Technology",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "13.5",
        height: "13.5",
        x: "5.25",
        y: "5.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M18.75 8.75h2.5M18.75 12h2.5m-2.5 3.25h2.5m-6 3.5v2.5M12 18.75v2.5m-3.25-2.5v2.5m-6-12.5h2.5M2.75 12h2.5m-2.5 3.25h2.5m10-12.5v2.5M12 2.75v2.5m-3.25-2.5v2.5"
      },
      []
    ],
    [
      "rect",
      {
        width: "5",
        height: "5",
        x: "9.5",
        y: "9.5",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "1"
      },
      []
    ]
  ]
);
export {
  MotherboardIcon
};
