/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const ReactjsIcon = createIcon(
  {
    name: "ReactJS",
    tags: ["Framework", "JavaScript", "Meta", "Facebook"],
    category: "Logos & Brands",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M12 8.013c-5.385 0-9.75 1.785-9.75 3.987s4.365 3.987 9.75 3.987 9.75-1.785 9.75-3.987S17.385 8.013 12 8.013"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M15.423 10.006c-2.692-4.704-6.407-7.625-8.298-6.524-1.89 1.101-1.24 5.807 1.452 10.512 2.692 4.704 6.408 7.625 8.298 6.524s1.24-5.807-1.452-10.512"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M15.423 13.994c2.693-4.705 3.343-9.41 1.452-10.512-1.89-1.1-5.606 1.82-8.298 6.524s-3.342 9.41-1.452 10.512c1.89 1.1 5.606-1.82 8.298-6.524"
      },
      []
    ],
    ["circle", { cx: "12", cy: "12", r: "1.5", fill: "currentColor" }, []]
  ]
);
export {
  ReactjsIcon
};
