/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const SvelteIcon = createIcon(
  {
    name: "Svelte",
    tags: ["SvelteKit", "Framework", "JavaScript", "Compiler"],
    category: "Logos & Brands",
    deprecated: false
  },
  [
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M18.878 10.881a5.63 5.63 0 0 1-2.181 7.44l-3.757 2.175a5.596 5.596 0 0 1-7.656-2.057 5.63 5.63 0 0 1-.162-5.32 5.63 5.63 0 0 1 2.181-7.44l3.757-2.175a5.596 5.596 0 0 1 7.656 2.057 5.63 5.63 0 0 1 .162 5.32"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M16.011 8.912a2.2 2.2 0 0 0-.228-1.653 2.195 2.195 0 0 0-3-.813l-3.8 2.2a2.207 2.207 0 0 0-.798 3.012 2.195 2.195 0 0 0 3.001.813l1.628-.942a2.195 2.195 0 0 1 3 .813 2.207 2.207 0 0 1-.797 3.012l-3.8 2.2a2.195 2.195 0 0 1-3-.813 2.2 2.2 0 0 1-.228-1.653"
      },
      []
    ]
  ]
);
export {
  SvelteIcon
};
