/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const TerminalIcon = createIcon(
  {
    name: "Terminal",
    tags: ["Cmd", "Command Prompt", "Bash", "Powershell", "Ps"],
    category: "Development",
    deprecated: false
  },
  [
    [
      "rect",
      {
        width: "18.5",
        height: "15.5",
        x: "2.75",
        y: "4.25",
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        rx: "3.5"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "m7.25 9 3 3-3 3m5.5 0h4"
      },
      []
    ]
  ]
);
export {
  TerminalIcon
};
