/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { createIcon } from "../utils/createIcon.js";
const UbuntuIcon = createIcon(
  {
    name: "Ubuntu",
    tags: ["Canonical", "Linux", "Mark Shuttleworth", "Open Source"],
    category: "Logos & Brands",
    deprecated: false
  },
  [
    [
      "circle",
      {
        cx: "12.75",
        cy: "12",
        r: "4.75",
        stroke: "currentColor",
        "stroke-width": "1.5"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-linecap": "round",
        "stroke-linejoin": "round",
        "stroke-width": "1.5",
        d: "M14.546 20.054a8.254 8.254 0 0 1-9.67-5.582m13.95 3.109A8.22 8.22 0 0 0 21 12a8.22 8.22 0 0 0-2.174-5.582m-4.28-2.473a8.254 8.254 0 0 0-9.67 5.582"
      },
      []
    ],
    [
      "path",
      {
        stroke: "currentColor",
        "stroke-width": "1.5",
        d: "M15.625 16.98a2.5 2.5 0 1 1 2.5 4.33 2.5 2.5 0 0 1-2.5-4.33ZM4.5 9.5a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5Zm11.125-6.81a2.5 2.5 0 1 1 2.5 4.33 2.5 2.5 0 0 1-2.5-4.33Z"
      },
      []
    ]
  ]
);
export {
  UbuntuIcon
};
