var __typeError = (msg) => {
  throw TypeError(msg);
};
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
var _nodes;
import { kebabCase, camelCase } from "./utils/rename.js";
import { renderNodeWithRoot, convertNodesWithConfig, rootNode } from "./utils/renderNodes.js";
class ProIcon {
  /**
   *
   * @param name The name of the icon in Friendly Form
   * @param kebabCase The name of the icon in kebab-case
   * @param camelCase The name of the icon in camelCase
   * @param category The category of the icon.
   * @param tags An array of the icon's tags.
   */
  constructor(name, tags, category, nodes) {
    __privateAdd(this, _nodes, []);
    this.name = name;
    this.kebabCase = kebabCase(name);
    this.camelCase = camelCase(name);
    this.tags = tags != null ? tags : [];
    this.category = category;
    __privateSet(this, _nodes, nodes);
    this.raw = this.toSvg();
  }
  /**
   * Returns an SVG string from the icon with the provided options
   * Note that this also works outside of a browser environment
   * @param options Customization options for the icon
   */
  toSvg(options) {
    return renderNodeWithRoot(
      convertNodesWithConfig(__privateGet(this, _nodes), options),
      rootNode,
      options
    );
  }
}
_nodes = new WeakMap();
export {
  ProIcon
};
