/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
import { ProIcon } from "../types.js";
function createIcon({ name, tags, category, deprecated, alternativeIcon }, nodes) {
  if (deprecated) {
    console.warn(
      `The icon ${name} is deprecated and will be removed in a future version. Use ${alternativeIcon} instead.`
    );
  }
  return new ProIcon(name, tags, category, nodes);
}
export {
  createIcon
};
