/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
function format(str) {
  return str.replace(/[-_()]/g, " ").replace(/\s\s+/g, " ");
}
function camelCase(str) {
  return format(str).split(" ").map((word, i) => i == 0 ? word.toLowerCase() : word.charAt(0).toUpperCase() + word.slice(1)).join("");
}
function kebabCase(str) {
  return format(str).replaceAll(" ", "-").toLowerCase();
}
function pascalCase(str) {
  return format(str).replaceAll(" ", "");
}
export {
  camelCase,
  format,
  kebabCase,
  pascalCase
};
