/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
const rootNode = [
  "svg",
  {
    width: "24",
    height: "24",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 24 24",
    fill: "none"
  },
  []
];
function convertNodesWithConfig(nodes, options) {
  const defaultStroke = 1.5;
  const attributeKey = {
    // configKey, svgAttr
    color: ["stroke", "fill"],
    strokeWidth: ["stroke-width"],
    strokeCaps: ["stroke-linejoin"],
    strokeJoin: ["stroke-linecap"],
    cornerRadius: ["rx"],
    strokeFilledElements: void 0
  };
  if (!options) return nodes;
  return nodes.map((node) => {
    var _a, _b, _c;
    const children = node[2];
    for (const [optionK, svgAttrs] of Object.entries(attributeKey)) {
      if (svgAttrs) {
        for (const s of svgAttrs) {
          if (node[1][s] && options[optionK]) {
            node[1][s] = options[optionK];
          }
        }
      }
    }
    if (!Object.hasOwn(node[1], "stroke-width") && Object.hasOwn(node[1], "fill") && node[1].fill != "none" && node[1].stroke != "none" && node[1]["stroke-width"] !== "0" && ((_a = options == null ? void 0 : options.strokeWidth) != null ? _a : 0) > defaultStroke) {
      node[1]["stroke-width"] = (options.strokeWidth - defaultStroke).toString();
      node[1].stroke = node[1].fill;
      node[1]["stroke-linecap"] = (_b = options.strokeCaps) != null ? _b : "round";
      node[1]["stroke-linejoin"] = (_c = options.strokeJoin) != null ? _c : "round";
    }
    if (children.length) {
      node[2] = convertNodesWithConfig(children, options);
    }
    return node;
  });
}
function renderNodeWithRoot(nodes, rootNode2, options) {
  const root = structuredClone(rootNode2);
  root[2].push(...nodes);
  if (options == null ? void 0 : options.size) {
    root[1].width = options.size.toString();
    root[1].height = options.size.toString();
  }
  if (options == null ? void 0 : options.attributes) {
    for (const [k, v] of Object.entries(options.attributes)) {
      root[1][k] = v;
    }
  }
  return renderNodes([root]);
}
function renderNodes(nodes) {
  return nodes.map(([element, attrs, children]) => {
    const attrMap = Object.entries(attrs).map(([k, v]) => `${k}=${JSON.stringify(v)}`);
    return `<${element} ${attrMap.join(" ")}${children.length > 0 ? `>${renderNodes(children)}</${element}>` : " />"}`;
  }).join("");
}
export {
  convertNodesWithConfig,
  renderNodeWithRoot,
  renderNodes,
  rootNode
};
