document.getElementById("menuButton").addEventListener("click", () => {
    const menuBar = document.getElementById("menuBar");
    const personButton = document.getElementById("personButton");
    const textElements = document.querySelectorAll("#menuBar span");
    const userInfo = document.getElementById("userInfo");

    if (menuBar.classList.contains("lg:w-[75px]")) {
        // Rozwiń menu
        menuBar.classList.remove("lg:w-[75px]");
        menuBar.classList.add("lg:w-[240px]");

        personButton.classList.add("hidden");


        setTimeout(() => {
            userInfo.classList.remove("hidden");
            userInfo.classList.add("flex");

            textElements.forEach((span) => {
                span.classList.remove("hidden");
                span.classList.add("block");
            });
        }, 300); // Opóźnienie synchronizowane z czasem animacji

    } else {
        // Zwiń menu
        menuBar.classList.remove("lg:w-[240px]");
        menuBar.classList.add("lg:w-[75px]");
        

        personButton.classList.remove("hidden");

        userInfo.classList.remove("flex");
        userInfo.classList.add("hidden");

        // Ukryj tekst natychmiast
        textElements.forEach((span) => {
            span.classList.remove("block");
            span.classList.add("hidden");
        });
    }
});

function showView(view) {
    // Ukryj oba widoki
    document.getElementById('home-view').classList.add('hidden');
    document.getElementById('settings-view').classList.add('hidden');
    
    // Pokaż wybrany widok
    document.getElementById(`${view}-view`).classList.remove('hidden');
};

document.addEventListener("DOMContentLoaded", () => {
    const dzisiejszeWizyty = document.getElementById("dzisiejszeWizyty");
    const kalendarz = document.getElementById("KalendarzBoard");
    const btnDzisiejszeWizyty = document.getElementById("btn-dzisiejsze-wizyty");
    const btnDodajWizyte = document.getElementById("btn-dodaj-wizyte");
    const btnKalendarz = document.getElementById("btn-kalendarz");
    const modalAddAppointment = document.getElementById("modalAddAppointment"); 
    const btnCloseModalAddAppointment = document.getElementById("btnCloseModalAddAppointment");
    const cancelButtonModalAddAppointment = document.getElementById("cancelButtonModalAddAppointment");

    // Początkowy stan
    kalendarz.classList.add("hidden");
    btnDzisiejszeWizyty.classList.add("bg-customBlue-20");
    btnKalendarz.classList.remove("bg-customBlue-20");
    btnDodajWizyte.classList.remove("bg-customBlue-20");
    modalAddAppointment.classList.add("hidden");

    // Funkcje przełączania widoków
    const showDzisiejszeWizyty = () => {
        dzisiejszeWizyty.classList.remove("hidden");
        btnKalendarz.classList.remove("bg-customBlue-20")
        kalendarz.classList.add("hidden");
        btnDzisiejszeWizyty.classList.add("bg-customBlue-20");
        btnDodajWizyte.classList.remove("bg-customBlue-20");
    };

    const showKalendarz = () => {
        kalendarz.classList.remove("hidden");
        btnDzisiejszeWizyty.classList.remove("bg-customBlue-20");
        dzisiejszeWizyty.classList.add("hidden");
        btnKalendarz.classList.add("bg-customBlue-20");
        btnDodajWizyte.classList.remove("bg-customBlue-20");
    };

    const showDodajWizyte = () => {
        btnDodajWizyte.classList.add("bg-customBlue-20");
        modalAddAppointment.classList.remove("hidden");
    };

    const closeDodajWizyte = () => {
        modalAddAppointment.classList.add("hidden");
        btnDodajWizyte.classList.remove("bg-customBlue-20");
    };

    // Event Listeners dla przycisków
    btnDzisiejszeWizyty.addEventListener("click", (e) => {
        e.preventDefault();
        showDzisiejszeWizyty();
    });

    btnKalendarz.addEventListener("click", (e) => {
        e.preventDefault();
        showKalendarz();
    });

    btnDodajWizyte.addEventListener("click", (e) => {
        e.preventDefault();
        showDodajWizyte();

        btnCloseModalAddAppointment.addEventListener("click", (e) => {
            e.preventDefault();
            closeDodajWizyte();
        });

        cancelButtonModalAddAppointment.addEventListener("click", (e) => {
            e.preventDefault();
            closeDodajWizyte();
        });
    });

    

    
});

