var __typeError = (msg) => {
  throw TypeError(msg);
};
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
/**
 * @license ProIcons v4.11.1 - MIT
 * 
 * This code is licensed under the MIT license.
 * See the LICENSE file in the root directory of the source tree.
 */
(function(global, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global = typeof globalThis !== "undefined" ? globalThis : global || self, factory(global.proicons = {}));
})(this, function(exports2) {
  "use strict";
  var _nodes;
  const categories = [
    "Accents",
    "Actions",
    "Activities",
    "Arrows",
    "Business",
    "Communication & Cloud",
    "Design",
    "Development",
    "Emojis",
    "Files",
    "Food & Drink",
    "Gestures",
    "Layout",
    "Logos & Brands",
    "Math & Numbers",
    "Media",
    "Miscellaneous",
    "Nature",
    "Objects",
    "Organization",
    "Places & Transportation",
    "Security",
    "Shapes",
    "Status",
    "System & Interface",
    "Technology",
    "Text",
    "Weather",
    "Window"
  ];
  const iconList = [
    "Accessibility",
    "Add",
    "Add Circular",
    "Add Rhombus",
    "Add Square",
    "Add Square Multiple",
    "Airplane",
    "Airplane Landing",
    "Airplane Takeoff",
    "Alert Circle",
    "Alert Triangle",
    "Align Bottom",
    "Align Horizontal Centers",
    "Align Left",
    "Align Right",
    "Align Top",
    "Align Vertical Centers",
    "Amazon",
    "Anchor",
    "Android",
    "Angle",
    "App Remove",
    "App Store",
    "Apple",
    "Apps",
    "Apps Add",
    "Apps List",
    "Arc",
    "Archive",
    "Archive Add 2",
    "Arrow Clockwise",
    "Arrow Counterclockwise",
    "Arrow Down",
    "Arrow Download",
    "Arrow Enter",
    "Arrow Export",
    "Arrow Foward",
    "Arrow Import",
    "Arrow Left",
    "Arrow Left Right",
    "Arrow Maximize",
    "Arrow Minimize",
    "Arrow Move",
    "Arrow Redo",
    "Arrow Redo 2",
    "Arrow Reply",
    "Arrow Right",
    "Arrow Rotate Clockwise",
    "Arrow Rotate Counterclockwise",
    "Arrow Sort",
    "Arrow Swap",
    "Arrow Sync",
    "Arrow Sync 2",
    "Arrow Trending",
    "Arrow Undo",
    "Arrow Undo 2",
    "Arrow Up",
    "Arrow Up Down",
    "Arrow Upload",
    "Attatch",
    "Background Color",
    "Background Color Accent",
    "Backspace",
    "Badge",
    "Bar Graph",
    "Battery",
    "Battery Full",
    "Beach",
    "Beaker",
    "Bell",
    "Bell Dot",
    "Bell Off",
    "Bluetooth",
    "Board",
    "Bolt",
    "Book",
    "Book 2",
    "Book Add",
    "Book Add 2",
    "Book Info",
    "Book Info 2",
    "Book Open",
    "Bookmark",
    "Bookmark Add",
    "Bookmark Multiple",
    "Border All",
    "Box",
    "Box Drag",
    "Box Margins",
    "Braces",
    "Braces Variable",
    "Brackets",
    "Branch",
    "Branch Compare",
    "Branch Fork",
    "Branch Fork 2",
    "Branch Pull Request",
    "Briefcase",
    "Briefcase 2",
    "Brightness",
    "Broom",
    "Bug",
    "Building Multiple",
    "Button",
    "CSS",
    "Cake",
    "Calculator",
    "Calendar",
    "Calligraphy Pen",
    "Camera",
    "Cancel",
    "Cancel Circle",
    "Cancel Square",
    "Candy",
    "Cart",
    "Cent",
    "Center Horizontal",
    "Center Vertical",
    "Chat",
    "Checkbox Checked",
    "Checkbox Indeterminate",
    "Checkbox Indeterminate 2",
    "Checkbox Intermediate 2",
    "Checkbox Unchecked",
    "Checkmark",
    "Checkmark Checked",
    "Checkmark Circle",
    "Checkmark Intermediate",
    "Checkmark Starburst",
    "Chevron Down",
    "Chevron Left",
    "Chevron Right",
    "Chevron Up",
    "Chrome Restore",
    "Circle",
    "Circle Small",
    "Clipboard",
    "Clipboard Paste",
    "Clipboard Search",
    "Clock",
    "Closed Captions",
    "Cloud",
    "Code",
    "Coffee Hot",
    "Color Palette",
    "Comment",
    "Comment Exclamation",
    "Comment Multiple",
    "Comment Multiple -Var",
    "Compare Size",
    "Compass",
    "Component",
    "Compose",
    "Computer",
    "Computer Mac",
    "Contract Down",
    "Cookies",
    "Copy",
    "Copyleft",
    "Copyright",
    "Corner Radius",
    "Credit Card",
    "Crop",
    "Cursor",
    "Cursor Click",
    "Cursor Drag",
    "Cut",
    "Dark Theme",
    "Database",
    "Database Add",
    "Delete",
    "Diamond",
    "Directions",
    "Do Not Disturb",
    "Document",
    "Dollar",
    "Dollar Circle",
    "Door",
    "Door Open",
    "Draw Text",
    "Drop",
    "Emoji",
    "Emoji Frown",
    "Emoji Grin",
    "Emoji Laughter",
    "Eraser",
    "Expand",
    "Extension",
    "Eye",
    "Eye Off",
    "Eyedropper",
    "Eyedropper Color",
    "Eyedropper Color Accent",
    "Facebook",
    "Fast Foward",
    "Figma",
    "File",
    "File Add",
    "File Sync",
    "Filter",
    "Filter 2",
    "Filter Cancel",
    "Filter Cancel 2",
    "Flag",
    "Flag 2",
    "Flashlight",
    "Foldable Horizontal",
    "Foldable Horizontal Half",
    "Foldable Vertical",
    "Foldable Vertical Half",
    "Folder",
    "Folder Add",
    "Folder Open",
    "Full Screen Maximize",
    "Full Screen Minimize",
    "Game",
    "Gift",
    "Git Commit",
    "GitHub",
    "GitLab",
    "Globe",
    "Google",
    "Google 2",
    "Google Chrome",
    "Google Play",
    "Graph",
    "Grid",
    "Grid Dots",
    "HTML",
    "Hamburger",
    "Hand",
    "Hard Drive",
    "Hash",
    "Hat Graduation",
    "Headphones",
    "Headphones Off",
    "Heart",
    "Heart Stylistic",
    "Hexagon",
    "Highlighter",
    "Highlighter Accent",
    "History",
    "Home",
    "Home 2",
    "Hourglass",
    "Infinity",
    "Info",
    "Instagram",
    "JavaScript",
    "Keyboard",
    "Keyboard Command",
    "Keyboard Shift",
    "Laptop",
    "Layers",
    "Layout",
    "Leaf",
    "Leaf Three",
    "Leaf Two",
    "Library",
    "Lightbulb",
    "Line Diagonal",
    "Link",
    "Linux",
    "Location",
    "Lock",
    "Lock Open",
    "Mail",
    "Mail Open",
    "Map",
    "Mask",
    "Math",
    "Megaphone",
    "Megaphone Loud",
    "Mention",
    "Menu",
    "Microphone",
    "Microphone Off",
    "Microsoft",
    "Microsoft Edge",
    "Moon",
    "More",
    "More Vertical",
    "Motherboard",
    "Movie",
    "Museum",
    "Music Note",
    "Music Note 2",
    "NPM",
    "Narrator",
    "NodeJS",
    "Note",
    "Note Add",
    "Octagon",
    "Open",
    "Open Source",
    "PDF",
    "PDF 2",
    "Page Margins",
    "Paint Bucket",
    "Paint Bucket Accent",
    "Paintbrush",
    "Paintbrush 2",
    "Panel Left",
    "Panel Left Contract",
    "Panel Left Expand",
    "Panel Left Open",
    "Panel Right",
    "Panel Right Contract",
    "Panel Right Expand",
    "Panel Right Open",
    "Pause",
    "Pencil",
    "Pentagon",
    "Person",
    "Person 2",
    "Person Add",
    "Person Add 2",
    "Person Circle",
    "Person Multiple",
    "Phone",
    "Phone Accept",
    "Phone Hang Up",
    "Photo",
    "Photo Filter",
    "Picture in Picture",
    "Picture in Picture 2",
    "Picture in Picture Enter",
    "Picture in Picture Exit",
    "Pin",
    "Pin Off",
    "Play",
    "Play Circular",
    "Printer",
    "Prohibited",
    "Python",
    "QR Code",
    "Question",
    "Question Circle",
    "Quote",
    "ReactJS",
    "Record",
    "Record Stop",
    "Rectangle Wide",
    "Regular Expression",
    "Reverse",
    "Rhombus",
    "Ribbon",
    "Ribbon Star",
    "Roblox",
    "Ruler",
    "Ruler Diagonal",
    "Save",
    "Save As",
    "Screen Size",
    "Script",
    "Script 2",
    "Search",
    "Search Cancel",
    "Section Break",
    "Send",
    "Server",
    "Settings",
    "Shape Difference",
    "Shape Intersect",
    "Shape Subtract",
    "Shape Union",
    "Shield",
    "Shield Cancel",
    "Shield Checkmark",
    "Shield Keyhole",
    "Skull",
    "Slash Box",
    "Soundwave",
    "Spacebar",
    "Sparkle",
    "Spinner",
    "Square",
    "Star",
    "Stroke Thickness",
    "Subtract",
    "Svelte",
    "Symbols",
    "TV",
    "Table",
    "Table Simple",
    "Tablet",
    "Tag",
    "Tag Accent",
    "Tag Multiple",
    "Task List",
    "Terminal",
    "Text",
    "Text Add",
    "Text Align Center",
    "Text Align Justify",
    "Text Align Left",
    "Text Align Right",
    "Text Bold",
    "Text Bullet List",
    "Text Bullet List Square",
    "Text Bullet List Square Add",
    "Text Case Lowercase",
    "Text Case Title",
    "Text Case Uppercase",
    "Text Clear Formatting",
    "Text Collapse",
    "Text Color",
    "Text Color Accent",
    "Text Edit Style",
    "Text Effects",
    "Text Expand",
    "Text Font",
    "Text Font Size",
    "Text Footnote",
    "Text Highlight Color",
    "Text Highlight Color Accent",
    "Text Indent Decrease",
    "Text Indent Increase",
    "Text Italic",
    "Text Large",
    "Text Letter Spacing",
    "Text Line Height",
    "Text Line Spacing",
    "Text Number List",
    "Text Position Bottom",
    "Text Position Middle",
    "Text Position Top",
    "Text Small",
    "Text Strikethrough",
    "Text Subscript",
    "Text Superscript",
    "Text Typography",
    "Text Underline",
    "Thumbs Down",
    "Thumbs Up",
    "TikTok",
    "Timer",
    "Toolbox",
    "Triangle",
    "Tune",
    "TypeScript",
    "Ubuntu",
    "Vehicle Car",
    "Video",
    "Video Clip",
    "Visual Studio Code",
    "Volume",
    "Volume 0",
    "Volume 1",
    "Volume Mute",
    "VueJS",
    "Watch",
    "Weather Cloudy",
    "Webpack",
    "Wi-Fi",
    "Window",
    "Window Multiple",
    "Wrench",
    "X (Twitter)",
    "YouTube",
    "YouTube Shorts",
    "Zoom In",
    "Zoom Out"
  ];
  function format(str) {
    return str.replace(/[-_()]/g, " ").replace(/\s\s+/g, " ");
  }
  function camelCase(str) {
    return format(str).split(" ").map((word, i) => i == 0 ? word.toLowerCase() : word.charAt(0).toUpperCase() + word.slice(1)).join("");
  }
  function kebabCase(str) {
    return format(str).replaceAll(" ", "-").toLowerCase();
  }
  function pascalCase(str) {
    return format(str).replaceAll(" ", "");
  }
  const rootNode = [
    "svg",
    {
      width: "24",
      height: "24",
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 24 24",
      fill: "none"
    },
    []
  ];
  function convertNodesWithConfig(nodes, options) {
    const defaultStroke = 1.5;
    const attributeKey = {
      // configKey, svgAttr
      color: ["stroke", "fill"],
      strokeWidth: ["stroke-width"],
      strokeCaps: ["stroke-linejoin"],
      strokeJoin: ["stroke-linecap"],
      cornerRadius: ["rx"],
      strokeFilledElements: void 0
    };
    if (!options) return nodes;
    return nodes.map((node) => {
      var _a, _b, _c;
      const children = node[2];
      for (const [optionK, svgAttrs] of Object.entries(attributeKey)) {
        if (svgAttrs) {
          for (const s of svgAttrs) {
            if (node[1][s] && options[optionK]) {
              node[1][s] = options[optionK];
            }
          }
        }
      }
      if (!Object.hasOwn(node[1], "stroke-width") && Object.hasOwn(node[1], "fill") && node[1].fill != "none" && node[1].stroke != "none" && node[1]["stroke-width"] !== "0" && ((_a = options == null ? void 0 : options.strokeWidth) != null ? _a : 0) > defaultStroke) {
        node[1]["stroke-width"] = (options.strokeWidth - defaultStroke).toString();
        node[1].stroke = node[1].fill;
        node[1]["stroke-linecap"] = (_b = options.strokeCaps) != null ? _b : "round";
        node[1]["stroke-linejoin"] = (_c = options.strokeJoin) != null ? _c : "round";
      }
      if (children.length) {
        node[2] = convertNodesWithConfig(children, options);
      }
      return node;
    });
  }
  function renderNodeWithRoot(nodes, rootNode2, options) {
    const root = structuredClone(rootNode2);
    root[2].push(...nodes);
    if (options == null ? void 0 : options.size) {
      root[1].width = options.size.toString();
      root[1].height = options.size.toString();
    }
    if (options == null ? void 0 : options.attributes) {
      for (const [k, v] of Object.entries(options.attributes)) {
        root[1][k] = v;
      }
    }
    return renderNodes([root]);
  }
  function renderNodes(nodes) {
    return nodes.map(([element, attrs, children]) => {
      const attrMap = Object.entries(attrs).map(([k, v]) => `${k}=${JSON.stringify(v)}`);
      return `<${element} ${attrMap.join(" ")}${children.length > 0 ? `>${renderNodes(children)}</${element}>` : " />"}`;
    }).join("");
  }
  class ProIcon {
    /**
     *
     * @param name The name of the icon in Friendly Form
     * @param kebabCase The name of the icon in kebab-case
     * @param camelCase The name of the icon in camelCase
     * @param category The category of the icon.
     * @param tags An array of the icon's tags.
     */
    constructor(name, tags, category, nodes) {
      __privateAdd(this, _nodes, []);
      this.name = name;
      this.kebabCase = kebabCase(name);
      this.camelCase = camelCase(name);
      this.tags = tags != null ? tags : [];
      this.category = category;
      __privateSet(this, _nodes, nodes);
      this.raw = this.toSvg();
    }
    /**
     * Returns an SVG string from the icon with the provided options
     * Note that this also works outside of a browser environment
     * @param options Customization options for the icon
     */
    toSvg(options) {
      return renderNodeWithRoot(
        convertNodesWithConfig(__privateGet(this, _nodes), options),
        rootNode,
        options
      );
    }
  }
  _nodes = new WeakMap();
  function createIcon({ name, tags, category, deprecated, alternativeIcon }, nodes) {
    if (deprecated) {
      console.warn(
        `The icon ${name} is deprecated and will be removed in a future version. Use ${alternativeIcon} instead.`
      );
    }
    return new ProIcon(name, tags, category, nodes);
  }
  const AccessibilityIcon = createIcon(
    {
      name: "Accessibility",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.867 5.543a1.58 1.58 0 0 0-2.155.576 1.57 1.57 0 0 0 .577 2.15l2.63 1.515a1 1 0 0 1 .5.866v3.536a1 1 0 0 1-.134.5l-2.408 4.162a1.57 1.57 0 0 0 .577 2.15 1.58 1.58 0 0 0 2.156-.576l3.258-5.629h.258l3.258 5.629a1.58 1.58 0 0 0 2.156.576 1.57 1.57 0 0 0 .577-2.15l-2.402-4.15a1 1 0 0 1-.135-.502V10.65a1 1 0 0 1 .501-.866l2.63-1.514a1.57 1.57 0 0 0 .577-2.15 1.58 1.58 0 0 0-2.155-.577l-3.636 2.094a3 3 0 0 1-2.994 0z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.623 5.414a2.623 2.623 0 1 1-5.246 0 2.623 2.623 0 0 1 5.246 0"
        },
        []
      ]
    ]
  );
  const AddCircularIcon = createIcon(
    {
      name: "Add Circular",
      tags: ["Add Circle", "Plus"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 8.5v7M8.5 12h7"
        },
        []
      ]
    ]
  );
  const AddRhombusIcon = createIcon(
    {
      name: "Add Rhombus",
      tags: ["Add Diamond", "Plus", "Keyframe", "Component"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.775 14.475a3.5 3.5 0 0 1 0-4.95l5.75-5.75a3.5 3.5 0 0 1 4.95 0l5.75 5.75a3.5 3.5 0 0 1 0 4.95l-5.75 5.75a3.5 3.5 0 0 1-4.95 0zM8.25 12H12m0 0h3.75M12 12V8.25M12 12v3.75"
        },
        []
      ]
    ]
  );
  const AddSquareMultipleIcon = createIcon(
    { name: "Add Square Multiple", tags: [""], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.63 7.66v5.94m-2.97-2.97h5.94"
        },
        []
      ],
      [
        "rect",
        {
          width: "14",
          height: "14",
          x: "3.63",
          y: "3.63",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.63 7.63v7a6 6 0 0 1-6 6h-7"
        },
        []
      ]
    ]
  );
  const AddSquareIcon = createIcon(
    {
      name: "Add Square",
      tags: ["Add Box", "Plus"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 8.5v7M8.5 12h7"
        },
        []
      ],
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ]
    ]
  );
  const AddIcon = createIcon(
    {
      name: "Add",
      tags: ["Plus", "Create", "New", "Addition"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4 12h8m0 0h8m-8 0V4m0 8v8"
        },
        []
      ]
    ]
  );
  const AirplaneLandingIcon = createIcon(
    {
      name: "Airplane Landing",
      tags: [
        "Aircraft",
        "Plane",
        "Aviation",
        "Jet",
        "Boeing",
        "Airbus",
        "Flight",
        "Aeroplane",
        "Airplane Mode",
        "Flight Mode",
        "Fly",
        "TO",
        "Climb"
      ],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 20.75h18.5m-2.05-7.453a1.783 1.783 0 1 1-.923 3.445L8.185 14.04a4 4 0 0 1-1.32-.628l-2.14-1.543A3.04 3.04 0 0 1 3.47 9.271l.11-2.508a.607.607 0 0 1 .765-.56l.436.117a1.52 1.52 0 0 1 1.086 1.121l.486 2.082c.051.218.218.39.434.448l4.015 1.076.506-6.735a.607.607 0 0 1 .763-.541l.422.113c.363.097.643.388.725.755l1.692 7.509z"
        },
        []
      ]
    ]
  );
  const AirplaneTakeoffIcon = createIcon(
    {
      name: "Airplane Takeoff",
      tags: [
        "Aircraft",
        "Plane",
        "Aviation",
        "Jet",
        "Boeing",
        "Airbus",
        "Flight",
        "Aeroplane",
        "Airplane Mode",
        "Flight Mode",
        "Fly",
        "TO",
        "Climb"
      ],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 20.75h18.5M18.575 6.299a1.783 1.783 0 0 1 1.783 3.089L11.31 14.61a4 4 0 0 1-1.377.49l-2.604.422a3.04 3.04 0 0 1-2.725-.948L2.91 12.723a.607.607 0 0 1 .145-.936l.391-.226a1.52 1.52 0 0 1 1.56.025l1.816 1.128c.19.118.43.122.624.01l3.6-2.078-4.404-5.12a.607.607 0 0 1 .156-.922l.378-.218c.326-.188.73-.18 1.047.02l6.506 4.113z"
        },
        []
      ]
    ]
  );
  const AirplaneIcon = createIcon(
    {
      name: "Airplane",
      tags: [
        "Aircraft",
        "Plane",
        "Aviation",
        "Jet",
        "Boeing",
        "Airbus",
        "Flight",
        "Aeroplane",
        "Airplane Mode",
        "Flight Mode",
        "Fly"
      ],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.238 4.512a1.762 1.762 0 1 1 3.524 0V8.9l6.733 3.535a1 1 0 0 1 .535.885v.431a.6.6 0 0 1-.712.59l-6.556-1.24v4.107a.6.6 0 0 0 .317.53l1.862.996a1.5 1.5 0 0 1 .792 1.322v.447a.6.6 0 0 1-.73.586L12 20.204l-4.003.885a.6.6 0 0 1-.73-.586v-.447a1.5 1.5 0 0 1 .792-1.322l1.862-.997a.6.6 0 0 0 .317-.529v-4.106L3.682 14.34a.6.6 0 0 1-.712-.59v-.43a1 1 0 0 1 .535-.886L10.238 8.9z"
        },
        []
      ]
    ]
  );
  const AlertCircleIcon = createIcon(
    { name: "Alert Circle", tags: ["Warning"], category: "Status", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 12.438v-5"
        },
        []
      ],
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(1 0 0 -1 10.75 17.063)"
        },
        []
      ]
    ]
  );
  const AlertTriangleIcon = createIcon(
    { name: "Alert Triangle", tags: ["Warning"], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M5.732 20.5c-2.29 0-3.723-2.498-2.581-4.5L9.419 5.006c1.144-2.008 4.018-2.008 5.163 0L20.849 16c1.142 2.002-.291 4.5-2.581 4.5z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 13.375V9"
        },
        []
      ],
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(1 0 0 -1 10.75 17.938)"
        },
        []
      ]
    ]
  );
  const AlignBottomIcon = createIcon(
    { name: "Align Bottom", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 21.25h18.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(-1 0 0 1 19.75 7.75)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(-1 0 0 1 10.25 2.75)"
        },
        []
      ]
    ]
  );
  const AlignHorizontalCentersIcon = createIcon(
    {
      name: "Align Horizontal Centers",
      tags: [""],
      category: "Organization",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.75 12h1.5m-11 0h3.5m-11 0h1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(-1 0 0 1 19.75 7)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(-1 0 0 1 10.25 4.5)"
        },
        []
      ]
    ]
  );
  const AlignLeftIcon = createIcon(
    { name: "Align Left", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 2.75v18.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(0 -1 -1 0 16.25 19.75)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(0 -1 -1 0 21.25 10.25)"
        },
        []
      ]
    ]
  );
  const AlignRightIcon = createIcon(
    { name: "Align Right", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 2.75v18.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          x: "7.75",
          y: "19.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(-90 7.75 19.75)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          x: "2.75",
          y: "10.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(-90 2.75 10.25)"
        },
        []
      ]
    ]
  );
  const AlignTopIcon = createIcon(
    { name: "Align Top", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 2.75h18.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          x: "19.75",
          y: "16.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(180 19.75 16.25)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          x: "10.25",
          y: "21.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(180 10.25 21.25)"
        },
        []
      ]
    ]
  );
  const AlignVerticalCentersIcon = createIcon(
    {
      name: "Align Vertical Centers",
      tags: [""],
      category: "Organization",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 19.75v1.5m0-11v3.5m0-11v1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          x: "7",
          y: "19.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(-90 7 19.75)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          x: "4.5",
          y: "10.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(-90 4.5 10.25)"
        },
        []
      ]
    ]
  );
  const AmazonIcon = createIcon(
    {
      name: "Amazon",
      tags: ["Shopping", "Delivery", "Prime"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.3",
          d: "M17.284 17.724h1.967c.543 0 .983.44.983.983v1.967"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "m6.901 7.111 1.976.2a.57.57 0 0 0 .558-.34c.268-.573.924-1.59 2.209-1.59.258 0 .478.041.665.108 1.04.373 1.02 1.77 1.02 2.874 0 0-2.415-.058-3.992.476-.465.157-.934.333-1.36.578-1.223.705-1.77 2.276-1.969 3.022-.071.27-.098.549-.08.828.08 1.178.558 3.184 2.968 3.599 2.247.386 3.749-.64 4.43-1.267.23-.213.612-.22.817.018l.88 1.017a.59.59 0 0 0 .825.066l1.676-1.402a.59.59 0 0 0 .101-.796l-.267-.374c-.215-.3-.422-.613-.517-.97-.099-.372-.09-.763-.09-1.148V6.704c0-2.372-2.295-3.681-3.94-3.85l-.592-.057a6 6 0 0 0-.972-.034 6 6 0 0 0-1.162.196c-1.537.399-3.348 1.765-3.597 3.664-.033.25.162.463.413.488m6.428 4.576v-1.432s-1.905-.047-2.664.363c-.312.168-.574.491-.775.813a2.54 2.54 0 0 0-.291 1.94c.066.275.158.54.282.695.259.323.876.439 1.166.476q.156.022.311.003c.157-.022.413-.08.67-.23.39-.229.695-.595.903-.995.118-.226.208-.471.273-.676a3.2 3.2 0 0 0 .125-.957",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M4.5 18.707c1.933 1.619 4.584 2.548 7.375 2.548 1.853 0 3.643-.41 5.203-1.158a11 11 0 0 0 .573-.295"
        },
        []
      ]
    ]
  );
  const AnchorIcon = createIcon(
    { name: "Anchor", tags: ["Lock"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 12a9.25 9.25 0 1 0 18.5 0M12 21.25V7.75"
        },
        []
      ],
      [
        "circle",
        {
          cx: "12",
          cy: "5.25",
          r: "2.5",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M2.75 12h4m10.5 0h4"
        },
        []
      ]
    ]
  );
  const AndroidIcon = createIcon(
    { name: "Android", tags: ["Social"], category: "Logos & Brands", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.764 9.907a9.3 9.3 0 0 1 1.777 1.46 9.8 9.8 0 0 1 2.005 3.158c.343.873.564 1.791.655 2.727.054.55-.399.998-.951.998H3.75c-.552 0-1.005-.449-.951-.998.091-.936.312-1.854.655-2.727a9.8 9.8 0 0 1 2.005-3.157 9.3 9.3 0 0 1 1.777-1.461m9.528 0a9 9 0 0 0-1.224-.65 8.85 8.85 0 0 0-3.54-.74 8.85 8.85 0 0 0-3.54.74 9 9 0 0 0-1.224.65m9.528 0L18.49 6.75M7.236 9.907 5.51 6.75"
        },
        []
      ],
      ["circle", { cx: "8.75", cy: "14.063", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "15.25", cy: "14.063", r: "1.25", fill: "currentColor" }, []]
    ]
  );
  const AngleIcon = createIcon(
    { name: "Angle", tags: [""], category: "Math & Numbers", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.25 4.25v12.5a3 3 0 0 0 3 3h12.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.25 10.356h.394a9 9 0 0 1 9 9v.394"
        },
        []
      ]
    ]
  );
  const AppRemoveIcon = createIcon(
    {
      name: "App Remove",
      tags: ["Uninstall", "Delete App"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(1 0 0 -1 3.75 20.25)"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 20.25 17 17m0 0-3.25-3.25M17 17l-3.25 3.25M17 17l3.25-3.25"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(1 0 0 -1 3.75 10.25)"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(1 0 0 -1 13.75 10.25)"
        },
        []
      ]
    ]
  );
  const AppStoreIcon = createIcon(
    {
      name: "App Store",
      tags: ["Apple", "Mac App Store", "Apple App Store", "iOS", "iPadOs", "macOS"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      ["path", { fill: "currentColor", d: "M10.904 13.794h2.024l-1.012-1.755z" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m8.843 17.367-1.58 2.74A1.784 1.784 0 1 1 4.17 18.32l.55-.953m4.122 0H4.72m4.122 0h6.146m-10.268 0h-.466a1.786 1.786 0 0 1 0-3.573h2.527l3.073-5.327-1.03-1.787a1.784 1.784 0 1 1 3.092-1.786 1.784 1.784 0 1 1 3.09 1.786l-1.03 1.786m-1.049 5.328h-2.024l1.012-1.755m1.012 1.755 2.061 3.573m-2.06-3.573-1.013-1.755m3.073 5.328 1.58 2.74a1.784 1.784 0 1 0 3.092-1.787l-.55-.953h.634a1.786 1.786 0 0 0 0-3.573H17.05l-3.073-5.328m0 0-2.06 3.573"
        },
        []
      ]
    ]
  );
  const AppleIcon = createIcon(
    {
      name: "Apple",
      tags: [
        "iPhone",
        "iPad",
        "Mac",
        "iOS",
        "iPadOS",
        "watchOS",
        "Watch",
        "Tablet",
        "Phone",
        "Tim Cook",
        "Steve Jobs",
        "macOS",
        "Cupertino"
      ],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.102 7.78a4 4 0 0 0-1.185-.161c-1.918 0-4.167 1.695-4.167 5.359 0 3.36 2.358 7.21 3.801 7.822.328.14.731.227 1.084.193.707-.07 1.348-.421 2.023-.622.228-.038.5-.074.719-.075.24-.002.51.06.774.12.715.164 1.505.65 2.255.577.267-.026.633-.187.746-.239l.07-.03c.85-.343 1.988-1.826 2.759-3.703.162-.396-.052-.833-.404-1.077-.999-.694-1.663-1.934-1.663-3.195 0-.969.313-1.854.907-2.523l.02-.023a8 8 0 0 1 .45-.5c.255-.248.326-.645.082-.904-.808-.854-1.832-1.277-2.764-1.277a3.6 3.6 0 0 0-1.106.156c-.138.033-.778.192-1.222.355-.257.071-.635.167-.81.21a.7.7 0 0 1-.192.023c-.735-.024-1.47-.303-2.177-.487Z",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          stroke: "currentColor",
          "stroke-linejoin": "round",
          d: "M13.86 5.178c-.733.878-1.975 1.047-1.975 1.047s-.05-1.256.684-2.135 1.976-1.046 1.976-1.046.05 1.256-.684 2.134Z"
        },
        []
      ]
    ]
  );
  const AppsAddIcon = createIcon(
    {
      name: "Apps Add",
      tags: ["Add App", "Install"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17 3.75V7m0 0v3.25M17 7h-3.25M17 7h3.25"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "3.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "13.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ]
    ]
  );
  const AppsListIcon = createIcon(
    { name: "Apps List", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 4.5h11"
        },
        []
      ],
      [
        "rect",
        {
          width: "3.5",
          height: "3.5",
          x: "2.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 12h11"
        },
        []
      ],
      [
        "rect",
        {
          width: "3.5",
          height: "3.5",
          x: "2.75",
          y: "10.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 19.5h11"
        },
        []
      ],
      [
        "rect",
        {
          width: "3.5",
          height: "3.5",
          x: "2.75",
          y: "17.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.2"
        },
        []
      ]
    ]
  );
  const AppsIcon = createIcon(
    {
      name: "Apps",
      tags: ["Applications", "Software", "Plugins", "Extensions"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.586 3.818a2 2 0 0 1 2.828 0l1.768 1.768a2 2 0 0 1 0 2.828l-1.768 1.768a2 2 0 0 1-2.828 0l-1.768-1.768a2 2 0 0 1 0-2.828z"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "3.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "13.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ]
    ]
  );
  const ArcIcon = createIcon(
    { name: "Arc", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.25 4.75h-.5c-7.732 0-14 6.268-14 14v.5"
        },
        []
      ]
    ]
  );
  const ArchiveAdd2Icon = createIcon(
    {
      name: "Archive Add 2",
      tags: ["UPDATE"],
      category: "Organization",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 12.25h2m-8.5-4h16.5m0 2v-1.7c0-1.68 0-2.52-.327-3.162a3 3 0 0 0-1.311-1.311c-.642-.327-1.482-.327-3.162-.327h-6.9c-1.68 0-2.52 0-3.162.327a3 3 0 0 0-1.311 1.311C3.75 6.03 3.75 6.87 3.75 8.55v6.9c0 1.68 0 2.52.327 3.162a3 3 0 0 0 1.311 1.311c.642.327 1.482.327 3.162.327h1.7"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 1 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const ArchiveIcon = createIcon(
    { name: "Archive", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 12.5h3.5m-10-4.75a4 4 0 0 1 4-4h8.5a4 4 0 0 1 4 4v8.5a4 4 0 0 1-4 4h-8.5a4 4 0 0 1-4-4zm0 1h16.5"
        },
        []
      ]
    ]
  );
  const ArrowClockwiseIcon = createIcon(
    { name: "Arrow Clockwise", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.719 14.385a8.25 8.25 0 1 1-.824-6.26l.42.908m.58-4.658v3.75a1 1 0 0 1-.58.908m-4.17.092h3.75c.15 0 .293-.033.42-.092"
        },
        []
      ]
    ]
  );
  const ArrowCounterclockwiseIcon = createIcon(
    { name: "Arrow Counterclockwise", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.281 14.385a8.25 8.25 0 1 0 .824-6.26l-.477.88m-.523-4.63v3.75a1 1 0 0 0 .523.88m4.227.12h-3.75a1 1 0 0 1-.477-.12"
        },
        []
      ]
    ]
  );
  const ArrowDownIcon = createIcon(
    { name: "Arrow Down", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 4v15.879M5.25 13.75l5.69 5.69c.292.292.676.439 1.06.439m6.75-6.129-5.69 5.69a1.5 1.5 0 0 1-1.06.439"
        },
        []
      ]
    ]
  );
  const ArrowDownloadIcon = createIcon(
    { name: "Arrow Download", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.074 3.25v12.478M6.19 10.465l4.822 4.822c.293.293.677.44 1.06.44m5.883-5.262-4.822 4.822c-.293.293-.677.44-1.06.44m8.677.788v.935a3.3 3.3 0 0 1-3.3 3.3H6.55a3.3 3.3 0 0 1-3.3-3.3v-.935"
        },
        []
      ]
    ]
  );
  const ArrowEnterIcon = createIcon(
    { name: "Arrow Enter", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.75 5.623V9.52a4 4 0 0 1-4 4H3.871m4.236 4.857L4.31 14.58a1.5 1.5 0 0 1-.44-1.061m4.236-4.857L4.31 12.46c-.293.293-.44.677-.44 1.061"
        },
        []
      ]
    ]
  );
  const ArrowExportIcon = createIcon(
    { name: "Arrow Export", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.798 12H2.871m5.157-5.778-4.717 4.717c-.293.293-.44.677-.44 1.061m5.157 5.778-4.717-4.717A1.5 1.5 0 0 1 2.87 12m17.88-7.905v15.81"
        },
        []
      ]
    ]
  );
  const ArrowFowardIcon = createIcon(
    { name: "Arrow Foward", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.25 18.219c0-2.352 0-3.527.383-4.455a5.06 5.06 0 0 1 2.743-2.743c.928-.383 2.103-.383 4.455-.383h8.298m-4.236-4.857 3.796 3.796c.293.293.44.677.44 1.061m-4.236 4.857 3.796-3.796c.293-.293.44-.677.44-1.061"
        },
        []
      ]
    ]
  );
  const ArrowImportIcon = createIcon(
    { name: "Arrow Import", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.25 12h12.927M10.02 6.222l4.717 4.717c.293.293.44.677.44 1.061m-5.157 5.778 4.717-4.717c.293-.293.44-.677.44-1.061m5.573-7.905v15.81"
        },
        []
      ]
    ]
  );
  const ArrowLeftRightIcon = createIcon(
    {
      name: "Arrow Left Right",
      tags: ["Left Right", "Bidirectional", "Horizontal", "Width", "Size", "Wide"],
      category: "Arrows",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16.25 17 3.94-3.94c.292-.292.439-.676.439-1.06M16.25 7l3.94 3.94c.292.292.439.676.439 1.06M7.75 17l-3.94-3.94A1.5 1.5 0 0 1 3.372 12M7.75 7l-3.94 3.94A1.5 1.5 0 0 0 3.371 12m0 0H20.63"
        },
        []
      ]
    ]
  );
  const ArrowLeftIcon = createIcon(
    { name: "Arrow Left", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20 12H4.121m6.129 6.75-5.69-5.69A1.5 1.5 0 0 1 4.122 12m6.129-6.75-5.69 5.69A1.5 1.5 0 0 0 4.122 12"
        },
        []
      ]
    ]
  );
  const ArrowMaximizeIcon = createIcon(
    { name: "Arrow Maximize", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 12.75v6c0 .414.168.79.44 1.06m7.06.44h-6a1.5 1.5 0 0 1-1.06-.44m16.06-8.56v-6c0-.414-.168-.79-.44-1.06m-7.06-.44h6c.414 0 .79.168 1.06.44M4.19 19.81l.56-.56 14.5-14.5.56-.56"
        },
        []
      ]
    ]
  );
  const ArrowMinimizeIcon = createIcon(
    { name: "Arrow Minimize", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 21.25 6.5-6.5.56-.56m.44 7.06v-6c0-.414-.168-.79-.44-1.06m-7.06-.44h6c.414 0 .79.168 1.06.44m3.94-11.44v6c0 .414.168.79.44 1.06m7.06.44h-6a1.5 1.5 0 0 1-1.06-.44m7.06-7.06-6.5 6.5-.56.56"
        },
        []
      ]
    ]
  );
  const ArrowMoveIcon = createIcon(
    {
      name: "Arrow Move",
      tags: ["Arrow 4-Way", "Move"],
      category: "Arrows",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 9.005V2.75M9 5.324l2.273-2.273c.201-.2.464-.301.727-.301m3 2.574-2.273-2.273c-.2-.2-.464-.301-.727-.301M14.995 12h6.255m-2.574-3 2.273 2.273c.2.201.301.464.301.727m-2.574 3 2.273-2.273c.2-.2.301-.464.301-.727M12 14.995v6.255m-3-2.574 2.273 2.273c.201.2.464.301.727.301m3-2.574-2.273 2.273c-.2.2-.464.301-.727.301M9.005 12H2.75m2.574-3-2.273 2.273c-.2.201-.301.464-.301.727m2.574 3-2.273-2.273c-.2-.2-.301-.464-.301-.727"
        },
        []
      ]
    ]
  );
  const ArrowRedo2Icon = createIcon(
    { name: "Arrow Redo 2", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m14.75 12 3.293-3.293A1 1 0 0 0 18.336 8M14.75 4l3.293 3.293a1 1 0 0 1 .293.707M16.75 19.5H10.5a5.75 5.75 0 0 1 0-11.5h7.836"
        },
        []
      ]
    ]
  );
  const ArrowRedoIcon = createIcon(
    { name: "Arrow Redo", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m14.03 21.25-8.26-8.26a5.999 5.999 0 0 1 8.483-8.483l4.734 4.734.622.622m-7.199.505h6.077c.447 0 .848-.195 1.122-.505m.378-7.072v6.077c0 .382-.142.73-.378.995"
        },
        []
      ]
    ]
  );
  const ArrowReplyIcon = createIcon(
    { name: "Arrow Reply", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.75 18.219c0-2.352 0-3.527-.383-4.455a5.06 5.06 0 0 0-2.743-2.743c-.928-.383-2.103-.383-4.455-.383H3.871m4.236-4.857L4.31 9.577c-.293.293-.44.677-.44 1.061m4.236 4.857L4.31 11.699a1.5 1.5 0 0 1-.44-1.061"
        },
        []
      ]
    ]
  );
  const ArrowRightIcon = createIcon(
    { name: "Arrow Right", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4 12h15.879m-6.129 6.75 5.69-5.69c.292-.292.439-.676.439-1.06M13.75 5.25l5.69 5.69c.292.292.439.676.439 1.06"
        },
        []
      ]
    ]
  );
  const ArrowRotateClockwiseIcon = createIcon(
    { name: "Arrow Rotate Clockwise", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 12a8.25 8.25 0 1 1 12.375 7.145l-1.199.421m-.051-3.316v3q0 .166.051.316m3.949.684h-3a1 1 0 0 1-.949-.684"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M14.5 11.75a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Z"
        },
        []
      ]
    ]
  );
  const ArrowRotateCounterclockwiseIcon = createIcon(
    {
      name: "Arrow Rotate Counterclockwise",
      tags: [""],
      category: "Arrows",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 12a8.25 8.25 0 1 0-12.375 7.145l1.168.503m.082-3.398v3q-.002.213-.082.398m-3.918.602h3a1 1 0 0 0 .918-.602"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M14.5 11.75a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Z"
        },
        []
      ]
    ]
  );
  const ArrowSortIcon = createIcon(
    { name: "Arrow Sort", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 9.867 8.186 6.053a1.5 1.5 0 0 0-1.061-.44M2.25 9.868l3.814-3.814c.293-.293.677-.44 1.061-.44m0 13.395V5.614m9.75-.124v13.394m4.875-4.253-3.814 3.814c-.293.293-.677.44-1.061.44M12 14.63l3.814 3.814c.293.293.677.44 1.061.44"
        },
        []
      ]
    ]
  );
  const ArrowSwapIcon = createIcon(
    { name: "Arrow Swap", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m9.618 12.249-3.814 3.814c-.293.293-.44.677-.44 1.06M9.619 22l-3.814-3.814a1.5 1.5 0 0 1-.44-1.061m13.395 0H5.365m-.124-9.751h13.394m-4.253-4.875 3.814 3.814c.293.293.44.677.44 1.06m-4.254 4.876 3.814-3.814c.293-.293.44-.677.44-1.061"
        },
        []
      ]
    ]
  );
  const ArrowSync2Icon = createIcon(
    { name: "Arrow Sync 2", tags: [""], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.915 18.532A7.83 7.83 0 0 1 11.831 3.92h1.043m-1.755-2.17 1.462 1.462a1 1 0 0 1 .293.708m-1.755 2.169 1.462-1.462a1 1 0 0 0 .293-.707m3.211 1.299a7.83 7.83 0 0 1-3.916 14.612h-1.043M12.881 22l-1.462-1.462a1 1 0 0 1-.293-.707m1.755-2.17-1.462 1.462a1 1 0 0 0-.293.708"
        },
        []
      ]
    ]
  );
  const ArrowSyncIcon = createIcon(
    { name: "Arrow Sync", tags: [""], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.548 9.735a8.75 8.75 0 0 1 16.03-2.11l.335.759m.837-5.134v4.147a1 1 0 0 1-.837.987m-4.31.013h4.147q.083 0 .163-.013M3.25 20.75v-4.147a1 1 0 0 1 1-1m0 0h4.147m-4.147 0 .172.772a8.75 8.75 0 0 0 16.03-2.11"
        },
        []
      ]
    ]
  );
  const ArrowTrendingIcon = createIcon(
    { name: "Arrow Trending", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.25 16.75 4.793-4.793a1 1 0 0 1 1.414 0l2.586 2.586a1 1 0 0 0 1.414 0L19.75 8.25l.56-.56m-5.56-.44h4.5c.414 0 .79.168 1.06.44m.44 5.56v-4.5c0-.414-.168-.79-.44-1.06"
        },
        []
      ]
    ]
  );
  const ArrowUndo2Icon = createIcon(
    { name: "Arrow Undo 2", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.25 12 5.957 8.707A1 1 0 0 1 5.664 8M9.25 4 5.957 7.293A1 1 0 0 0 5.664 8M7.25 19.5h6.25a5.75 5.75 0 0 0 0-11.5H5.664"
        },
        []
      ]
    ]
  );
  const ArrowUndoIcon = createIcon(
    { name: "Arrow Undo", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m9.97 21.25 8.26-8.26a5.999 5.999 0 0 0-8.483-8.483L5.013 9.24l-.622.622m7.199.505H5.513c-.447 0-.848-.195-1.122-.505M4.013 2.79v6.077c0 .382.143.73.378.995"
        },
        []
      ]
    ]
  );
  const ArrowUpDownIcon = createIcon(
    {
      name: "Arrow Up Down",
      tags: ["Up-Down", "Bidirectional", "Vertical", "Height", "Size"],
      category: "Arrows",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7 16.25 3.94 3.94c.292.292.676.439 1.06.439m5-4.379-3.94 3.94a1.5 1.5 0 0 1-1.06.439M7 7.75l3.94-3.94A1.5 1.5 0 0 1 12 3.371m5 4.379-3.94-3.94A1.5 1.5 0 0 0 12 3.372m0 0V20.63"
        },
        []
      ]
    ]
  );
  const ArrowUpIcon = createIcon(
    { name: "Arrow Up", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 20V4.121M5.25 10.25l5.69-5.69A1.5 1.5 0 0 1 12 4.121m6.75 6.129-5.69-5.69A1.5 1.5 0 0 0 12 4.122"
        },
        []
      ]
    ]
  );
  const ArrowUploadIcon = createIcon(
    { name: "Arrow Upload", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 16.349V3.87M6.118 9.132l4.821-4.821c.293-.293.677-.44 1.061-.44m5.882 5.261-4.821-4.821A1.5 1.5 0 0 0 12 3.87m8.75 12.645v.935a3.3 3.3 0 0 1-3.3 3.3H6.55a3.3 3.3 0 0 1-3.3-3.3v-.935"
        },
        []
      ]
    ]
  );
  const AttatchIcon = createIcon(
    {
      name: "Attatch",
      tags: ["Clip", "Paper Clip", "Paperclip"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.861 13.625 9.342-9.342a5.235 5.235 0 1 1 7.403 7.403L10.88 20.41a2.867 2.867 0 0 1-4.054-4.054l8.372-8.373"
        },
        []
      ]
    ]
  );
  const BackgroundColorAccentIcon = createIcon(
    {
      name: "Background Color Accent",
      tags: ["House", "Home Samsung"],
      category: "Accents",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M3 14.95v-1.68h.633c.168.163.33.33.486.462.307.261.696.54 1.204.706a3.5 3.5 0 0 0 2.168 0c.507-.165.896-.445 1.203-.706.28-.236.583-.54.895-.852l1.185-1.186c-1.322 3.12 2.099 6.198 5.084 4.475a3.574 3.574 0 0 0 1.308-4.882 2 2 0 0 0-.118-.179l-1.744-2.313a1.75 1.75 0 0 0-1.764-.657 1.75 1.75 0 0 0-.511-1.173l-.739-.716V4.75h4.41c1.68 0 2.52 0 3.162.327a3 3 0 0 1 1.311 1.311c.327.642.327 1.482.327 3.162v5.4c0 1.68 0 2.52-.327 3.162a3 3 0 0 1-1.311 1.311c-.642.327-1.482.327-3.162.327H7.8c-1.68 0-2.52 0-3.162-.327a3 3 0 0 1-1.311-1.311C3 17.47 3 16.63 3 14.95",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const BackgroundColorIcon = createIcon(
    {
      name: "Background Color",
      tags: ["House", "Home Samsung"],
      category: "Design",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M13.04 4.75h3.66c1.68 0 2.52 0 3.162.327a3 3 0 0 1 1.311 1.311c.327.642.327 1.482.327 3.162v5.4c0 1.68 0 2.52-.327 3.162a3 3 0 0 1-1.311 1.311c-.642.327-1.482.327-3.162.327H7.8c-1.68 0-2.52 0-3.162-.327a3 3 0 0 1-1.311-1.311C3 17.47 3 16.63 3 14.95v-.93"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m6.407 2.818 5.384 5.385M6.407 2.818 3.01 6.214c-.696.696-1.044 1.044-1.174 1.446-.057.176-.086.36-.086.543m4.657-5.385L5.589 2m6.202 6.203-3.396 3.396c-.696.696-1.044 1.044-1.445 1.174a1.76 1.76 0 0 1-1.086 0c-.401-.13-.75-.478-1.445-1.174L3.01 10.191c-.696-.696-1.044-1.044-1.174-1.445a1.8 1.8 0 0 1-.086-.543m10.042 0H1.75m10.672 4.094 1.485-2.448 1.744 2.313a1.824 1.824 0 0 1-.668 2.491c-1.546.893-3.322-.74-2.562-2.356"
        },
        []
      ]
    ]
  );
  const BackspaceIcon = createIcon(
    { name: "Backspace", tags: ["Delete"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.71 6.084a3.5 3.5 0 0 1 2.572-1.126h7.968a3.5 3.5 0 0 1 3.5 3.5v7.084a3.5 3.5 0 0 1-3.5 3.5H9.282a3.5 3.5 0 0 1-2.571-1.126l-3.27-3.542a3.5 3.5 0 0 1 0-4.748zm4.11 3.281 5.271 5.27m0-5.27-5.27 5.27"
        },
        []
      ]
    ]
  );
  const BadgeIcon = createIcon(
    { name: "Badge", tags: [""], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 3.75H8.75a5 5 0 0 0-5 5v6.5a5 5 0 0 0 5 5h6.5a5 5 0 0 0 5-5V12"
        },
        []
      ],
      [
        "circle",
        {
          cx: "18.25",
          cy: "5.75",
          r: "3",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const BarGraphIcon = createIcon(
    {
      name: "Bar Graph",
      tags: ["Stats", "Statistics", "Data", "Graph", "Chart"],
      category: "Layout",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 21h18.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "10",
          x: "4",
          y: "7.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "15",
          x: "14",
          y: "2.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ]
    ]
  );
  const BatteryFullIcon = createIcon(
    {
      name: "Battery Full",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16",
          height: "12",
          x: "2.75",
          y: "6",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.25"
        },
        []
      ],
      [
        "rect",
        {
          width: "11",
          height: "7",
          x: "5.25",
          y: "8.5",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 10v4"
        },
        []
      ]
    ]
  );
  const BatteryIcon = createIcon(
    { name: "Battery", tags: [""], category: "System & Interface", deprecated: false },
    [
      [
        "rect",
        {
          width: "16",
          height: "12",
          x: "2.75",
          y: "6",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.25"
        },
        []
      ],
      [
        "rect",
        {
          width: "7",
          height: "7",
          x: "5.25",
          y: "8.5",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 10v4"
        },
        []
      ]
    ]
  );
  const BeachIcon = createIcon(
    { name: "Beach", tags: [""], category: "Places & Transportation", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.135 4.027c1.969 1.137 3.369 3.074 3.89 5.386a9.4 9.4 0 0 1 .005 4.066c-.361 1.67-2.311 2.182-3.791 1.328l-9.492-5.48c-1.48-.855-2.012-2.8-.746-3.948a9.4 9.4 0 0 1 3.523-2.03c2.263-.703 4.641-.46 6.61.678m0 0c-1.368-.79-4.554 2.17-7.118 6.61m7.118-6.61c1.367.789.397 5.028-2.167 9.469m-2.475-1.43-3.61 6.254m7.027 2.725a9.306 9.306 0 0 0-13.159 0"
        },
        []
      ]
    ]
  );
  const BeakerIcon = createIcon(
    {
      name: "Beaker",
      tags: ["Flask", "Test", "Lab", "Experiment"],
      category: "Development",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.456 3.75v5.09a3 3 0 0 1-.557 1.742l-1.736 2.436M9.456 3.75h-1.65m1.65 0h5.088m0 0v5.09a3 3 0 0 0 .557 1.742l1.736 2.436M14.544 3.75h1.65m-9.031 9.268-2.378 3.337a2.465 2.465 0 0 0 2.007 3.895h10.416a2.465 2.465 0 0 0 2.007-3.895l-2.378-3.337m-9.674 0h9.674"
        },
        []
      ]
    ]
  );
  const BellDotIcon = createIcon(
    {
      name: "Bell Dot",
      tags: ["New Notification", "Alert", "Unread"],
      category: "Status",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.477 9.75v3.64a3 3 0 0 0 .456 1.59l1.09 1.74a1 1 0 0 1-.849 1.53H4.826a1 1 0 0 1-.848-1.53l1.088-1.74a3 3 0 0 0 .457-1.59V9.226A6.477 6.477 0 0 1 14.52 3.26"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M10 21.25h4"
        },
        []
      ],
      ["circle", { cx: "18.5", cy: "5.5", r: "2.5", fill: "currentColor" }, []]
    ]
  );
  const BellOffIcon = createIcon(
    {
      name: "Bell Off",
      tags: ["Notification", "Alert", "Do Not Disturb"],
      category: "Status",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M10 21.25h4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.188 18.25H4.826a1 1 0 0 1-.848-1.53l1.089-1.74a3 3 0 0 0 .457-1.59V9.226c0-.788.14-1.543.398-2.242M7.62 4.458l.06-.055a6.477 6.477 0 0 1 10.798 4.825v4.161a3 3 0 0 0 .457 1.592l1.088 1.74q.068.106.104.219"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m20.719 21.782-3.531-3.531L5.922 6.985 2.218 3.282"
        },
        []
      ]
    ]
  );
  const BellIcon = createIcon(
    {
      name: "Bell",
      tags: ["Notification", "Alert"],
      category: "Status",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.934 14.98a3 3 0 0 1-.457-1.59V9.226a6.477 6.477 0 0 0-12.954 0v4.162a3 3 0 0 1-.457 1.592l-1.088 1.74a1 1 0 0 0 .848 1.53h14.348a1 1 0 0 0 .848-1.53z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M10 21.25h4"
        },
        []
      ]
    ]
  );
  const BluetoothIcon = createIcon(
    {
      name: "Bluetooth",
      tags: ["BT", "Wireless"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m6.25 7.5 5.454 4.5m0 0 5.246 3.982a.65.65 0 0 1 0 1.036l-4.202 3.19a.65.65 0 0 1-1.043-.517V4.31a.65.65 0 0 1 1.043-.518l4.202 3.19a.65.65 0 0 1 0 1.036zm0 0L6.25 16.5"
        },
        []
      ]
    ]
  );
  const BoardIcon = createIcon(
    { name: "Board", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.75 4H6.25a3.5 3.5 0 0 0-3.5 3.5v9a3.5 3.5 0 0 0 3.5 3.5h11.5a3.5 3.5 0 0 0 3.5-3.5v-9a3.5 3.5 0 0 0-3.5-3.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M17.1 6.95H6.9a1.2 1.2 0 0 0-1.2 1.2v.483a1.2 1.2 0 0 0 1.2 1.2h10.2a1.2 1.2 0 0 0 1.2-1.2V8.15a1.2 1.2 0 0 0-1.2-1.2m0 5.64h-2.9a1.2 1.2 0 0 0-1.2 1.2v2.06a1.2 1.2 0 0 0 1.2 1.2h2.9a1.2 1.2 0 0 0 1.2-1.2v-2.06a1.2 1.2 0 0 0-1.2-1.2m-8.1 0H6.9a1.2 1.2 0 0 0-1.2 1.2v2.06a1.2 1.2 0 0 0 1.2 1.2H9a1.2 1.2 0 0 0 1.2-1.2v-2.06a1.2 1.2 0 0 0-1.2-1.2"
        },
        []
      ]
    ]
  );
  const BoltIcon = createIcon(
    {
      name: "Bolt",
      tags: ["Lightning", "Strike", "Flash", "Zap"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.896 11.457c.64 0 .924.804.426 1.206l-10.45 8.434c-.505.407-1.238-.057-1.086-.687l1.615-6.696H4.104a.678.678 0 0 1-.455-1.182l10.63-9.604c.489-.442 1.257.002 1.118.646l-1.698 7.883z"
        },
        []
      ]
    ]
  );
  const Book2Icon = createIcon(
    { name: "Book 2", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 4.749a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v13h-15zm0 13v1.503a2 2 0 0 0 2 2h13"
        },
        []
      ],
      [
        "rect",
        {
          width: "8",
          height: "3",
          x: "8",
          y: "6.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: ".6"
        },
        []
      ]
    ]
  );
  const BookAdd2Icon = createIcon(
    { name: "Book Add 2", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 18.749v-12.8c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874c.428-.218.988-.218 2.108-.218h8.6c1.12 0 1.68 0 2.108.218a2 2 0 0 1 .874.874c.218.427.218.987.218 2.108v4.301m-15 8.499c0 .467 0 .7.039.895a2 2 0 0 0 1.568 1.569c.195.039.429.039.896.039h3.247M4.5 18.749h4.75M8.96 9.25h6.08c.336 0 .504 0 .632-.065a.6.6 0 0 0 .263-.263C16 8.794 16 8.626 16 8.29V7.21c0-.336 0-.504-.065-.632a.6.6 0 0 0-.263-.263c-.128-.065-.296-.065-.632-.065H8.96c-.336 0-.504 0-.632.065a.6.6 0 0 0-.263.263C8 6.706 8 6.874 8 7.21v1.08c0 .336 0 .504.065.632a.6.6 0 0 0 .263.263c.128.065.296.065.632.065"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 1 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const BookAddIcon = createIcon(
    { name: "Book Add", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 1 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 19.125a2.5 2.5 0 0 0 2.5 2.5h4.61m-7.11-2.5a2.5 2.5 0 0 1 2.5-2.5h3.32m-5.82 2.5v-13a3 3 0 0 1 3-3h11a1 1 0 0 1 1 1v6.495"
        },
        []
      ]
    ]
  );
  const BookInfo2Icon = createIcon(
    {
      name: "Book Info 2",
      tags: ["Manual", "Infobook", "Tutorial"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 4.749a2 2 0 0 1 2-2h11a2 2 0 0 1 2 2v13h-15z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 10.07v4.79"
        },
        []
      ],
      ["circle", { cx: "12", cy: "6.837", r: "1.197", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 17.749v1.503a2 2 0 0 0 2 2h13"
        },
        []
      ]
    ]
  );
  const BookInfoIcon = createIcon(
    { name: "Book Info", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 16.625v-10.5a3 3 0 0 1 3-3h11a1 1 0 0 1 1 1v12.5H7.375M4.5 16.62V19"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.5 21.625H7a2.5 2.5 0 0 1 0-5h12.5v4a1 1 0 0 1-1 1"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 9.825v3.79"
        },
        []
      ],
      ["circle", { cx: "12", cy: "6.592", r: "1.197", fill: "currentColor" }, []]
    ]
  );
  const BookOpenIcon = createIcon(
    { name: "Book Open", tags: ["Reading"], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 7.21a2 2 0 0 1 2-2H8.5a3.5 3.5 0 0 1 3.5 3.5v10.885l-1.015-.721a4 4 0 0 0-2.318-.74H4.75a2 2 0 0 1-2-2zm18.5 0a2 2 0 0 0-2-2H15.5a3.5 3.5 0 0 0-3.5 3.5v10.885l1.015-.721a4 4 0 0 1 2.317-.74h3.918a2 2 0 0 0 2-2z"
        },
        []
      ]
    ]
  );
  const BookIcon = createIcon(
    { name: "Book", tags: ["Reading"], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 16.625v-10.5a3 3 0 0 1 3-3h11a1 1 0 0 1 1 1v12.5H7.375M4.5 16.62V19"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.5 21.625H7a2.5 2.5 0 0 1 0-5h12.5v4a1 1 0 0 1-1 1"
        },
        []
      ]
    ]
  );
  const BookmarkAddIcon = createIcon(
    { name: "Bookmark Add", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V6h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 0 1-1 0V7h-2.493a.5.5 0 1 1 0-1H17V3.507a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.25 13.5v6.613a.644.644 0 0 1-.983.54l-5.702-3.48a1.09 1.09 0 0 0-1.13 0l-5.702 3.48a.644.644 0 0 1-.983-.54V6.25a3 3 0 0 1 3-3h3.31"
        },
        []
      ]
    ]
  );
  const BookmarkMultipleIcon = createIcon(
    {
      name: "Bookmark Multiple",
      tags: [""],
      category: "Organization",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 20.654a.6.6 0 0 0 .916.51l5.308-3.282a1 1 0 0 1 1.052 0l5.308 3.282a.6.6 0 0 0 .916-.51V8.75a3 3 0 0 0-3-3h-7.5a3 3 0 0 0-3 3z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 17.65v-8.9a6 6 0 0 0-6-6h-6.5"
        },
        []
      ]
    ]
  );
  const BookmarkIcon = createIcon(
    { name: "Bookmark", tags: ["Favorite"], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.75 20.113c0 .498.554.803.983.54l5.702-3.48a1.09 1.09 0 0 1 1.13 0l5.702 3.48a.644.644 0 0 0 .983-.54V6.25a3 3 0 0 0-3-3h-8.5a3 3 0 0 0-3 3z"
        },
        []
      ]
    ]
  );
  const BorderAllIcon = createIcon(
    {
      name: "Border All",
      tags: ["Not to be confused with 'Microsoft'"],
      category: "Design",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 20.25h4.25a4 4 0 0 0 4-4V12M12 20.25H7.75a4 4 0 0 1-4-4V12M12 20.25V3.75m0 0H7.75a4 4 0 0 0-4 4V12M12 3.75h4.25a4 4 0 0 1 4 4V12m-16.5 0h16.5"
        },
        []
      ]
    ]
  );
  const BoxDragIcon = createIcon(
    {
      name: "Box Drag",
      tags: ["Grab", "Hand", "Drop", "Grabber", "Draging"],
      category: "Gestures",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.073 17.533v-3.864m2.544-2.937c0-.699-.57-1.265-1.272-1.265s-1.272.566-1.272 1.265v2.937m2.544-.444v-4.21c0-.698.57-1.265 1.272-1.265s1.272.567 1.272 1.266v1.716m0 0v2.493m0-2.493a1.273 1.273 0 0 1 2.545 0v1.717m0 0v.776m0-.776c0-.7.57-1.266 1.272-1.266s1.272.567 1.272 1.266V17.1a5.15 5.15 0 0 1-5.15 5.15h-2.31a5.55 5.55 0 0 1-5.541-5.872l.012-.201a2.4 2.4 0 0 1 1.67-2.146l1.142-.362"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.75 18.25a3 3 0 0 1-3-3v-8.5a3 3 0 0 1 3-3h8.5a3 3 0 0 1 2.959 2.5"
        },
        []
      ]
    ]
  );
  const BoxMarginsIcon = createIcon(
    { name: "Box Margins", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.75 3.75v16.5m8.5 0V3.75m-12.5 4h16.5m0 8.5H3.75"
        },
        []
      ]
    ]
  );
  const BoxIcon = createIcon(
    {
      name: "Box",
      tags: ["Package", "Amazon", "Delivery"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.687 9.687 2.66 1.426A3.5 3.5 0 0 0 12 11.53M7.687 9.687 3.884 7.65m3.803 2.038 8.496-4.555.128-.07M3.884 7.648a3.5 3.5 0 0 0-.51 1.82v5.061a3.5 3.5 0 0 0 1.845 3.085l5.127 2.748A3.5 3.5 0 0 0 12 20.78M3.884 7.649a3.5 3.5 0 0 1 1.335-1.264l5.127-2.748a3.5 3.5 0 0 1 3.308 0L16.31 5.06M12 11.53a3.5 3.5 0 0 0 1.654-.416l6.462-3.464M12 11.529v9.25m0 0a3.5 3.5 0 0 0 1.654-.416l5.127-2.748a3.5 3.5 0 0 0 1.846-3.085V9.47a3.5 3.5 0 0 0-.511-1.821m0 0a3.5 3.5 0 0 0-1.335-1.264l-2.47-1.324"
        },
        []
      ]
    ]
  );
  const BracesVariableIcon = createIcon(
    { name: "Braces Variable", tags: [""], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7 20.25a2 2 0 0 1-2-2v-2.343a4 4 0 0 0-1.172-2.829L2.75 12l1.078-1.078A4 4 0 0 0 5 8.093V5.75a2 2 0 0 1 2-2m10 16.5a2 2 0 0 0 2-2v-2.343a4 4 0 0 1 1.172-2.829L21.25 12l-1.078-1.078A4 4 0 0 1 19 8.093V5.75a2 2 0 0 0-2-2M9 8.143l6 7.714m0-7.714-6 7.714"
        },
        []
      ]
    ]
  );
  const BracesIcon = createIcon(
    { name: "Braces", tags: [""], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8 20.25a2 2 0 0 1-2-2v-2.343a4 4 0 0 0-1.172-2.829L3.75 12l1.078-1.078A4 4 0 0 0 6 8.093V5.75a2 2 0 0 1 2-2m8 16.5a2 2 0 0 0 2-2v-2.343a4 4 0 0 1 1.172-2.829L20.25 12l-1.078-1.078A4 4 0 0 1 18 8.093V5.75a2 2 0 0 0-2-2"
        },
        []
      ]
    ]
  );
  const BracketsIcon = createIcon(
    { name: "Brackets", tags: ["Code"], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.75 3.75h-2a2 2 0 0 0-2 2v12.5a2 2 0 0 0 2 2h2m6.5-16.5h2a2 2 0 0 1 2 2v12.5a2 2 0 0 1-2 2h-2"
        },
        []
      ]
    ]
  );
  const BranchCompareIcon = createIcon(
    { name: "Branch Compare", tags: ["Git"], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.25 5.5a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0m13 13a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.5 8.25v7.25a3 3 0 0 0 3 3h4.336M10.75 16l1.793 1.793a1 1 0 0 1 .293.707M10.75 21l1.793-1.793a1 1 0 0 0 .293-.707m5.664-2.75V8.5a3 3 0 0 0-3-3h-4.336M13.25 8l-1.793-1.793a1 1 0 0 1-.293-.707M13.25 3l-1.793 1.793a1 1 0 0 0-.293.707"
        },
        []
      ]
    ]
  );
  const BranchFork2Icon = createIcon(
    { name: "Branch Fork 2", tags: ["Git"], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.5 8.25a2.75 2.75 0 1 0 0-5.5 2.75 2.75 0 0 0 0 5.5m0 0V10a2 2 0 0 0 2 2h3m6-3.75a2.75 2.75 0 1 0 0-5.5 2.75 2.75 0 0 0 0 5.5m0 0V10a2 2 0 0 1-2 2h-4m0 0v3.75m0 0a2.75 2.75 0 1 0 0 5.5 2.75 2.75 0 0 0 0-5.5"
        },
        []
      ]
    ]
  );
  const BranchForkIcon = createIcon(
    { name: "Branch Fork", tags: ["Git"], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7 8.25a2.75 2.75 0 1 0 0-5.5 2.75 2.75 0 0 0 0 5.5m0 0V12m0 3.75a2.75 2.75 0 1 0 0 5.5 2.75 2.75 0 0 0 0-5.5m0 0V12m10-3.75a2.75 2.75 0 1 0 0-5.5 2.75 2.75 0 0 0 0 5.5m0 0V9a3 3 0 0 1-3 3H7"
        },
        []
      ]
    ]
  );
  const BranchPullRequestIcon = createIcon(
    {
      name: "Branch Pull Request",
      tags: ["Git"],
      category: "Development",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.25 5.5a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0m13 13a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0m-13 0a2.75 2.75 0 1 1-5.5 0 2.75 2.75 0 0 1 5.5 0M5.5 8.25v7.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.5 15.75V8.5a3 3 0 0 0-3-3h-4.336M13.25 8l-1.793-1.793a1 1 0 0 1-.293-.707M13.25 3l-1.793 1.793a1 1 0 0 0-.293.707"
        },
        []
      ]
    ]
  );
  const BranchIcon = createIcon(
    { name: "Branch", tags: [""], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7 8.25a2.75 2.75 0 1 0 0-5.5 2.75 2.75 0 0 0 0 5.5m0 0v7.5m0-7.5c0 2.9 2.35 5.25 5.25 5.25h2M7 15.75a2.75 2.75 0 1 0 0 5.5 2.75 2.75 0 0 0 0-5.5m7.25-2.25a2.75 2.75 0 1 0 5.5 0 2.75 2.75 0 0 0-5.5 0"
        },
        []
      ]
    ]
  );
  const Briefcase2Icon = createIcon(
    {
      name: "Briefcase 2",
      tags: ["Suitcase", "Work"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 10.5A2.5 2.5 0 0 1 6.25 8h11.5a2.5 2.5 0 0 1 2.5 2.5v7a2.5 2.5 0 0 1-2.5 2.5H6.25a2.5 2.5 0 0 1-2.5-2.5zm4.853-5a1.5 1.5 0 0 1 1.5-1.5h3.794a1.5 1.5 0 0 1 1.5 1.5V8H8.603z"
        },
        []
      ]
    ]
  );
  const BriefcaseIcon = createIcon(
    { name: "Briefcase", tags: ["Suitcase"], category: "Business", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 9.894a2.5 2.5 0 0 1 2.5-2.5h11.5a2.5 2.5 0 0 1 2.5 2.5V17.5a2.5 2.5 0 0 1-2.5 2.5H6.25a2.5 2.5 0 0 1-2.5-2.5z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.75 7.394H6.25a2.5 2.5 0 0 0-2.5 2.5v.303a3 3 0 0 0 3 3h10.5a3 3 0 0 0 3-3v-.303a2.5 2.5 0 0 0-2.5-2.5M8.603 5.5a1.5 1.5 0 0 1 1.5-1.5h3.794a1.5 1.5 0 0 1 1.5 1.5v1.894H8.603z"
        },
        []
      ]
    ]
  );
  const BrightnessIcon = createIcon(
    {
      name: "Brightness",
      tags: ["Weather Sunny"],
      category: "Weather",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "4.25",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 2.75v1.5M5.46 5.46l1.06 1.06M12 19.75v1.5m5.48-3.77 1.06 1.06M2.75 12h1.5m1.21 6.54 1.06-1.06M19.75 12h1.5m-3.77-5.48 1.06-1.06"
        },
        []
      ]
    ]
  );
  const BroomIcon = createIcon(
    {
      name: "Broom",
      tags: ["Sweep", "Clean"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m13.444 17.626.707-.707a5 5 0 0 0 0-7.071m-.707 7.778-7.071-7.071m7.07 7.07-2.828 4.243-8.485-8.485 4.243-2.828m0 0 .707-.707a5 5 0 0 1 7.07 0m0 0 6.718-6.718"
        },
        []
      ]
    ]
  );
  const BugIcon = createIcon(
    { name: "Bug", tags: [""], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.5 9.08a3.23 3.23 0 0 1 3.23-3.23h2.54a3.23 3.23 0 0 1 3.23 3.23v6.27a4.5 4.5 0 0 1-4.5 4.5v0a4.5 4.5 0 0 1-4.5-4.5zm9 3.77h4.75m-18.5 0H7.5m2.25-9.7v.45A2.25 2.25 0 0 0 12 5.85v0a2.25 2.25 0 0 0 2.25-2.25v-.45M16.5 16.6h1.253a2.5 2.5 0 0 1 2.5 2.5v1.75M7.5 16.6H6.247a2.5 2.5 0 0 0-2.5 2.5v1.75M16.5 9.1h1.253a2.5 2.5 0 0 0 2.5-2.5V4.85M7.5 9.1H6.247a2.5 2.5 0 0 1-2.5-2.5V4.85"
        },
        []
      ]
    ]
  );
  const BuildingMultipleIcon = createIcon(
    {
      name: "Building Multiple",
      tags: [""],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.75 5a1.5 1.5 0 0 0-1.5-1.5H9.288a1 1 0 0 0-1 1v1H4.75a2 2 0 0 0-2 2v11a2 2 0 0 0 2 2h10zm0 3.5h4.5a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2h-4.5zm0 4h2.5m-2.5 4h2.5"
        },
        []
      ],
      ["circle", { cx: "6.75", cy: "9.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "6.75", cy: "13", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "6.75", cy: "16.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "10.75", cy: "9.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "10.75", cy: "13", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "10.75", cy: "16.5", r: "1", fill: "currentColor" }, []]
    ]
  );
  const ButtonIcon = createIcon(
    { name: "Button", tags: ["UI"], category: "System & Interface", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "11",
          x: "2.75",
          y: "6.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7 12h10"
        },
        []
      ]
    ]
  );
  const CakeIcon = createIcon(
    {
      name: "Cake",
      tags: ["Birthday", "Party"],
      category: "Food & Drink",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.25 13.25a2.5 2.5 0 0 1 2.5-2.5h10.5a2.5 2.5 0 0 1 2.5 2.5v8H4.25z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4.25 14.87 2.249 1.45a3 3 0 0 0 3.252 0l.623-.4a3 3 0 0 1 3.252 0l.623.4a3 3 0 0 0 3.252 0l2.249-1.45m1.5 6.375H2.75M12 2.75l1.414 1.414a2 2 0 1 1-2.828 0zm0 4.83v3.17"
        },
        []
      ]
    ]
  );
  const CalculatorIcon = createIcon(
    {
      name: "Calculator",
      tags: ["Solve", "Math"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "14.5",
          height: "18.5",
          x: "4.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "rect",
        {
          width: "7.5",
          height: "3.75",
          x: "8.25",
          y: "6.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1"
        },
        []
      ],
      ["circle", { cx: "8.5", cy: "13.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "12", cy: "13.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "15.5", cy: "13.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "8.5", cy: "17.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "12", cy: "17.5", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "15.5", cy: "17.5", r: "1", fill: "currentColor" }, []]
    ]
  );
  const CalendarIcon = createIcon(
    { name: "Calendar", tags: ["Date"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.25 4.75H6.75a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h10.5a3.5 3.5 0 0 0 3.5-3.5v-9.5a3.5 3.5 0 0 0-3.5-3.5m-14 4.5h17.5M7.361 4.75v-2m9.25 2v-2"
        },
        []
      ]
    ]
  );
  const CalligraphyPenIcon = createIcon(
    {
      name: "Calligraphy Pen",
      tags: ["Sketch"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.16 2.75v1.049c0 1.187 0 1.78-.231 2.233a2.12 2.12 0 0 1-.926.927c-.454.23-1.047.23-2.234.23h-.423M4.84 2.75v1.049c0 1.187 0 1.78.231 2.233.203.4.528.724.926.927.454.23 1.047.23 2.234.23h.423m0 0L6.319 11.47c-.367.673-.55 1.01-.61 1.362a2.1 2.1 0 0 0 .054.935c.1.344.32.657.762 1.283l2.704 3.83c.934 1.323 1.4 1.983 1.98 2.217a2.12 2.12 0 0 0 1.582 0c.58-.234 1.047-.894 1.98-2.216l2.704-3.83c.442-.627.662-.94.761-1.284a2.1 2.1 0 0 0 .055-.935c-.06-.352-.243-.689-.61-1.362l-2.335-4.28m-6.692 0h6.692M12 13.325v7.522"
        },
        []
      ],
      ["circle", { cx: "12", cy: "13.325", r: "1.673", fill: "currentColor" }, []]
    ]
  );
  const CameraIcon = createIcon(
    {
      name: "Camera",
      tags: ["Photo", "Picture", "Photography", "Shot", "Shoot"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.857 3.189h-1.714c-.681 0-1.022 0-1.331.094-.274.083-.529.22-.75.401-.25.205-.438.489-.816 1.056L7.103 6.454c-1.524 0-2.286 0-2.868.296a2.72 2.72 0 0 0-1.188 1.19c-.297.581-.297 1.343-.297 2.867v5.651c0 1.524 0 2.286.297 2.868.26.512.677.928 1.188 1.189.582.296 1.344.296 2.868.296h9.794c1.524 0 2.286 0 2.868-.296a2.72 2.72 0 0 0 1.188-1.19c.297-.581.297-1.343.297-2.867v-5.651c0-1.524 0-2.286-.297-2.868a2.72 2.72 0 0 0-1.188-1.189c-.582-.296-1.344-.296-2.868-.296L15.754 4.74c-.378-.567-.567-.85-.816-1.056a2.2 2.2 0 0 0-.75-.401c-.309-.094-.65-.094-1.331-.094"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.775 13.212a3.775 3.775 0 1 1-7.55 0 3.775 3.775 0 0 1 7.55 0"
        },
        []
      ]
    ]
  );
  const CancelCircleIcon = createIcon(
    { name: "Cancel Circle", tags: [""], category: "Status", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "m8.875 8.875 6.25 6.25m0-6.25-6.25 6.25"
        },
        []
      ]
    ]
  );
  const CancelSquareIcon = createIcon(
    { name: "Cancel Square", tags: [""], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M8.25 3.75a4.5 4.5 0 0 0-4.5 4.5v7.5a4.5 4.5 0 0 0 4.5 4.5h7.5a4.5 4.5 0 0 0 4.5-4.5v-7.5a4.5 4.5 0 0 0-4.5-4.5z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "m8.655 8.655 6.69 6.69m0-6.69-6.69 6.69"
        },
        []
      ]
    ]
  );
  const CancelIcon = createIcon(
    {
      name: "Cancel",
      tags: ["Dismiss", "X", "Close", "Abort", "Delete"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m5 19 7-7m0 0 7-7m-7 7L5 5m7 7 7 7"
        },
        []
      ]
    ]
  );
  const CandyIcon = createIcon(
    {
      name: "Candy",
      tags: [
        "Skeleton",
        "Emoji",
        "Bones",
        "Head",
        "Spooky",
        "Poison",
        "Pirate",
        "Kill",
        "Blood",
        "Death",
        "Die"
      ],
      category: "Food & Drink",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.02 7.53 7.53 9.02A5.269 5.269 0 0 0 14 17.243M9.02 7.53q.294-.295.62-.533m-.62.532.62-.532m0 0q.177-.128.36-.24m0 11.106V6.757m0 0a5.28 5.28 0 0 1 4.288-.54 5.268 5.268 0 0 1 2.183 8.764l-1.49 1.49a5.3 5.3 0 0 1-.981.772m0-11.106v11.106"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.47 7.53a3.16 3.16 0 0 1 0-4.471 1.053 1.053 0 0 1 1.486-.005l2.99 2.99a1.053 1.053 0 0 1-.005 1.486 3.16 3.16 0 0 1-4.47 0M7.53 16.47a3.16 3.16 0 0 0-4.471 0 1.053 1.053 0 0 0-.005 1.486l2.99 2.99a1.053 1.053 0 0 0 1.486-.005 3.16 3.16 0 0 0 0-4.47"
        },
        []
      ]
    ]
  );
  const CartIcon = createIcon(
    {
      name: "Cart",
      tags: ["Shopping", "Trolley", "Amazon", "Shopping Cart"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "9.549",
          cy: "19.049",
          r: "1.701",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "circle",
        {
          cx: "16.96",
          cy: "19.049",
          r: "1.701",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m5.606 5.555 2.01 6.364c.309.978.463 1.467.76 1.829.26.32.599.567.982.72.435.173.947.173 1.973.173h3.855c1.026 0 1.538 0 1.972-.173.384-.153.722-.4.983-.72.296-.362.45-.851.76-1.829l.409-1.296.24-.766.331-1.05a2.5 2.5 0 0 0-2.384-3.252zm0 0-.011-.037a7 7 0 0 0-.14-.42 2.92 2.92 0 0 0-2.512-1.84C2.84 3.25 2.727 3.25 2.5 3.25"
        },
        []
      ]
    ]
  );
  const CentIcon = createIcon(
    {
      name: "Cent",
      tags: ["$", "Money", "Coin", "Dollar", "¢"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.085 3.875v2.417m0 14.083v-2.417m4.382-1.705a5.84 5.84 0 0 1-4.382 1.705m4.382-9.961a5.84 5.84 0 0 0-4.382-1.705m0 11.666A5.836 5.836 0 0 1 6.5 12.125a5.84 5.84 0 0 1 5.585-5.833"
        },
        []
      ]
    ]
  );
  const CenterHorizontalIcon = createIcon(
    {
      name: "Center Horizontal",
      tags: ["Stats", "Statistics", "Data", "Graph", "Chart"],
      category: "Organization",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 20.25V3.75m-16.5 16.5V3.75"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "13",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(-1 0 0 1 15 5.5)"
        },
        []
      ]
    ]
  );
  const CenterVerticalIcon = createIcon(
    {
      name: "Center Vertical",
      tags: ["Stats", "Statistics", "Data", "Graph", "Chart"],
      category: "Organization",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 20.25h16.5M3.75 3.75h16.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "6",
          height: "13",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "matrix(0 -1 -1 0 18.5 15)"
        },
        []
      ]
    ]
  );
  const ChatIcon = createIcon(
    { name: "Chat", tags: [""], category: "Communication & Cloud", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 21.25a9.25 9.25 0 1 0-8.307-5.177c.108.22.144.468.089.706l-.816 3.536a.6.6 0 0 0 .72.72l3.535-.817a1.06 1.06 0 0 1 .706.09A9.2 9.2 0 0 0 12 21.25M7.97 9.886h8.06m-8.06 4.228h5.748"
        },
        []
      ]
    ]
  );
  const CheckboxCheckedIcon = createIcon(
    {
      name: "Checkbox Checked",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16.512 9.107-5.787 5.786-3.237-3.232"
        },
        []
      ]
    ]
  );
  const CheckboxIndeterminate2Icon = createIcon(
    {
      name: "Checkbox Indeterminate 2",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "18.5",
          x: "2.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.113 6.25a.86.86 0 0 0-.863.862v9.775c0 .477.386.863.862.863h9.775a.863.863 0 0 0 .863-.863V7.114a.863.863 0 0 0-.863-.863z"
        },
        []
      ]
    ]
  );
  const CheckboxIndeterminateIcon = createIcon(
    {
      name: "Checkbox Indeterminate",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.19 12H7.81"
        },
        []
      ]
    ]
  );
  const CheckboxUncheckedIcon = createIcon(
    {
      name: "Checkbox Unchecked",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ]
    ]
  );
  const CheckmarkCircleIcon = createIcon(
    { name: "Checkmark Circle", tags: [""], category: "Status", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16.375 9.194-5.611 5.612-3.139-3.134"
        },
        []
      ]
    ]
  );
  const CheckmarkStarburstIcon = createIcon(
    {
      name: "Checkmark Starburst",
      tags: [
        "Verified",
        "Twitter Blue",
        "Trusted",
        "Safe",
        "Legitimate",
        "Real",
        "X Premium"
      ],
      category: "Security",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.072 4.069a2.17 2.17 0 0 1 2.804-1.162l1.315.529c.52.208 1.099.208 1.618 0l1.315-.529a2.17 2.17 0 0 1 2.804 1.162l.556 1.303c.22.515.63.925 1.144 1.144l1.303.556a2.17 2.17 0 0 1 1.162 2.804l-.529 1.315a2.17 2.17 0 0 0 0 1.618l.529 1.315a2.17 2.17 0 0 1-1.162 2.804l-1.303.556a2.17 2.17 0 0 0-1.144 1.144l-.556 1.303a2.17 2.17 0 0 1-2.804 1.162l-1.315-.529a2.17 2.17 0 0 0-1.618 0l-1.315.529a2.17 2.17 0 0 1-2.804-1.162l-.556-1.303a2.17 2.17 0 0 0-1.144-1.144l-1.303-.556a2.17 2.17 0 0 1-1.162-2.804l.529-1.315a2.17 2.17 0 0 0 0-1.618l-.529-1.315A2.17 2.17 0 0 1 4.07 7.072l1.303-.556a2.17 2.17 0 0 0 1.144-1.144z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m15.899 9.5-5 5-2.797-2.793"
        },
        []
      ]
    ]
  );
  const CheckmarkIcon = createIcon(
    {
      name: "Checkmark",
      tags: ["Done", "Check", "Completed"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m19.75 7.018-9.257 9.257a1 1 0 0 1-1.414 0L4.25 11.446"
        },
        []
      ]
    ]
  );
  const ChevronDownIcon = createIcon(
    { name: "Chevron Down", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4.75 9.75 6.19 6.19a1.5 1.5 0 0 0 2.12 0l6.19-6.19"
        },
        []
      ]
    ]
  );
  const ChevronLeftIcon = createIcon(
    { name: "Chevron Left", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m14.25 4.75-6.19 6.19a1.5 1.5 0 0 0 0 2.12l6.19 6.19"
        },
        []
      ]
    ]
  );
  const ChevronRightIcon = createIcon(
    { name: "Chevron Right", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m9.75 4.75 6.19 6.19a1.5 1.5 0 0 1 0 2.12l-6.19 6.19"
        },
        []
      ]
    ]
  );
  const ChevronUpIcon = createIcon(
    { name: "Chevron Up", tags: [""], category: "Arrows", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4.75 14.25 6.19-6.19a1.5 1.5 0 0 1 2.12 0l6.19 6.19"
        },
        []
      ]
    ]
  );
  const ChromeRestoreIcon = createIcon(
    { name: "Chrome Restore", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 9.25a3.5 3.5 0 0 1 3.5-3.5h8.5a3.5 3.5 0 0 1 3.5 3.5v8.5a3.5 3.5 0 0 1-3.5 3.5h-8.5a3.5 3.5 0 0 1-3.5-3.5z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.75 2.75h8a6.5 6.5 0 0 1 6.5 6.5v8"
        },
        []
      ]
    ]
  );
  const CircleSmallIcon = createIcon(
    { name: "Circle Small", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "3.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const CircleIcon = createIcon(
    { name: "Circle", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const ClipboardPasteIcon = createIcon(
    { name: "Clipboard Paste", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M9.75 21.25h-3a3.5 3.5 0 0 1-3.5-3.5V6.25a3.5 3.5 0 0 1 3.5-3.5h9.5a3.5 3.5 0 0 1 3.5 3.5v2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M7.75 2.75h7.5v2.5a2 2 0 0 1-2 2h-3.5a2 2 0 0 1-2-2z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.25 13.25a2.5 2.5 0 0 1 2.5-2.5h3.5a2.5 2.5 0 0 1 2.5 2.5v5.5a2.5 2.5 0 0 1-2.5 2.5h-3.5a2.5 2.5 0 0 1-2.5-2.5z"
        },
        []
      ]
    ]
  );
  const ClipboardSearchIcon = createIcon(
    { name: "Clipboard Search", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M14.25 21.25h3a3.5 3.5 0 0 0 3.5-3.5V6.25a3.5 3.5 0 0 0-3.5-3.5h-9.5a3.5 3.5 0 0 0-3.5 3.5v4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M8.75 2.75h7.5v2.5a2 2 0 0 1-2 2h-3.5a2 2 0 0 1-2-2z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.17 19.67a4.054 4.054 0 1 0-5.733-5.733A4.054 4.054 0 0 0 9.17 19.67m0 0 2.58 2.58"
        },
        []
      ]
    ]
  );
  const ClipboardIcon = createIcon(
    { name: "Clipboard", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "18.5",
          x: "3.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-width": "1.5",
          rx: "3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M8.25 2.75h7.5v2.5a2 2 0 0 1-2 2h-3.5a2 2 0 0 1-2-2z"
        },
        []
      ]
    ]
  );
  const ClockIcon = createIcon(
    { name: "Clock", tags: ["Analog", "Time"], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 12a9.25 9.25 0 1 1-18.5 0 9.25 9.25 0 0 1 18.5 0"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.25 6.75v6h4"
        },
        []
      ]
    ]
  );
  const ClosedCaptionsIcon = createIcon(
    {
      name: "Closed Captions",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "14.5",
          x: "2.75",
          y: "4.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.5 14.382a2.75 2.75 0 1 1 0-4.764m7.125 4.764a2.75 2.75 0 1 1 0-4.764"
        },
        []
      ]
    ]
  );
  const CloudIcon = createIcon(
    { name: "Cloud", tags: [""], category: "Communication & Cloud", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "m7.197 18.496.037-.75h-.072zm.234-8.83.728.181zm11.334 1.983.217-.717zM22 15a4.25 4.25 0 0 0-3.018-4.068l-.434 1.435A2.75 2.75 0 0 1 20.5 15zm-4.25 4.25A4.25 4.25 0 0 0 22 15h-1.5a2.75 2.75 0 0 1-2.75 2.75zm-10.375 0H17.75v-1.5H7.375zm-.216-.005q.108.005.216.005v-1.5q-.07 0-.14-.003zm.003-1.499L7 17.75v1.5q.116 0 .23-.005zM7 17.75a3.5 3.5 0 0 1-3.5-3.5H2a5 5 0 0 0 5 5zm-3.5-3.5a3.5 3.5 0 0 1 3.5-3.5v-1.5a5 5 0 0 0-5 5zm9.268-9.5a6.25 6.25 0 0 0-6.065 4.735l1.456.362a4.75 4.75 0 0 1 4.61-3.597zm6.25 6.25a6.25 6.25 0 0 0-6.25-6.25v1.5a4.75 4.75 0 0 1 4.75 4.75zM7 10.75c.54 0 1.025-.365 1.159-.903l-1.456-.362A.305.305 0 0 1 7 9.25zm10.518.25a1.44 1.44 0 0 0 1.03 1.367l.434-1.435a.04.04 0 0 1 .02.013.1.1 0 0 1 .016.055z"
        },
        []
      ]
    ]
  );
  const CodeIcon = createIcon(
    { name: "Code", tags: [""], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.75 6.5 3.25 12l5.5 5.5m6.5-11 5.5 5.5-5.5 5.5"
        },
        []
      ]
    ]
  );
  const CoffeeHotIcon = createIcon(
    { name: "Coffee Hot", tags: [""], category: "Food & Drink", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.5 10.682c0-.875.71-1.585 1.585-1.585H16.52c.876 0 1.585.71 1.585 1.585v3.265a7.303 7.303 0 0 1-7.302 7.303v0A7.303 7.303 0 0 1 3.5 13.947z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.105 10.556h1.464A2.43 2.43 0 0 1 22 12.986v0a2.43 2.43 0 0 1-2.43 2.43h-1.465M6.421 3.75v2.43m4.382-2.43v2.43m4.381-2.43v2.43"
        },
        []
      ]
    ]
  );
  const ColorPaletteIcon = createIcon(
    {
      name: "Color Palette",
      tags: ["House", "Home Samsung"],
      category: "Design",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(-1 0 0 1 16.654 6.034)"
        },
        []
      ],
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(-1 0 0 1 12.156 5.221)"
        },
        []
      ],
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(-1 0 0 1 8.654 7.94)"
        },
        []
      ],
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(-1 0 0 1 7.685 12.156)"
        },
        []
      ],
      [
        "circle",
        {
          cx: "1.25",
          cy: "1.25",
          r: "1.25",
          fill: "currentColor",
          transform: "matrix(-1 0 0 1 9.904 15.948)"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 12A9.25 9.25 0 1 0 12 21.25c1.318 0 2.224-1.28 2.329-2.594l.117-1.473a3 3 0 0 1 2.758-2.752l1.651-.129c1.28-.1 2.395-1.019 2.395-2.302Z"
        },
        []
      ]
    ]
  );
  const CommentExclamationIcon = createIcon(
    {
      name: "Comment Exclamation",
      tags: ["Message", "Important"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.183 16.958h.75a.75.75 0 0 0-.75-.75zm.839 4.16.508.552zm4.52-4.16v-.75a.75.75 0 0 0-.508.199zM3.839 6.75A3.25 3.25 0 0 1 7.09 3.5V2a4.75 4.75 0 0 0-4.75 4.75zm0 6.208V6.75h-1.5v6.208zm3.25 3.25a3.25 3.25 0 0 1-3.25-3.25h-1.5a4.75 4.75 0 0 0 4.75 4.75zm.072 0H7.09v1.5h.072zm.022 0h-.022v1.5h.022zm.75 4.542v-3.792h-1.5v3.792zm-.419-.184a.25.25 0 0 1 .42.184h-1.5c0 1.09 1.295 1.657 2.096.92zm4.52-4.16-4.52 4.16L8.53 21.67l4.52-4.16zm4.877-.198h-4.37v1.5h4.37zm3.25-3.25a3.25 3.25 0 0 1-3.25 3.25v1.5a4.75 4.75 0 0 0 4.75-4.75zm0-6.208v6.208h1.5V6.75zM16.91 3.5a3.25 3.25 0 0 1 3.25 3.25h1.5A4.75 4.75 0 0 0 16.91 2zm-9.822 0h9.822V2H7.089z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 6.25v4"
        },
        []
      ],
      ["circle", { cx: "12", cy: "13.25", r: "1", fill: "currentColor" }, []]
    ]
  );
  const CommentMultipleIcon = createIcon(
    {
      name: "Comment Multiple",
      tags: ["Message", "Conversation"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M6.43 17.742h.75a.75.75 0 0 0-.75-.75zm.84 3.384-.509-.55zm3.67-3.385v-.75a.75.75 0 0 0-.508.2zM3.736 8.76a2.25 2.25 0 0 1 2.25-2.25v-1.5a3.75 3.75 0 0 0-3.75 3.75zm0 5.982V8.76h-1.5v5.982zm2.25 2.25a2.25 2.25 0 0 1-2.25-2.25h-1.5a3.75 3.75 0 0 0 3.75 3.75zm.427 0h-.427v1.5h.427zm.019 0h-.02v1.5h.02zm.75 3.767V17.74h-1.5v3.018zm-.42-.184a.25.25 0 0 1 .42.184h-1.5c0 1.09 1.296 1.657 2.097.919zm3.671-3.385-3.67 3.385 1.016 1.103 3.671-3.385zm4.553-.199H10.94v1.5h4.044zm2.25-2.25a2.25 2.25 0 0 1-2.25 2.25v1.5a3.75 3.75 0 0 0 3.75-3.75zm0-5.981v5.982h1.5V8.76zm-2.25-2.25a2.25 2.25 0 0 1 2.25 2.25h1.5a3.75 3.75 0 0 0-3.75-3.75zm-9 0h9v-1.5h-9z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.985 2.76h8a6 6 0 0 1 6 6v4.982"
        },
        []
      ]
    ]
  );
  const CommentIcon = createIcon(
    {
      name: "Comment",
      tags: ["Message"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.183 16.958h.75a.75.75 0 0 0-.75-.75zm.839 4.16.508.552zm4.52-4.16v-.75a.75.75 0 0 0-.508.199zM3.839 6.75A3.25 3.25 0 0 1 7.09 3.5V2a4.75 4.75 0 0 0-4.75 4.75zm0 6.208V6.75h-1.5v6.208zm3.25 3.25a3.25 3.25 0 0 1-3.25-3.25h-1.5a4.75 4.75 0 0 0 4.75 4.75zm.072 0H7.09v1.5h.072zm.022 0h-.022v1.5h.022zm.75 4.542v-3.792h-1.5v3.792zm-.419-.184a.25.25 0 0 1 .42.184h-1.5c0 1.09 1.295 1.657 2.096.92zm4.52-4.16-4.52 4.16L8.53 21.67l4.52-4.16zm4.877-.198h-4.37v1.5h4.37zm3.25-3.25a3.25 3.25 0 0 1-3.25 3.25v1.5a4.75 4.75 0 0 0 4.75-4.75zm0-6.208v6.208h1.5V6.75zM16.91 3.5a3.25 3.25 0 0 1 3.25 3.25h1.5A4.75 4.75 0 0 0 16.91 2zm-9.822 0h9.822V2H7.089z"
        },
        []
      ]
    ]
  );
  const CompareSizeIcon = createIcon(
    { name: "Compare Size", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.75 8.75a2.5 2.5 0 0 1 2.5 2.5v6.5a2.5 2.5 0 0 1-2.5 2.5H5.25a2.5 2.5 0 0 1-2.5-2.5v-6.5a2.5 2.5 0 0 1 2.5-2.5zm-2.5 7.5v2.5m0-8v2.5m-8-9.5h2.5m3 0h.5a2 2 0 0 1 2 2v.5m-11-2.5h-.5a2 2 0 0 0-2 2v.5"
        },
        []
      ]
    ]
  );
  const CompassIcon = createIcon(
    {
      name: "Compass",
      tags: ["Direction", "Explore", "Safari"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.195 10.195q.221-.22.475-.404c.382-.275.835-.456 1.74-.818l2.357-.943c.632-.252.947-.379 1.148-.313.174.058.31.194.368.368.066.2-.06.517-.313 1.148l-.943 2.357c-.362.905-.543 1.358-.818 1.74q-.183.255-.404.475m-3.61-3.61a4 4 0 0 0-.404.475c-.275.382-.456.835-.818 1.74l-.943 2.357c-.252.632-.379.947-.313 1.148.058.174.194.31.368.368.2.066.516-.06 1.148-.313l2.357-.943c.905-.362 1.358-.543 1.74-.818q.255-.183.475-.404m-3.61-3.61 3.61 3.61"
        },
        []
      ]
    ]
  );
  const ComponentIcon = createIcon(
    {
      name: "Component",
      tags: ["Symbol", "Figma", "Sketch", "Icon", "Asset"],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "5.671",
          height: "5.671",
          x: "7.99",
          y: "17.86",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5",
          transform: "rotate(-45 7.99 17.86)"
        },
        []
      ],
      [
        "rect",
        {
          width: "5.671",
          height: "5.671",
          x: "13.851",
          y: "12",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5",
          transform: "rotate(-45 13.85 12)"
        },
        []
      ],
      [
        "rect",
        {
          width: "5.671",
          height: "5.671",
          x: "2.13",
          y: "12",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5",
          transform: "rotate(-45 2.13 12)"
        },
        []
      ],
      [
        "rect",
        {
          width: "5.671",
          height: "5.671",
          x: "7.99",
          y: "6.14",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5",
          transform: "rotate(-45 7.99 6.14)"
        },
        []
      ]
    ]
  );
  const ComposeIcon = createIcon(
    { name: "Compose", tags: ["Mail", "Write"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.371 4.25H8.25a5 5 0 0 0-5 5v6.5a5 5 0 0 0 5 5h6.5a5 5 0 0 0 5-5v-2.121"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.299 14.75a1.86 1.86 0 0 0 1.316-.545l6.59-6.59a1.86 1.86 0 0 0 0-2.633l-1.187-1.187a1.86 1.86 0 0 0-2.633 0l-6.59 6.59a1.86 1.86 0 0 0-.545 1.316v3.049z"
        },
        []
      ]
    ]
  );
  const ComputerMacIcon = createIcon(
    {
      name: "Computer Mac",
      tags: ["iMac", "All-in-one", "AIO", "Desktop", "Apple", "Mac"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 6.25a3.5 3.5 0 0 1 3.5-3.5h11.5a3.5 3.5 0 0 1 3.5 3.5v8.031a3.5 3.5 0 0 1-3.5 3.5H6.25a3.5 3.5 0 0 1-3.5-3.5zm0 7.75h18.5M9.11 17.781v1.469a2 2 0 0 1-2 2h-.6m8.38-3.469v1.469a2 2 0 0 0 2 2h.6m-10.982 0h10.984"
        },
        []
      ]
    ]
  );
  const ComputerIcon = createIcon(
    {
      name: "Computer",
      tags: ["All-in-one", "AIO", "Desktop", "PC"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "15.031",
          x: "2.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.11 17.781v3.469m5.78-3.469v3.469m-8.382 0h10.984"
        },
        []
      ]
    ]
  );
  const ContractDownIcon = createIcon(
    { name: "Contract Down", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 20.25h4.25a4 4 0 0 0 4-4v-2.5M12 20.25H7.75a4 4 0 0 1-4-4V12M12 20.25V15a3 3 0 0 0-3-3H3.75m0 0V7.75a4 4 0 0 1 4-4h2.5m10 6.5h-5.5a1 1 0 0 1-.707-.293M13.75 3.75v5.5c0 .276.112.526.293.707M20.25 3.75l-5.5 5.5-.707.707"
        },
        []
      ]
    ]
  );
  const CookiesIcon = createIcon(
    { name: "Cookies", tags: [""], category: "Food & Drink", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.076 10.535a2.75 2.75 0 0 0 3.89 0v0c.127-.128.362-.076.393.102a9.25 9.25 0 0 1-15.65 8.154 9.25 9.25 0 0 1 8.154-15.65c.178.031.23.266.102.394v0a2.75 2.75 0 0 0 2.333 4.667 2.75 2.75 0 0 0 .778 2.333"
        },
        []
      ],
      ["circle", { cx: "8.5", cy: "15.5", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "7.5", cy: "9.5", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "12.5", cy: "12.5", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "15.5", cy: "16.5", r: "1.25", fill: "currentColor" }, []]
    ]
  );
  const CopyIcon = createIcon(
    { name: "Copy", tags: ["Clipboard"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.75 5.75a3 3 0 0 0-3-3h-6.5a3 3 0 0 0-3 3v9.5a3 3 0 0 0 3 3h6.5a3 3 0 0 0 3-3z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.75 6.75v8.5a6 6 0 0 1-6 6h-5.5"
        },
        []
      ]
    ]
  );
  const CopyleftIcon = createIcon(
    {
      name: "Copyleft",
      tags: ["Legal", "Rights", "License"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.172 14.828a4 4 0 1 0 0-5.656"
        },
        []
      ]
    ]
  );
  const CopyrightIcon = createIcon(
    {
      name: "Copyright",
      tags: ["Legal", "Rights", "License", "Protection"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.828 14.828a4 4 0 1 1 0-5.656"
        },
        []
      ]
    ]
  );
  const CornerRadiusIcon = createIcon(
    { name: "Corner Radius", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.25 4.75h-7.5a7 7 0 0 0-7 7v7.5"
        },
        []
      ]
    ]
  );
  const CreditCardIcon = createIcon(
    {
      name: "Credit Card",
      tags: ["Debit Card", "Payment"],
      category: "Security",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "14",
          x: "2.75",
          y: "5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        { stroke: "currentColor", "stroke-width": "1.5", d: "M2.75 9.5h18.5" },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M14.75 14.25h3"
        },
        []
      ]
    ]
  );
  const CropIcon = createIcon(
    {
      name: "Crop",
      tags: ["Edit", "Photo", "Image", "Picture"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 17.653H9.347a3 3 0 0 1-3-3V2.75M2.75 6.347h3.597m11.306 11.306v3.597M8.917 6.347h5.736a3 3 0 0 1 3 3v5.736"
        },
        []
      ]
    ]
  );
  const CssIcon = createIcon(
    {
      name: "CSS",
      tags: ["CSS3", "Stylesheet", "Programming", "Web"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m20.754 4.792-2.84 14.31a1.5 1.5 0 0 1-1.099 1.161l-4.442 1.141a1.5 1.5 0 0 1-.746 0l-4.442-1.14a1.5 1.5 0 0 1-1.098-1.162L3.246 4.792A1.5 1.5 0 0 1 4.717 3h14.566a1.5 1.5 0 0 1 1.471 1.792"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.77 6.881h9.53l-8.63 5.577h6.225a1 1 0 0 1 .978 1.205l-.562 2.683a1 1 0 0 1-.653.74l-2.283.786a1 1 0 0 1-.66-.003L8.99 16.9"
        },
        []
      ]
    ]
  );
  const CursorClickIcon = createIcon(
    {
      name: "Cursor Click",
      tags: [""],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.394 20.734c-.757.985-2.332.471-2.362-.771l-.239-9.86a1.317 1.317 0 0 1 2.003-1.157l8.42 5.137c1.06.647.718 2.268-.513 2.431l-3.987.527c-.346.046-.66.227-.872.503z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.797 8.75h2.5m3.75-3.502v-2.5M6.815 5.765 5.047 3.998m8.232 1.767 1.768-1.767"
        },
        []
      ]
    ]
  );
  const CursorDragIcon = createIcon(
    {
      name: "Cursor Drag",
      tags: ["Grab", "Hand", "Drop", "Grabber"],
      category: "Gestures",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.315 11.055v4.176m3.246-6.593V6.555c0-.892-.727-1.615-1.623-1.615s-1.623.723-1.623 1.615v3.747m3.246-.566V4.365a1.62 1.62 0 0 1 1.623-1.615c.897 0 1.623.723 1.623 1.615V9.73m0 .005v-3.18a1.624 1.624 0 0 1 3.246 0v2.19m0 0v.99m0-.99a1.62 1.62 0 0 1 1.624-1.615A1.62 1.62 0 0 1 20.3 8.745v5.935a6.57 6.57 0 0 1-6.57 6.57h-2.95a7.08 7.08 0 0 1-7.069-7.492l.015-.256a3.06 3.06 0 0 1 2.13-2.738l1.458-.462m0 0V11.4"
        },
        []
      ]
    ]
  );
  const CursorIcon = createIcon(
    {
      name: "Cursor",
      tags: ["Cursor", "Mouse", "Pointer"],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.084 20.276c-1.06 1.38-3.264.66-3.306-1.079L4.443 5.392C4.407 3.932 6 3.012 7.247 3.773l11.788 7.192c1.485.906 1.006 3.176-.719 3.403l-5.581.738a1.84 1.84 0 0 0-1.221.705z"
        },
        []
      ]
    ]
  );
  const CutIcon = createIcon(
    { name: "Cut", tags: ["Scissors"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.651 14.43a3.75 3.75 0 1 0-4.302 6.143 3.75 3.75 0 0 0 4.302-6.144m0 0 3.35-4.446m5.45-7.235-3.82 5.069m1.718 6.611a3.75 3.75 0 1 1 4.302 6.144 3.75 3.75 0 0 1-4.302-6.144m0 0L12 9.984M6.55 2.749 12 9.984"
        },
        []
      ]
    ]
  );
  const DarkThemeIcon = createIcon(
    {
      name: "Dark Theme",
      tags: ["Appearance"],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M2.75 12A9.25 9.25 0 0 0 12 21.25V2.75A9.25 9.25 0 0 0 2.75 12"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 21.25a9.25 9.25 0 0 0 0-18.5m0 18.5a9.25 9.25 0 0 1 0-18.5m0 18.5V2.75"
        },
        []
      ]
    ]
  );
  const DatabaseAddIcon = createIcon(
    {
      name: "Database Add",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.25 6.25c0 1.933-3.246 3.5-7.25 3.5s-7.25-1.567-7.25-3.5m14.5 0c0-1.933-3.246-3.5-7.25-3.5s-7.25 1.567-7.25 3.5m14.5 0v3.53M4.75 6.25V12m0 0v5.75c0 1.756 2.678 3.21 6.17 3.461M4.75 12c0 1.577 2.16 2.91 5.13 3.348"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 1 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const DatabaseIcon = createIcon(
    {
      name: "Database",
      tags: ["SQL", "MongoDB"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.25 6.25c0 1.933-3.246 3.5-7.25 3.5s-7.25-1.567-7.25-3.5m14.5 0c0-1.933-3.246-3.5-7.25-3.5s-7.25 1.567-7.25 3.5m14.5 0V12M4.75 6.25V12m0 0v5.75c0 1.933 3.246 3.5 7.25 3.5s7.25-1.567 7.25-3.5V12m-14.5 0c0 1.933 3.246 3.5 7.25 3.5s7.25-1.567 7.25-3.5"
        },
        []
      ]
    ]
  );
  const DeleteIcon = createIcon(
    { name: "Delete", tags: ["Trash", "Remove"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.687 6.213 6.8 18.976a2.5 2.5 0 0 0 2.466 2.092h3.348m6.698-14.855L17.2 18.976a2.5 2.5 0 0 1-2.466 2.092h-3.348m-1.364-9.952v5.049m3.956-5.049v5.049M2.75 6.213h18.5m-6.473 0v-1.78a1.5 1.5 0 0 0-1.5-1.5h-2.554a1.5 1.5 0 0 0-1.5 1.5v1.78z"
        },
        []
      ]
    ]
  );
  const DiamondIcon = createIcon(
    { name: "Diamond", tags: ["Premium", "Pro"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.69 9.915h8.62m-8.62 0H2.75m4.94 0 3.65 10.051M7.69 9.915l2.4-3.933.55-1.012m5.67 4.945h4.94m-4.94 0-3.65 10.051m3.65-10.051-2.4-3.933-.566-1.012M2.75 9.915c0 .42.079.84.236 1.236.212.535.642 1.028 1.5 2.013l3.467 3.976c1.397 1.602 2.095 2.404 2.923 2.698q.229.081.464.128M2.75 9.915c0-.42.079-.84.236-1.237.212-.535.642-1.027 1.5-2.013.467-.534.7-.801.97-1.008a3.36 3.36 0 0 1 1.361-.619c.334-.068.688-.068 1.397-.068h2.427M21.25 9.915c0 .42-.079.84-.236 1.236-.212.535-.642 1.028-1.5 2.013l-3.467 3.976c-1.397 1.602-2.095 2.404-2.923 2.698a3.4 3.4 0 0 1-.464.128m8.59-10.051c0-.42-.079-.84-.236-1.237-.212-.535-.642-1.027-1.5-2.013-.467-.534-.7-.801-.97-1.008a3.36 3.36 0 0 0-1.361-.619c-.334-.068-.688-.068-1.397-.068h-2.442m-.684 14.996a3.4 3.4 0 0 1-1.32 0M13.344 4.97H10.64"
        },
        []
      ]
    ]
  );
  const DirectionsIcon = createIcon(
    {
      name: "Directions",
      tags: [""],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.507 14.007a2.84 2.84 0 0 1 0-4.014l6.486-6.486a2.84 2.84 0 0 1 4.014 0l6.486 6.486a2.84 2.84 0 0 1 0 4.014l-6.486 6.486a2.84 2.84 0 0 1-4.014 0z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m14.46 9.02 1.394 1.395a1 1 0 0 1 .293.707m-1.688 2.102 1.395-1.395a1 1 0 0 0 .293-.707m-7.46 4.031v-2.53a1.5 1.5 0 0 1 1.5-1.5h5.96"
        },
        []
      ]
    ]
  );
  const DoNotDisturbIcon = createIcon(
    { name: "Do Not Disturb", tags: [""], category: "Status", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M7.5 12h9"
        },
        []
      ]
    ]
  );
  const DocumentIcon = createIcon(
    { name: "Document", tags: ["Docs"], category: "Text", deprecated: false },
    [
      [
        "rect",
        {
          width: "15",
          height: "18.5",
          x: "4.5",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.5 6.755h7m-7 4h7m-7 4H12"
        },
        []
      ]
    ]
  );
  const DollarCircleIcon = createIcon(
    {
      name: "Dollar Circle",
      tags: ["$", "Money", "Cash", "Bill", "Currency"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M15.099 9.723s-.377-1.783-3.001-1.977m-2.957 7.108s.761 1.8 2.957 1.912m0-10.766v1.746m0 10.754v-1.734m0-9.02a7 7 0 0 0-.476-.017c-1.14 0-2.622.95-2.622 2.275 0 1.326 1.073 1.846 2.965 2.169s3.23 1.035 3.23 2.497-1.566 2.101-2.881 2.101a4 4 0 0 1-.216-.005"
        },
        []
      ],
      [
        "circle",
        {
          cx: "12.25",
          cy: "12.25",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const DollarIcon = createIcon(
    {
      name: "Dollar",
      tags: ["$", "Money", "Cash", "Bill", "Currency"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M16.441 8.26S15.884 5.621 12 5.334m-4.376 10.52S8.75 18.518 12 18.684M12 2.75v2.584m0 15.916v-2.567m0-13.35a10 10 0 0 0-.704-.024c-1.688 0-3.881 1.405-3.881 3.367 0 1.963 1.589 2.732 4.388 3.21s4.782 1.531 4.782 3.696-2.32 3.11-4.266 3.11a6 6 0 0 1-.319-.009"
        },
        []
      ]
    ]
  );
  const DoorOpenIcon = createIcon(
    {
      name: "Door Open",
      tags: ["Configure", "Spanner", "Options", "Mechanism", "Mechanic"],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.157 20.517h.593a2.5 2.5 0 0 0 2.5-2.5V5.75a2.5 2.5 0 0 0-2.5-2.5h-9.5c-.55 0-1.06.178-1.473.48m-1.02 13.742a1.5 1.5 0 0 0 .86 1.357l5.896 2.775a1.5 1.5 0 0 0 2.138-1.358V8.387a1.5 1.5 0 0 0-.86-1.356l-7.014-3.3m0 0A2.5 2.5 0 0 0 4.75 5.75v11.722"
        },
        []
      ],
      ["circle", { cx: "10.25", cy: "12.75", r: "1.25", fill: "currentColor" }, []]
    ]
  );
  const DoorIcon = createIcon(
    {
      name: "Door",
      tags: ["Closed"],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.25 6.25a2.5 2.5 0 0 1 2.5-2.5h8.5a2.5 2.5 0 0 1 2.5 2.5v15H5.25zm-2.5 15h18.5"
        },
        []
      ],
      ["circle", { cx: "15.25", cy: "12.5", r: "1.5", fill: "currentColor" }, []]
    ]
  );
  const DrawTextIcon = createIcon(
    { name: "Draw Text", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m5.719 16.25 1.92-4.404m0 0h6.91m-6.91 0 2.94-6.747a.553.553 0 0 1 1.029 0l2.941 6.747m0 0 .337.774"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M15.68 20.936a2.5 2.5 0 0 0 1.218-.673l5.455-5.45a2.526 2.526 0 1 0-3.57-3.573l-5.453 5.452c-.335.336-.57.76-.675 1.222l-.535 2.354a1.007 1.007 0 0 0 1.206 1.206z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.75 19.687.568.234c.638.263 1.364.175 1.956-.18.69-.411 1.649-.915 2.483-1.1.583-.13 1.243.199 1.091.776-.17.642-.69 1.396-.192 1.745.75.525 5.031-.818 5.031-.818"
        },
        []
      ]
    ]
  );
  const DropIcon = createIcon(
    {
      name: "Drop",
      tags: ["Water", "Fill", "Transparency", "Transparent", "Droplet"],
      category: "Food & Drink",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M12 21c-1.804 0-3.246-.566-4.397-1.446C2.38 15.557 5.832 8.09 10.801 3.522a1.767 1.767 0 0 1 2.398 0c4.97 4.568 8.42 12.035 3.198 16.032C15.246 20.434 13.804 21 12 21Z"
        },
        []
      ]
    ]
  );
  const EmojiFrownIcon = createIcon(
    {
      name: "Emoji Frown",
      tags: ["Sad", "Dislike", "Not Helpful"],
      category: "Emojis",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      ["circle", { cx: "9", cy: "9.5", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "15", cy: "9.5", r: "1.25", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.464 15.813a4 4 0 0 0-6.928 0"
        },
        []
      ]
    ]
  );
  const EmojiGrinIcon = createIcon(
    { name: "Emoji Grin", tags: [""], category: "Emojis", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      ["circle", { cx: "9", cy: "9", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "15", cy: "9", r: "1.25", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.5 12.75c.276 0 .503.224.475.5a4.999 4.999 0 0 1-9.594 1.413 5 5 0 0 1-.356-1.414c-.028-.275.199-.499.475-.499z"
        },
        []
      ]
    ]
  );
  const EmojiLaughterIcon = createIcon(
    { name: "Emoji Laughter", tags: [""], category: "Emojis", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.5 12.75c.276 0 .503.224.475.5a4.999 4.999 0 0 1-9.594 1.413 5 5 0 0 1-.356-1.414c-.028-.275.199-.499.475-.499zM7.264 9.082a1.797 1.797 0 0 1 3.472 0m2.528 0a1.796 1.796 0 0 1 3.472 0"
        },
        []
      ]
    ]
  );
  const EmojiIcon = createIcon(
    {
      name: "Emoji",
      tags: ["Smile", "Happy", "Smiley", "Like", "Helpful"],
      category: "Emojis",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      ["circle", { cx: "9", cy: "9.5", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "15", cy: "9.5", r: "1.25", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.464 14.25a4 4 0 0 1-6.928 0"
        },
        []
      ]
    ]
  );
  const EraserIcon = createIcon(
    { name: "Eraser", tags: [""], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.788 20.5h9.02m-9.02 0a3.47 3.47 0 0 0 2.486-1.02l1.29-1.29M9.788 20.5a3.47 3.47 0 0 1-2.438-1.02l-3.33-3.33a3.48 3.48 0 0 1 0-4.923l1.29-1.29m0 0 5.417-5.417a3.48 3.48 0 0 1 4.923 0l3.33 3.33a3.48 3.48 0 0 1 0 4.924l-5.417 5.416M5.31 9.936l.367.368 7.585 7.585.301.301"
        },
        []
      ]
    ]
  );
  const ExpandIcon = createIcon(
    { name: "Expand", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 20.25h4.25a4 4 0 0 0 4-4v-2.5M12 20.25H7.75a4 4 0 0 1-4-4V12M12 20.25V15a3 3 0 0 0-3-3H3.75m0 0V7.75a4 4 0 0 1 4-4h2.5m3.5 0h5.5c.276 0 .526.112.707.293m.293 6.207v-5.5a1 1 0 0 0-.293-.707M13.75 10.25l5.5-5.5.707-.707"
        },
        []
      ]
    ]
  );
  const ExtensionIcon = createIcon(
    {
      name: "Extension",
      tags: ["Puzzle"],
      category: "System & Interface",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M6 9a.75.75 0 0 0 0 1.5zm4 10a.75.75 0 0 0 1.5 0zm8.5-10a.75.75 0 0 0 0 1.5zM16 5a.75.75 0 0 0-1.5 0zm-.267.738-.146.736zm-.472-.471-.735.146zm3.977 9.466-.735.146zm-.738-.483V15zm.267.011.146-.735zM6.738 9.268l.736.146zm-.471.471-.146-.735zm8.994 8.995.736.146zm.472-.471-.146-.736zm-9.466-4-.146.735zm.471.471-.735.146zm12.029-4.995.146.736zm.471-.471-.735-.146zm-8.971 8.995-.146.735zm.471.47.736-.145zm0-13.465.736.146zm-.471.471.146.736zM11.5 5A1.5 1.5 0 0 1 13 3.5V2a3 3 0 0 0-3 3zM9.75 6.5H10V5h-.25zM7.5 8.75A2.25 2.25 0 0 1 9.75 6.5V5A3.75 3.75 0 0 0 6 8.75zm0 .25v-.25H6V9zm-3 3A1.5 1.5 0 0 1 6 10.5V9a3 3 0 0 0-3 3zM6 13.5A1.5 1.5 0 0 1 4.5 12H3a3 3 0 0 0 3 3zm1.5 1.75V15H6v.25zm2.25 2.25a2.25 2.25 0 0 1-2.25-2.25H6A3.75 3.75 0 0 0 9.75 19zm.25 0h-.25V19H10zm3 3a1.5 1.5 0 0 1-1.5-1.5H10a3 3 0 0 0 3 3zm1.5-1.5a1.5 1.5 0 0 1-1.5 1.5V22a3 3 0 0 0 3-3zm1.75-1.5H16V19h.25zm2.25-2.25a2.25 2.25 0 0 1-2.25 2.25V19A3.75 3.75 0 0 0 20 15.25zm0-.25v.25H20V15zm0-1.5A1.5 1.5 0 0 1 17 12h-1.5a3 3 0 0 0 3 3zM17 12a1.5 1.5 0 0 1 1.5-1.5V9a3 3 0 0 0-3 3zm1.5-3.25V9H20v-.25zM16.25 6.5a2.25 2.25 0 0 1 2.25 2.25H20A3.75 3.75 0 0 0 16.25 5zm-.25 0h.25V5H16zm-3-3A1.5 1.5 0 0 1 14.5 5H16a3 3 0 0 0-3-3zM16 5h-.087l-.051-.001c-.024 0-.01-.002.017.004l-.292 1.471c.148.03.31.026.413.026zm-1.5 0c0 .103-.004.265.026.413l1.471-.292c.006.027.005.04.004.017v-.05L16 5zm1.38.003a.15.15 0 0 1 .117.118l-1.471.292a1.35 1.35 0 0 0 1.06 1.061zM20 15c0-.104.003-.265-.026-.413l-1.471.292c-.006-.027-.005-.04-.004-.017V15zm-1.5 0 .138.001c.024 0 .01.002-.017-.004l.292-1.471c-.148-.03-.31-.026-.413-.026zm1.474-.413a1.35 1.35 0 0 0-1.06-1.061l-.293 1.471a.15.15 0 0 1-.118-.118zM6 9l-.001.138c0 .024-.002.01.004-.017l1.471.292c.03-.148.026-.31.026-.413zm0 1.5c.103 0 .265.004.413-.026l-.292-1.471c.027-.006.04-.005.017-.004A2 2 0 0 1 6 9zm.003-1.38a.15.15 0 0 1 .118-.117l.292 1.471a1.35 1.35 0 0 0 1.061-1.06zM16 19v-.087l.001-.051c0-.024.002-.01-.004.017l-1.471-.292c-.03.148-.026.31-.026.413zm0-1.5c-.104 0-.265-.004-.413.026l.292 1.471c-.027.006-.04.005-.017.004h.05L16 19zm-.003 1.38a.15.15 0 0 1-.118.117l-.292-1.471a1.35 1.35 0 0 0-1.061 1.06zM6 15l.138.001c.024 0 .01.002-.017-.004l.292-1.471c-.148-.03-.31-.026-.413-.026zm1.5 0c0-.104.004-.265-.026-.413l-1.471.292c-.006-.027-.005-.04-.004-.017V15zm-1.38-.003a.15.15 0 0 1-.117-.118l1.471-.292a1.35 1.35 0 0 0-1.06-1.061zM18.5 10.5c.103 0 .265.004.413-.026l-.292-1.471c.027-.006.04-.005.017-.004A2 2 0 0 1 18.5 9zm0-1.5v.087l-.001.051c0 .024-.002.01.004-.017l1.471.292c.03-.148.026-.31.026-.413zm.413 1.474a1.35 1.35 0 0 0 1.061-1.06l-1.471-.293a.15.15 0 0 1 .118-.118zM10 19l.138.001c.024 0 .01.002-.017-.004l.292-1.471c-.148-.03-.31-.026-.413-.026zm1.5 0c0-.103.004-.265-.026-.413l-1.471.292c-.006-.027-.005-.04-.004-.017A2 2 0 0 1 10 19zm-1.38-.003a.15.15 0 0 1-.117-.118l1.471-.292a1.35 1.35 0 0 0-1.06-1.061zM10 5l-.001.138c0 .024-.002.01.004-.017l1.471.292c.03-.148.026-.31.026-.413zm0 1.5c.103 0 .265.004.413-.026l-.292-1.471c.027-.006.04-.005.017-.004h-.05L10 5zm.003-1.38a.15.15 0 0 1 .118-.117l.292 1.471a1.35 1.35 0 0 0 1.061-1.06z"
        },
        []
      ]
    ]
  );
  const EyeOffIcon = createIcon(
    {
      name: "Eye Off",
      tags: ["Invisible", "Hidden"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.282 21.782 4.278-4.278M21.782 3.282 17.673 7.39m-3.363 3.363a2.64 2.64 0 0 0-1.063-1.063 2.625 2.625 0 1 0-2.494 4.62m3.557-3.557-3.557 3.557m3.557-3.557 3.363-3.363m-6.92 6.92L7.56 17.504M17.673 7.39c-.38-.319-.791-.621-1.232-.894C15.2 5.726 13.717 5.19 12 5.19c-4.956 0-7.948 4.459-8.91 6.16-.11.196-.165.293-.197.446a1.2 1.2 0 0 0 0 .408c.032.152.088.25.198.445.51.903 1.593 2.582 3.237 3.96.38.319.791.621 1.232.895m12.18-7.925c.528.694.919 1.328 1.17 1.773.11.194.165.292.197.444.023.112.023.296 0 .408-.032.152-.087.25-.197.444-.96 1.702-3.95 6.162-8.91 6.162q-.714-.002-1.374-.117"
        },
        []
      ]
    ]
  );
  const EyeIcon = createIcon(
    { name: "Eye", tags: ["Look"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.182 12.808C4.233 14.613 7.195 18.81 12 18.81c4.813 0 7.77-4.199 8.82-6.002a1.6 1.6 0 0 0-.001-1.615C19.769 9.389 16.809 5.19 12 5.19s-7.768 4.197-8.818 6.001a1.6 1.6 0 0 0 0 1.617Z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 14.625a2.625 2.625 0 1 0 0-5.25 2.625 2.625 0 0 0 0 5.25Z"
        },
        []
      ]
    ]
  );
  const EyedropperColorAccentIcon = createIcon(
    {
      name: "Eyedropper Color Accent",
      tags: ["Eyedropper 2"],
      category: "Accents",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "m7.941 19.968 6.109-6.108H6.235l-2.202 2.202c-.205.205-.308.307-.387.425a1.5 1.5 0 0 0-.171.335c-.048.134-.07.277-.116.563l-.096.608c-.173 1.1-.26 1.65-.087 2.05.151.35.43.629.78.78.399.174.949.087 2.05-.085l.61-.096c.286-.044.43-.067.563-.115q.18-.065.337-.17c.117-.08.22-.183.425-.389"
        },
        []
      ]
    ]
  );
  const EyedropperColorIcon = createIcon(
    {
      name: "Eyedropper Color",
      tags: ["Eyedropper 2"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.047 7.819 20.92 9.69m-1.872-1.87-2.864-2.864m2.864 2.864 1.496-1.496a1 1 0 0 0 0-1.414l-1.45-1.45a1 1 0 0 0-1.414 0l-1.496 1.496m-1.872-1.872 1.872 1.872M6.235 13.86l-2.202 2.202c-.205.205-.308.307-.387.425q-.107.157-.171.335c-.048.134-.07.277-.116.563l-.096.608c-.173 1.1-.26 1.65-.087 2.05.151.35.43.629.78.78.399.174.949.087 2.05-.085l.61-.096c.286-.044.43-.067.563-.115q.18-.065.337-.17c.117-.08.22-.183.425-.389l7.718-7.718c.594-.594.891-.89 1.002-1.233a1.5 1.5 0 0 0 0-.927c-.11-.343-.408-.64-1.002-1.234l-.513-.513c-.594-.594-.891-.891-1.234-1.002a1.5 1.5 0 0 0-.927 0c-.342.11-.64.408-1.233 1.002zm0 0h7.815"
        },
        []
      ]
    ]
  );
  const EyedropperIcon = createIcon(
    { name: "Eyedropper", tags: ["Color"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.047 7.819 20.92 9.69m-1.872-1.87-2.864-2.864m2.864 2.864 1.496-1.496a1 1 0 0 0 0-1.414l-1.45-1.45a1 1 0 0 0-1.414 0l-1.496 1.496m-1.872-1.872 1.872 1.872m-3.796 2.751a1.5 1.5 0 0 1 2.121 0l1.787 1.786a1.5 1.5 0 0 1 0 2.12l-8.562 8.563a1.5 1.5 0 0 1-.829.421l-2.12.332a1.5 1.5 0 0 1-1.714-1.715l.334-2.118a1.5 1.5 0 0 1 .42-.827z"
        },
        []
      ]
    ]
  );
  const FacebookIcon = createIcon(
    {
      name: "Facebook",
      tags: ["Meta", "Social Media", "Mark Zuckerburg", "Messenger"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M10.478 21.125a9.3 9.3 0 0 0 3.037.002m-3.038-.002A9.25 9.25 0 0 1 2.75 12a9.25 9.25 0 1 1 10.765 9.127m-3.038-.002V16.12H8.58a.6.6 0 0 1-.6-.6v-1.838a.6.6 0 0 1 .6-.6h1.897V9.95a3 3 0 0 1 3-3h1.81a1 1 0 0 1 1 1v1.04a1 1 0 0 1-1 1h-.772a1 1 0 0 0-1 1v2.092h2.297a.6.6 0 0 1 .592.698l-.25 1.504a1 1 0 0 1-.986.836h-1.653v5.007"
        },
        []
      ]
    ]
  );
  const FastFowardIcon = createIcon(
    { name: "Fast Foward", tags: [""], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.996 18.323c-1.02.784-2.496.057-2.496-1.229V6.906c0-1.286 1.476-2.013 2.496-1.229l6.224 5.192a1.473 1.473 0 0 1 0 2.262z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.246 18.323c-1.02.784-2.496.057-2.496-1.229V6.906c0-1.286 1.476-2.013 2.496-1.229l6.224 5.192a1.473 1.473 0 0 1 0 2.262z"
        },
        []
      ]
    ]
  );
  const FigmaIcon = createIcon(
    {
      name: "Figma",
      tags: [
        "Design",
        "Dylan Field",
        "Sketch",
        "Icons",
        "Prototype",
        "Prototyping",
        "Adobe"
      ],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.833 5.833A3.083 3.083 0 0 1 8.917 2.75H12v6.167H8.917a3.083 3.083 0 0 1-3.084-3.084m12.334 0a3.083 3.083 0 0 0-3.084-3.083H12v6.167h3.083a3.083 3.083 0 0 0 3.084-3.084"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.167",
          height: "6.167",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.083",
          transform: "matrix(-1 0 0 1 18.167 8.917)"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.833 12a3.083 3.083 0 0 1 3.084-3.083H12v6.166H8.917A3.083 3.083 0 0 1 5.833 12"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.833 18.167a3.083 3.083 0 0 1 3.084-3.084H12v3.084a3.083 3.083 0 0 1-3.083 3.083v0a3.083 3.083 0 0 1-3.084-3.083"
        },
        []
      ]
    ]
  );
  const FileAddIcon = createIcon(
    { name: "File Add", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M6.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H7v2.493a.5.5 0 1 1-1 0V18H3.507a.5.5 0 0 1 0-1H6v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.292 10.25v-4a3.5 3.5 0 0 1 3.5-3.5h2.448a3.5 3.5 0 0 1 1.447.313M13.75 21.25h2.458a3.5 3.5 0 0 0 3.5-3.5v-5.53c0-.505-.109-.999-.314-1.45m-7.706-7.707a3.5 3.5 0 0 1 1.027.712l5.968 5.97c.3.3.54.647.711 1.026m-7.706-7.708V8.77a2 2 0 0 0 2 2h5.706"
        },
        []
      ]
    ]
  );
  const FileSyncIcon = createIcon(
    { name: "File Sync", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.292 10.25v-4a3.5 3.5 0 0 1 3.5-3.5h2.448a3.5 3.5 0 0 1 1.447.313M13.75 21.25h2.458a3.5 3.5 0 0 0 3.5-3.5v-5.53c0-.505-.109-.999-.314-1.45m-7.706-7.707a3.5 3.5 0 0 1 1.027.712l5.968 5.97c.3.3.54.647.711 1.026m-7.706-7.708V8.77a2 2 0 0 0 2 2h5.706"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M6.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m1.548-8.64a3.5 3.5 0 0 0-4.929 2.234.5.5 0 0 0 .966.259A2.5 2.5 0 0 1 8.3 15.765h-.565a.5.5 0 0 0 0 1H9.5a.5.5 0 0 0 .5-.5V14.5a.5.5 0 0 0-1 0v.55a3.5 3.5 0 0 0-.952-.69m1.833 4.046a.5.5 0 0 0-.966-.259A2.5 2.5 0 0 1 4.7 19.235h.565a.5.5 0 0 0 0-1H3.5a.5.5 0 0 0-.5.5V20.5a.5.5 0 0 0 1 0v-.55a3.5 3.5 0 0 0 5.88-1.544",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const FileIcon = createIcon(
    { name: "File", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.688 3.063a3.5 3.5 0 0 1 1.027.712l5.968 5.97c.3.3.54.647.711 1.026m-7.706-7.708a3.5 3.5 0 0 0-1.448-.313H7.792a3.5 3.5 0 0 0-3.5 3.5v11.5a3.5 3.5 0 0 0 3.5 3.5h8.416a3.5 3.5 0 0 0 3.5-3.5v-5.53c0-.505-.109-.999-.314-1.45m-7.706-7.707V8.77a2 2 0 0 0 2 2h5.706"
        },
        []
      ]
    ]
  );
  const Filter2Icon = createIcon(
    { name: "Filter 2", tags: ["Funnel"], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.145 17.704v-3.976c0-.381 0-.572-.044-.75a1.5 1.5 0 0 0-.192-.446c-.1-.155-.238-.286-.515-.548L3.578 7.43a2.648 2.648 0 0 1 1.82-4.572h13.189a2.664 2.664 0 0 1 1.852 4.579l-4.765 4.607c-.27.261-.405.392-.501.545a1.5 1.5 0 0 0-.187.441c-.044.176-.044.364-.044.74v3.935c0 .542 0 .813-.062 1.057a2 2 0 0 1-.641 1.027c-.192.163-.436.282-.923.52-1.14.557-1.709.835-2.172.835a2 2 0 0 1-1.795-1.121c-.204-.416-.204-1.05-.204-2.318"
        },
        []
      ]
    ]
  );
  const FilterCancel2Icon = createIcon(
    { name: "Filter Cancel 2", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m17.52 10.25 2.919-2.814a2.664 2.664 0 0 0-1.852-4.579H5.397a2.648 2.648 0 0 0-1.82 4.572l4.817 4.555c.277.262.415.393.515.548a1.5 1.5 0 0 1 .192.446c.044.178.044.369.044.75v3.976c0 1.268 0 1.902.204 2.318a2 2 0 0 0 .901.91"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m-2.352-7.852a.5.5 0 0 1 .707 0l1.645 1.645 1.645-1.645a.5.5 0 1 1 .707.707L18.207 17.5l1.645 1.645a.5.5 0 0 1-.707.707L17.5 18.207l-1.645 1.645a.5.5 0 1 1-.707-.707l1.645-1.645-1.645-1.645a.5.5 0 0 1 0-.707",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const FilterCancelIcon = createIcon(
    { name: "Filter Cancel", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 7.25h5.75M7.385 12H12m-1.73 4.75h3.46"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m-2.352-7.852a.5.5 0 0 1 .707 0L17.5 5.793l1.645-1.645a.5.5 0 1 1 .707.707L18.207 6.5l1.645 1.645a.5.5 0 0 1-.707.707L17.5 7.207l-1.645 1.645a.5.5 0 0 1-.707-.707L16.793 6.5l-1.645-1.645a.5.5 0 0 1 0-.707",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const FilterIcon = createIcon(
    { name: "Filter", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 7.25h15M7.385 12h9.23m-6.345 4.75h3.46"
        },
        []
      ]
    ]
  );
  const Flag2Icon = createIcon(
    {
      name: "Flag 2",
      tags: [
        "Report",
        "Checkpoint",
        "Flagged",
        "Font Awesome",
        "Curved",
        "Waving",
        "Wave"
      ],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.25 15.182v6.07m0-6.07a7.5 7.5 0 0 1 7.25 0 7.5 7.5 0 0 0 6.936.164.57.57 0 0 0 .314-.518V3.682a7.5 7.5 0 0 1-7.25 0 7.5 7.5 0 0 0-6.722-.265.93.93 0 0 0-.528.855z"
        },
        []
      ]
    ]
  );
  const FlagIcon = createIcon(
    {
      name: "Flag",
      tags: ["Report", "Checkpoint", "Flagged", "Font Awesome"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.25 21.25v-6m0 0v-10a1.5 1.5 0 0 1 1.5-1.5h11.086a1 1 0 0 1 .821 1.571L15.75 9.5l2.907 4.179a1 1 0 0 1-.82 1.571z"
        },
        []
      ]
    ]
  );
  const FlashlightIcon = createIcon(
    {
      name: "Flashlight",
      tags: ["Torch", "Light"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.512 7.71h10.976m-8.73 3.78h6.477v8.11a1.9 1.9 0 0 1-1.9 1.9h-2.677a1.9 1.9 0 0 1-1.9-1.9z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m5.806 7.99 2.952 3.5h6.477l2.959-3.5a1 1 0 0 0 .236-.645V4.85A1.85 1.85 0 0 0 16.58 3H7.42a1.85 1.85 0 0 0-1.85 1.85v2.495a1 1 0 0 0 .236.645m6.191 7.039v1.766"
        },
        []
      ]
    ]
  );
  const FoldableHorizontalHalfIcon = createIcon(
    {
      name: "Foldable Horizontal Half",
      tags: ["Folding Phone", "Z Fold", "Dual Screen"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m12 5.25 6.777-1.649a2 2 0 0 1 2.473 1.944v12.91a2 2 0 0 1-2.473 1.944L12 18.75z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-dasharray": "2.5 3",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m9.5 19.358-4.895 1.19a1.5 1.5 0 0 1-1.855-1.457V4.91a1.5 1.5 0 0 1 1.855-1.46L9.5 4.641"
        },
        []
      ]
    ]
  );
  const FoldableHorizontalIcon = createIcon(
    {
      name: "Foldable Horizontal",
      tags: ["Folding Phone", "Z Fold", "Dual Screen"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 5.25 5.223 3.601A2 2 0 0 0 2.75 5.545v12.91A2 2 0 0 0 5.223 20.4L12 18.75m0-13.5v13.5m0-13.5 6.777-1.649a2 2 0 0 1 2.473 1.944v12.91a2 2 0 0 1-2.473 1.944L12 18.75"
        },
        []
      ]
    ]
  );
  const FoldableVerticalHalfIcon = createIcon(
    {
      name: "Foldable Vertical Half",
      tags: ["Folding Phone", "Z Flip", "Dual Screen"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m17.25 12 1.648 6.777a2 2 0 0 1-1.943 2.473h-9.91A2 2 0 0 1 5.1 18.777L6.75 12z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-dasharray": "2 3",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m6.142 9.5-1.19-4.895A1.5 1.5 0 0 1 6.408 2.75H17.59a1.5 1.5 0 0 1 1.458 1.855L17.859 9.5"
        },
        []
      ]
    ]
  );
  const FoldableVerticalIcon = createIcon(
    {
      name: "Foldable Vertical",
      tags: ["Folding Phone", "Z Flip", "Dual Screen"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m6.375 12-1.39 6.853a2 2 0 0 0 1.961 2.397h10.108a2 2 0 0 0 1.96-2.397L17.625 12m-11.25 0h11.25m-11.25 0-1.39-6.853A2 2 0 0 1 6.947 2.75h10.108a2 2 0 0 1 1.96 2.397L17.625 12"
        },
        []
      ]
    ]
  );
  const FolderAddIcon = createIcon(
    { name: "Folder Add", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.494a.5.5 0 0 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 8.623v6.579c0 1.68 0 2.52.327 3.162a3 3 0 0 0 1.311 1.31c.642.328 1.482.328 3.162.328h2.7M2.75 8.623V7.598c0-1.26 0-1.89.245-2.371a2.25 2.25 0 0 1 .984-.984c.48-.245 1.11-.245 2.371-.245h1.679c.611 0 .917 0 1.205.07a2.5 2.5 0 0 1 .722.299c.253.154.469.37.901.803L12 6.313m-9.25 2.31h5.283c.611 0 .917 0 1.205-.069a2.5 2.5 0 0 0 .722-.3c.252-.154.469-.37.901-.802L12 6.312m0 0h4.449c1.68 0 2.52 0 3.163.326a3 3 0 0 1 1.31 1.311c.267.521.316 1.174.326 2.301"
        },
        []
      ]
    ]
  );
  const FolderOpenIcon = createIcon(
    { name: "Folder Open", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.882 18.043 4.041-5.623a4 4 0 0 1 3.249-1.665h8.752M3.882 18.043a3.65 3.65 0 0 0 2.777 1.277h8.343a4 4 0 0 0 3.405-1.9l2.918-4.734a1.287 1.287 0 0 0-1.115-1.931h-.286M3.882 18.043A3.65 3.65 0 0 1 3 15.661V7.424A2.744 2.744 0 0 1 5.744 4.68h2.653c.607 0 1.189.24 1.618.67l.911.91a1.83 1.83 0 0 0 1.294.537l4.044-.001a3.66 3.66 0 0 1 3.66 3.66v.299"
        },
        []
      ]
    ]
  );
  const FolderIcon = createIcon(
    { name: "Folder", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 8.623v7.379a4 4 0 0 0 4 4h10.5a4 4 0 0 0 4-4v-5.69a4 4 0 0 0-4-4H12M2.75 8.624V6.998a3 3 0 0 1 3-3h2.9a2.5 2.5 0 0 1 1.768.732L12 6.313m-9.25 2.31h5.904a2.5 2.5 0 0 0 1.768-.732L12 6.313"
        },
        []
      ]
    ]
  );
  const FullScreenMaximizeIcon = createIcon(
    { name: "Full Screen Maximize", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 8.345V6.25a2.5 2.5 0 0 1 2.5-2.5h2.095M3.75 15.655v2.095a2.5 2.5 0 0 0 2.5 2.5h2.095M20.25 8.345V6.25a2.5 2.5 0 0 0-2.5-2.5h-2.095m4.595 11.905v2.095a2.5 2.5 0 0 1-2.5 2.5h-2.095"
        },
        []
      ]
    ]
  );
  const FullScreenMinimizeIcon = createIcon(
    { name: "Full Screen Minimize", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.345 3.75v2.095a2.5 2.5 0 0 1-2.5 2.5H3.75M8.345 20.25v-2.095a2.5 2.5 0 0 0-2.5-2.5H3.75M15.655 3.75v2.095a2.5 2.5 0 0 0 2.5 2.5h2.095M15.655 20.25v-2.095a2.5 2.5 0 0 1 2.5-2.5h2.095"
        },
        []
      ]
    ]
  );
  const GameIcon = createIcon(
    {
      name: "Game",
      tags: ["Controller", "Xbox", "PlayStation", "Arcade", "Gaming", "Steam"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.031 3.887H7.97a5.22 5.22 0 0 0-5.219 5.22v8.265c0 2.075 2.533 3.085 3.962 1.581l2.976-3.134h4.624l2.875 3.46c1.374 1.654 4.063.682 4.063-1.467V9.106a5.22 5.22 0 0 0-5.219-5.219M8.138 8.39v4m-2-2h4"
        },
        []
      ],
      ["circle", { cx: "14.662", cy: "9.39", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "16.862", cy: "11.59", r: "1", fill: "currentColor" }, []]
    ]
  );
  const GiftIcon = createIcon(
    { name: "Gift", tags: ["Present"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.5 12.5H12V21H7a2.5 2.5 0 0 1-2.5-2.5zm-1.75-3A1.5 1.5 0 0 1 4.25 8H12v4.5H4.25a1.5 1.5 0 0 1-1.5-1.5zm9.25 3h7.5v6A2.5 2.5 0 0 1 17 21h-5zM12 8h7.75a1.5 1.5 0 0 1 1.5 1.5V11a1.5 1.5 0 0 1-1.5 1.5H12zM7 5.5A2.5 2.5 0 0 1 9.5 3v0A2.5 2.5 0 0 1 12 5.5V8H9.5A2.5 2.5 0 0 1 7 5.5m10 0A2.5 2.5 0 0 0 14.5 3v0A2.5 2.5 0 0 0 12 5.5V8h2.5A2.5 2.5 0 0 0 17 5.5"
        },
        []
      ]
    ]
  );
  const GitCommitIcon = createIcon(
    { name: "Git Commit", tags: [""], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.75 12a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0m0 0h5.5m-18.5 0h5.5"
        },
        []
      ]
    ]
  );
  const GithubIcon = createIcon(
    {
      name: "GitHub",
      tags: ["Open Source", "Code", "Microsoft", "Git"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.096 21.25v-3.146a3.33 3.33 0 0 1 .758-2.115c-3.005-.4-5.28-1.859-5.28-5.798 0-1.666 1.432-3.89 1.432-3.89-.514-1.13-.5-3.084.06-3.551 0 0 1.95.175 3.847 1.75 1.838-.495 3.764-.554 5.661 0 1.897-1.575 3.848-1.75 3.848-1.75.558.467.573 2.422.06 3.551 0 0 1.432 2.224 1.432 3.89 0 3.94-2.276 5.398-5.28 5.798a3.33 3.33 0 0 1 .757 2.115v3.146"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.086 16.57c.163.554.463 1.066.878 1.496.414.431.932.77 1.513.988a4.46 4.46 0 0 0 3.62-.216"
        },
        []
      ]
    ]
  );
  const GitlabIcon = createIcon(
    {
      name: "GitLab",
      tags: ["Open Source"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.063 12.052a3.19 3.19 0 0 1-1.058 3.606l-6.706 5.164a2.13 2.13 0 0 1-2.598 0l-6.706-5.164a3.19 3.19 0 0 1-1.058-3.606L5.915 3.73l2.37 6.621c.15.423.552.706 1.001.706h5.428c.45 0 .85-.283 1.002-.706l2.37-6.621z"
        },
        []
      ]
    ]
  );
  const GlobeIcon = createIcon(
    { name: "Globe", tags: [""], category: "Communication & Cloud", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 12A9.25 9.25 0 0 0 12 2.75M21.25 12H2.75m18.5 0A9.25 9.25 0 0 1 12 21.25m0-18.5A9.25 9.25 0 0 0 2.75 12M12 2.75c-.5 0-4 4.141-4 9.25s3.5 9.25 4 9.25m0-18.5c.5 0 4 4.141 4 9.25s-3.5 9.25-4 9.25M2.75 12A9.25 9.25 0 0 0 12 21.25"
        },
        []
      ]
    ]
  );
  const Google2Icon = createIcon(
    {
      name: "Google 2",
      tags: ["Google Color", "Pixel", "Sundar Pichai", "Search", "Android"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.201 9.947a5.365 5.365 0 0 1 8.145-2.262c.355.262.858.268 1.17-.044l1.617-1.616c.312-.312.314-.822-.024-1.106A9.25 9.25 0 0 0 3.612 8.46M7.2 9.947a5.365 5.365 0 0 0 1.69 6.31M7.2 9.947 3.611 8.46m5.28 7.796a5.365 5.365 0 0 0 6.533 0m-6.532 0-2.365 3.082m8.897-3.082a5.4 5.4 0 0 0 1.537-1.866h-3.91a.8.8 0 0 1-.8-.8V11.3a.8.8 0 0 1 .8-.8h7.493c.316 0 .61.186.681.495.313 1.362-.125 3.246-.158 3.384l-.004.016c-.528 1.963-1.661 3.706-3.274 4.944m-2.365-3.083 2.365 3.082m0 0a9.25 9.25 0 0 1-11.262 0m0 0A9.25 9.25 0 0 1 3.612 8.46"
        },
        []
      ]
    ]
  );
  const GoogleChromeIcon = createIcon(
    {
      name: "Google Chrome",
      tags: ["Browser", "Chromium", "Microsoft", "MS Edge"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 8.25a3.75 3.75 0 0 0-3.747 3.904M12 8.25a3.75 3.75 0 0 1 3.608 4.775M12 8.25h8.458m-4.85 4.775a3.752 3.752 0 0 1-7.355-.871m7.355.871-3.08 8.21m7.93-12.985A9.252 9.252 0 0 0 4.6 6.45m15.858 1.8q.085.19.161.386a9.25 9.25 0 0 1-8.09 12.599m0 0A9.25 9.25 0 0 1 2.75 12c0-2.083.688-4.004 1.85-5.55m3.653 5.704L4.6 6.45"
        },
        []
      ]
    ]
  );
  const GooglePlayIcon = createIcon(
    {
      name: "Google Play",
      tags: ["App Store", "Android", "Google", "Google Play Store"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16.28 16.311 3.29-1.861A2.79 2.79 0 0 0 21 12c0-.955-.476-1.91-1.43-2.45l-3.29-1.86m0 8.622L8.209 20.88a2.8 2.8 0 0 1-2.779 0 2.9 2.9 0 0 1-.7-.557m11.552-4.012L4.729 3.677m0 16.646A2.78 2.78 0 0 1 4 18.43V5.57a2.78 2.78 0 0 1 1.061-2.202 2.81 2.81 0 0 1 3.147-.248l8.073 4.569M4.729 20.323 16.281 7.69"
        },
        []
      ]
    ]
  );
  const GoogleIcon = createIcon(
    {
      name: "Google",
      tags: ["Pixel", "Sundar Pichai", "Search", "Android"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M13.365 2.83a9.25 9.25 0 0 1 4.744 2.089c.338.284.336.794.024 1.106l-1.616 1.616c-.312.312-.816.306-1.171.044a5.365 5.365 0 1 0 1.615 6.705h-3.91a.8.8 0 0 1-.8-.8V11.3a.8.8 0 0 1 .8-.8h7.493c.316 0 .61.186.681.495.313 1.362-.125 3.246-.158 3.384l-.004.016c-.528 1.963-1.661 3.706-3.274 4.944a9.25 9.25 0 1 1-4.424-16.51"
        },
        []
      ]
    ]
  );
  const GraphIcon = createIcon(
    { name: "Graph", tags: ["Stocks", "Data"], category: "Business", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.5 4v13.5a3 3 0 0 0 3 3H20"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m6.5 15 4.5-4.5 3.5 3.5L20 8.5"
        },
        []
      ]
    ]
  );
  const GridDotsIcon = createIcon(
    { name: "Grid Dots", tags: [""], category: "Layout", deprecated: false },
    [
      ["circle", { cx: "5", cy: "5", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "12", cy: "5", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "19", cy: "5", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "5", cy: "12", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "12", cy: "12", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "19", cy: "12", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "5", cy: "19", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "12", cy: "19", r: "1.5", fill: "currentColor" }, []],
      ["circle", { cx: "19", cy: "19", r: "1.5", fill: "currentColor" }, []]
    ]
  );
  const GridIcon = createIcon(
    { name: "Grid", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "3.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "13.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "rect",
        {
          width: "6.5",
          height: "6.5",
          x: "13.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ]
    ]
  );
  const HamburgerIcon = createIcon(
    { name: "Hamburger", tags: [""], category: "Food & Drink", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 3.724c-4.302 0-7.79 3.051-7.79 6.816h15.58c0-3.765-3.488-6.816-7.79-6.816"
        },
        []
      ],
      [
        "rect",
        {
          width: "18.5",
          height: "5.355",
          x: "2.75",
          y: "10.54",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.21 15.895h15.58l-.278 1.249a4 4 0 0 1-3.905 3.132H8.393a4 4 0 0 1-3.905-3.132zm10.926-2.833-2.162-2.522h5.842l-2.162 2.522a1 1 0 0 1-1.518 0"
        },
        []
      ]
    ]
  );
  const HandIcon = createIcon(
    { name: "Hand", tags: [""], category: "Gestures", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4 10.059v3.424c0 1.853 0 2.78.221 3.536.527 1.8 1.935 3.216 3.735 3.846.6.176 1.196.363 2.344.532a5.8 5.8 0 0 0 2.014-.066c.303-.062.55-.115.758-.16.49-.106.98-.233 1.43-.454.508-.248.903-.506 1.475-.933.342-.255.655-.566 1.28-1.188l3.247-3.23a1.68 1.68 0 0 0 0-2.384 1.7 1.7 0 0 0-2.396 0l-2.25 2.239v-5.162"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.893 7.852V5.95c0-.815.664-1.475 1.483-1.475.818 0 1.482.66 1.482 1.475v4.424m-5.929-.319V3.95c0-.815.664-1.475 1.482-1.475.819 0 1.482.66 1.482 1.475v6.109M6.964 7.32v2.739-5.104a1.483 1.483 0 0 1 2.965 0v5.104M6.964 8.854V7.95c0-.815-.663-1.475-1.482-1.475C4.664 6.475 4 7.135 4 7.95v2.738"
        },
        []
      ]
    ]
  );
  const HardDriveIcon = createIcon(
    {
      name: "Hard Drive",
      tags: ["Disk", "SSD", "HDD", "Macintosh HD"],
      category: "Files",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 16.75v2.5a2 2 0 0 1-2 2H4.75a2 2 0 0 1-2-2v-2.5m18.5 0a2 2 0 0 0-2-2H4.75a2 2 0 0 0-2 2m18.5 0v-1.63a3 3 0 0 0-.09-.728l-2.342-9.37a3 3 0 0 0-2.91-2.272H8.092a3 3 0 0 0-2.91 2.272l-2.342 9.37a3 3 0 0 0-.09.727v1.631"
        },
        []
      ],
      ["circle", { cx: "18", cy: "18", r: "1", fill: "currentColor" }, []]
    ]
  );
  const HashIcon = createIcon(
    {
      name: "Hash",
      tags: ["Hashtag", "Tag", "Category", "Number", "Count", "Pound"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.778 8.395H21.25m-18.5 7.21h17.472M6.282 21.13 9.495 2.87m5.01 18.26 3.212-18.26"
        },
        []
      ]
    ]
  );
  const HatGraduationIcon = createIcon(
    {
      name: "Hat Graduation",
      tags: ["Education", "Diplomat", "Student", "Learning"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.652 14.714V9.78m3.18 2.07 4.049 2.667a4 4 0 0 0 4.402 0l4.049-2.668m-12.5 0L3.099 10.05a.99.99 0 0 1-.45-.815m3.183 2.616v5.061c0 .495.119.987.44 1.364.747.877 2.514 2.39 5.81 2.39s5.063-1.513 5.81-2.39c.32-.377.44-.869.44-1.364V11.85m0 0 2.48-1.634a1.2 1.2 0 0 0 0-2.004l-6.53-4.302a4 4 0 0 0-4.401 0L3.099 8.379a.99.99 0 0 0-.45.855m0 0v.547"
        },
        []
      ]
    ]
  );
  const HeadphonesOffIcon = createIcon(
    { name: "Headphones Off", tags: ["Audio"], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M17.75 21.25h1.5c.276 0 .54-.056.78-.158l-4.28-4.279v2.437a2 2 0 0 0 2 2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 13.321V12A9.25 9.25 0 0 0 7.217 4.08m14.033 9.241h-4a1.5 1.5 0 0 0-1.5 1.5v1.992m5.5-3.492v4.765m-18.5-.718V12c0-2.284.828-4.374 2.2-5.988m10.8 10.801v2.437a2 2 0 0 0 2 2h1.5c.276 0 .54-.056.78-.158m-4.28-4.279 4.28 4.28m-4.28-4.28-10.8-10.8m0 0L2.217 3.28m18.5 18.5-.689-.689M2.75 13.322h4a1.5 1.5 0 0 1 1.5 1.5v4.428a2 2 0 0 1-2 2h-1.5a2 2 0 0 1-2-2z"
        },
        []
      ]
    ]
  );
  const HeadphonesIcon = createIcon(
    { name: "Headphones", tags: [""], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 17.368V12A9.25 9.25 0 0 0 12 2.75v0A9.25 9.25 0 0 0 2.75 12v5.368"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 13.321h4a1.5 1.5 0 0 1 1.5 1.5v4.429a2 2 0 0 1-2 2h-1.5a2 2 0 0 1-2-2zm13 1.5a1.5 1.5 0 0 1 1.5-1.5h4v5.929a2 2 0 0 1-2 2h-1.5a2 2 0 0 1-2-2z"
        },
        []
      ]
    ]
  );
  const HeartStylisticIcon = createIcon(
    { name: "Heart Stylistic", tags: ["Love"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m12 7.934-1.457-1.457a4.565 4.565 0 1 0-6.456 6.457l1.457 1.456M12 7.934l1.457-1.457a4.565 4.565 0 0 1 6.456 6.457l-1.457 1.456.013.013-6.456 6.457-.013-.013-.013.013-6.456-6.457.013-.013M12 7.934 5.544 14.39"
        },
        []
      ]
    ]
  );
  const HeartIcon = createIcon(
    {
      name: "Heart",
      tags: ["Love", "Like", "Favorite"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.087 6.477a4.565 4.565 0 0 1 6.456 0L12 7.934l1.457-1.457a4.565 4.565 0 0 1 6.456 6.457l-1.457 1.456.013.013-6.456 6.457-.013-.013-.013.013-6.456-6.457.013-.013-1.457-1.456a4.565 4.565 0 0 1 0-6.457Z"
        },
        []
      ]
    ]
  );
  const HexagonIcon = createIcon(
    { name: "Hexagon", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.42 3.173a3.16 3.16 0 0 1 3.16 0l5.275 3.046a3.16 3.16 0 0 1 1.579 2.735v6.092a3.16 3.16 0 0 1-1.58 2.735l-5.275 3.046a3.16 3.16 0 0 1-3.158 0L5.145 17.78a3.16 3.16 0 0 1-1.579-2.735V8.954c0-1.128.602-2.17 1.58-2.735z"
        },
        []
      ]
    ]
  );
  const HighlighterAccentIcon = createIcon(
    {
      name: "Highlighter Accent",
      tags: ["Marker"],
      category: "Accents",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M20.25 6.25v-3.5H3.75v3.5a3.5 3.5 0 0 0 3.5 3.5h9.5a3.5 3.5 0 0 0 3.5-3.5m-4 7.5h-8.5v5.663a1.3 1.3 0 0 0 1.733 1.226l5.433-1.918a2 2 0 0 0 1.334-1.886z"
        },
        []
      ]
    ]
  );
  const HighlighterIcon = createIcon(
    { name: "Highlighter", tags: ["Marker"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 2.75v3.5a3.5 3.5 0 0 0 3.5 3.5h9.5a3.5 3.5 0 0 0 3.5-3.5v-3.5m-14.5 7h12.5v1.8a2.2 2.2 0 0 1-2.2 2.2h-8.1a2.2 2.2 0 0 1-2.2-2.2zm10.5 4h-8.5v5.663a1.3 1.3 0 0 0 1.733 1.226l5.433-1.918a2 2 0 0 0 1.334-1.886z"
        },
        []
      ]
    ]
  );
  const HistoryIcon = createIcon(
    { name: "History", tags: [""], category: "Miscellaneous", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.25 7.75v5h3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.855 7.875a8.25 8.25 0 1 1-.824 6.26m-.176-5.26v-4.75m0 4.75h4.75"
        },
        []
      ]
    ]
  );
  const Home2Icon = createIcon(
    {
      name: "Home 2",
      tags: ["House"],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.71 18.65v-7.622a3 3 0 0 0-1.151-2.362l-6.326-4.951a2 2 0 0 0-2.466 0l-6.326 4.95a3 3 0 0 0-1.15 2.363v7.622c0 1.16.94 2.1 2.1 2.1h3.97v-7.965h5.278v7.965h3.97a2.1 2.1 0 0 0 2.1-2.1"
        },
        []
      ]
    ]
  );
  const HomeIcon = createIcon(
    {
      name: "Home",
      tags: ["House"],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.29 20.663h3.017a2.194 2.194 0 0 0 2.193-2.194v-6.454a3.3 3.3 0 0 0-1.13-2.48l-5.93-5.166a2.194 2.194 0 0 0-2.88 0L4.63 9.534a3.3 3.3 0 0 0-1.13 2.481v6.454c0 1.212.982 2.194 2.194 2.194h3.29m6.306 0v-6.581c0-.908-.736-1.645-1.645-1.645H10.63c-.909 0-1.645.737-1.645 1.645v6.581m6.306 0H8.984"
        },
        []
      ]
    ]
  );
  const HourglassIcon = createIcon(
    {
      name: "Hourglass",
      tags: ["Time", "Timer"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4.095 3.298 15.81-.048m-15.81 17.5 15.81-.048"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.426 3.31H5.574l.079 1.449a7.38 7.38 0 0 0 2.251 4.913l1.242 1.195a1.58 1.58 0 0 1 0 2.279L7.904 14.34a7.38 7.38 0 0 0-2.251 4.913l-.08 1.448h12.853l-.079-1.445a7.38 7.38 0 0 0-2.256-4.917l-1.242-1.194a1.58 1.58 0 0 1 0-2.28l1.242-1.193a7.38 7.38 0 0 0 2.256-4.918z"
        },
        []
      ]
    ]
  );
  const HtmlIcon = createIcon(
    {
      name: "HTML",
      tags: ["HTML5", "Markup", "Programming", "Web"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m20.754 4.792-2.84 14.31a1.5 1.5 0 0 1-1.099 1.161l-4.442 1.141a1.5 1.5 0 0 1-.746 0l-4.442-1.14a1.5 1.5 0 0 1-1.098-1.162L3.246 4.792A1.5 1.5 0 0 1 4.717 3h14.566a1.5 1.5 0 0 1 1.471 1.792"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.3 6.881H8.944a1 1 0 0 0-.987 1.16l.577 3.576a1 1 0 0 0 .987.841h5.374a1 1 0 0 1 .978 1.205l-.562 2.683a1 1 0 0 1-.653.74l-2.283.786a1 1 0 0 1-.66-.003L8.99 16.9"
        },
        []
      ]
    ]
  );
  const InfinityIcon = createIcon(
    {
      name: "Infinity",
      tags: ["Number", "Infinite"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.872 9.172a3.72 3.72 0 0 1 5.419 0L12 12l-2.71 2.828a3.72 3.72 0 0 1-5.418 0c-1.496-1.562-1.496-4.094 0-5.656Zm16.256 0a3.72 3.72 0 0 0-5.419 0L12 12l2.71 2.828a3.72 3.72 0 0 0 5.418 0c1.496-1.562 1.496-4.094 0-5.656Z"
        },
        []
      ]
    ]
  );
  const InfoIcon = createIcon(
    { name: "Info", tags: ["Information"], category: "Status", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M12 11.813v5"
        },
        []
      ],
      ["circle", { cx: "12", cy: "8.438", r: "1.25", fill: "currentColor" }, []]
    ]
  );
  const InstagramIcon = createIcon(
    {
      name: "Instagram",
      tags: ["Social"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "17",
          height: "17",
          x: "3.5",
          y: "3.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "5.5"
        },
        []
      ],
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "3.606",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      ["circle", { cx: "16.894", cy: "7.106", r: "1.03", fill: "currentColor" }, []]
    ]
  );
  const JavascriptIcon = createIcon(
    {
      name: "JavaScript",
      tags: ["Programming", "Web", "Electron", "JS"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.5 11.25v5a1 1 0 0 1-1 1H9m8.25-6h-2a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-2"
        },
        []
      ]
    ]
  );
  const KeyboardCommandIcon = createIcon(
    {
      name: "Keyboard Command",
      tags: ["Mac", "macOS", "Meta", "Super", "Cmd"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 5.751a3 3 0 0 1 3-3v0a3 3 0 0 1 3 3v3h-3a3 3 0 0 1-3-3m0 12.498a3 3 0 0 0 3 3v0a3 3 0 0 0 3-3v-3h-3a3 3 0 0 0-3 3m18.5-12.498a3 3 0 0 0-3-3v0a3 3 0 0 0-3 3v3h3a3 3 0 0 0 3-3m0 12.498a3 3 0 0 1-3 3v0a3 3 0 0 1-3-3v-3h3a3 3 0 0 1 3 3M8.75 8.751h6.5v6.5h-6.5z"
        },
        []
      ]
    ]
  );
  const KeyboardShiftIcon = createIcon(
    { name: "Keyboard Shift", tags: [""], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.503 11.913 6.601-8.252a2.428 2.428 0 0 1 3.792 0l6.6 8.251c.83 1.037.092 2.573-1.235 2.573h-4.095v3.725c0 1.064 0 1.596-.207 2.003a1.9 1.9 0 0 1-.83.83c-.406.207-.938.207-2.002.207h-.254c-1.064 0-1.596 0-2.002-.207a1.9 1.9 0 0 1-.83-.83c-.207-.407-.207-.939-.207-2.003v-3.725H4.739c-1.327 0-2.065-1.536-1.236-2.572"
        },
        []
      ]
    ]
  );
  const KeyboardIcon = createIcon(
    { name: "Keyboard", tags: ["Peripheral"], category: "Technology", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "13.5",
          x: "2.75",
          y: "5.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8 15.38h8"
        },
        []
      ],
      ["circle", { cx: "7.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "10.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "13.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "16.5", cy: "8.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "7.5", cy: "11.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "10.5", cy: "11.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "13.5", cy: "11.875", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "16.5", cy: "11.875", r: "1", fill: "currentColor" }, []]
    ]
  );
  const LaptopIcon = createIcon(
    {
      name: "Laptop",
      tags: ["Computer", "PC"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M4.75 7a2 2 0 0 1 2-2h10.5a2 2 0 0 1 2 2v9H4.75zm-2 10a1 1 0 0 1 1-1h16.5a1 1 0 0 1 1 1v1a2 2 0 0 1-2 2H4.75a2 2 0 0 1-2-2z"
        },
        []
      ]
    ]
  );
  const LayersIcon = createIcon(
    { name: "Layers", tags: [""], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.991 3.066a2 2 0 0 0-1.982 0L2.75 7.778l8.259 4.712a2 2 0 0 0 1.982 0l8.259-4.712z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 12 7.268 4.147a4 4 0 0 0 3.964 0L21.25 12"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 16.222 7.268 4.147a4 4 0 0 0 3.964 0l7.268-4.147"
        },
        []
      ]
    ]
  );
  const LayoutIcon = createIcon(
    { name: "Layout", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 8.75v8a3 3 0 0 0 3 3H10m-7.25-11v-1.5a3 3 0 0 1 3-3h12.5a3 3 0 0 1 3 3v1.5m-18.5 0H10m11.25 0v8a3 3 0 0 1-3 3H10m11.25-11H10m0 0v11"
        },
        []
      ]
    ]
  );
  const LeafThreeIcon = createIcon(
    { name: "Leaf Three", tags: ["Leaf 3"], category: "Nature", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.526 7.499a4.75 4.75 0 0 1 4.75-4.75h2.217c.887 0 1.33 0 1.669.172.298.152.54.394.692.692.172.339.172.782.172 1.669v2.217c0 .433-.058.853-.167 1.252m-10.716 2.84 2.3 2.301m5.624 1.288-6.071 6.071M12.012 9.81a6.03 6.03 0 0 1 3.423-1.059h2.424M12.012 9.81a4.85 4.85 0 0 0-4.163-2.361H5.586c-.905 0-1.358 0-1.704.176a1.6 1.6 0 0 0-.706.706C3 8.677 3 9.13 3 10.035v2.262a4.85 4.85 0 0 0 6.7 4.483m2.312-6.97a6.1 6.1 0 0 0-1.54 1.523 6 6 0 0 0-1.029 2.56M17.86 8.75h.404c1.132 0 1.698 0 2.13.22.38.194.689.503.883.884.22.432.22.997.22 2.129v2.828A6.06 6.06 0 0 1 9.7 16.78m-.258-2.888A6.1 6.1 0 0 0 9.7 16.78"
        },
        []
      ]
    ]
  );
  const LeafTwoIcon = createIcon(
    { name: "Leaf Two", tags: ["Leaf One"], category: "Nature", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.35 8.1 1.93 1.93m5.277 3.663L8 20.25m4.872-13.162a6.5 6.5 0 0 1 2.082-.338h3.055c1.222 0 1.833 0 2.3.238.41.209.744.543.953.953.238.467.238 1.078.238 2.3v3.055a6.546 6.546 0 0 1-13.062.625m4.434-6.833a5.09 5.09 0 0 0-4.78-3.338H5.714c-.95 0-1.425 0-1.788.185a1.7 1.7 0 0 0-.742.742C3 5.04 3 5.515 3 6.465v2.376a5.09 5.09 0 0 0 5.438 5.08m4.434-6.833A6.57 6.57 0 0 0 9.28 10.03m-.842 3.89a6.5 6.5 0 0 1 .842-3.89"
        },
        []
      ]
    ]
  );
  const LeafIcon = createIcon(
    { name: "Leaf", tags: ["Leaf One", "1"], category: "Nature", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.508 16.223a6.38 6.38 0 0 1-9.016 0 6.367 6.367 0 0 1 0-9.009l3.094-3.091a2 2 0 0 1 2.828 0l3.094 3.091a6.367 6.367 0 0 1 0 9.01M12 12.265v9.025"
        },
        []
      ]
    ]
  );
  const LibraryIcon = createIcon(
    {
      name: "Library",
      tags: ["Book", "Bookshelf"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "3.998",
          height: "15",
          x: "2.75",
          y: "4.504",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "3.998",
          height: "15",
          x: "9.201",
          y: "4.504",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.267 8.378c-.165-.615.2-1.247.814-1.411l1.038-.278c.614-.165 1.245.2 1.41.814l2.681 10.014a1.15 1.15 0 0 1-.814 1.41l-1.038.279a1.15 1.15 0 0 1-1.41-.815z"
        },
        []
      ]
    ]
  );
  const LightbulbIcon = createIcon(
    { name: "Lightbulb", tags: ["Tip"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.013 17.104c.126-.958.736-1.764 1.464-2.4a6.816 6.816 0 1 0-8.955 0c.729.636 1.34 1.442 1.465 2.4l.084.633.233 1.774a2 2 0 0 0 1.983 1.739h1.426a2 2 0 0 0 1.983-1.739l.233-1.774zm-5.943.633h5.86"
        },
        []
      ]
    ]
  );
  const LineDiagonalIcon = createIcon(
    { name: "Line Diagonal", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "m21.25 2.75-18.5 18.5"
        },
        []
      ]
    ]
  );
  const LinkIcon = createIcon(
    {
      name: "Link",
      tags: ["URL", "Attatchment"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.621 7.5H7.25a4.5 4.5 0 0 0-4.5 4.5v0a4.5 4.5 0 0 0 4.5 4.5h2.371m4.758-9h2.371a4.5 4.5 0 0 1 4.5 4.5v0a4.5 4.5 0 0 1-4.5 4.5h-2.371M7.243 12h9.514"
        },
        []
      ]
    ]
  );
  const LinuxIcon = createIcon(
    {
      name: "Linux",
      tags: [
        "Tux",
        "GNU/Linux",
        "Penguin",
        "Operating System",
        "OS",
        "Linus Torvalds",
        "Open Source"
      ],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "1.48",
          height: "1.48",
          x: "12.671",
          y: "5.713",
          fill: "currentColor",
          rx: ".74"
        },
        []
      ],
      [
        "rect",
        {
          width: "1.48",
          height: "1.48",
          x: "10.38",
          y: "5.713",
          fill: "currentColor",
          rx: ".74"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "m17.06 11.837-.603.445zm-9.59 0 .604.445zm2.223 9.204.65.375zm-2.354.828.271-.699zm1.894-3.28.47-.586zm-3.339-1.66.65.375zm1.03-.193.47-.585zm-2.691 3.071-.65-.375zm.347.99-.272.698zm10.823.946-.375.65zm-.828-2.354-.699-.272zm3.281 1.894-.585-.47zm1.659-3.339-.375.65zm.193 1.03.585.47zm-3.071-2.692-.375.65zm-.989.348.7.272zm-5.835 4.166-.696-.28zm-3.377-4.21.062.748zm8.016 3.671.747-.068zM9.95 20.1l.75.006zm-.738-1.528-.469.585zm.597-1.214c0-.955.32-2.128.842-3.05.551-.975 1.16-1.397 1.615-1.397v-1.5c-1.316 0-2.311 1.082-2.92 2.158-.639 1.128-1.037 2.553-1.037 3.789zm0-11.152c0-1.356 1.1-2.456 2.457-2.456v-1.5a3.956 3.956 0 0 0-3.957 3.956zm0 1.954V6.206h-1.5V8.16zm-2.748 7.208c0-1.157.376-2.223 1.013-3.086l-1.207-.89a6.68 6.68 0 0 0-1.306 3.976zm9.396-3.086a5.18 5.18 0 0 1 1.013 3.086h1.5a6.68 6.68 0 0 0-1.305-3.977zm-1.735-6.076V8.16h1.5V6.206zM12.266 3.75c1.356 0 2.456 1.1 2.456 2.456h1.5a3.956 3.956 0 0 0-3.956-3.956zm5.399 7.641c-.815-1.104-1.443-2.139-1.443-3.23h-1.5c0 1.635.93 3.03 1.735 4.12zm-9.356-3.23c0 1.091-.628 2.127-1.442 3.23l1.207.89c.805-1.09 1.735-2.485 1.735-4.12zm-3.427 12.02 1.662-2.878-1.3-.75-1.661 2.878zm2.728.988-2.758-1.073-.544 1.398 2.759 1.073zm1.434-.504a1.166 1.166 0 0 1-1.434.504l-.543 1.398a2.67 2.67 0 0 0 3.276-1.152zm-5.461-1.234a1.44 1.44 0 0 0 .725 2.063l.544-1.398a.06.06 0 0 1 .03.085zm15.54-.927-1.852 2.308 1.17.94 1.852-2.31zm-1.852 2.308c-.36.45-.994.569-1.493.28l-.75 1.3c1.14.658 2.59.386 3.413-.64zm1.869-2.22a.06.06 0 0 1-.017-.088l1.17.939a1.44 1.44 0 0 0-.403-2.15zm-2.128-2.96a1.44 1.44 0 0 0-2.063.725l1.398.544a.06.06 0 0 1-.085.03zm-1.234 5.46a1.16 1.16 0 0 1-.487-.545l-1.376.597c.22.509.602.952 1.113 1.248zm-1.47-.936a5.2 5.2 0 0 1-2.042.415v1.5c.932 0 1.823-.19 2.632-.536zm-5.191.36a1 1 0 0 1-.073.15l1.299.75q.096-.168.166-.342zm3.149.055a5.2 5.2 0 0 1-2.144-.46l-.618 1.367a6.7 6.7 0 0 0 2.762.593zM7.17 16.434a5.2 5.2 0 0 1-.11-1.066h-1.5c0 .469.05.928.141 1.371zm-.626.87a.1.1 0 0 1-.021.021l-.025.009-.124-1.495a1.44 1.44 0 0 0-1.13.715zm-.046.03a.06.06 0 0 1-.043-.013l.939-1.17a1.44 1.44 0 0 0-1.02-.312zm10.972-1.966c0 .514-.074 1.009-.212 1.476l1.439.425a6.7 6.7 0 0 0 .273-1.901zm-1.208 1.564 1.34.774.75-1.3-1.34-.773zm1.34.774 1.538.887.75-1.299-1.538-.887zm-2.328 1.954.89-2.289-1.397-.544-.89 2.29zm.89-2.289.183-.469-1.398-.544-.182.47zm-3.898-4.46c.435 0 1.014.385 1.554 1.293.513.861.85 1.977.896 2.932l1.499-.073c-.06-1.206-.471-2.56-1.106-3.626-.608-1.021-1.576-2.026-2.843-2.026zm3.025 7.637a1.2 1.2 0 0 1-.092-.36l-1.493.138c.026.283.097.56.209.819zm-.092-.36a1.2 1.2 0 0 1 .075-.528l-1.398-.543a2.66 2.66 0 0 0-.17 1.209zm-6.436-1.015c.287.23.44.572.437.92l1.5.013a2.67 2.67 0 0 0-.998-2.103zm.437.92a1.2 1.2 0 0 1-.083.423l1.392.559c.126-.314.188-.642.191-.969zm.738-1.71a4 4 0 0 1-.129-1.025h-1.5c0 .486.062.958.177 1.403zm-3.483-1.062 2.288 1.836.939-1.17-2.288-1.836zm2.288 1.836.02.016.94-1.17-.021-.016zM11.08 8.272a.6.6 0 0 0-.46.984l1.185 1.423a.6.6 0 0 0 .922 0l1.185-1.423a.6.6 0 0 0-.46-.984z"
        },
        []
      ]
    ]
  );
  const LocationIcon = createIcon(
    {
      name: "Location",
      tags: [""],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.4 4.76a7.92 7.92 0 0 1 11.2 11.2l-4.186 4.186a2 2 0 0 1-2.828 0L6.4 15.96a7.92 7.92 0 0 1 0-11.2Z"
        },
        []
      ],
      [
        "circle",
        {
          cx: "12",
          cy: "10.36",
          r: "3",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const LockOpenIcon = createIcon(
    {
      name: "Lock Open",
      tags: ["Unlock", "Unsafe"],
      category: "Security",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "14.478",
          height: "12.87",
          x: "4.761",
          y: "8.38",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.783 8.38V5.967a3.217 3.217 0 0 1 6.132-1.363"
        },
        []
      ],
      ["circle", { cx: "12", cy: "14.815", r: "1.5", fill: "currentColor" }, []]
    ]
  );
  const LockIcon = createIcon(
    {
      name: "Lock",
      tags: ["Safe", "Secure", "Private", "Privacy"],
      category: "Security",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "14.478",
          height: "12.87",
          x: "4.761",
          y: "8.38",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.217 8.38V5.967A3.217 3.217 0 0 0 12 2.75v0a3.217 3.217 0 0 0-3.217 3.217V8.38"
        },
        []
      ],
      ["circle", { cx: "12", cy: "14.815", r: "1.5", fill: "currentColor" }, []]
    ]
  );
  const MailOpenIcon = createIcon(
    {
      name: "Mail Open",
      tags: ["Gmail", "Outlook", "Yahoo", "Inbox", "Unread", "Envelope Open"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m20.59 8.949-7.755 3.562a2 2 0 0 1-1.67 0L3.41 8.95m14.84 11.3H5.75a3 3 0 0 1-3-3v-7.215A2.5 2.5 0 0 1 3.93 7.91l7.014-4.36a2 2 0 0 1 2.112 0l7.014 4.36a2.5 2.5 0 0 1 1.18 2.124v7.215a3 3 0 0 1-3 3"
        },
        []
      ]
    ]
  );
  const MailIcon = createIcon(
    {
      name: "Mail",
      tags: ["Gmail", "Outlook", "Yahoo", "Inbox", "Unread", "Envelope"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "15.5",
          x: "2.75",
          y: "4.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 8 8.415 3.866a2 2 0 0 0 1.67 0L21.25 8"
        },
        []
      ]
    ]
  );
  const MapIcon = createIcon(
    { name: "Map", tags: [""], category: "Places & Transportation", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.496 4.439 4.247 6.91a1 1 0 0 0-.497.864V18.26a1 1 0 0 0 1.503.865l3.243-1.887a1.5 1.5 0 0 1 1.508 0l3.992 2.322a1.5 1.5 0 0 0 1.508 0l4.249-2.472a1 1 0 0 0 .497-.864V5.739a1 1 0 0 0-1.503-.865l-3.243 1.887a1.5 1.5 0 0 1-1.508 0L10.004 4.44a1.5 1.5 0 0 0-1.508 0Zm.754.311v11.8m5.5-9.1v11.8"
        },
        []
      ]
    ]
  );
  const MaskIcon = createIcon(
    { name: "Mask", tags: [""], category: "Design", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M8.844 20.698a9.254 9.254 0 0 1 0-17.396 9.254 9.254 0 0 1 0 17.396"
        },
        []
      ]
    ]
  );
  const MathIcon = createIcon(
    {
      name: "Math",
      tags: ["Operations", "Addition", "Subtraction", "Multiplication", "Division"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M2.75 6.248h7m-3.5-3.5v7m8-3.5h7M3.45 20.552l2.8-2.8m0 0 2.8-2.8m-2.8 2.8-2.8-2.8m2.8 2.8 2.8 2.8m5.2-4.9h7m-7 4.2h7"
        },
        []
      ]
    ]
  );
  const MegaphoneLoudIcon = createIcon(
    {
      name: "Megaphone Loud",
      tags: ["Announcement"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "m8.784 19.283-1.251.75c-.632.378-.948.568-1.272.637-.44.094-.897.037-1.3-.16-.298-.147-.558-.408-1.08-.93-.52-.52-.781-.781-.927-1.079a2 2 0 0 1-.16-1.3c.068-.325.258-.642.636-1.274l4.356-7.282c.718-1.2 1.077-1.8 1.57-2.061.433-.23.935-.291 1.41-.175.544.133 1.038.628 2.026 1.617l2.636 2.638c.988.989 1.482 1.483 1.616 2.026.116.476.054.979-.175 1.412-.261.494-.86.853-2.06 1.572l-1.27.761m-4.755 2.848a2.778 2.778 0 0 0 4.463.744 2.784 2.784 0 0 0 .291-3.592m-4.754 2.848 4.754-2.848"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.007 4.404 17.542 6.87m3.709 3.007h-2.49m-4.224-6.719V5.65"
        },
        []
      ]
    ]
  );
  const MegaphoneIcon = createIcon(
    {
      name: "Megaphone",
      tags: ["Announcement"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "m7.142 15.9-2.5-.627a2.5 2.5 0 0 1-1.892-2.425V10.78a2.5 2.5 0 0 1 1.891-2.424l13.5-3.39a2.5 2.5 0 0 1 3.109 2.425v8.847a2.5 2.5 0 0 1-3.109 2.425l-5.19-1.304m-5.81-1.458a3 3 0 1 0 5.809 1.459M7.143 15.9l5.809 1.46"
        },
        []
      ]
    ]
  );
  const MentionIcon = createIcon(
    {
      name: "Mention",
      tags: ["@", "Tag", "@mention", "At"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.625 20.01A9.25 9.25 0 1 1 21.25 12v1.5a2.5 2.5 0 0 1-2.5 2.5v0a2.5 2.5 0 0 1-2.5-2.5V12m0 0a4.25 4.25 0 1 1-8.5 0 4.25 4.25 0 0 1 8.5 0m0 0V7.75"
        },
        []
      ]
    ]
  );
  const MenuIcon = createIcon(
    { name: "Menu", tags: [""], category: "System & Interface", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 4.75h18.5M2.75 12h18.5m-18.5 7.25h18.5"
        },
        []
      ]
    ]
  );
  const MicrophoneOffIcon = createIcon(
    { name: "Microphone Off", tags: ["Mute"], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M12 14.597a3.2 3.2 0 0 0 3.199-3.199V9.864l-4.47 4.47c.39.17.82.263 1.271.263"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 18.181a6.78 6.78 0 0 0 6.779-6.779M12 18.182v2.568m0-2.569a6.75 6.75 0 0 1-3.89-1.227m-2.89-5.552c0 1.1.262 2.14.727 3.058m-2.666 7.322 4.827-4.828M21.782 3.282l-6.583 6.582m0 0v1.534a3.2 3.2 0 0 1-4.47 2.937m4.47-4.47-4.47 4.47m0 0-2.62 2.62m.734-5.035a3 3 0 0 1-.042-.522v-4.95a3.199 3.199 0 0 1 6.391-.208"
        },
        []
      ]
    ]
  );
  const MicrophoneIcon = createIcon(
    {
      name: "Microphone",
      tags: ["Unmute", "Speak"],
      category: "Media",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.801 6.449a3.199 3.199 0 1 1 6.398 0v4.95a3.199 3.199 0 0 1-6.398 0zM12 18.181a6.78 6.78 0 0 1-6.779-6.779M12 18.182a6.78 6.78 0 0 0 6.779-6.78M12 18.182v2.568"
        },
        []
      ]
    ]
  );
  const MicrosoftEdgeIcon = createIcon(
    {
      name: "Microsoft Edge",
      tags: ["Browser", "Chromium", "Microsoft", "MS Edge"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.76 12a9.25 9.25 0 0 0 11.527 8.968M2.761 12a9.25 9.25 0 0 1 9.25-9.25c3.795 0 7.996 1.777 9.017 6.798.223 1.1.09 2.258-.463 3.235-.582 1.025-1.559 2.182-3.01 2.182-.55.088-4.164.176-3.979-1.312A2.27 2.27 0 0 0 14.287 12M2.761 12s.444-4.849 5.78-4.833C14.117 7.184 14.288 12 14.288 12m0 0a2.277 2.277 0 0 0-2.277-2.277c-.642 0-1.636.694-1.636.694m3.913 10.55a9.26 9.26 0 0 0 5.406-3.814c.185-.275.058-.694-.26-.6a.5.5 0 0 0-.174.092c-1.364.617-4.22 1.12-6.685-.257-1.5-.838-2.374-2.135-2.639-3.202-.099-.255-.201-.896-.201-1.186 0-.615.243-1.173.64-1.583m3.913 10.55s-6.012.49-6.546-5.053c-.297-3.09 1.307-4.702 2.633-5.497"
        },
        []
      ]
    ]
  );
  const MicrosoftIcon = createIcon(
    {
      name: "Microsoft",
      tags: [
        "Windows",
        "Win11",
        "Windows 11",
        "Satya Nadella",
        "Steve Ballmer",
        "Bill Gates"
      ],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 3.75H5.75a2 2 0 0 0-2 2V12M12 3.75h6.25a2 2 0 0 1 2 2V12M12 3.75v16.5m0 0h6.25a2 2 0 0 0 2-2V12M12 20.25H5.75a2 2 0 0 1-2-2V12m0 0h16.5"
        },
        []
      ]
    ]
  );
  const MoonIcon = createIcon(
    {
      name: "Moon",
      tags: ["Crescent", "Dark", "Dark Mode", "Dark Theme"],
      category: "Weather",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.578 3.512a6.307 6.307 0 0 0 8.91 8.91.45.45 0 0 1 .466-.095c.176.067.29.24.275.428A9.255 9.255 0 1 1 5.461 5.45a9.22 9.22 0 0 1 5.784-2.68.42.42 0 0 1 .428.275c.06.16.02.34-.095.466Z"
        },
        []
      ]
    ]
  );
  const MoreVerticalIcon = createIcon(
    { name: "More Vertical", tags: ["Kabab"], category: "Actions", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "18",
          r: "1.75",
          fill: "currentColor",
          transform: "rotate(-90 12 18)"
        },
        []
      ],
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "1.75",
          fill: "currentColor",
          transform: "rotate(-90 12 12)"
        },
        []
      ],
      [
        "circle",
        {
          cx: "12",
          cy: "6",
          r: "1.75",
          fill: "currentColor",
          transform: "rotate(-90 12 6)"
        },
        []
      ]
    ]
  );
  const MoreIcon = createIcon(
    { name: "More", tags: ["Kabab"], category: "Actions", deprecated: false },
    [
      ["circle", { cx: "6", cy: "12", r: "1.75", fill: "currentColor" }, []],
      ["circle", { cx: "12", cy: "12", r: "1.75", fill: "currentColor" }, []],
      ["circle", { cx: "18", cy: "12", r: "1.75", fill: "currentColor" }, []]
    ]
  );
  const MotherboardIcon = createIcon(
    {
      name: "Motherboard",
      tags: [
        "Computer Board",
        "Chip",
        "Components",
        "Transistor",
        "Silicon",
        "PC",
        "CPU"
      ],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "13.5",
          height: "13.5",
          x: "5.25",
          y: "5.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.75 8.75h2.5M18.75 12h2.5m-2.5 3.25h2.5m-6 3.5v2.5M12 18.75v2.5m-3.25-2.5v2.5m-6-12.5h2.5M2.75 12h2.5m-2.5 3.25h2.5m10-12.5v2.5M12 2.75v2.5m-3.25-2.5v2.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "5",
          height: "5",
          x: "9.5",
          y: "9.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1"
        },
        []
      ]
    ]
  );
  const MovieIcon = createIcon(
    { name: "Movie", tags: ["Video", "Film"], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 7.5a3 3 0 0 1 3-3h12.5a3 3 0 0 1 3 3v9a3 3 0 0 1-3 3H5.75a3 3 0 0 1-3-3zM7 5v14M17 5v14M2.75 9.5H7m-4.25 5H7m10-5h4.25m-4.25 5h4.25"
        },
        []
      ]
    ]
  );
  const MuseumIcon = createIcon(
    {
      name: "Museum",
      tags: [""],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "3",
          x: "2.75",
          y: "18.376",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.04 3.15 3.27 7.4a1 1 0 0 0-.52.877v.997a.6.6 0 0 0 .6.6h17.3a.6.6 0 0 0 .6-.6v-.997a1 1 0 0 0-.52-.877l-7.77-4.25a2 2 0 0 0-1.92 0M5.25 9.874v8.51m13.5-8.51v8.51m-4.25-8.51v8.51m-5-8.51v8.51"
        },
        []
      ]
    ]
  );
  const MusicNote2Icon = createIcon(
    {
      name: "Music Note 2",
      tags: ["Song", "Single"],
      category: "Media",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.5 17.25a4 4 0 1 1-8 0 4 4 0 0 1 8 0m0 0v-9m0 0 4.83 2.415a1.5 1.5 0 0 0 2.17-1.342V7.177a1.5 1.5 0 0 0-.83-1.342l-4.723-2.361a1 1 0 0 0-1.447.894z"
        },
        []
      ]
    ]
  );
  const MusicNoteIcon = createIcon(
    {
      name: "Music Note",
      tags: ["Song", "Double"],
      category: "Media",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.962 17.968V6.696a1.5 1.5 0 0 1 1.106-1.447l8.15-2.223a1.5 1.5 0 0 1 1.895 1.447v11.468M8.963 9.92l11.15-3.04M8.962 17.968a3.041 3.041 0 1 1-6.082 0 3.041 3.041 0 0 1 6.082 0"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.113 15.94a3.041 3.041 0 1 1-6.082 0 3.041 3.041 0 0 1 6.082 0"
        },
        []
      ]
    ]
  );
  const NarratorIcon = createIcon(
    {
      name: "Narrator",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.183 16.958h.75a.75.75 0 0 0-.75-.75zm.839 4.16.508.552zm4.52-4.16v-.75a.75.75 0 0 0-.508.199zM3.839 6.75A3.25 3.25 0 0 1 7.09 3.5V2a4.75 4.75 0 0 0-4.75 4.75zm0 6.208V6.75h-1.5v6.208zm3.25 3.25a3.25 3.25 0 0 1-3.25-3.25h-1.5a4.75 4.75 0 0 0 4.75 4.75zm.072 0H7.09v1.5h.072zm.022 0h-.022v1.5h.022zm.75 4.542v-3.792h-1.5v3.792zm-.419-.184a.25.25 0 0 1 .42.184h-1.5c0 1.09 1.295 1.657 2.096.92zm4.52-4.16-4.52 4.16L8.53 21.67l4.52-4.16zm4.877-.198h-4.37v1.5h4.37zm3.25-3.25a3.25 3.25 0 0 1-3.25 3.25v1.5a4.75 4.75 0 0 0 4.75-4.75zm0-6.208v6.208h1.5V6.75zM16.91 3.5a3.25 3.25 0 0 1 3.25 3.25h1.5A4.75 4.75 0 0 0 16.91 2zm-9.822 0h9.822V2H7.089z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 14V6m3.25 5.788V8.212m-6.5 3.576V8.212"
        },
        []
      ]
    ]
  );
  const NodejsIcon = createIcon(
    {
      name: "NodeJS",
      tags: ["Node Package Manager", "JavaScript", "JS", "Node.js"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.75 8.5v7.964c0 .866-.456 1.626-1.142 2.052-.745.463-1.672.13-2.432-.308l-1.43-.826a2.07 2.07 0 0 1-1.034-1.792V8.41c0-.74.394-1.423 1.035-1.792l6.218-3.59a2.07 2.07 0 0 1 2.07 0l6.218 3.59a2.07 2.07 0 0 1 1.035 1.792v7.18a2.07 2.07 0 0 1-1.035 1.792l-6.218 3.59a2.07 2.07 0 0 1-2.07 0l-.989-.57"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.29 8.5h-2.75a1.75 1.75 0 0 0-1.75 1.75v0c0 .966.784 1.75 1.75 1.75h1c.966 0 1.75.784 1.75 1.75v0a1.75 1.75 0 0 1-1.75 1.75h-2.75"
        },
        []
      ]
    ]
  );
  const NoteAddIcon = createIcon(
    { name: "Note Add", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M6.5 12a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V6h2.493a.5.5 0 0 1 0 1H7v2.493a.5.5 0 1 1-1 0V7H3.507a.5.5 0 0 1 0-1H6V3.507a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.5 14h-1.7c-1.68 0-2.52 0-3.162.327a3 3 0 0 0-1.311 1.311C14 16.28 14 17.12 14 18.8v1.7M15.5 8H14m-2.5 4H13m.75-8h.35c2.24 0 3.36 0 4.216.436a4 4 0 0 1 1.748 1.748c.436.856.436 1.976.436 4.216v3.449c0 .978 0 1.468-.11 1.928-.099.408-.26.798-.48 1.156-.247.404-.593.75-1.285 1.442l-.25.25c-.692.692-1.038 1.038-1.442 1.286a4 4 0 0 1-1.156.479c-.46.11-.95.11-1.928.11H10.4c-2.24 0-3.36 0-4.216-.436a4 4 0 0 1-1.748-1.748C4 17.46 4 16.34 4 14.1v-.35"
        },
        []
      ]
    ]
  );
  const NoteIcon = createIcon(
    { name: "Note", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.5 4H8a4 4 0 0 0-4 4v8.5a4 4 0 0 0 4 4h6.843a4 4 0 0 0 2.829-1.172l1.656-1.656a4 4 0 0 0 1.172-2.829V8a4 4 0 0 0-4-4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.5 14H17a3 3 0 0 0-3 3v3.5M8 8h7.5M8 12h5"
        },
        []
      ]
    ]
  );
  const NpmIcon = createIcon(
    {
      name: "NPM",
      tags: ["Node Package Manager", "JavaScript", "JS", "Node.js"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        { fill: "currentColor", d: "M12 9a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v11.25h-4z" },
        []
      ]
    ]
  );
  const OctagonIcon = createIcon(
    { name: "Octagon", tags: ["Stop", "Sign"], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.29 3.629a3 3 0 0 1 2.12-.879h5.178a3 3 0 0 1 2.121.879l3.661 3.66a3 3 0 0 1 .879 2.122v5.178a3 3 0 0 1-.879 2.121l-3.66 3.661a3 3 0 0 1-2.122.879H9.41a3 3 0 0 1-2.121-.879l-3.661-3.66a3 3 0 0 1-.879-2.122V9.41a3 3 0 0 1 .879-2.121z"
        },
        []
      ]
    ]
  );
  const OpenSourceIcon = createIcon(
    {
      name: "Open Source",
      tags: ["Open Source Initiative", "OSI", "Free Software", "FOSS"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.157 20.136c.211.51.8.757 1.284.492a9.25 9.25 0 1 0-8.882 0c.484.265 1.073.018 1.284-.492l1.358-3.28c.212-.51-.043-1.086-.478-1.426a3.7 3.7 0 1 1 4.554 0c-.435.34-.69.916-.478 1.426z"
        },
        []
      ]
    ]
  );
  const OpenIcon = createIcon(
    {
      name: "Open",
      tags: ["External Link", "Box Arrow Top Right"],
      category: "Window",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 3.75h-2.5a4 4 0 0 0-4 4v8.5a4 4 0 0 0 4 4h8.5a4 4 0 0 0 4-4v-2.5m-6.5-10h5.5c.276 0 .526.112.707.293m.293 6.207v-5.5a1 1 0 0 0-.293-.707M12.75 11.25l6.5-6.5.707-.707"
        },
        []
      ]
    ]
  );
  const PageMarginsIcon = createIcon(
    { name: "Page Margins", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "rect",
        {
          width: "15.5",
          height: "18.5",
          x: "4.25",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.25 2.75v18.5m-4-14.5h15.5m-15.5 10.5h15.5m-4-14.5v18.5"
        },
        []
      ]
    ]
  );
  const PaintBucketAccentIcon = createIcon(
    {
      name: "Paint Bucket Accent",
      tags: ["House", "Home Samsung"],
      category: "Accents",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "m18.677 13.35-1.923 3.17c-.985 2.092 1.314 4.206 3.317 3.05a2.36 2.36 0 0 0 .864-3.225zm-7.325 1.578 4.398-4.398H2.748c0 .237.037.475.112.703.168.52.619.97 1.52 1.871l1.824 1.824c.9.9 1.351 1.351 1.87 1.52.458.149.95.149 1.407 0 .52-.169.97-.62 1.871-1.52"
        },
        []
      ]
    ]
  );
  const PaintBucketIcon = createIcon(
    {
      name: "Paint Bucket",
      tags: ["House", "Home Samsung"],
      category: "Design",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m18.677 13.35-1.923 3.17c-.985 2.093 1.314 4.206 3.317 3.05a2.36 2.36 0 0 0 .864-3.225z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m8.778 3.558 6.972 6.972M8.778 3.558 4.38 7.956c-.901.9-1.352 1.351-1.52 1.87a2.3 2.3 0 0 0-.112.704m6.03-6.972-1.06-1.059m8.032 8.031-4.398 4.398c-.9.9-1.351 1.351-1.871 1.52-.457.149-.95.149-1.406 0-.52-.169-.97-.62-1.871-1.52L4.38 13.104c-.901-.9-1.352-1.351-1.52-1.87a2.3 2.3 0 0 1-.112-.704m13.002 0H2.748m10.188 9.971H3.748"
        },
        []
      ]
    ]
  );
  const Paintbrush2Icon = createIcon(
    { name: "Paintbrush 2", tags: [""], category: "Design", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.781 10.832A4.79 4.79 0 0 0 3.75 15.46v3.79a1 1 0 0 0 1 1h3.79a4.79 4.79 0 0 0 4.628-6.03m-3.387-3.388a4.8 4.8 0 0 1 3.387 3.387m-3.387-3.387 3.19-3.19m.197 6.577 3.19-3.19m-3.387-3.387 3.19-3.19a2.395 2.395 0 0 1 3.387 3.387l-3.19 3.19m-3.387-3.387 3.387 3.387"
        },
        []
      ]
    ]
  );
  const PaintbrushIcon = createIcon(
    { name: "Paintbrush", tags: [""], category: "Design", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.32 5.75a3 3 0 0 1 3-3h7.36a3 3 0 0 1 3 3V12H5.32z"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M5.32 12v-.75a.75.75 0 0 0-.75.75zm13.36 0h.75a.75.75 0 0 0-.75-.75zm-8.479 4.111h.75a.75.75 0 0 0-.75-.75zm3.598 0v-.75a.75.75 0 0 0-.75.75zm-8.48-3.361h13.362v-1.5H5.319zm.75 1.861V12h-1.5v2.611zm.75.75a.75.75 0 0 1-.75-.75h-1.5a2.25 2.25 0 0 0 2.25 2.25zm3.382 0H6.82v1.5h3.382zm.75 4.09v-3.34h-1.5v3.34zM12 20.5c-.58 0-1.049-.47-1.049-1.049h-1.5A2.55 2.55 0 0 0 12 22zm1.049-1.049c0 .58-.47 1.049-1.049 1.049V22a2.55 2.55 0 0 0 2.549-2.549zm0-3.34v3.34h1.5v-3.34zm4.132-.75h-3.382v1.5h3.382zm.75-.75a.75.75 0 0 1-.75.75v1.5a2.25 2.25 0 0 0 2.25-2.25zm0-2.611v2.611h1.5V12z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.5 2.75V6.5m-3-3.75v2.5"
        },
        []
      ]
    ]
  );
  const PanelLeftContractIcon = createIcon(
    { name: "Panel Left Contract", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.547 3.75H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h2.297m0-16.5h7.203a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5H9.547m0-16.5v16.5m5.213-6L12.55 12m0 0 2.21-2.25M12.55 12h4.7"
        },
        []
      ]
    ]
  );
  const PanelLeftExpandIcon = createIcon(
    { name: "Panel Left Expand", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.547 3.75H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h2.297m0-16.5h7.203a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5H9.547m0-16.5v16.5m5.493-6L17.25 12m0 0-2.21-2.25M17.25 12h-4.7"
        },
        []
      ]
    ]
  );
  const PanelLeftOpenIcon = createIcon(
    { name: "Panel Left Open", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M16.75 3.75a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5h-2.297V3.75z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.453 3.75h2.297a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5h-2.297m0-16.5H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h7.203m0-16.5v16.5"
        },
        []
      ]
    ]
  );
  const PanelLeftIcon = createIcon(
    { name: "Panel Left", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.547 3.75H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h2.297m0-16.5h7.203a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5H9.547m0-16.5v16.5"
        },
        []
      ]
    ]
  );
  const PanelRightContractIcon = createIcon(
    { name: "Panel Right Contract", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.453 3.75h2.297a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5h-2.297m0-16.5H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h7.203m0-16.5v16.5m-5.213-6L11.45 12m0 0L9.24 9.75M11.45 12h-4.7"
        },
        []
      ]
    ]
  );
  const PanelRightExpandIcon = createIcon(
    { name: "Panel Right Expand", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.453 3.75h2.297a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5h-2.297m0-16.5H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h7.203m0-16.5v16.5m-5.493-6L6.75 12m0 0 2.21-2.25M6.75 12h4.7"
        },
        []
      ]
    ]
  );
  const PanelRightOpenIcon = createIcon(
    { name: "Panel Right Open", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.25 3.75a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h2.297V3.75z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.547 3.75H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h2.297m0-16.5h7.203a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5H9.547m0-16.5v16.5"
        },
        []
      ]
    ]
  );
  const PanelRightIcon = createIcon(
    { name: "Panel Right", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.453 3.75h2.297a3.5 3.5 0 0 1 3.5 3.5v9.5a3.5 3.5 0 0 1-3.5 3.5h-2.297m0-16.5H7.25a3.5 3.5 0 0 0-3.5 3.5v9.5a3.5 3.5 0 0 0 3.5 3.5h7.203m0-16.5v16.5"
        },
        []
      ]
    ]
  );
  const PauseIcon = createIcon(
    { name: "Pause", tags: ["Stop"], category: "Actions", deprecated: false },
    [
      [
        "rect",
        {
          width: "5",
          height: "16.5",
          x: "5",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "rect",
        {
          width: "5",
          height: "16.5",
          x: "14",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ]
    ]
  );
  const Pdf2Icon = createIcon(
    { name: "PDF 2", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.792 21.25h8.416a3.5 3.5 0 0 0 3.5-3.5v-5.53a3.5 3.5 0 0 0-1.024-2.475l-5.969-5.97A3.5 3.5 0 0 0 10.24 2.75H7.792a3.5 3.5 0 0 0-3.5 3.5v11.5a3.5 3.5 0 0 0 3.5 3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.688 3.11v5.66a2 2 0 0 0 2 2h5.662"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          d: "M7.25 16.5v-1m0 0v-2h1a1 1 0 0 1 1 1v0a1 1 0 0 1-1 1zm4 1v-3h.5a1.5 1.5 0 0 1 0 3zm4 0v-1.25m1.5-1.75h-1.5v1.75m0 0h1.5"
        },
        []
      ]
    ]
  );
  const PdfIcon = createIcon(
    { name: "PDF", tags: [""], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          d: "m11.79 10.673-.058.265a9.8 9.8 0 0 1-1.368 3.286m1.425-3.551.467-2.136c.162-.738-.556-1.316-1.11-.894-.297.226-.407.665-.26 1.037l.246.617q.286.719.657 1.376Zm0 0a10.4 10.4 0 0 0 2.064 2.596m0 0 2.255-.286c.632-.08 1.09.671.806 1.32-.207.474-.721.649-1.121.382l-.851-.568a9.4 9.4 0 0 1-1.089-.848Zm0 0-.095.013a12.3 12.3 0 0 0-3.394.942m0 0q-.626.274-1.228.618l-1.706.975c-.475.271-.577.994-.202 1.423.332.379.88.338 1.165-.087l1.91-2.837z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.792 21.25h8.416a3.5 3.5 0 0 0 3.5-3.5v-5.53a3.5 3.5 0 0 0-1.024-2.475l-5.969-5.97A3.5 3.5 0 0 0 10.24 2.75H7.792a3.5 3.5 0 0 0-3.5 3.5v11.5a3.5 3.5 0 0 0 3.5 3.5"
        },
        []
      ]
    ]
  );
  const PencilIcon = createIcon(
    {
      name: "Pencil",
      tags: ["Write", "Draw", "Edit"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.44 5.78 4.198 16.02a2 2 0 0 0-.565 1.125l-.553 3.774 3.775-.553A2 2 0 0 0 7.98 19.8L18.22 9.56m-3.78-3.78 2.229-2.23a1.6 1.6 0 0 1 2.263 0l1.518 1.518a1.6 1.6 0 0 1 0 2.263l-2.23 2.23M14.44 5.78l3.78 3.78"
        },
        []
      ]
    ]
  );
  const PentagonIcon = createIcon(
    { name: "Pentagon", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.13 3.655a3.18 3.18 0 0 1 3.74 0l6.069 4.409a3.18 3.18 0 0 1 1.155 3.557l-2.318 7.134a3.18 3.18 0 0 1-3.025 2.198H8.249a3.18 3.18 0 0 1-3.025-2.198L2.906 11.62A3.18 3.18 0 0 1 4.06 8.063z"
        },
        []
      ]
    ]
  );
  const Person2Icon = createIcon(
    {
      name: "Person 2",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "8.196",
          r: "4.446",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.608 20.25a7.608 7.608 0 0 0-15.216 0"
        },
        []
      ]
    ]
  );
  const PersonAdd2Icon = createIcon(
    {
      name: "Person Add 2",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.25 1.75v6m-3-3h6m-11.814 8.814a3.907 3.907 0 1 0 0-7.814 3.907 3.907 0 0 0 0 7.814m0 0a6.686 6.686 0 0 1 6.685 6.686m-6.685-6.686A6.686 6.686 0 0 0 3.75 20.25"
        },
        []
      ]
    ]
  );
  const PersonAddIcon = createIcon(
    {
      name: "Person Add",
      tags: ["Account Add", "User"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.104 6.854a3.604 3.604 0 1 1-7.208 0 3.604 3.604 0 0 1 7.208 0M10.87 20.75H3.5a1 1 0 0 1-1-1v-1.246c0-2.806 3.974-5.004 8-5.004q.387 0 .77.027"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.494a.5.5 0 0 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const PersonCircleIcon = createIcon(
    {
      name: "Person Circle",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 13.826a3.506 3.506 0 1 0 0-7.013 3.506 3.506 0 0 0 0 7.013m0 0a6 6 0 0 1 5.953 5.254M12 13.826a6 6 0 0 0-5.953 5.254m0 0A9.2 9.2 0 0 0 12 21.25a9.2 9.2 0 0 0 5.953-2.17m-11.906 0a9.25 9.25 0 1 1 11.907 0"
        },
        []
      ]
    ]
  );
  const PersonMultipleIcon = createIcon(
    {
      name: "Person Multiple",
      tags: ["Users", "User Multiple"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M13.322 7.209c0 .749-.237 1.442-.64 2.009a3.42 3.42 0 0 1-2.796 1.45c-1.898 0-3.436-1.55-3.436-3.46S7.988 3.75 9.886 3.75a3.445 3.445 0 0 1 3.436 3.459M2.75 18.107c0-2.677 3.545-4.774 7.136-4.774 1.432 0 2.857.333 4.053.904 1.803.86 3.084 2.26 3.082 3.87v1.143a1 1 0 0 1-1 1H3.75a1 1 0 0 1-1-1zM15.172 3.75a3.445 3.445 0 0 1 3.435 3.459c0 .749-.236 1.442-.639 2.009a3.42 3.42 0 0 1-2.796 1.45m3.452 2.569c1.536.86 2.628 2.763 2.626 4.373v2.64"
        },
        []
      ]
    ]
  );
  const PersonIcon = createIcon(
    { name: "Person", tags: [""], category: "Communication & Cloud", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19 20.75a1 1 0 0 0 1-1v-1.246c.004-2.806-3.974-5.004-8-5.004s-8 2.198-8 5.004v1.246a1 1 0 0 0 1 1zM15.604 6.854a3.604 3.604 0 1 1-7.208 0 3.604 3.604 0 0 1 7.208 0"
        },
        []
      ]
    ]
  );
  const PhoneAcceptIcon = createIcon(
    {
      name: "Phone Accept",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M8.14 15.733c2.158 2.158 4.278 3.28 5.89 3.864 1.768.64 3.606-.117 4.935-1.446l.459-.458a1.5 1.5 0 0 0 0-2.122l-1.149-1.149a1.5 1.5 0 0 0-2.121 0l-.387.387a2 2 0 0 1-2.828 0l-3.713-3.712a2 2 0 0 1 0-2.829l.387-.387a1.5 1.5 0 0 0 0-2.12l-1.15-1.15a1.5 1.5 0 0 0-2.12 0l-.572.572c-1.262 1.262-2.013 2.99-1.438 4.68.538 1.58 1.622 3.685 3.806 5.87Z"
        },
        []
      ]
    ]
  );
  const PhoneHangUpIcon = createIcon(
    {
      name: "Phone Hang Up",
      tags: [""],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M12.116 7.953c-3.053 0-5.346.706-6.899 1.433-1.702.797-2.467 2.632-2.467 4.512v.649a1.5 1.5 0 0 0 1.5 1.5h1.625a1.5 1.5 0 0 0 1.5-1.5V14a2 2 0 0 1 2-2h5.25a2 2 0 0 1 2 2v.547a1.5 1.5 0 0 0 1.5 1.5h1.625a1.5 1.5 0 0 0 1.5-1.5v-.81c0-1.784-.691-3.537-2.293-4.325-1.496-.736-3.752-1.459-6.841-1.459Z"
        },
        []
      ]
    ]
  );
  const PhoneIcon = createIcon(
    {
      name: "Phone",
      tags: ["iPhone", "Samsung Galaxy", "Mobile", "Android", "iOS", "Smartphone"],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "12.5",
          height: "18.5",
          x: "5.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11 17.75h2"
        },
        []
      ]
    ]
  );
  const PhotoFilterIcon = createIcon(
    {
      name: "Photo Filter",
      tags: ["Color Filter", "Tint"],
      category: "Activities",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "8.73",
          r: "5.98",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "circle",
        {
          cx: "8.729",
          cy: "15.27",
          r: "5.98",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "circle",
        {
          cx: "15.271",
          cy: "15.27",
          r: "5.98",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const PhotoIcon = createIcon(
    { name: "Photo", tags: ["Image", "Picture"], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.33 17.657c.11-.366.17-.755.17-1.157v-9a4 4 0 0 0-4-4h-9a4 4 0 0 0-4 4v9.07m16.83 1.087-.088-.104-2.466-2.976a2 2 0 0 0-3.073-.008l-1.312 1.566-.214.261m7.153 1.26a4 4 0 0 1-3.713 2.842m0 0-.117.002h-9a4 4 0 0 1-4-3.93m13.117 3.928-.093-.106-3.347-3.996m-9.676.175.177-.201 3.206-3.827a2 2 0 0 1 3.066 0l3.227 3.853"
        },
        []
      ],
      ["circle", { cx: "15.091", cy: "8.909", r: "1.5", fill: "currentColor" }, []]
    ]
  );
  const PictureInPicture2Icon = createIcon(
    { name: "Picture in Picture 2", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.25 4H5.75a3 3 0 0 0-3 3v10a3 3 0 0 0 3 3h12.5a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3"
        },
        []
      ],
      [
        "rect",
        {
          width: "8.5",
          height: "7.083",
          x: "10.25",
          y: "10.42",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ]
    ]
  );
  const PictureInPictureEnterIcon = createIcon(
    {
      name: "Picture in Picture Enter",
      tags: [""],
      category: "Window",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.25 18.25h-3.5a3 3 0 0 1-3-3v-8.5a3 3 0 0 1 3-3h12.5a3 3 0 0 1 3 3v3.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "12",
          height: "10",
          x: "11",
          y: "12",
          fill: "currentColor",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10 7.667V10.4a.6.6 0 0 1-.176.424M6.667 11H9.4a.6.6 0 0 0 .424-.176M6 7l3 3 .824.824"
        },
        []
      ]
    ]
  );
  const PictureInPictureExitIcon = createIcon(
    {
      name: "Picture in Picture Exit",
      tags: [""],
      category: "Window",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.75 5.75h3.5a3 3 0 0 1 3 3v8.5a3 3 0 0 1-3 3H5.75a3 3 0 0 1-3-3v-3.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "12",
          height: "10",
          x: "13",
          y: "12",
          fill: "currentColor",
          rx: "2",
          transform: "rotate(180 13 12)"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18 13.667V16.4a.6.6 0 0 1-.176.424M14.667 17H17.4a.6.6 0 0 0 .424-.176M14 13l3 3 .824.824"
        },
        []
      ]
    ]
  );
  const PictureInPictureIcon = createIcon(
    { name: "Picture in Picture", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.25 18.25h-3.5a3 3 0 0 1-3-3v-8.5a3 3 0 0 1 3-3h12.5a3 3 0 0 1 3 3v3.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "12",
          height: "10",
          x: "11",
          y: "12",
          fill: "currentColor",
          rx: "2"
        },
        []
      ]
    ]
  );
  const PinOffIcon = createIcon(
    { name: "Pin Off", tags: ["Unpin"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.77 16.233-4.02 4.02m16.968 1.529-6.258-6.26M2.217 3.283 8.48 9.545m5.979 5.979q-.183.357-.292.75l-.688 2.5a1.5 1.5 0 0 1-2.507.663L4.568 13.03a1.5 1.5 0 0 1 .662-2.507l2.5-.688a4 4 0 0 0 .75-.291m5.98 5.979-5.98-5.98m1.765-1.775q.087-.175.158-.36l1.291-3.372a2 2 0 0 1 3.282-.7l5.69 5.691a2 2 0 0 1-.698 3.282L16.595 13.6q-.184.07-.36.159"
        },
        []
      ]
    ]
  );
  const PinIcon = createIcon(
    { name: "Pin", tags: [""], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.77 16.233-4.02 4.02M14.976 3.336l5.69 5.691a2 2 0 0 1-.698 3.282L16.595 13.6a4 4 0 0 0-2.426 2.674l-.689 2.5a1.5 1.5 0 0 1-2.507.662L4.568 13.03a1.5 1.5 0 0 1 .662-2.507l2.5-.688a4 4 0 0 0 2.673-2.427l1.291-3.372a2 2 0 0 1 3.282-.7"
        },
        []
      ]
    ]
  );
  const PlayCircularIcon = createIcon(
    { name: "Play Circular", tags: [""], category: "Actions", deprecated: false },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M8.93 13.29c0 1.098 0 1.646.23 1.964.202.277.51.456.85.492.391.041.867-.232 1.818-.779l2.244-1.29c.957-.55 1.435-.825 1.595-1.185.14-.313.14-.671 0-.984-.16-.36-.639-.635-1.595-1.184l-2.244-1.291c-.951-.547-1.427-.82-1.817-.779-.34.036-.65.215-.85.492-.23.318-.23.866-.23 1.963z"
        },
        []
      ]
    ]
  );
  const PlayIcon = createIcon(
    { name: "Play", tags: ["Start", "Resume"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.5 12V5.624c0-1.974 2.18-3.17 3.844-2.108l10 6.376c1.541.983 1.541 3.233 0 4.216l-10 6.376C7.68 21.545 5.5 20.35 5.5 18.376z"
        },
        []
      ]
    ]
  );
  const PrinterIcon = createIcon(
    { name: "Printer", tags: [""], category: "Technology", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.75 17v1.05c0 1.12 0 1.68.218 2.108a2 2 0 0 0 .874.874c.428.218.988.218 2.108.218h4.1c1.12 0 1.68 0 2.108-.218a2 2 0 0 0 .874-.874c.218-.428.218-.988.218-2.108V17m-10.5 0v-1.05c0-1.12 0-1.68.218-2.108a2 2 0 0 1 .874-.874c.428-.218.988-.218 2.108-.218h4.1c1.12 0 1.68 0 2.108.218a2 2 0 0 1 .874.874c.218.428.218.988.218 2.108V17m-10.5 0h-.8c-1.12 0-1.68 0-2.108-.218a2 2 0 0 1-.874-.874c-.218-.428-.218-.988-.218-2.108v-3c0-1.68 0-2.52.327-3.162a3 3 0 0 1 1.311-1.311C5.03 6 5.87 6 7.55 6h8.9c1.68 0 2.52 0 3.162.327a3 3 0 0 1 1.311 1.311c.327.642.327 1.482.327 3.162v3c0 1.12 0 1.68-.218 2.108a2 2 0 0 1-.874.874C19.73 17 19.17 17 18.05 17h-.8M6.75 4.25a1.5 1.5 0 0 1 1.5-1.5h7.5a1.5 1.5 0 0 1 1.5 1.5V6H6.75z"
        },
        []
      ]
    ]
  );
  const ProhibitedIcon = createIcon(
    { name: "Prohibited", tags: [""], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.46 18.54A9.25 9.25 0 0 0 18.54 5.46M5.459 18.541A9.25 9.25 0 0 1 18.54 5.46M5.46 18.54 18.54 5.46"
        },
        []
      ]
    ]
  );
  const PythonIcon = createIcon(
    {
      name: "Python",
      tags: ["Programming"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 7.5H7.5m4.5 9h4.5m0 0h1.521c.807 0 1.634-.188 2.13-.824.531-.679 1.099-1.835 1.099-3.676 0-1.84-.568-2.997-1.098-3.676-.497-.636-1.324-.824-2.13-.824H16.5m0 9v1.521c0 .807-.188 1.634-.824 2.13-.679.531-1.835 1.099-3.676 1.099-1.84 0-2.997-.568-3.676-1.098-.636-.497-.824-1.324-.824-2.13V16.5m0-9H5.978c-.807 0-1.633.188-2.13.824-.53.679-1.098 1.835-1.098 3.676 0 1.84.568 2.997 1.098 3.676.497.636 1.323.824 2.13.824H7.5m0-9V5.978c0-.807.188-1.633.824-2.13.679-.53 1.835-1.098 3.676-1.098 1.84 0 2.997.568 3.676 1.098.636.497.824 1.323.824 2.13V7.5m-9 9V14a2 2 0 0 1 2-2h5a2 2 0 0 0 2-2V7.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M15 18.5a.75.75 0 1 1-1.5 0 .75.75 0 0 1 1.5 0m-6-13a.75.75 0 1 1 1.5 0 .75.75 0 0 1-1.5 0"
        },
        []
      ]
    ]
  );
  const QrCodeIcon = createIcon(
    { name: "QR Code", tags: [""], category: "Files", deprecated: false },
    [
      [
        "rect",
        {
          width: "7.5",
          height: "7.5",
          x: "2.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "7.5",
          height: "7.5",
          x: "13.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "7.5",
          height: "7.5",
          x: "2.75",
          y: "13.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2.5"
        },
        []
      ],
      [
        "rect",
        { width: "3", height: "3", x: "5", y: "5", fill: "currentColor", rx: "1.5" },
        []
      ],
      [
        "rect",
        { width: "3", height: "3", x: "16", y: "5", fill: "currentColor", rx: "1.5" },
        []
      ],
      [
        "rect",
        { width: "3", height: "3", x: "5", y: "16", fill: "currentColor", rx: "1.5" },
        []
      ],
      [
        "rect",
        {
          width: "3",
          height: "3",
          x: "13",
          y: "13",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "3",
          height: "3",
          x: "16",
          y: "16",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "3",
          height: "3",
          x: "19",
          y: "19",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "3",
          height: "3",
          x: "19",
          y: "13",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ],
      [
        "rect",
        {
          width: "3",
          height: "3",
          x: "13",
          y: "19",
          fill: "currentColor",
          rx: "1.5"
        },
        []
      ]
    ]
  );
  const QuestionCircleIcon = createIcon(
    {
      name: "Question Circle",
      tags: ["Help", "Support"],
      category: "Miscellaneous",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.301 9.709a2.699 2.699 0 1 1 4.85 1.63 4 4 0 0 1-.32.317c-.092.078-.137.11-.227.171l-.979.675a1.81 1.81 0 0 0-.784 1.493"
        },
        []
      ],
      ["circle", { cx: "11.828", cy: "16.74", r: "1", fill: "currentColor" }, []],
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ]
    ]
  );
  const QuestionIcon = createIcon(
    { name: "Question", tags: [""], category: "Miscellaneous", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.817 8.808a4.183 4.183 0 1 1 7.518 2.526l-.133.145c-.065.07-.29.286-.363.347a4 4 0 0 1-.353.266l-1.517 1.045a2.81 2.81 0 0 0-1.215 2.315"
        },
        []
      ],
      ["circle", { cx: "11.754", cy: "19.141", r: ".984", fill: "currentColor" }, []]
    ]
  );
  const QuoteIcon = createIcon(
    { name: "Quote", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m9.937 10.453-.01.13c0 3.35-2.038 5.115-4.63 6.058m4.64-6.188a3.093 3.093 0 1 1-6.187.001 3.093 3.093 0 0 1 6.187-.001m10.313 0-.01.13c0 3.35-2.038 5.115-4.63 6.058m4.64-6.188a3.093 3.093 0 1 1-6.187 0 3.093 3.093 0 0 1 6.187 0"
        },
        []
      ]
    ]
  );
  const ReactjsIcon = createIcon(
    {
      name: "ReactJS",
      tags: ["Framework", "JavaScript", "Meta", "Facebook"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 8.013c-5.385 0-9.75 1.785-9.75 3.987s4.365 3.987 9.75 3.987 9.75-1.785 9.75-3.987S17.385 8.013 12 8.013"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.423 10.006c-2.692-4.704-6.407-7.625-8.298-6.524-1.89 1.101-1.24 5.807 1.452 10.512 2.692 4.704 6.408 7.625 8.298 6.524s1.24-5.807-1.452-10.512"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.423 13.994c2.693-4.705 3.343-9.41 1.452-10.512-1.89-1.1-5.606 1.82-8.298 6.524s-3.342 9.41-1.452 10.512c1.89 1.1 5.606-1.82 8.298-6.524"
        },
        []
      ],
      ["circle", { cx: "12", cy: "12", r: "1.5", fill: "currentColor" }, []]
    ]
  );
  const RecordStopIcon = createIcon(
    {
      name: "Record Stop",
      tags: ["Recording", "Voice"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "rect",
        { width: "8", height: "8", x: "8", y: "8", fill: "currentColor", rx: "2" },
        []
      ]
    ]
  );
  const RecordIcon = createIcon(
    {
      name: "Record",
      tags: ["Recording", "Voice"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12",
          cy: "12",
          r: "9.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      ["circle", { cx: "12", cy: "12", r: "5", fill: "currentColor" }, []]
    ]
  );
  const RectangleWideIcon = createIcon(
    { name: "Rectangle Wide", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "14.5",
          x: "2.75",
          y: "4.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ]
    ]
  );
  const RegularExpressionIcon = createIcon(
    {
      name: "Regular Expression",
      tags: ["RegExp", "Text", "Match"],
      category: "Text",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "6.75",
          cy: "17.25",
          r: "3",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16 3.75.003 4.996L20.25 6.25l-4.245 2.5 4.245 2.5-4.247-2.496L16 13.75l-.002-4.996-4.248 2.496 4.245-2.5-4.245-2.5 4.248 2.496z"
        },
        []
      ]
    ]
  );
  const ReverseIcon = createIcon(
    { name: "Reverse", tags: [""], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.005 18.323c1.019.784 2.495.057 2.495-1.229V6.906c0-1.286-1.476-2.013-2.495-1.229L11.78 10.87a1.473 1.473 0 0 0 0 2.262z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.754 18.323c1.02.784 2.496.057 2.496-1.229V6.906c0-1.286-1.476-2.013-2.496-1.229L2.53 10.87a1.473 1.473 0 0 0 0 2.262z"
        },
        []
      ]
    ]
  );
  const RhombusIcon = createIcon(
    { name: "Rhombus", tags: ["Diamond"], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.775 14.475a3.5 3.5 0 0 1 0-4.95l5.75-5.75a3.5 3.5 0 0 1 4.95 0l5.75 5.75a3.5 3.5 0 0 1 0 4.95l-5.75 5.75a3.5 3.5 0 0 1-4.95 0z"
        },
        []
      ]
    ]
  );
  const RibbonStarIcon = createIcon(
    { name: "Ribbon Star", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.41 9.16a6.4 6.4 0 0 1-2.426 5.02A6.38 6.38 0 0 1 12 15.57c-1.506 0-2.89-.52-3.984-1.388A6.41 6.41 0 1 1 18.41 9.16"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.984 14.18v7.07L12 18.267 8.016 21.25v-7.07"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M11.455 6.74c.179-.307.268-.461.385-.513a.4.4 0 0 1 .32 0c.117.052.206.206.385.513l.488.838a1 1 0 0 0 .112.168q.045.047.106.076a1 1 0 0 0 .194.055l.947.205c.348.075.522.113.607.208.075.083.11.193.1.304-.014.127-.133.26-.37.525l-.646.723a1 1 0 0 0-.125.159.4.4 0 0 0-.04.123 1 1 0 0 0 .008.202l.098.964c.036.355.054.532-.01.642a.4.4 0 0 1-.26.188c-.124.027-.287-.045-.612-.188l-.887-.391a1 1 0 0 0-.19-.07.4.4 0 0 0-.13 0 1 1 0 0 0-.19.07l-.886.39c-.326.144-.49.216-.614.19a.4.4 0 0 1-.259-.189c-.064-.11-.046-.287-.01-.642l.098-.964c.01-.102.015-.153.008-.202a.4.4 0 0 0-.04-.123 1 1 0 0 0-.125-.159L9.27 9.12c-.238-.265-.356-.398-.37-.525a.4.4 0 0 1 .1-.304c.085-.095.259-.133.607-.208l.947-.205c.1-.022.15-.033.194-.055a.4.4 0 0 0 .106-.076 1 1 0 0 0 .112-.168z"
        },
        []
      ]
    ]
  );
  const RibbonIcon = createIcon(
    { name: "Ribbon", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.41 9.16a6.4 6.4 0 0 1-2.426 5.02A6.38 6.38 0 0 1 12 15.57c-1.506 0-2.89-.52-3.984-1.388A6.41 6.41 0 1 1 18.41 9.16"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.984 14.18v7.07L12 18.267 8.016 21.25v-7.07"
        },
        []
      ]
    ]
  );
  const RobloxIcon = createIcon(
    {
      name: "Roblox",
      tags: ["Gaming", "Studio", "Bloxy", "Player"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.02",
          height: "16.02",
          x: "6.336",
          y: "2.19",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2.5",
          transform: "rotate(15 6.336 2.19)"
        },
        []
      ],
      [
        "rect",
        {
          width: "5.34",
          height: "5.34",
          x: "10.112",
          y: "8.73",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: ".8",
          transform: "rotate(15 10.112 8.73)"
        },
        []
      ]
    ]
  );
  const RulerDiagonalIcon = createIcon(
    {
      name: "Ruler Diagonal",
      tags: ["Measure", "Length", "Meter", "Foot", "Metre", "Feet", "Yard"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "9",
          height: "19.5",
          x: "15.712",
          y: "1.924",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2",
          transform: "rotate(45 15.712 1.924)"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M8.818 8.818 12 12m0-6.364 3.182 3.182M5.636 12l3.182 3.182"
        },
        []
      ]
    ]
  );
  const RulerIcon = createIcon(
    {
      name: "Ruler",
      tags: ["Measure", "Length", "Meter", "Foot", "Metre", "Feet", "Yard"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "9.5",
          height: "18.5",
          x: "6.75",
          y: "2.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M6.75 12h4.5m-4.5-4.5h4.5m-4.5 9h4.5"
        },
        []
      ]
    ]
  );
  const SaveAsIcon = createIcon(
    { name: "Save As", tags: ["Floppy Disk"], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.558 3.75v1.27c0 1.094 0 1.641.208 2.061a2 2 0 0 0 .903.903c.42.208.967.208 2.062.208s1.642 0 2.062-.208a2 2 0 0 0 .902-.903c.209-.42.209-.967.209-2.062V3.75m-6.346 0h6.346m-6.346 0c-.751 0-1.126 0-1.438.067A3 3 0 0 0 3.817 6.12c-.067.312-.067.687-.067 1.438v9.519c0 .16 0 .241.003.309a3 3 0 0 0 2.861 2.86c.068.004.148.004.31.004m6.98-16.5h.052a3 3 0 0 1 2.078.86l.037.037 2.773 2.774c.519.519.778.778.964 1.081a3 3 0 0 1 .36.867c.028.12.047.242.059.381M6.923 20.25V16c0-1.4 0-2.1.273-2.635a2.5 2.5 0 0 1 1.092-1.092C8.823 12 9.523 12 10.923 12h2.154c1.168 0 1.849 0 2.353.158M6.923 20.25H9.75"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M21.796 12.204a2.4 2.4 0 0 0-1.546-.7 2.4 2.4 0 0 0-1.854.7l-1.47 1.47-4.305 4.306a2.3 2.3 0 0 0-.635 1.172l-.21 1.098-.261 1.371a.74.74 0 0 0 .195.67.74.74 0 0 0 .669.194l2.469-.47a2.3 2.3 0 0 0 1.172-.636l5.776-5.776a2.404 2.404 0 0 0 0-3.399"
        },
        []
      ]
    ]
  );
  const SaveIcon = createIcon(
    { name: "Save", tags: ["Floppy Disk"], category: "Files", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.558 3.75H7.25a3.5 3.5 0 0 0-3.5 3.5v9.827a3.173 3.173 0 0 0 3.173 3.173v0m.635-16.5v2.442a2 2 0 0 0 2 2h2.346a2 2 0 0 0 2-2V3.75m-6.346 0h6.346m0 0h.026a3 3 0 0 1 2.122.879l3.173 3.173a3.5 3.5 0 0 1 1.025 2.475v6.8a3.173 3.173 0 0 1-3.173 3.173v0m-10.154 0V15a3 3 0 0 1 3-3h4.154a3 3 0 0 1 3 3v5.25m-10.154 0h10.154"
        },
        []
      ]
    ]
  );
  const ScreenSizeIcon = createIcon(
    {
      name: "Screen Size",
      tags: ["Aspect Ratio"],
      category: "Math & Numbers",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "15.5",
          x: "2.75",
          y: "4.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.75 12.25v-4h4m6.5 3.5v4h-4"
        },
        []
      ]
    ]
  );
  const Script2Icon = createIcon(
    { name: "Script 2", tags: ["Macro"], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.25 21.25H4A2.25 2.25 0 0 1 1.75 19v-1.25a1.5 1.5 0 0 1 1.5-1.5h1.5m10.5 5a2.5 2.5 0 0 0 2.5-2.5v-11m-2.5 13.5a2.5 2.5 0 0 1-2.5-2.5v-1.5a1 1 0 0 0-1-1h-7m15.376-13.5H8.25a3.5 3.5 0 0 0-3.5 3.5v10m13-8.5h3.5a1 1 0 0 0 1-1V5a2.25 2.25 0 0 0-4.5 0z"
        },
        []
      ]
    ]
  );
  const ScriptIcon = createIcon(
    { name: "Script", tags: ["Macro"], category: "Development", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.25 21.25H4A2.25 2.25 0 0 1 1.75 19v-1.25a1.5 1.5 0 0 1 1.5-1.5h1.5m10.5 5a2.5 2.5 0 0 0 2.5-2.5v-11m-2.5 13.5a2.5 2.5 0 0 1-2.5-2.5v-1.5a1 1 0 0 0-1-1h-7m15.376-13.5H8.25a3.5 3.5 0 0 0-3.5 3.5v10m13-8.5h3.5a1 1 0 0 0 1-1V5a2.25 2.25 0 0 0-4.5 0zm-9.25-.5h6m-6 4h4"
        },
        []
      ]
    ]
  );
  const SearchCancelIcon = createIcon(
    {
      name: "Search Cancel",
      tags: ["No Results", "Clear Search"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m8.44 12.682 2.12-2.121m0 0 2.122-2.122m-2.121 2.122 2.12 2.12m-2.12-2.12L8.439 8.439m7.114 7.114a7.06 7.06 0 1 0-9.985-9.985 7.06 7.06 0 0 0 9.985 9.985m0 0L20 20"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.553 5.568a7.06 7.06 0 1 1-9.985 9.985 7.06 7.06 0 0 1 9.985-9.985"
        },
        []
      ]
    ]
  );
  const SearchIcon = createIcon(
    { name: "Search", tags: ["Find", "Look"], category: "Actions", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.553 15.553a7.06 7.06 0 1 0-9.985-9.985 7.06 7.06 0 0 0 9.985 9.985m0 0L20 20"
        },
        []
      ]
    ]
  );
  const SectionBreakIcon = createIcon(
    { name: "Section Break", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 12h18.5M4 2.75V5.5a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2.75M4 21.25V18.5a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v2.75"
        },
        []
      ]
    ]
  );
  const SendIcon = createIcon(
    { name: "Send", tags: [""], category: "Communication & Cloud", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.76 12H6.832m0 0c0-.275-.057-.55-.17-.808L4.285 5.814c-.76-1.72 1.058-3.442 2.734-2.591L20.8 10.217c1.46.74 1.46 2.826 0 3.566L7.02 20.777c-1.677.851-3.495-.872-2.735-2.591l2.375-5.378A2 2 0 0 0 6.83 12"
        },
        []
      ]
    ]
  );
  const ServerIcon = createIcon(
    {
      name: "Server",
      tags: ["Internet"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "7.5",
          x: "2.75",
          y: "2.751",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      ["circle", { cx: "6.25", cy: "6.501", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "10.25", cy: "6.501", r: "1.25", fill: "currentColor" }, []],
      [
        "rect",
        {
          width: "18.5",
          height: "7.5",
          x: "2.75",
          y: "13.749",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      ["circle", { cx: "6.25", cy: "17.499", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "10.25", cy: "17.499", r: "1.25", fill: "currentColor" }, []]
    ]
  );
  const SettingsIcon = createIcon(
    { name: "Settings", tags: [""], category: "System & Interface", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.05 6.462a2 2 0 0 0 2.63-1.519l.32-1.72a9 9 0 0 1 3.998 0l.322 1.72a2 2 0 0 0 2.63 1.519l1.649-.58a9 9 0 0 1 2.001 3.46l-1.33 1.14a2 2 0 0 0 0 3.037l1.33 1.139a9 9 0 0 1-2.001 3.46l-1.65-.58a2 2 0 0 0-2.63 1.519L14 20.777a9 9 0 0 1-3.998 0l-.322-1.72a2 2 0 0 0-2.63-1.519l-1.649.58a9 9 0 0 1-2.001-3.46l1.33-1.14a2 2 0 0 0 0-3.036L3.4 9.342a9 9 0 0 1 2-3.46zM12 9a3 3 0 1 1 0 6 3 3 0 0 1 0-6",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const ShapeDifferenceIcon = createIcon(
    { name: "Shape Difference", tags: [""], category: "Design", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M1.998 5.75A3.75 3.75 0 0 1 5.748 2h7a3.75 3.75 0 0 1 3.75 3.75V7.5h-5.246a3.75 3.75 0 0 0-3.75 3.75v5.25H5.748a3.75 3.75 0 0 1-3.75-3.75z"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.502 16.5h5.246a3.75 3.75 0 0 0 3.75-3.75V7.5h1.754a3.75 3.75 0 0 1 3.75 3.75v7a3.75 3.75 0 0 1-3.75 3.75h-7a3.75 3.75 0 0 1-3.75-3.75z"
        },
        []
      ]
    ]
  );
  const ShapeIntersectIcon = createIcon(
    { name: "Shape Intersect", tags: [""], category: "Design", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M12.748 15.75a3 3 0 0 0 3-3v-4.5h-4.496a3 3 0 0 0-3 3v4.5z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.252 15.75v2.5a3 3 0 0 0 3 3h7a3 3 0 0 0 3-3v-7a3 3 0 0 0-3-3h-2.504m-7.496 7.5v-4.5a3 3 0 0 1 3-3h4.496m-7.496 7.5h4.496a3 3 0 0 0 3-3v-4.5m-7.496 7.5H5.748a3 3 0 0 1-3-3v-7a3 3 0 0 1 3-3h7a3 3 0 0 1 3 3v2.5"
        },
        []
      ]
    ]
  );
  const ShapeSubtractIcon = createIcon(
    { name: "Shape Subtract", tags: [""], category: "Design", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M12.748 2.75h-7a3 3 0 0 0-3 3v7a3 3 0 0 0 3 3h2.504v-4.5a3 3 0 0 1 3-3h4.496v-2.5a3 3 0 0 0-3-3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.252 15.75v2.5a3 3 0 0 0 3 3h7a3 3 0 0 0 3-3v-7a3 3 0 0 0-3-3h-2.504m-7.496 7.5v-4.5a3 3 0 0 1 3-3h4.496m-7.496 7.5H5.748a3 3 0 0 1-3-3v-7a3 3 0 0 1 3-3h7a3 3 0 0 1 3 3v2.5"
        },
        []
      ]
    ]
  );
  const ShapeUnionIcon = createIcon(
    { name: "Shape Union", tags: [""], category: "Design", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M2.748 5.75a3 3 0 0 1 3-3h7a3 3 0 0 1 3 3v7a3 3 0 0 1-3 3h-7a3 3 0 0 1-3-3z"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M8.252 11.25a3 3 0 0 1 3-3h7a3 3 0 0 1 3 3v7a3 3 0 0 1-3 3h-7a3 3 0 0 1-3-3z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.748 5.75a3 3 0 0 1 3-3h7a3 3 0 0 1 3 3v7a3 3 0 0 1-3 3h-7a3 3 0 0 1-3-3z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M8.252 11.25a3 3 0 0 1 3-3h7a3 3 0 0 1 3 3v7a3 3 0 0 1-3 3h-7a3 3 0 0 1-3-3z"
        },
        []
      ]
    ]
  );
  const ShieldCancelIcon = createIcon(
    { name: "Shield Cancel", tags: [""], category: "Security", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 10.907V7.272c0-.829-.633-1.521-1.453-1.644-.951-.142-2.18-.376-3.078-.722-.907-.349-1.997-1.007-2.762-1.505a1.76 1.76 0 0 0-1.914 0c-.764.498-1.855 1.156-2.762 1.505-.899.346-2.127.58-3.078.722-.82.123-1.453.815-1.453 1.644v3.635a10.13 10.13 0 0 0 5.363 8.939l.23.123 1.962.946a1.6 1.6 0 0 0 1.39 0l1.961-.946.23-.123a10.13 10.13 0 0 0 5.364-8.939M9.5 9.5l5 5m0-5-5 5"
        },
        []
      ]
    ]
  );
  const ShieldCheckmarkIcon = createIcon(
    { name: "Shield Checkmark", tags: [""], category: "Security", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 10.907V7.272c0-.829-.633-1.521-1.453-1.644-.951-.142-2.18-.376-3.078-.722-.907-.349-1.997-1.007-2.762-1.505a1.76 1.76 0 0 0-1.914 0c-.764.498-1.855 1.156-2.762 1.505-.899.346-2.127.58-3.078.722-.82.123-1.453.815-1.453 1.644v3.635a10.13 10.13 0 0 0 5.363 8.939l.23.123 1.962.946a1.6 1.6 0 0 0 1.39 0l1.961-.946.23-.123a10.13 10.13 0 0 0 5.364-8.939"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m15.509 10-4.076 4.076a.6.6 0 0 1-.849 0l-2.093-2.09"
        },
        []
      ]
    ]
  );
  const ShieldKeyholeIcon = createIcon(
    { name: "Shield Keyhole", tags: [""], category: "Security", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 10.907V7.272c0-.829-.633-1.521-1.453-1.644-.951-.142-2.18-.376-3.078-.722-.907-.349-1.997-1.007-2.762-1.505a1.76 1.76 0 0 0-1.914 0c-.764.498-1.855 1.156-2.762 1.505-.899.346-2.127.58-3.078.722-.82.123-1.453.815-1.453 1.644v3.635a10.13 10.13 0 0 0 5.363 8.939l.23.123 1.962.946a1.6 1.6 0 0 0 1.39 0l1.961-.946.23-.123a10.13 10.13 0 0 0 5.364-8.939"
        },
        []
      ],
      ["circle", { cx: "12", cy: "10.5", r: "2", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 14.75v-2.5"
        },
        []
      ]
    ]
  );
  const ShieldIcon = createIcon(
    { name: "Shield", tags: ["Security"], category: "Security", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.25 10.907V7.272c0-.829-.633-1.521-1.453-1.644-.951-.142-2.18-.376-3.078-.722-.907-.349-1.997-1.007-2.762-1.505a1.76 1.76 0 0 0-1.914 0c-.764.498-1.855 1.156-2.762 1.505-.899.346-2.127.58-3.078.722-.82.123-1.453.815-1.453 1.644v3.635a10.13 10.13 0 0 0 5.363 8.939l.23.123 1.962.946a1.6 1.6 0 0 0 1.39 0l1.961-.946.23-.123a10.13 10.13 0 0 0 5.364-8.939"
        },
        []
      ]
    ]
  );
  const SkullIcon = createIcon(
    {
      name: "Skull",
      tags: [
        "Skeleton",
        "Emoji",
        "Bones",
        "Head",
        "Spooky",
        "Poison",
        "Pirate",
        "Kill",
        "Blood",
        "Death",
        "Die,"
      ],
      category: "Emojis",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.99 17.284c2.225-1.528 3.26-3.442 3.26-6.164 0-4.62-4.141-8.37-9.25-8.37S2.75 6.5 2.75 11.12c0 2.722 1.437 4.636 3.663 6.164-.175.61-.132 2.251.187 2.78.414.687 1.219 1.186 1.87 1.186.743 0 1.396-.474 1.765-1.186.37.712 1.022 1.186 1.765 1.186s1.396-.473 1.765-1.186c.37.713 1.022 1.186 1.765 1.186.651 0 1.454-.499 1.94-1.186.374-.529.52-2.17.52-2.78"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M5.75 10.25a2.5 2.5 0 0 1 5 0v1a1.5 1.5 0 0 1-1.5 1.5h-1a2.5 2.5 0 0 1-2.5-2.5m7.5 0a2.5 2.5 0 1 1 2.5 2.5h-1a1.5 1.5 0 0 1-1.5-1.5zm-1.773 2.93-1.224 2.176a.6.6 0 0 0 .523.894h2.448a.6.6 0 0 0 .523-.894l-1.224-2.176a.6.6 0 0 0-1.046 0"
        },
        []
      ]
    ]
  );
  const SlashBoxIcon = createIcon(
    { name: "Slash Box", tags: ["Command"], category: "Actions", deprecated: false },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m14.5 7-5 10"
        },
        []
      ]
    ]
  );
  const SoundwaveIcon = createIcon(
    {
      name: "Soundwave",
      tags: ["Audio", "EQ", "Waveform", "mp3"],
      category: "Media",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 20.75V3.25m8 11.71V9.04M4 14.96V9.04m12 8.872V6.088M8 17.912V6.088"
        },
        []
      ]
    ]
  );
  const SpacebarIcon = createIcon(
    { name: "Spacebar", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 10v2.5a2 2 0 0 0 2 2h12.5a2 2 0 0 0 2-2V10"
        },
        []
      ]
    ]
  );
  const SparkleIcon = createIcon(
    {
      name: "Sparkle",
      tags: ["Flare", "Gemini"],
      category: "Miscellaneous",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M11.256 3.567c.266-.675 1.222-.675 1.488 0l2.047 5.19a.8.8 0 0 0 .451.452l5.191 2.047c.675.266.675 1.222 0 1.488l-5.19 2.047a.8.8 0 0 0-.452.451l-2.047 5.191c-.266.675-1.222.675-1.488 0l-2.047-5.19a.8.8 0 0 0-.451-.452l-5.191-2.047c-.675-.266-.675-1.222 0-1.488l5.19-2.047a.8.8 0 0 0 .452-.451z"
        },
        []
      ],
      ["circle", { cx: "5.25", cy: "5.25", r: "1.25", fill: "currentColor" }, []],
      ["circle", { cx: "19", cy: "19", r: "1", fill: "currentColor" }, []]
    ]
  );
  const SpinnerIcon = createIcon(
    { name: "Spinner", tags: ["Loading"], category: "Status", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 21.25A9.25 9.25 0 1 0 2.75 12"
        },
        []
      ]
    ]
  );
  const SquareIcon = createIcon(
    { name: "Square", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ]
    ]
  );
  const StarIcon = createIcon(
    {
      name: "Star",
      tags: ["Favourite", "Favorite"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.704 4.325a1.5 1.5 0 0 1 2.592 0l1.818 3.12a1.5 1.5 0 0 0 .978.712l3.53.764a1.5 1.5 0 0 1 .8 2.465l-2.405 2.693a1.5 1.5 0 0 0-.374 1.15l.363 3.593a1.5 1.5 0 0 1-2.097 1.524l-3.304-1.456a1.5 1.5 0 0 0-1.21 0l-3.304 1.456a1.5 1.5 0 0 1-2.097-1.524l.363-3.593a1.5 1.5 0 0 0-.373-1.15l-2.406-2.693a1.5 1.5 0 0 1 .8-2.465l3.53-.764a1.5 1.5 0 0 0 .979-.711z"
        },
        []
      ]
    ]
  );
  const StrokeThicknessIcon = createIcon(
    {
      name: "Stroke Thickness",
      tags: ["Line Thickness", "Border", "Weight", "Outline"],
      category: "Design",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 4.5h18.5M20.5 10h-17a.75.75 0 0 0 0 1.5h17a.75.75 0 0 0 0-1.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M19.75 17H4.25a1.5 1.5 0 0 0 0 3h15.5a1.5 1.5 0 0 0 0-3"
        },
        []
      ]
    ]
  );
  const SubtractIcon = createIcon(
    {
      name: "Subtract",
      tags: ["Minus", "Minimize", "Line Horizonal", "Subtract"],
      category: "Arrows",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 12h16.5"
        },
        []
      ]
    ]
  );
  const SvelteIcon = createIcon(
    {
      name: "Svelte",
      tags: ["SvelteKit", "Framework", "JavaScript", "Compiler"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.878 10.881a5.63 5.63 0 0 1-2.181 7.44l-3.757 2.175a5.596 5.596 0 0 1-7.656-2.057 5.63 5.63 0 0 1-.162-5.32 5.63 5.63 0 0 1 2.181-7.44l3.757-2.175a5.596 5.596 0 0 1 7.656 2.057 5.63 5.63 0 0 1 .162 5.32"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.011 8.912a2.2 2.2 0 0 0-.228-1.653 2.195 2.195 0 0 0-3-.813l-3.8 2.2a2.207 2.207 0 0 0-.798 3.012 2.195 2.195 0 0 0 3.001.813l1.628-.942a2.195 2.195 0 0 1 3 .813 2.207 2.207 0 0 1-.797 3.012l-3.8 2.2a2.195 2.195 0 0 1-3-.813 2.2 2.2 0 0 1-.228-1.653"
        },
        []
      ]
    ]
  );
  const SymbolsIcon = createIcon(
    { name: "Symbols", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M13.9 3.918a1.955 1.955 0 0 1 2.765 0l.624.624.624-.624a1.955 1.955 0 1 1 2.764 2.765l-.623.624.005.005-2.764 2.765-.006-.006-.006.006-2.764-2.765.005-.005-.623-.624a1.955 1.955 0 0 1 0-2.765Z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.736 9.091a3.366 3.366 0 1 0 4.76-4.76m-4.76 4.76a3.366 3.366 0 1 1 4.76-4.76m-4.76 4.76 4.76-4.76M2.75 17.289h3.366m0 0H9.48m-3.365 0v-3.366m0 3.366v3.366m7.328-4.237a3.365 3.365 0 0 1 6.165-.812l.189.297m.262-1.98v1.98h-.262m-1.718 0h1.718m-6.47 4.752v-1.98h.267m1.714 0h-1.714m6.35-.515a3.366 3.366 0 0 1-6.165.812l-.185-.297"
        },
        []
      ]
    ]
  );
  const TableSimpleIcon = createIcon(
    { name: "Table Simple", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 9.25h16.5m-16.5 5.5h16.5m-11-11v16.5m5.5-16.5v16.5"
        },
        []
      ]
    ]
  );
  const TableIcon = createIcon(
    { name: "Table", tags: [""], category: "Layout", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "16.5",
          x: "2.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 7.75h18.5M2.75 14h18.5M8.92 7.75v12.5m6.17-12.5v12.5"
        },
        []
      ]
    ]
  );
  const TabletIcon = createIcon(
    { name: "Tablet", tags: ["iPad"], category: "Technology", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "15",
          x: "2.75",
          y: "4.5",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10 16h4"
        },
        []
      ]
    ]
  );
  const TagAccentIcon = createIcon(
    { name: "Tag Accent", tags: ["Label"], category: "Accents", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M20.162 10.925 13.716 4.48a2.5 2.5 0 0 0-1.767-.732h-5.2a3 3 0 0 0-3 3v5.2a2.5 2.5 0 0 0 .731 1.768l6.445 6.446a4 4 0 0 0 5.657 0l3.58-3.58a4 4 0 0 0 0-5.657"
        },
        []
      ]
    ]
  );
  const TagMultipleIcon = createIcon(
    { name: "Tag Multiple", tags: ["Tags"], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m18.828 9.629-5.48-5.492a3.02 3.02 0 0 0-2.196-.886l-4.324.086a2.52 2.52 0 0 0-2.467 2.472l-.086 4.334a3.03 3.03 0 0 0 .884 2.2l5.48 5.493a3.016 3.016 0 0 0 4.273 0l3.916-3.925a3.03 3.03 0 0 0 0-4.282"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4.25 15.714 4.254 4.262a6.03 6.03 0 0 0 8.544 0l3.202-3.209"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.967 5.798a1.15 1.15 0 1 1 .002 2.298 1.15 1.15 0 0 1-.002-2.298"
        },
        []
      ]
    ]
  );
  const TagIcon = createIcon(
    { name: "Tag", tags: ["Label"], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M20.162 10.926 13.716 4.48a2.5 2.5 0 0 0-1.767-.732h-5.2a3 3 0 0 0-3 3v5.2a2.5 2.5 0 0 0 .731 1.768l6.445 6.446a4 4 0 0 0 5.657 0l1.79-1.79 1.79-1.79a4 4 0 0 0 0-5.657"
        },
        []
      ],
      [
        "circle",
        {
          cx: "7.738",
          cy: "7.738",
          r: "1.277",
          fill: "currentColor",
          transform: "rotate(-45 7.738 7.738)"
        },
        []
      ]
    ]
  );
  const TaskListIcon = createIcon(
    { name: "Task List", tags: [""], category: "Organization", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.25 4.5h11m-14-1.446L4.357 5.946 2.75 4.34m7.5 7.66h11m-14-1.446-2.893 2.892L2.75 11.84m7.5 7.66h11m-14-1.446-2.893 2.892L2.75 19.34"
        },
        []
      ]
    ]
  );
  const TerminalIcon = createIcon(
    {
      name: "Terminal",
      tags: ["Cmd", "Command Prompt", "Bash", "Powershell", "Ps"],
      category: "Development",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "15.5",
          x: "2.75",
          y: "4.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.25 9 3 3-3 3m5.5 0h4"
        },
        []
      ]
    ]
  );
  const TextAddIcon = createIcon(
    { name: "Text Add", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m19.25 8.389-.62-1.235A3 3 0 0 0 15.95 5.5h-7.9a3 3 0 0 0-2.68 1.654L4.75 8.39M12 5.5v6"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 1 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const TextAlignCenterIcon = createIcon(
    { name: "Text Align Center", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M5.25 5.25h13.5M2.75 12h18.5M7 18.75h10"
        },
        []
      ]
    ]
  );
  const TextAlignJustifyIcon = createIcon(
    { name: "Text Align Justify", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M2.75 5.25h18.5M2.75 12h18.5m-18.5 6.75h18.5"
        },
        []
      ]
    ]
  );
  const TextAlignLeftIcon = createIcon(
    { name: "Text Align Left", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M2.75 5.25h13.5M2.75 12h18.5m-18.5 6.75h10"
        },
        []
      ]
    ]
  );
  const TextAlignRightIcon = createIcon(
    { name: "Text Align Right", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M7.75 5.25h13.5M2.75 12h18.5m-10 6.75h10"
        },
        []
      ]
    ]
  );
  const TextBoldIcon = createIcon(
    { name: "Text Bold", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "3",
          d: "M7.5 11.776h4.551c1.712 0 3.099-1.405 3.099-3.138S13.763 5.5 12.051 5.5H8.5a1 1 0 0 0-1 1zm0 0h5.625a3.37 3.37 0 0 1 3.375 3.362 3.37 3.37 0 0 1-3.375 3.362H8.5a1 1 0 0 1-1-1z"
        },
        []
      ]
    ]
  );
  const TextBulletListSquareAddIcon = createIcon(
    {
      name: "Text Bullet List Square Add",
      tags: [""],
      category: "Organization",
      deprecated: false
    },
    [
      ["circle", { cx: "7.877", cy: "8.25", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.062 8.25h5.31"
        },
        []
      ],
      ["circle", { cx: "7.877", cy: "12", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.062 12h1.31"
        },
        []
      ],
      ["circle", { cx: "7.877", cy: "15.75", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M20.25 10.25v-2.5a4 4 0 0 0-4-4h-8.5a4 4 0 0 0-4 4v8.5a4 4 0 0 0 4 4h2.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M17.5 23a5.5 5.5 0 1 0 0-11 5.5 5.5 0 0 0 0 11m0-8.993a.5.5 0 0 1 .5.5V17h2.493a.5.5 0 1 1 0 1H18v2.493a.5.5 0 1 1-1 0V18h-2.493a.5.5 0 1 1 0-1H17v-2.493a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const TextBulletListSquareIcon = createIcon(
    {
      name: "Text Bullet List Square",
      tags: [""],
      category: "Organization",
      deprecated: false
    },
    [
      ["circle", { cx: "7.877", cy: "8.25", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.062 8.25h5.31"
        },
        []
      ],
      ["circle", { cx: "7.877", cy: "12", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.062 12h5.31"
        },
        []
      ],
      ["circle", { cx: "7.877", cy: "15.75", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.062 15.75h5.31"
        },
        []
      ],
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ]
    ]
  );
  const TextBulletListIcon = createIcon(
    { name: "Text Bullet List", tags: [""], category: "Organization", deprecated: false },
    [
      ["circle", { cx: "4.443", cy: "5.081", r: "1.331", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.123 5.08h11.765"
        },
        []
      ],
      ["circle", { cx: "4.443", cy: "12", r: "1.331", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.123 12h11.765"
        },
        []
      ],
      ["circle", { cx: "4.443", cy: "18.919", r: "1.331", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.123 18.92h11.765"
        },
        []
      ]
    ]
  );
  const TextCaseLowercaseIcon = createIcon(
    { name: "Text Case Lowercase", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m9.81 12.919-.074-.015c-3.049-.578-6.676-.49-6.676 2.555 0 .854.491 1.658 1.206 2.095.71.434 1.604.446 2.44.446 1.15 0 2.41-.65 2.914-1.662q.146-.29.19-.657v-1.167m0-1.595v-.609c0-.762-.09-1.768-.547-2.384-.497-.67-1.38-1.426-2.828-1.426-2.393 0-3.166 1.654-3.166 1.654M9.81 12.92v1.595m0 3.383v-3.383M13.56 6.5V18m8-4a4 4 0 1 1-8 0 4 4 0 0 1 8 0"
        },
        []
      ]
    ]
  );
  const TextCaseTitleIcon = createIcon(
    { name: "Text Case Title", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m1.88 18 1.83-4.404m0 0h6.59m-6.59 0L6.515 6.85c.193-.465.787-.465.98 0l2.805 6.747m0 0L12.13 18m2.66-11.5V18m7.59-3.795a3.795 3.795 0 1 1-7.59 0 3.795 3.795 0 0 1 7.59 0"
        },
        []
      ]
    ]
  );
  const TextCaseUppercaseIcon = createIcon(
    { name: "Text Case Uppercase", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m1.01 18 1.92-4.404m0 0h6.91m-6.91 0L5.87 6.85a.553.553 0 0 1 1.028 0l2.941 6.747m0 0L11.76 18m3-5.948h4.046a2.765 2.765 0 0 0 2.754-2.776A2.765 2.765 0 0 0 18.806 6.5H14.76zm0 0h5c1.657 0 3 1.331 3 2.974 0 1.642-1.343 2.974-3 2.974h-5z"
        },
        []
      ]
    ]
  );
  const TextClearFormattingIcon = createIcon(
    { name: "Text Clear Formatting", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.77 22.252h6.476m-9.69-7.733 5.925 5.925m-6.195-.808 1.078 1.078c.849.848 1.273 1.272 1.762 1.431.43.14.894.14 1.324 0 .49-.159.913-.583 1.762-1.431l3.502-3.502c.848-.849 1.272-1.273 1.431-1.762.14-.43.14-.894 0-1.324-.159-.49-.583-.913-1.431-1.762l-1.078-1.078c-.849-.848-1.273-1.272-1.762-1.431a2.14 2.14 0 0 0-1.324 0c-.49.159-.913.583-1.762 1.431l-3.502 3.502c-.848.849-1.272 1.273-1.431 1.762-.14.43-.14.894 0 1.324.159.49.583.913 1.431 1.762M2.75 12.427 4.328 8.72m0 0h5.68m-5.68 0 2.417-5.678a.45.45 0 0 1 .845 0l2.418 5.678m0 0 1.137 2.673M14.09 2.75v5.739l.112-.096a3.195 3.195 0 0 1 6.202.158"
        },
        []
      ]
    ]
  );
  const TextCollapseIcon = createIcon(
    { name: "Text Collapse", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.125 4.5h14.5m-14.5 15h14.5m-7.5-10h7.5m-7.5 5h7.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M6.875 16.5a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9m-2-5a.5.5 0 1 0 0 1h4a.5.5 0 0 0 0-1z",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const TextColorAccentIcon = createIcon(
    { name: "Text Color Accent", tags: [""], category: "Accents", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "M4.25 18.397a1.5 1.5 0 0 1 1.5-1.5h12.5a1.5 1.5 0 0 1 1.5 1.5v1.353a1.5 1.5 0 0 1-1.5 1.5H5.75a1.5 1.5 0 0 1-1.5-1.5z"
        },
        []
      ]
    ]
  );
  const TextColorIcon = createIcon(
    { name: "Text Color", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.154 13.088 1.73-3.959m0 0h6.231m-6.23 0 2.652-6.065a.5.5 0 0 1 .926 0l2.652 6.065m0 0 1.731 3.96"
        },
        []
      ],
      [
        "rect",
        {
          width: "15.5",
          height: "4.353",
          x: "4.25",
          y: "16.897",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5"
        },
        []
      ]
    ]
  );
  const TextEditStyleIcon = createIcon(
    {
      name: "Text Edit Style",
      tags: ["Text edit", "Text pencil"],
      category: "Text",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.25 14.25 1.875-4.403m0 0h6.75m-6.75 0 2.873-6.748a.536.536 0 0 1 1.004 0l2.873 6.748m0 0 .575 1.349m.886 9.49a2.5 2.5 0 0 0 1.219-.673l5.454-5.45a2.526 2.526 0 1 0-3.57-3.573l-5.453 5.452c-.335.336-.569.76-.674 1.222l-.536 2.354a1.007 1.007 0 0 0 1.206 1.206z"
        },
        []
      ]
    ]
  );
  const TextEffectsIcon = createIcon(
    { name: "Text Effects", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M14.453 12.928H9.547L12 7.63zM12 2.75a2.5 2.5 0 0 1 2.269 1.45l6.25 13.5a2.5 2.5 0 0 1-4.538 2.1l-1.56-3.372H9.58L8.019 19.8a2.5 2.5 0 0 1-4.538-2.1m5.14-2.772h6.758l1.964 4.242a1 1 0 1 0 1.814-.84l-6.25-13.5a1 1 0 0 0-1.815 0l-6.25 13.5a1 1 0 0 0 1.815.84zM12 2.75A2.5 2.5 0 0 0 9.731 4.2zM9.731 4.2l-6.25 13.5z",
          "clip-rule": "evenodd"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M14.269 4.2a2.5 2.5 0 0 0-4.538 0l-6.25 13.5a2.5 2.5 0 0 0 4.538 2.1l1.56-3.372h4.841l1.561 3.372a2.5 2.5 0 0 0 4.538-2.1zM8.62 14.927h6.758l1.964 4.242a1 1 0 1 0 1.814-.84l-6.25-13.5a1 1 0 0 0-1.815 0l-6.25 13.5a1 1 0 0 0 1.815.84z",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const TextExpandIcon = createIcon(
    { name: "Text Expand", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.125 4.5h14.5m-14.5 15h14.5m-7.5-10h7.5m-7.5 5h7.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M6.875 16.5a4.5 4.5 0 1 0 0-9 4.5 4.5 0 0 0 0 9m0-7a.5.5 0 0 1 .5.5v1.5h1.5a.5.5 0 1 1 0 1h-1.5V14a.5.5 0 1 1-1 0v-1.5h-1.5a.5.5 0 0 1 0-1h1.5V10a.5.5 0 0 1 .5-.5",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const TextFontSizeIcon = createIcon(
    { name: "Text Font Size", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 17.75 1.875-4.404m0 0h6.75m-6.75 0L7.498 6.6a.536.536 0 0 1 1.004 0l2.873 6.747m0 0 1.875 4.404m0-.001 1.429-3.277m0 0h5.142m-5.142 0 2.188-5.022a.412.412 0 0 1 .765 0l2.19 5.022m0 0 1.428 3.277"
        },
        []
      ]
    ]
  );
  const TextFontIcon = createIcon(
    { name: "Text Font", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m20.08 21.25-2.133-4.842m0 0H10.27m7.677 0-3.268-7.42a.617.617 0 0 0-1.142 0l-3.267 7.42m0 0L8.137 21.25m-1.174 0h2.812m8.663 0h2.812M4.423 8.82 2.75 12.584M4.423 8.82h6.021L7.881 3.05a.485.485 0 0 0-.895 0z"
        },
        []
      ]
    ]
  );
  const TextFootnoteIcon = createIcon(
    { name: "Text Footnote", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 17.248 1.44-3.384m0 0h5.188m-5.187 0 2.208-5.186a.412.412 0 0 1 .771 0l2.208 5.186m0 0 1.441 3.384m2.398-8.838v8.838m5.833-2.916a2.916 2.916 0 1 1-5.833 0 2.916 2.916 0 0 1 5.833 0m0-7.707 2.2-1.375v5.5"
        },
        []
      ]
    ]
  );
  const TextHighlightColorAccentIcon = createIcon(
    {
      name: "Text Highlight Color Accent",
      tags: [""],
      category: "Accents",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          "fill-rule": "evenodd",
          d: "M7.75 3.75a4 4 0 0 0-4 4v8.5a4 4 0 0 0 4 4h8.5a4 4 0 0 0 4-4v-8.5a4 4 0 0 0-4-4zm2.986 8.437L12 9.295l1.264 2.892zm-.002 2.5h2.532l.88 2.014a1.75 1.75 0 0 0 3.207-1.402l-3.391-7.757c-.753-1.723-3.171-1.723-3.924 0l-3.391 7.757a1.75 1.75 0 0 0 3.206 1.402zm2.312-6.745 3.391 7.758a.75.75 0 1 1-1.374.6l-1.143-2.613h-3.84L8.937 16.3a.75.75 0 1 1-1.374-.6l3.391-7.758a1.136 1.136 0 0 1 2.092 0",
          "clip-rule": "evenodd"
        },
        []
      ]
    ]
  );
  const TextHighlightColorIcon = createIcon(
    { name: "Text Highlight Color", tags: [""], category: "Text", deprecated: false },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "4"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m8.25 16 1.34-3.063m0 0h4.82m-4.82 0 2.051-4.694a.386.386 0 0 1 .718 0l2.052 4.694m0 0L15.75 16"
        },
        []
      ]
    ]
  );
  const TextIndentDecreaseIcon = createIcon(
    { name: "Text Indent Decrease", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M8 17.502h12M8 6.498h12m-9 5.504h9"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m5.81 9.195-2.807 2.807 2.807 2.807"
        },
        []
      ]
    ]
  );
  const TextIndentIncreaseIcon = createIcon(
    { name: "Text Indent Increase", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M8 17.502h12M8 6.498h12m-9 5.504h9"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4 9.195 2.807 2.807L4 14.809"
        },
        []
      ]
    ]
  );
  const TextItalicIcon = createIcon(
    { name: "Text Italic", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M9.25 4.75h9m-13.5 14.5h9m-4.75 0 5.263-14.5"
        },
        []
      ]
    ]
  );
  const TextLargeIcon = createIcon(
    { name: "Text Large", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m5.5 19.207 2.321-5.325m0 0h8.358m-8.358 0 3.558-8.16a.669.669 0 0 1 1.242 0l3.558 8.16m0 0 2.321 5.325"
        },
        []
      ]
    ]
  );
  const TextLetterSpacingIcon = createIcon(
    { name: "Text Letter Spacing", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m7.6 16.937 1.571-3.781m0 0h5.658m-5.658 0 2.408-5.793c.166-.4.676-.4.842 0l2.408 5.793m0 0 1.571 3.78"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M21.25 20.25V3.75m-18.5 16.5V3.75"
        },
        []
      ]
    ]
  );
  const TextLineHeightIcon = createIcon(
    { name: "Text Line Height", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 18.345 1.992 2.037c.235.24.547.361.858.361m2.85-2.398-1.992 2.037c-.235.24-.547.361-.858.361M2.75 5.61l2.002-2.002c.234-.234.54-.351.848-.351M8.45 5.61l-2-2.002a1.2 1.2 0 0 0-.849-.351m0 17.486V3.257"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.55 4.25h9.7m-9.7 15.5h9.7"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m13.12 15.594 1.171-2.752m0 0h4.219m-4.219 0 1.796-4.218a.335.335 0 0 1 .627 0l1.796 4.217m0 0 1.172 2.753"
        },
        []
      ]
    ]
  );
  const TextLineSpacingIcon = createIcon(
    { name: "Text Line Spacing", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.75 18.345 1.992 2.037c.235.24.547.361.858.361m2.85-2.398-1.992 2.037c-.235.24-.547.361-.858.361M2.75 5.61l2.002-2.002c.234-.234.54-.351.848-.351M8.45 5.61l-2-2.002a1.2 1.2 0 0 0-.849-.351m0 0v17.486"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M11.55 4.25h9.7m-9.7 5.17h9.7m-9.7 5.17h9.7m-9.7 5.17h6.7"
        },
        []
      ]
    ]
  );
  const TextNumberListIcon = createIcon(
    { name: "Text Number List", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M9.75 5.247h10M9.75 12h10m-10 6.753h10M3.694 4.123 5.494 3v4.493m-2.223 3.582A1.32 1.32 0 0 1 4.465 9.76a1.325 1.325 0 0 1 1.428 1.057 1.32 1.32 0 0 1-.363 1.192l-1.994 1.973v.265H5.86m-2.265 2.26h2.344l-2.103 1.927h1.037c.589 0 1.066.477 1.066 1.065s-.172 1.242-1.241 1.483c-.587.132-1.448-.482-1.448-.964"
        },
        []
      ]
    ]
  );
  const TextPositionBottomIcon = createIcon(
    { name: "Text Position Bottom", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 2.75v13.379m-6.287-5.666 5.226 5.226c.293.293.677.44 1.061.44m6.287-5.666-5.226 5.226c-.293.293-.677.44-1.061.44M2.75 21.25h18.5"
        },
        []
      ]
    ]
  );
  const TextPositionMiddleIcon = createIcon(
    { name: "Text Position Middle", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 2.75v6.086M9.081 6.33l2.212 2.212a1 1 0 0 0 .707.293m2.919-2.505-2.212 2.212a1 1 0 0 1-.707.293m0 12.415v-6.086M9.081 17.67l2.212-2.212a1 1 0 0 1 .707-.293m2.919 2.505-2.212-2.212a1 1 0 0 0-.707-.293M2.75 12h18.5"
        },
        []
      ]
    ]
  );
  const TextPositionTopIcon = createIcon(
    { name: "Text Position Top", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 21.25V7.871m-6.287 5.666 5.226-5.226c.293-.293.677-.44 1.061-.44m6.287 5.666-5.226-5.226A1.5 1.5 0 0 0 12 7.87M2.75 2.75h18.5"
        },
        []
      ]
    ]
  );
  const TextSmallIcon = createIcon(
    { name: "Text Small", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m6.5 18.138 1.964-4.507m0 0h7.072m-7.072 0 3.01-6.904a.566.566 0 0 1 1.052 0l3.01 6.905m0 0 1.964 4.506"
        },
        []
      ]
    ]
  );
  const TextStrikethroughIcon = createIcon(
    { name: "Text Strikethrough", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-width": "1.5",
          d: "M17.059 8.113s-.71-3.363-5.861-3.363c-1.923 0-4.42 1.601-4.42 3.838 0 .493.087.92.259 1.292q.194.418.526.75m-.526 6.365S8.382 20 12.364 20c2.217 0 4.859-1.078 4.859-3.544 0-1.571-.918-2.63-2.408-3.331m-10.065 0h10.065m4.435 0h-4.435"
        },
        []
      ]
    ]
  );
  const TextSubscriptIcon = createIcon(
    { name: "Text Subscript", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m3.5 19.25 12-14.5m-12 0 8.586 10.375 2.04 2.465m2.051-1.928a1.912 1.912 0 1 1 3.263 1.352l-2.881 2.854v.382h3.359"
        },
        []
      ]
    ]
  );
  const TextSuperscriptIcon = createIcon(
    { name: "Text Superscript", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m4 4.75 12 14.5m-12 0L14.626 6.41m2.051-1.748a1.912 1.912 0 1 1 3.263 1.352l-2.88 2.854v.382h3.359"
        },
        []
      ]
    ]
  );
  const TextTypographyIcon = createIcon(
    { name: "Text Typography", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m2.25 18.25 1.875-4.404m0 0h6.75m-6.75 0L6.998 7.1a.536.536 0 0 1 1.004 0l2.873 6.747m0 0 1.875 4.404m9-4.948-.07-.014c-2.88-.557-6.308-.472-6.308 2.462 0 .824.464 1.598 1.14 2.02.67.417 1.515.429 2.305.429 1.086 0 2.277-.626 2.754-1.602q.137-.279.179-.633V14.84m0-1.537v-.587c0-.734-.085-1.704-.517-2.297-.47-.646-1.303-1.375-2.672-1.375-2.261 0-2.991 1.595-2.991 1.595m6.18 2.664v1.537m0 3.26v-3.26"
        },
        []
      ]
    ]
  );
  const TextUnderlineIcon = createIcon(
    { name: "Text Underline", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M6.5 4.75v6.5a5.5 5.5 0 0 0 5.5 5.5v0a5.5 5.5 0 0 0 5.5-5.5v-6.5m-11 15h11"
        },
        []
      ]
    ]
  );
  const TextIcon = createIcon(
    { name: "Text", tags: [""], category: "Text", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m19.25 8.389-.62-1.235A3 3 0 0 0 15.95 5.5h-7.9a3 3 0 0 0-2.68 1.654L4.75 8.39M12 5.5v13m0 0h-1.45m1.45 0h1.45"
        },
        []
      ]
    ]
  );
  const ThumbsDownIcon = createIcon(
    { name: "Thumbs Down", tags: ["Dislike"], category: "Gestures", deprecated: false },
    [
      [
        "rect",
        {
          width: "4.2",
          height: "13.296",
          x: "21.25",
          y: "16.799",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5",
          transform: "rotate(180 21.25 16.8)"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M17.05 11.447h.75a.75.75 0 0 0-.75-.75zm0 3.028.627.412a.75.75 0 0 0 .123-.412zm0-3.028h-.75c0 .415.336.75.75.75zm-12.285-6.1.723.196zm-1.958 7.187.723.197zm6.507 3.157h.75a.75.75 0 0 0-.75-.75zM13.02 20.6l-.626-.412zm3.28-9.152v3.028h1.5v-3.028zm.75.75v-1.5zm-.75-5.694v4.944h1.5V6.503zm-2.25-2.25a2.25 2.25 0 0 1 2.25 2.25h1.5a3.75 3.75 0 0 0-3.75-3.75zm-6.873 0h6.873v-1.5H7.177zm-1.689 1.29a1.75 1.75 0 0 1 1.689-1.29v-1.5A3.25 3.25 0 0 0 4.04 5.15zM3.53 12.731l1.958-7.188-1.447-.394-1.958 7.188zm1.689 2.21a1.75 1.75 0 0 1-1.689-2.21l-1.447-.394a3.25 3.25 0 0 0 3.136 4.104zm4.095 0H5.219v1.5h4.095zm.75 1.972V15.69h-1.5v1.222zm0 0h-1.5zm0 2.587v-2.587h-1.5V19.5zm1.25 1.25c-.69 0-1.25-.56-1.25-1.25h-1.5a2.75 2.75 0 0 0 2.75 2.75zm.036 0h-.036v1.5h.036zm1.044-.563a1.25 1.25 0 0 1-1.044.563v1.5a2.75 2.75 0 0 0 2.297-1.238zm4.03-6.125-4.03 6.125 1.253.825 4.03-6.125z"
        },
        []
      ]
    ]
  );
  const ThumbsUpIcon = createIcon(
    { name: "Thumbs Up", tags: ["Like"], category: "Gestures", deprecated: false },
    [
      [
        "rect",
        {
          width: "4.2",
          height: "13.296",
          x: "3.25",
          y: "7.201",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "1.5"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M7.45 12.553H6.7c0 .414.336.75.75.75zm0-3.027-.627-.413a.75.75 0 0 0-.123.413zm0 3.027h.75a.75.75 0 0 0-.75-.75zm12.285 6.1-.723-.196zm1.958-7.187-.723-.197zm-6.507-3.157h-.75c0 .414.336.75.75.75zM11.48 3.4l.626.412zM8.2 12.553V9.526H6.7v3.027zm-.75-.75v1.5zm.75 5.694v-4.944H6.7v4.944zm2.25 2.25a2.25 2.25 0 0 1-2.25-2.25H6.7a3.75 3.75 0 0 0 3.75 3.75zm6.873 0H10.45v1.5h6.873zm1.689-1.29a1.75 1.75 0 0 1-1.689 1.29v1.5a3.25 3.25 0 0 0 3.136-2.396zm1.958-7.188-1.958 7.188 1.447.394 1.958-7.188zm-1.689-2.21a1.75 1.75 0 0 1 1.689 2.21l1.447.394a3.25 3.25 0 0 0-3.136-4.104zm-4.095 0h4.095v-1.5h-4.095zm-.75-1.972V8.31h1.5V7.087zm0 0h1.5zm0-2.587v2.587h1.5V4.5zm-1.25-1.25c.69 0 1.25.56 1.25 1.25h1.5a2.75 2.75 0 0 0-2.75-2.75zm-.036 0h.036v-1.5h-.036zm-1.044.563a1.25 1.25 0 0 1 1.044-.563v-1.5a2.75 2.75 0 0 0-2.297 1.238zm-4.03 6.125 4.03-6.125-1.253-.825-4.03 6.125z"
        },
        []
      ]
    ]
  );
  const TiktokIcon = createIcon(
    {
      name: "TikTok",
      tags: ["ByteDance", "Now", "Shorts", "Social", "Videos"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          fill: "currentColor",
          d: "m17.139 9.891-.287.693zM15.8 15.5h-.75zm-1.011 3.333-.624-.416zm-2.693 2.21-.287-.693zm-3.467.342.147-.736zm-3.072-1.642.53-.53zM3.915 16.67l.736-.147zm.342-3.467.693.287zm2.21-2.693-.417-.623zm2 2.994-.417-.624zm-.884 1.077.693.287zm-.137 1.386-.735.146zm.657 1.23-.53.53zm2.615.52.287.692zm1.078-.885.623.417zM12.2 15.5h-.75zm3.935-11.316.693-.287zm2.381 2.381-.287.693zm1.285.317.068-.747zm0 3.608.037-.75zM9.4 13.133l-.124-.74zm6.399-3.21h-.75zM12.2 2.9h.75zm3.618 0-.747.068zM9.4 9.512l-.05-.748zm7.452 1.07a8.8 8.8 0 0 0 2.91.656l.076-1.498a7.3 7.3 0 0 1-2.413-.543zm-.767-.36q.374.199.767.36l.573-1.385a7 7 0 0 1-.634-.3zm-1.035-.3V15.5h1.5V9.924zm.362 9.327a6.75 6.75 0 0 0 1.138-3.75h-1.5a5.25 5.25 0 0 1-.885 2.917zm-3.029 2.486a6.75 6.75 0 0 0 3.03-2.486l-1.248-.833a5.25 5.25 0 0 1-2.356 1.933zm-3.9.384a6.75 6.75 0 0 0 3.9-.384l-.574-1.386a5.25 5.25 0 0 1-3.033.3zm-3.456-1.847a6.75 6.75 0 0 0 3.456 1.847l.293-1.47a5.25 5.25 0 0 1-2.688-1.438zM3.18 16.817a6.75 6.75 0 0 0 1.847 3.456l1.06-1.06a5.25 5.25 0 0 1-1.436-2.689zm.384-3.9a6.75 6.75 0 0 0-.384 3.9l1.47-.293a5.25 5.25 0 0 1 .3-3.033zm2.486-3.03a6.75 6.75 0 0 0-2.486 3.03l1.386.574a5.25 5.25 0 0 1 1.933-2.356zm3.3-1.122a6.75 6.75 0 0 0-3.3 1.123l.833 1.247a5.25 5.25 0 0 1 2.567-.873zm1.2 3.935V9.9h-1.5v2.8zm-1.667 1.428a1.65 1.65 0 0 1 .643-.255l-.249-1.48a3.15 3.15 0 0 0-1.227.488zm-.607.74a1.65 1.65 0 0 1 .607-.74l-.833-1.247a3.15 3.15 0 0 0-1.16 1.413zm-.094.954a1.65 1.65 0 0 1 .094-.953l-1.386-.575a3.15 3.15 0 0 0-.18 1.82zm.451.845a1.65 1.65 0 0 1-.451-.845l-1.471.293a3.15 3.15 0 0 0 .862 1.612zm.845.451a1.65 1.65 0 0 1-.845-.451l-1.06 1.06c.44.44 1.001.74 1.612.863zm.953-.094a1.65 1.65 0 0 1-.953.094l-.293 1.472a3.15 3.15 0 0 0 1.82-.18zm.74-.607a1.65 1.65 0 0 1-.74.607l.574 1.386a3.15 3.15 0 0 0 1.414-1.16zm.279-.917c0 .326-.097.645-.278.917l1.247.833a3.15 3.15 0 0 0 .531-1.75zm1.5 0V2.9h-1.5v12.6zM12.6 3.25h2.8v-1.5h-2.8zm4.228.647a3.7 3.7 0 0 1-.263-1.066l-1.494.137c.047.516.172 1.022.371 1.503zm.791 1.184a3.7 3.7 0 0 1-.791-1.184l-1.386.574a5.2 5.2 0 0 0 1.116 1.67zm1.184.791a3.7 3.7 0 0 1-1.184-.791l-1.06 1.06a5.2 5.2 0 0 0 1.67 1.117zm1.066.263a3.7 3.7 0 0 1-1.066-.263l-.574 1.386c.48.199.987.324 1.503.37zM20.95 10.1V7.3h-1.5v2.8zm-1.218-2.471a.32.32 0 0 1-.282-.329h1.5c0-.65-.518-1.114-1.081-1.165zm.03 3.61A1.135 1.135 0 0 0 20.95 10.1h-1.5c0-.183.155-.37.388-.36zM9.05 12.7c0-.102.044-.183.089-.23a.25.25 0 0 1 .138-.076l.25 1.479c.501-.085 1.023-.513 1.023-1.173zm7.74-3.802c-.729-.388-1.74.084-1.74 1.026h1.5c0 .143-.086.25-.17.297a.31.31 0 0 1-.295.001zM12.95 2.9a.35.35 0 0 1-.35.35v-1.5a1.15 1.15 0 0 0-1.15 1.15zm2.45.35a.32.32 0 0 1-.329-.282l1.494-.137c-.051-.563-.514-1.081-1.165-1.081zm-5.95 7.012a.37.37 0 0 1-.4-.362h1.5c0-.62-.513-1.18-1.2-1.135z"
        },
        []
      ]
    ]
  );
  const TimerIcon = createIcon(
    { name: "Timer", tags: ["Stopwatch"], category: "Objects", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.022 8.862A7.716 7.716 0 1 0 5.74 18.206a7.716 7.716 0 0 0 12.282-9.344m0 0 1.813-1.813M9.28 2.75h5.2m-2.6 7.215v3.57"
        },
        []
      ]
    ]
  );
  const ToolboxIcon = createIcon(
    {
      name: "Toolbox",
      tags: ["Suitcase", "Work"],
      category: "Business",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 10a3 3 0 0 1 3-3h12.5a3 3 0 0 1 3 3v7.5a3 3 0 0 1-3 3H5.75a3 3 0 0 1-3-3zM8 5.5a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2V7H8zm.5 5.5v3m7-3v3M2.75 12.5h18.5"
        },
        []
      ]
    ]
  );
  const TriangleIcon = createIcon(
    { name: "Triangle", tags: [""], category: "Shapes", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M5.732 20.5c-2.29 0-3.723-2.498-2.581-4.5L9.419 5.006c1.144-2.008 4.018-2.008 5.163 0L20.849 16c1.142 2.002-.291 4.5-2.581 4.5z"
        },
        []
      ]
    ]
  );
  const TuneIcon = createIcon(
    {
      name: "Tune",
      tags: ["Customize", "Sliders", "Controls", "Settings", "Options", "Customise"],
      category: "Actions",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 12h10.5m0 0a2.5 2.5 0 0 0 5 0m-5 0a2.5 2.5 0 0 1 5 0m0 0h3M7.75 5.25h13.5m-13.5 0a2.5 2.5 0 1 1-5 0 2.5 2.5 0 0 1 5 0m-5 13.5h3m0 0a2.5 2.5 0 0 0 5 0m-5 0a2.5 2.5 0 0 1 5 0m0 0h10.5"
        },
        []
      ]
    ]
  );
  const TvIcon = createIcon(
    { name: "TV", tags: ["Television"], category: "Technology", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "13",
          x: "2.75",
          y: "4",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7 20h10"
        },
        []
      ]
    ]
  );
  const TypescriptIcon = createIcon(
    {
      name: "TypeScript",
      tags: ["Programming", "Web", "TS", "Microsoft"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "rect",
        {
          width: "16.5",
          height: "16.5",
          x: "3.75",
          y: "3.75",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "2"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M17.25 11.25h-2a1 1 0 0 0-1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1h-2m-4.75-6v6m-2-6h4"
        },
        []
      ]
    ]
  );
  const UbuntuIcon = createIcon(
    {
      name: "Ubuntu",
      tags: ["Canonical", "Linux", "Mark Shuttleworth", "Open Source"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "circle",
        {
          cx: "12.75",
          cy: "12",
          r: "4.75",
          stroke: "currentColor",
          "stroke-width": "1.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M14.546 20.054a8.254 8.254 0 0 1-9.67-5.582m13.95 3.109A8.22 8.22 0 0 0 21 12a8.22 8.22 0 0 0-2.174-5.582m-4.28-2.473a8.254 8.254 0 0 0-9.67 5.582"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M15.625 16.98a2.5 2.5 0 1 1 2.5 4.33 2.5 2.5 0 0 1-2.5-4.33ZM4.5 9.5a2.5 2.5 0 1 1 0 5 2.5 2.5 0 0 1 0-5Zm11.125-6.81a2.5 2.5 0 1 1 2.5 4.33 2.5 2.5 0 0 1-2.5-4.33Z"
        },
        []
      ]
    ]
  );
  const VehicleCarIcon = createIcon(
    {
      name: "Vehicle Car",
      tags: [""],
      category: "Places & Transportation",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 11.75a2 2 0 0 1 2-2h12.5a2 2 0 0 1 2 2v6H3.75z"
        },
        []
      ],
      ["circle", { cx: "7", cy: "13", r: "1", fill: "currentColor" }, []],
      ["circle", { cx: "17", cy: "13", r: "1", fill: "currentColor" }, []],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10 14.75h4M6.271 5.567a2 2 0 0 1 1.88-1.317h7.698a2 2 0 0 1 1.88 1.317L19.25 9.75H4.75zM3.75 17.75h3.438v1.7a1.3 1.3 0 0 1-1.3 1.3H5.05a1.3 1.3 0 0 1-1.3-1.3zm13.063 0h3.437v1.7a1.3 1.3 0 0 1-1.3 1.3h-.837a1.3 1.3 0 0 1-1.3-1.3z"
        },
        []
      ]
    ]
  );
  const VideoClipIcon = createIcon(
    { name: "Video Clip", tags: [""], category: "Development", deprecated: false },
    [
      [
        "rect",
        {
          width: "18.5",
          height: "15.5",
          x: "2.75",
          y: "4.25",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-width": "1.5",
          d: "M8.83 13.29c0 1.098 0 1.646.23 1.964.201.277.51.456.85.492.391.041.867-.232 1.818-.779l2.244-1.29c.956-.55 1.435-.825 1.595-1.185a1.2 1.2 0 0 0 0-.984c-.16-.36-.639-.635-1.595-1.184l-2.244-1.291c-.951-.547-1.427-.82-1.817-.779-.34.036-.65.215-.85.492-.231.318-.231.866-.231 1.963z"
        },
        []
      ]
    ]
  );
  const VideoIcon = createIcon(
    { name: "Video", tags: [""], category: "Activities", deprecated: false },
    [
      [
        "rect",
        {
          width: "13.5",
          height: "12",
          x: "2.75",
          y: "6",
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          rx: "3.5"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16.25 9.74 3.554-1.77a1 1 0 0 1 1.446.895v6.268a1 1 0 0 1-1.447.895l-3.553-1.773z"
        },
        []
      ]
    ]
  );
  const VisualStudioCodeIcon = createIcon(
    {
      name: "Visual Studio Code",
      tags: ["VSCode", "VS Code", "IDE", "Text Editor", "Microsoft"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.695 16.318 10.333 12m5.362 4.318V7.682m0 8.636v2.18c0 .68-.27 1.332-.75 1.813M10.332 12l5.362-4.318M10.333 12 7.828 9.983m7.867-2.3v-2.18c0-.68-.27-1.333-.75-1.814M7.827 14.017l-3.516 2.831a.61.61 0 0 1-.813-.044l-1.071-1.076a.61.61 0 0 1 .022-.881L5.598 12m2.23 2.017 6.456 5.84q.304.273.66.454m-7.116-6.294L5.598 12m0 0L2.45 9.153a.61.61 0 0 1-.022-.881l1.071-1.076c.22-.22.57-.24.813-.044l3.516 2.83m0 0 6.456-5.839q.304-.273.66-.454m0 16.622a3.04 3.04 0 0 0 2.517.113l2.334-.937c.577-.232.955-.791.955-1.413V5.926c0-.622-.378-1.181-.955-1.413l-2.334-.937a3.04 3.04 0 0 0-2.517.113"
        },
        []
      ]
    ]
  );
  const Volume0Icon = createIcon(
    { name: "Volume 0", tags: [""], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.253 19.4 7.99 15.782a1 1 0 0 0-.647-.238H4.75a2 2 0 0 1-2-2v-3.086a2 2 0 0 1 2-2h2.594a1 1 0 0 0 .647-.238l4.262-3.62a1 1 0 0 1 1.647.762V18.64a1 1 0 0 1-1.647.762Z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.664 8.542c.48.35.88.854 1.158 1.462.277.607.424 1.295.424 1.996 0 .7-.147 1.39-.424 1.996-.278.607-.677 1.112-1.158 1.462M18.7 6.424c.775.565 1.42 1.378 1.867 2.357.447.978.683 2.089.683 3.219s-.236 2.24-.683 3.22c-.448.978-1.092 1.791-1.867 2.356"
        },
        []
      ]
    ]
  );
  const Volume1Icon = createIcon(
    { name: "Volume 1", tags: [""], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.253 19.4 7.99 15.782a1 1 0 0 0-.647-.238H4.75a2 2 0 0 1-2-2v-3.086a2 2 0 0 1 2-2h2.594a1 1 0 0 0 .647-.238l4.262-3.62a1 1 0 0 1 1.647.762V18.64a1 1 0 0 1-1.647.762Z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.664 8.542c.48.35.88.854 1.158 1.462.277.607.423 1.295.423 1.996 0 .7-.146 1.39-.423 1.996-.278.607-.677 1.112-1.158 1.462"
        },
        []
      ]
    ]
  );
  const VolumeMuteIcon = createIcon(
    { name: "Volume Mute", tags: [""], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.253 19.4 7.99 15.782a1 1 0 0 0-.647-.238H4.75a2 2 0 0 1-2-2v-3.086a2 2 0 0 1 2-2h2.594a1 1 0 0 0 .647-.238l4.262-3.62a1 1 0 0 1 1.647.762V18.64a1 1 0 0 1-1.647.762Z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m16.53 9.64 4.72 4.72m0-4.72-4.72 4.72"
        },
        []
      ]
    ]
  );
  const VolumeIcon = createIcon(
    { name: "Volume", tags: [""], category: "Media", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.253 19.4 7.99 15.782a1 1 0 0 0-.647-.238H4.75a2 2 0 0 1-2-2v-3.086a2 2 0 0 1 2-2h2.594a1 1 0 0 0 .647-.238l4.262-3.62a1 1 0 0 1 1.647.762V18.64a1 1 0 0 1-1.647.762Z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M16.664 8.542c.48.35.88.854 1.158 1.462.277.607.424 1.295.424 1.996 0 .7-.147 1.39-.424 1.996-.278.607-.677 1.112-1.158 1.462M18.7 6.424c.775.565 1.42 1.378 1.867 2.357.447.978.683 2.089.683 3.219s-.236 2.24-.683 3.22c-.448.978-1.092 1.791-1.867 2.356"
        },
        []
      ]
    ]
  );
  const VuejsIcon = createIcon(
    {
      name: "VueJS",
      tags: ["JavaScript", "Framework", "Open Source", "Evan You"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.701 4.57h3.161c.384 0 .739.202.936.531L12 8.791l2.203-3.69a1.09 1.09 0 0 1 .935-.531h3.16m-12.597 0h-1.86a1.09 1.09 0 0 0-.935 1.648l8.158 13.671a1.09 1.09 0 0 0 1.872 0l8.158-13.671a1.09 1.09 0 0 0-.935-1.648h-1.86M5.7 4.57 12 15.124 18.299 4.57"
        },
        []
      ]
    ]
  );
  const WatchIcon = createIcon(
    {
      name: "Watch",
      tags: [
        "Apple Watch",
        "Watch",
        "Samsung Galaxy",
        "Clock",
        "Time",
        "Smartwatch",
        "Tracker"
      ],
      category: "Technology",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M18.314 12a6.3 6.3 0 0 0-2.623-5.123v-2.92c0-.805-.652-1.457-1.457-1.457H9.766c-.805 0-1.457.652-1.457 1.457v2.92A6.3 6.3 0 0 0 5.686 12m12.628 0a6.3 6.3 0 0 1-2.623 5.123v2.92c0 .805-.652 1.457-1.457 1.457H9.766a1.457 1.457 0 0 1-1.457-1.457v-2.92A6.3 6.3 0 0 1 5.686 12m12.628 0a6.314 6.314 0 1 1-12.628 0m12.628 0a6.314 6.314 0 1 0-12.628 0"
        },
        []
      ]
    ]
  );
  const WeatherCloudyIcon = createIcon(
    { name: "Weather Cloudy", tags: [""], category: "Weather", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.465 13.796a3.43 3.43 0 0 1-.715-2.101 3.457 3.457 0 0 1 3.114-3.437.31.31 0 0 0 .276-.305A3.46 3.46 0 0 1 9.603 4.5c.88 0 1.682.327 2.293.866m4.665 6.083a3.46 3.46 0 0 0-3.493-3.453 3.46 3.46 0 0 0-3.432 3.453c0 .157-.12.29-.276.305a3.46 3.46 0 0 0-3.114 3.437 3.46 3.46 0 0 0 3.462 3.453h8.08a3.46 3.46 0 0 0 3.462-3.453 3.46 3.46 0 0 0-3.462-3.454h-.95a.283.283 0 0 1-.277-.288"
        },
        []
      ]
    ]
  );
  const WebpackIcon = createIcon(
    {
      name: "Webpack",
      tags: ["Module Bundler", "JavaScript"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12 12 7.435 9.364M12 12l4.565-2.636M12 12v5.272m-8.01-.647c.178.31.437.573.757.757l6.218 3.59c.32.186.678.278 1.035.278m-8.01-4.625a2.07 2.07 0 0 1-.278-1.035V8.41c0-.37.099-.726.277-1.035m0 9.25 3.446-1.99M12 21.25a2.07 2.07 0 0 0 1.035-.277l6.218-3.59c.32-.185.58-.449.758-.758M12 21.25v-3.978m8.01-.647-3.306-1.91-.136-.083m3.443 1.993c.178-.31.277-.665.277-1.035V8.41c0-.37-.099-.726-.277-1.035m0 0a2.07 2.07 0 0 0-.758-.757l-6.218-3.59A2.07 2.07 0 0 0 12 2.75m8.01 4.625-3.445 1.99M12 2.75a2.07 2.07 0 0 0-1.035.277l-6.218 3.59c-.32.185-.58.449-.758.758M12 2.75v3.978m-8.01.647 3.445 1.99m0 0c-.09.154-.139.332-.139.516v4.237c0 .185.05.363.139.518m0-5.272c.089-.155.218-.286.378-.379l3.67-2.118c.16-.092.338-.139.517-.139m4.565 2.636a1.03 1.03 0 0 0-.378-.379l-3.67-2.118A1.03 1.03 0 0 0 12 6.728m4.565 2.636c.09.155.139.333.139.517v4.237c0 .184-.049.36-.136.514m0 0c-.09.156-.22.29-.381.383l-3.67 2.118c-.16.092-.338.139-.517.139m-4.565-2.636c.089.155.218.286.378.379l3.67 2.118c.16.092.338.139.517.139"
        },
        []
      ]
    ]
  );
  const WiFiIcon = createIcon(
    {
      name: "Wi-Fi",
      tags: ["Internet"],
      category: "Communication & Cloud",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 8.988A12.068 12.068 0 0 1 21.25 9"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M5.64 11.964a8.297 8.297 0 0 1 12.72.01m-9.805 3.029a4.495 4.495 0 0 1 6.89.005"
        },
        []
      ],
      ["circle", { cx: "12", cy: "17.878", r: "1.445", fill: "currentColor" }, []]
    ]
  );
  const WindowMultipleIcon = createIcon(
    { name: "Window Multiple", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.75 6.25a3.5 3.5 0 0 1 3.5-3.5h8.5a3.5 3.5 0 0 1 3.5 3.5v8.5a3.5 3.5 0 0 1-3.5 3.5h-8.5a3.5 3.5 0 0 1-3.5-3.5z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M21.25 6.75v8a6.5 6.5 0 0 1-6.5 6.5h-8m-4-14.273h15.5"
        },
        []
      ]
    ]
  );
  const WindowIcon = createIcon(
    { name: "Window", tags: [""], category: "Window", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M3.75 7.75a4 4 0 0 1 4-4h8.5a4 4 0 0 1 4 4v8.5a4 4 0 0 1-4 4h-8.5a4 4 0 0 1-4-4zm0 .5h16.5"
        },
        []
      ]
    ]
  );
  const WrenchIcon = createIcon(
    {
      name: "Wrench",
      tags: ["Configure", "Spanner", "Options", "Mechanism", "Mechanic"],
      category: "Objects",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M10.691 4.562a6.19 6.19 0 0 1 6.545-1.42c.378.141.45.62.165.906l-2.787 2.787a1.037 1.037 0 0 0 0 1.467l1.084 1.084a1.037 1.037 0 0 0 1.467 0L19.953 6.6c.285-.285.764-.212.905.165a6.187 6.187 0 0 1-7.696 8.058c-.396-.128-.84-.054-1.134.24L6.481 20.61a2.186 2.186 0 1 1-3.09-3.09l5.547-5.548c.294-.294.368-.738.24-1.134a6.19 6.19 0 0 1 1.513-6.276Z"
        },
        []
      ]
    ]
  );
  const XTwitterIcon = createIcon(
    {
      name: "X (Twitter)",
      tags: [
        "Twitter",
        "X/Twitter",
        "X Corp.",
        "Elon Musk",
        "Bird",
        "Tweet",
        "Post",
        "Social Media"
      ],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m13.081 10.712-4.786-6.71a.6.6 0 0 0-.489-.252H5.28a.6.6 0 0 0-.488.948l6.127 8.59m2.162-2.576 6.127 8.59a.6.6 0 0 1-.488.948h-2.526a.6.6 0 0 1-.489-.252l-4.786-6.71m2.162-2.576 5.842-6.962m-8.004 9.538L5.077 20.25"
        },
        []
      ]
    ]
  );
  const YoutubeShortsIcon = createIcon(
    {
      name: "YouTube Shorts",
      tags: ["YT Shorts", "Watch", "YouTube", "Vertical", "TikTok"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M12.834 3.186a3.627 3.627 0 0 1 3.627 6.282l-.74.426a3.626 3.626 0 0 1 1.935 6.766l-7.02 4.053a3.626 3.626 0 1 1-3.627-6.28l.739-.428A3.627 3.627 0 0 1 5.814 7.24z"
        },
        []
      ],
      [
        "path",
        {
          fill: "currentColor",
          d: "M13.992 11.016 11.2 9.271c-.74-.463-1.7.07-1.7.942v3.49c0 .873.96 1.405 1.7.943l2.792-1.746a1.11 1.11 0 0 0 0-1.884"
        },
        []
      ]
    ]
  );
  const YoutubeIcon = createIcon(
    {
      name: "YouTube",
      tags: ["Social", "Shorts", "Watch", "Videos"],
      category: "Logos & Brands",
      deprecated: false
    },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M2.45 11.419c0-3.017.3-4.526 1.237-5.463s2.446-.937 5.463-.937h5.7c3.017 0 4.525 0 5.463.937s1.237 2.446 1.237 5.463v1.162c0 3.017-.3 4.526-1.237 5.463s-2.446.937-5.463.937h-5.7c-3.017 0-4.526 0-5.463-.937S2.45 15.598 2.45 12.581z"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "m14.686 11.491-4.268-2.667a.6.6 0 0 0-.918.509v5.335a.6.6 0 0 0 .918.508l4.268-2.667a.6.6 0 0 0 0-1.018Z"
        },
        []
      ]
    ]
  );
  const ZoomInIcon = createIcon(
    { name: "Zoom In", tags: [""], category: "System & Interface", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.56 10.56h6m-3 3v-6m4.993 7.993a7.06 7.06 0 1 0-9.985-9.985 7.06 7.06 0 0 0 9.985 9.985m0 0L20 20"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.553 5.568a7.06 7.06 0 1 1-9.985 9.985 7.06 7.06 0 0 1 9.985-9.985"
        },
        []
      ]
    ]
  );
  const ZoomOutIcon = createIcon(
    { name: "Zoom Out", tags: [""], category: "System & Interface", deprecated: false },
    [
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M7.56 10.56h6m1.993 4.993a7.06 7.06 0 1 0-9.985-9.985 7.06 7.06 0 0 0 9.985 9.985m0 0L20 20"
        },
        []
      ],
      [
        "path",
        {
          stroke: "currentColor",
          "stroke-linecap": "round",
          "stroke-linejoin": "round",
          "stroke-width": "1.5",
          d: "M15.553 5.568a7.06 7.06 0 1 1-9.985 9.985 7.06 7.06 0 0 1 9.985-9.985"
        },
        []
      ]
    ]
  );
  const icons = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    AccessibilityIcon,
    AddCircularIcon,
    AddIcon,
    AddRhombusIcon,
    AddSquareIcon,
    AddSquareMultipleIcon,
    AddSquareMultipleVarIcon: AddSquareMultipleIcon,
    AdditionIcon: AddIcon,
    AirplaneIcon,
    AirplaneLandingIcon,
    AirplaneTakeoffIcon,
    AlertCircleIcon,
    AlertTriangleIcon,
    AlignBottomIcon,
    AlignHorizontalCentersIcon,
    AlignLeftIcon,
    AlignRightIcon,
    AlignTopIcon,
    AlignVerticalCentersIcon,
    AmazonIcon,
    AnchorIcon,
    AndroidIcon,
    AngleIcon,
    AppRemoveIcon,
    AppStoreIcon,
    AppleIcon,
    AppsAddIcon,
    AppsIcon,
    AppsListIcon,
    ArcIcon,
    ArchiveAdd2Icon,
    ArchiveIcon,
    ArrowClockwiseIcon,
    ArrowCounterclockwiseIcon,
    ArrowDownIcon,
    ArrowDownloadIcon,
    ArrowEnterIcon,
    ArrowExportIcon,
    ArrowFowardIcon,
    ArrowImportIcon,
    ArrowLeftIcon,
    ArrowLeftRightIcon,
    ArrowMaximizeIcon,
    ArrowMinimizeIcon,
    ArrowMoveIcon,
    ArrowRedo2Icon,
    ArrowRedoIcon,
    ArrowReplyIcon,
    ArrowRightIcon,
    ArrowRotateClockwiseIcon,
    ArrowRotateCounterclockwiseIcon,
    ArrowSortIcon,
    ArrowSwapIcon,
    ArrowSync2Icon,
    ArrowSyncIcon,
    ArrowTrendingIcon,
    ArrowUndo2Icon,
    ArrowUndoIcon,
    ArrowUpDownIcon,
    ArrowUpIcon,
    ArrowUploadIcon,
    AttatchIcon,
    BackgroundColorAccentIcon,
    BackgroundColorIcon,
    BackspaceIcon,
    BadgeIcon,
    BarGraphIcon,
    BatteryFullIcon,
    BatteryIcon,
    BeachIcon,
    BeakerIcon,
    BellDotIcon,
    BellIcon,
    BellOffIcon,
    BluetoothIcon,
    BoardIcon,
    BoltIcon,
    Book2Icon,
    BookAdd2Icon,
    BookAddIcon,
    BookIcon,
    BookInfo2Icon,
    BookInfoIcon,
    BookOpenIcon,
    BookmarkAddIcon,
    BookmarkIcon,
    BookmarkMultipleIcon,
    BookmarkMultipleVarIcon: BookmarkMultipleIcon,
    BorderAllIcon,
    BoxDragIcon,
    BoxIcon,
    BoxMarginsIcon,
    BracesIcon,
    BracesVariableIcon,
    BracketsIcon,
    BranchCompareIcon,
    BranchFork2Icon,
    BranchForkIcon,
    BranchIcon,
    BranchPullRequestIcon,
    Briefcase2Icon,
    BriefcaseIcon,
    BrightnessIcon,
    BroomIcon,
    BugIcon,
    BuildingMultipleIcon,
    ButtonIcon,
    CakeIcon,
    CalculatorIcon,
    CalendarIcon,
    CalligraphyPenIcon,
    CameraIcon,
    CancelCircleIcon,
    CancelIcon,
    CancelSquareIcon,
    CandyIcon,
    CartIcon,
    CentIcon,
    CenterHorizontalIcon,
    CenterVerticalIcon,
    ChatIcon,
    CheckboxCheckedIcon,
    CheckboxIndeterminate2Icon,
    CheckboxIndeterminateIcon,
    CheckboxIntermediate2Icon: CheckboxIndeterminate2Icon,
    CheckboxUncheckedIcon,
    CheckmarkCheckedIcon: CheckboxCheckedIcon,
    CheckmarkCircleIcon,
    CheckmarkIcon,
    CheckmarkIntermediateIcon: CheckboxIndeterminateIcon,
    CheckmarkStarburstIcon,
    ChevronDownIcon,
    ChevronLeftIcon,
    ChevronRightIcon,
    ChevronUpIcon,
    ChromeRestoreIcon,
    ChromeRestoreVarIcon: ChromeRestoreIcon,
    CircleIcon,
    CircleSmallIcon,
    ClipboardIcon,
    ClipboardPasteIcon,
    ClipboardSearchIcon,
    ClockIcon,
    CloseIcon: CancelIcon,
    ClosedCaptionsIcon,
    CloudIcon,
    CodeIcon,
    CoffeeHotIcon,
    ColorPaletteIcon,
    CommentExclamationIcon,
    CommentIcon,
    CommentMultipleIcon,
    CommentMultipleVarIcon: CommentMultipleIcon,
    CompareSizeIcon,
    CompassIcon,
    ComponentIcon,
    ComposeIcon,
    ComputerIcon,
    ComputerMacIcon,
    ContractDownIcon,
    CookiesIcon,
    CopyIcon,
    CopyVarIcon: CopyIcon,
    CopyleftIcon,
    CopyrightIcon,
    CornerRadiusIcon,
    CreateIcon: AddIcon,
    CreditCardIcon,
    CropIcon,
    CssIcon,
    CursorClickIcon,
    CursorDragIcon,
    CursorIcon,
    CutIcon,
    DarkThemeIcon,
    DatabaseAddIcon,
    DatabaseIcon,
    DeleteIcon,
    DiamondIcon,
    DirectionsIcon,
    DismissIcon: CancelIcon,
    DoNotDisturbIcon,
    DocumentIcon,
    DollarCircleIcon,
    DollarIcon,
    DoorIcon,
    DoorOpenIcon,
    DrawTextIcon,
    DropIcon,
    EmojiFrownIcon,
    EmojiGrinIcon,
    EmojiIcon,
    EmojiLaughterIcon,
    EraserIcon,
    ExpandIcon,
    ExtensionIcon,
    EyeIcon,
    EyeOffIcon,
    EyedropperColorAccentIcon,
    EyedropperColorIcon,
    EyedropperIcon,
    FacebookIcon,
    FastFowardIcon,
    FigmaIcon,
    FileAddIcon,
    FileIcon,
    FileSyncIcon,
    Filter2Icon,
    FilterCancel2Icon,
    FilterCancelIcon,
    FilterIcon,
    Flag2Icon,
    FlagIcon,
    FlashlightIcon,
    FoldableHorizontalHalfIcon,
    FoldableHorizontalIcon,
    FoldableVerticalHalfIcon,
    FoldableVerticalIcon,
    FolderAddIcon,
    FolderIcon,
    FolderOpenIcon,
    FullScreenMaximizeIcon,
    FullScreenMinimizeIcon,
    GameIcon,
    GiftIcon,
    GitCommitIcon,
    GithubIcon,
    GitlabIcon,
    GlobeIcon,
    Google2Icon,
    GoogleChromeIcon,
    GoogleIcon,
    GooglePlayIcon,
    GraphIcon,
    GridDotsIcon,
    GridIcon,
    HamburgerIcon,
    HandIcon,
    HardDriveIcon,
    HashIcon,
    HatGraduationIcon,
    HeadphonesIcon,
    HeadphonesOffIcon,
    HeartIcon,
    HeartStylisticIcon,
    HexagonIcon,
    HighlighterAccentIcon,
    HighlighterIcon,
    HistoryIcon,
    Home2Icon,
    HomeIcon,
    HourglassIcon,
    HtmlIcon,
    InfinityIcon,
    InfoIcon,
    InstagramIcon,
    JavascriptIcon,
    KeyboardCommandIcon,
    KeyboardIcon,
    KeyboardShiftIcon,
    LaptopIcon,
    LayersIcon,
    LayoutIcon,
    LeafIcon,
    LeafThreeIcon,
    LeafTwoIcon,
    LibraryIcon,
    LightbulbIcon,
    LineDiagonalIcon,
    LinkIcon,
    LinuxIcon,
    LocationIcon,
    LockIcon,
    LockOpenIcon,
    MailIcon,
    MailOpenIcon,
    MapIcon,
    MaskIcon,
    MathIcon,
    MegaphoneIcon,
    MegaphoneLoudIcon,
    MentionIcon,
    MenuIcon,
    MicrophoneIcon,
    MicrophoneOffIcon,
    MicrosoftEdgeIcon,
    MicrosoftIcon,
    MoonIcon,
    MoreIcon,
    MoreVerticalIcon,
    MotherboardIcon,
    MovieIcon,
    MuseumIcon,
    MusicNote2Icon,
    MusicNoteIcon,
    NarratorIcon,
    NodejsIcon,
    NoteAddIcon,
    NoteIcon,
    NpmIcon,
    OctagonIcon,
    OpenIcon,
    OpenSourceIcon,
    PageMarginsIcon,
    PaintBucketAccentIcon,
    PaintBucketIcon,
    Paintbrush2Icon,
    PaintbrushIcon,
    PanelLeftContractIcon,
    PanelLeftExpandIcon,
    PanelLeftIcon,
    PanelLeftOpenIcon,
    PanelRightContractIcon,
    PanelRightExpandIcon,
    PanelRightIcon,
    PanelRightOpenIcon,
    PauseIcon,
    Pdf2Icon,
    PdfIcon,
    PencilIcon,
    PentagonIcon,
    Person2Icon,
    PersonAdd2Icon,
    PersonAddIcon,
    PersonCircleIcon,
    PersonIcon,
    PersonMultipleIcon,
    PhoneAcceptIcon,
    PhoneHangUpIcon,
    PhoneIcon,
    PhotoFilterIcon,
    PhotoIcon,
    PictureInPicture2Icon,
    PictureInPictureEnterIcon,
    PictureInPictureExitIcon,
    PictureInPictureIcon,
    PinIcon,
    PinOffIcon,
    PlayCircularIcon,
    PlayIcon,
    PlusIcon: AddIcon,
    PrinterIcon,
    ProhibitedIcon,
    PythonIcon,
    QrCodeIcon,
    QuestionCircleIcon,
    QuestionIcon,
    QuoteIcon,
    ReactjsIcon,
    RecordIcon,
    RecordStopIcon,
    RectangleWideIcon,
    RegularExpressionIcon,
    ReverseIcon,
    RhombusIcon,
    RibbonIcon,
    RibbonStarIcon,
    RobloxIcon,
    RulerDiagonalIcon,
    RulerIcon,
    SaveAsIcon,
    SaveIcon,
    ScreenSizeIcon,
    Script2Icon,
    ScriptIcon,
    SearchCancelIcon,
    SearchIcon,
    SectionBreakIcon,
    SendIcon,
    ServerIcon,
    SettingsIcon,
    ShapeDifferenceIcon,
    ShapeIntersectIcon,
    ShapeSubtractIcon,
    ShapeUnionIcon,
    ShieldCancelIcon,
    ShieldCheckmarkIcon,
    ShieldIcon,
    ShieldKeyholeIcon,
    SkullIcon,
    SlashBoxIcon,
    SoundwaveIcon,
    SpacebarIcon,
    SparkleIcon,
    SpinnerIcon,
    SquareIcon,
    StarIcon,
    StrokeThicknessIcon,
    SubtractIcon,
    SvelteIcon,
    SymbolsIcon,
    TableIcon,
    TableSimpleIcon,
    TabletIcon,
    TagAccentIcon,
    TagIcon,
    TagMultipleIcon,
    TagMultipleVarIcon: TagMultipleIcon,
    TaskListIcon,
    TerminalIcon,
    TextAddIcon,
    TextAlignCenterIcon,
    TextAlignJustifyIcon,
    TextAlignLeftIcon,
    TextAlignRightIcon,
    TextBoldIcon,
    TextBulletListIcon,
    TextBulletListSquareAddIcon,
    TextBulletListSquareIcon,
    TextCaseLowercaseIcon,
    TextCaseTitleIcon,
    TextCaseUppercaseIcon,
    TextClearFormattingIcon,
    TextCollapseIcon,
    TextColorAccentIcon,
    TextColorIcon,
    TextEditStyleIcon,
    TextEffectsIcon,
    TextExpandIcon,
    TextFontIcon,
    TextFontSizeIcon,
    TextFootnoteIcon,
    TextHighlightColorAccentIcon,
    TextHighlightColorIcon,
    TextIcon,
    TextIndentDecreaseIcon,
    TextIndentIncreaseIcon,
    TextItalicIcon,
    TextLargeIcon,
    TextLetterSpacingIcon,
    TextLineHeightIcon,
    TextLineSpacingIcon,
    TextNumberListIcon,
    TextPositionBottomIcon,
    TextPositionMiddleIcon,
    TextPositionTopIcon,
    TextSmallIcon,
    TextStrikethroughIcon,
    TextSubscriptIcon,
    TextSuperscriptIcon,
    TextTypographyIcon,
    TextUnderlineIcon,
    ThumbsDownIcon,
    ThumbsUpIcon,
    TiktokIcon,
    TimerIcon,
    ToolboxIcon,
    TriangleIcon,
    TuneIcon,
    TvIcon,
    TwitterIcon: XTwitterIcon,
    TypescriptIcon,
    UbuntuIcon,
    VehicleCarIcon,
    VideoClipIcon,
    VideoIcon,
    VisualStudioCodeIcon,
    Volume0Icon,
    Volume1Icon,
    VolumeIcon,
    VolumeMuteIcon,
    VuejsIcon,
    WatchIcon,
    WeatherCloudyIcon,
    WebpackIcon,
    WiFiIcon,
    WindowIcon,
    WindowMultipleIcon,
    WindowMultipleVarIcon: WindowMultipleIcon,
    WrenchIcon,
    XIcon: CancelIcon,
    XTwitterIcon,
    YoutubeIcon,
    YoutubeShortsIcon,
    ZoomInIcon,
    ZoomOutIcon,
    accessibility: AccessibilityIcon,
    add: AddIcon,
    addCircular: AddCircularIcon,
    addRhombus: AddRhombusIcon,
    addSquare: AddSquareIcon,
    addSquareMultiple: AddSquareMultipleIcon,
    addSquareMultipleVar: AddSquareMultipleIcon,
    addition: AddIcon,
    airplane: AirplaneIcon,
    airplaneLanding: AirplaneLandingIcon,
    airplaneTakeoff: AirplaneTakeoffIcon,
    alertCircle: AlertCircleIcon,
    alertTriangle: AlertTriangleIcon,
    alignBottom: AlignBottomIcon,
    alignHorizontalCenters: AlignHorizontalCentersIcon,
    alignLeft: AlignLeftIcon,
    alignRight: AlignRightIcon,
    alignTop: AlignTopIcon,
    alignVerticalCenters: AlignVerticalCentersIcon,
    amazon: AmazonIcon,
    anchor: AnchorIcon,
    android: AndroidIcon,
    angle: AngleIcon,
    appRemove: AppRemoveIcon,
    appStore: AppStoreIcon,
    apple: AppleIcon,
    apps: AppsIcon,
    appsAdd: AppsAddIcon,
    appsList: AppsListIcon,
    arc: ArcIcon,
    archive: ArchiveIcon,
    archiveAdd2: ArchiveAdd2Icon,
    arrowClockwise: ArrowClockwiseIcon,
    arrowCounterclockwise: ArrowCounterclockwiseIcon,
    arrowDown: ArrowDownIcon,
    arrowDownload: ArrowDownloadIcon,
    arrowEnter: ArrowEnterIcon,
    arrowExport: ArrowExportIcon,
    arrowFoward: ArrowFowardIcon,
    arrowImport: ArrowImportIcon,
    arrowLeft: ArrowLeftIcon,
    arrowLeftRight: ArrowLeftRightIcon,
    arrowMaximize: ArrowMaximizeIcon,
    arrowMinimize: ArrowMinimizeIcon,
    arrowMove: ArrowMoveIcon,
    arrowRedo: ArrowRedoIcon,
    arrowRedo2: ArrowRedo2Icon,
    arrowReply: ArrowReplyIcon,
    arrowRight: ArrowRightIcon,
    arrowRotateClockwise: ArrowRotateClockwiseIcon,
    arrowRotateCounterclockwise: ArrowRotateCounterclockwiseIcon,
    arrowSort: ArrowSortIcon,
    arrowSwap: ArrowSwapIcon,
    arrowSync: ArrowSyncIcon,
    arrowSync2: ArrowSync2Icon,
    arrowTrending: ArrowTrendingIcon,
    arrowUndo: ArrowUndoIcon,
    arrowUndo2: ArrowUndo2Icon,
    arrowUp: ArrowUpIcon,
    arrowUpDown: ArrowUpDownIcon,
    arrowUpload: ArrowUploadIcon,
    attatch: AttatchIcon,
    backgroundColor: BackgroundColorIcon,
    backgroundColorAccent: BackgroundColorAccentIcon,
    backspace: BackspaceIcon,
    badge: BadgeIcon,
    barGraph: BarGraphIcon,
    battery: BatteryIcon,
    batteryFull: BatteryFullIcon,
    beach: BeachIcon,
    beaker: BeakerIcon,
    bell: BellIcon,
    bellDot: BellDotIcon,
    bellOff: BellOffIcon,
    bluetooth: BluetoothIcon,
    board: BoardIcon,
    bolt: BoltIcon,
    book: BookIcon,
    book2: Book2Icon,
    bookAdd: BookAddIcon,
    bookAdd2: BookAdd2Icon,
    bookInfo: BookInfoIcon,
    bookInfo2: BookInfo2Icon,
    bookOpen: BookOpenIcon,
    bookmark: BookmarkIcon,
    bookmarkAdd: BookmarkAddIcon,
    bookmarkMultiple: BookmarkMultipleIcon,
    bookmarkMultipleVar: BookmarkMultipleIcon,
    borderAll: BorderAllIcon,
    box: BoxIcon,
    boxDrag: BoxDragIcon,
    boxMargins: BoxMarginsIcon,
    braces: BracesIcon,
    bracesVariable: BracesVariableIcon,
    brackets: BracketsIcon,
    branch: BranchIcon,
    branchCompare: BranchCompareIcon,
    branchFork: BranchForkIcon,
    branchFork2: BranchFork2Icon,
    branchPullRequest: BranchPullRequestIcon,
    briefcase: BriefcaseIcon,
    briefcase2: Briefcase2Icon,
    brightness: BrightnessIcon,
    broom: BroomIcon,
    bug: BugIcon,
    buildingMultiple: BuildingMultipleIcon,
    button: ButtonIcon,
    cake: CakeIcon,
    calculator: CalculatorIcon,
    calendar: CalendarIcon,
    calligraphyPen: CalligraphyPenIcon,
    camera: CameraIcon,
    cancel: CancelIcon,
    cancelCircle: CancelCircleIcon,
    cancelSquare: CancelSquareIcon,
    candy: CandyIcon,
    cart: CartIcon,
    cent: CentIcon,
    centerHorizontal: CenterHorizontalIcon,
    centerVertical: CenterVerticalIcon,
    chat: ChatIcon,
    checkboxChecked: CheckboxCheckedIcon,
    checkboxIndeterminate: CheckboxIndeterminateIcon,
    checkboxIndeterminate2: CheckboxIndeterminate2Icon,
    checkboxIntermediate2: CheckboxIndeterminate2Icon,
    checkboxUnchecked: CheckboxUncheckedIcon,
    checkmark: CheckmarkIcon,
    checkmarkChecked: CheckboxCheckedIcon,
    checkmarkCircle: CheckmarkCircleIcon,
    checkmarkIntermediate: CheckboxIndeterminateIcon,
    checkmarkStarburst: CheckmarkStarburstIcon,
    chevronDown: ChevronDownIcon,
    chevronLeft: ChevronLeftIcon,
    chevronRight: ChevronRightIcon,
    chevronUp: ChevronUpIcon,
    chromeRestore: ChromeRestoreIcon,
    chromeRestoreVar: ChromeRestoreIcon,
    circle: CircleIcon,
    circleSmall: CircleSmallIcon,
    clipboard: ClipboardIcon,
    clipboardPaste: ClipboardPasteIcon,
    clipboardSearch: ClipboardSearchIcon,
    clock: ClockIcon,
    close: CancelIcon,
    closedCaptions: ClosedCaptionsIcon,
    cloud: CloudIcon,
    code: CodeIcon,
    coffeeHot: CoffeeHotIcon,
    colorPalette: ColorPaletteIcon,
    comment: CommentIcon,
    commentExclamation: CommentExclamationIcon,
    commentMultiple: CommentMultipleIcon,
    commentMultipleVar: CommentMultipleIcon,
    compareSize: CompareSizeIcon,
    compass: CompassIcon,
    component: ComponentIcon,
    compose: ComposeIcon,
    computer: ComputerIcon,
    computerMac: ComputerMacIcon,
    contractDown: ContractDownIcon,
    cookies: CookiesIcon,
    copy: CopyIcon,
    copyVar: CopyIcon,
    copyleft: CopyleftIcon,
    copyright: CopyrightIcon,
    cornerRadius: CornerRadiusIcon,
    create: AddIcon,
    creditCard: CreditCardIcon,
    crop: CropIcon,
    css: CssIcon,
    cursor: CursorIcon,
    cursorClick: CursorClickIcon,
    cursorDrag: CursorDragIcon,
    cut: CutIcon,
    darkTheme: DarkThemeIcon,
    database: DatabaseIcon,
    databaseAdd: DatabaseAddIcon,
    delete: DeleteIcon,
    diamond: DiamondIcon,
    directions: DirectionsIcon,
    dismiss: CancelIcon,
    doNotDisturb: DoNotDisturbIcon,
    document: DocumentIcon,
    dollar: DollarIcon,
    dollarCircle: DollarCircleIcon,
    door: DoorIcon,
    doorOpen: DoorOpenIcon,
    drawText: DrawTextIcon,
    drop: DropIcon,
    emoji: EmojiIcon,
    emojiFrown: EmojiFrownIcon,
    emojiGrin: EmojiGrinIcon,
    emojiLaughter: EmojiLaughterIcon,
    eraser: EraserIcon,
    expand: ExpandIcon,
    extension: ExtensionIcon,
    eye: EyeIcon,
    eyeOff: EyeOffIcon,
    eyedropper: EyedropperIcon,
    eyedropperColor: EyedropperColorIcon,
    eyedropperColorAccent: EyedropperColorAccentIcon,
    facebook: FacebookIcon,
    fastFoward: FastFowardIcon,
    figma: FigmaIcon,
    file: FileIcon,
    fileAdd: FileAddIcon,
    fileSync: FileSyncIcon,
    filter: FilterIcon,
    filter2: Filter2Icon,
    filterCancel: FilterCancelIcon,
    filterCancel2: FilterCancel2Icon,
    flag: FlagIcon,
    flag2: Flag2Icon,
    flashlight: FlashlightIcon,
    foldableHorizontal: FoldableHorizontalIcon,
    foldableHorizontalHalf: FoldableHorizontalHalfIcon,
    foldableVertical: FoldableVerticalIcon,
    foldableVerticalHalf: FoldableVerticalHalfIcon,
    folder: FolderIcon,
    folderAdd: FolderAddIcon,
    folderOpen: FolderOpenIcon,
    fullScreenMaximize: FullScreenMaximizeIcon,
    fullScreenMinimize: FullScreenMinimizeIcon,
    game: GameIcon,
    gift: GiftIcon,
    gitCommit: GitCommitIcon,
    github: GithubIcon,
    gitlab: GitlabIcon,
    globe: GlobeIcon,
    google: GoogleIcon,
    google2: Google2Icon,
    googleChrome: GoogleChromeIcon,
    googlePlay: GooglePlayIcon,
    graph: GraphIcon,
    grid: GridIcon,
    gridDots: GridDotsIcon,
    hamburger: HamburgerIcon,
    hand: HandIcon,
    hardDrive: HardDriveIcon,
    hash: HashIcon,
    hatGraduation: HatGraduationIcon,
    headphones: HeadphonesIcon,
    headphonesOff: HeadphonesOffIcon,
    heart: HeartIcon,
    heartStylistic: HeartStylisticIcon,
    hexagon: HexagonIcon,
    highlighter: HighlighterIcon,
    highlighterAccent: HighlighterAccentIcon,
    history: HistoryIcon,
    home: HomeIcon,
    home2: Home2Icon,
    hourglass: HourglassIcon,
    html: HtmlIcon,
    infinity: InfinityIcon,
    info: InfoIcon,
    instagram: InstagramIcon,
    javascript: JavascriptIcon,
    keyboard: KeyboardIcon,
    keyboardCommand: KeyboardCommandIcon,
    keyboardShift: KeyboardShiftIcon,
    laptop: LaptopIcon,
    layers: LayersIcon,
    layout: LayoutIcon,
    leaf: LeafIcon,
    leafThree: LeafThreeIcon,
    leafTwo: LeafTwoIcon,
    library: LibraryIcon,
    lightbulb: LightbulbIcon,
    lineDiagonal: LineDiagonalIcon,
    link: LinkIcon,
    linux: LinuxIcon,
    location: LocationIcon,
    lock: LockIcon,
    lockOpen: LockOpenIcon,
    mail: MailIcon,
    mailOpen: MailOpenIcon,
    map: MapIcon,
    mask: MaskIcon,
    math: MathIcon,
    megaphone: MegaphoneIcon,
    megaphoneLoud: MegaphoneLoudIcon,
    mention: MentionIcon,
    menu: MenuIcon,
    microphone: MicrophoneIcon,
    microphoneOff: MicrophoneOffIcon,
    microsoft: MicrosoftIcon,
    microsoftEdge: MicrosoftEdgeIcon,
    moon: MoonIcon,
    more: MoreIcon,
    moreVertical: MoreVerticalIcon,
    motherboard: MotherboardIcon,
    movie: MovieIcon,
    museum: MuseumIcon,
    musicNote: MusicNoteIcon,
    musicNote2: MusicNote2Icon,
    narrator: NarratorIcon,
    nodejs: NodejsIcon,
    note: NoteIcon,
    noteAdd: NoteAddIcon,
    npm: NpmIcon,
    octagon: OctagonIcon,
    open: OpenIcon,
    openSource: OpenSourceIcon,
    pageMargins: PageMarginsIcon,
    paintBucket: PaintBucketIcon,
    paintBucketAccent: PaintBucketAccentIcon,
    paintbrush: PaintbrushIcon,
    paintbrush2: Paintbrush2Icon,
    panelLeft: PanelLeftIcon,
    panelLeftContract: PanelLeftContractIcon,
    panelLeftExpand: PanelLeftExpandIcon,
    panelLeftOpen: PanelLeftOpenIcon,
    panelRight: PanelRightIcon,
    panelRightContract: PanelRightContractIcon,
    panelRightExpand: PanelRightExpandIcon,
    panelRightOpen: PanelRightOpenIcon,
    pause: PauseIcon,
    pdf: PdfIcon,
    pdf2: Pdf2Icon,
    pencil: PencilIcon,
    pentagon: PentagonIcon,
    person: PersonIcon,
    person2: Person2Icon,
    personAdd: PersonAddIcon,
    personAdd2: PersonAdd2Icon,
    personCircle: PersonCircleIcon,
    personMultiple: PersonMultipleIcon,
    phone: PhoneIcon,
    phoneAccept: PhoneAcceptIcon,
    phoneHangUp: PhoneHangUpIcon,
    photo: PhotoIcon,
    photoFilter: PhotoFilterIcon,
    pictureInPicture: PictureInPictureIcon,
    pictureInPicture2: PictureInPicture2Icon,
    pictureInPictureEnter: PictureInPictureEnterIcon,
    pictureInPictureExit: PictureInPictureExitIcon,
    pin: PinIcon,
    pinOff: PinOffIcon,
    play: PlayIcon,
    playCircular: PlayCircularIcon,
    plus: AddIcon,
    printer: PrinterIcon,
    prohibited: ProhibitedIcon,
    python: PythonIcon,
    qrCode: QrCodeIcon,
    question: QuestionIcon,
    questionCircle: QuestionCircleIcon,
    quote: QuoteIcon,
    reactjs: ReactjsIcon,
    record: RecordIcon,
    recordStop: RecordStopIcon,
    rectangleWide: RectangleWideIcon,
    regularExpression: RegularExpressionIcon,
    reverse: ReverseIcon,
    rhombus: RhombusIcon,
    ribbon: RibbonIcon,
    ribbonStar: RibbonStarIcon,
    roblox: RobloxIcon,
    ruler: RulerIcon,
    rulerDiagonal: RulerDiagonalIcon,
    save: SaveIcon,
    saveAs: SaveAsIcon,
    screenSize: ScreenSizeIcon,
    script: ScriptIcon,
    script2: Script2Icon,
    search: SearchIcon,
    searchCancel: SearchCancelIcon,
    sectionBreak: SectionBreakIcon,
    send: SendIcon,
    server: ServerIcon,
    settings: SettingsIcon,
    shapeDifference: ShapeDifferenceIcon,
    shapeIntersect: ShapeIntersectIcon,
    shapeSubtract: ShapeSubtractIcon,
    shapeUnion: ShapeUnionIcon,
    shield: ShieldIcon,
    shieldCancel: ShieldCancelIcon,
    shieldCheckmark: ShieldCheckmarkIcon,
    shieldKeyhole: ShieldKeyholeIcon,
    skull: SkullIcon,
    slashBox: SlashBoxIcon,
    soundwave: SoundwaveIcon,
    spacebar: SpacebarIcon,
    sparkle: SparkleIcon,
    spinner: SpinnerIcon,
    square: SquareIcon,
    star: StarIcon,
    strokeThickness: StrokeThicknessIcon,
    subtract: SubtractIcon,
    svelte: SvelteIcon,
    symbols: SymbolsIcon,
    table: TableIcon,
    tableSimple: TableSimpleIcon,
    tablet: TabletIcon,
    tag: TagIcon,
    tagAccent: TagAccentIcon,
    tagMultiple: TagMultipleIcon,
    tagMultipleVar: TagMultipleIcon,
    taskList: TaskListIcon,
    terminal: TerminalIcon,
    text: TextIcon,
    textAdd: TextAddIcon,
    textAlignCenter: TextAlignCenterIcon,
    textAlignJustify: TextAlignJustifyIcon,
    textAlignLeft: TextAlignLeftIcon,
    textAlignRight: TextAlignRightIcon,
    textBold: TextBoldIcon,
    textBulletList: TextBulletListIcon,
    textBulletListSquare: TextBulletListSquareIcon,
    textBulletListSquareAdd: TextBulletListSquareAddIcon,
    textCaseLowercase: TextCaseLowercaseIcon,
    textCaseTitle: TextCaseTitleIcon,
    textCaseUppercase: TextCaseUppercaseIcon,
    textClearFormatting: TextClearFormattingIcon,
    textCollapse: TextCollapseIcon,
    textColor: TextColorIcon,
    textColorAccent: TextColorAccentIcon,
    textEditStyle: TextEditStyleIcon,
    textEffects: TextEffectsIcon,
    textExpand: TextExpandIcon,
    textFont: TextFontIcon,
    textFontSize: TextFontSizeIcon,
    textFootnote: TextFootnoteIcon,
    textHighlightColor: TextHighlightColorIcon,
    textHighlightColorAccent: TextHighlightColorAccentIcon,
    textIndentDecrease: TextIndentDecreaseIcon,
    textIndentIncrease: TextIndentIncreaseIcon,
    textItalic: TextItalicIcon,
    textLarge: TextLargeIcon,
    textLetterSpacing: TextLetterSpacingIcon,
    textLineHeight: TextLineHeightIcon,
    textLineSpacing: TextLineSpacingIcon,
    textNumberList: TextNumberListIcon,
    textPositionBottom: TextPositionBottomIcon,
    textPositionMiddle: TextPositionMiddleIcon,
    textPositionTop: TextPositionTopIcon,
    textSmall: TextSmallIcon,
    textStrikethrough: TextStrikethroughIcon,
    textSubscript: TextSubscriptIcon,
    textSuperscript: TextSuperscriptIcon,
    textTypography: TextTypographyIcon,
    textUnderline: TextUnderlineIcon,
    thumbsDown: ThumbsDownIcon,
    thumbsUp: ThumbsUpIcon,
    tiktok: TiktokIcon,
    timer: TimerIcon,
    toolbox: ToolboxIcon,
    triangle: TriangleIcon,
    tune: TuneIcon,
    tv: TvIcon,
    twitter: XTwitterIcon,
    typescript: TypescriptIcon,
    ubuntu: UbuntuIcon,
    vehicleCar: VehicleCarIcon,
    video: VideoIcon,
    videoClip: VideoClipIcon,
    visualStudioCode: VisualStudioCodeIcon,
    volume: VolumeIcon,
    volume0: Volume0Icon,
    volume1: Volume1Icon,
    volumeMute: VolumeMuteIcon,
    vuejs: VuejsIcon,
    watch: WatchIcon,
    weatherCloudy: WeatherCloudyIcon,
    webpack: WebpackIcon,
    wiFi: WiFiIcon,
    window: WindowIcon,
    windowMultiple: WindowMultipleIcon,
    windowMultipleVar: WindowMultipleIcon,
    wrench: WrenchIcon,
    x: CancelIcon,
    xTwitter: XTwitterIcon,
    youtube: YoutubeIcon,
    youtubeShorts: YoutubeShortsIcon,
    zoomIn: ZoomInIcon,
    zoomOut: ZoomOutIcon
  }, Symbol.toStringTag, { value: "Module" }));
  function getIconInfo(key) {
    const lowerName = key.toLowerCase();
    const iconName = Object.keys(icons).find((pascalName) => {
      const lowerIconName = pascalName.replace(/Icon$/, "").toLowerCase();
      return lowerIconName == lowerName || lowerIconName + "icon" == lowerName || kebabCase(lowerIconName) == lowerName || lowerIconName == pascalCase(lowerName);
    });
    return icons[iconName];
  }
  function replace(rootElm, config) {
    var _a, _b, _c, _d;
    if (!(window == null ? void 0 : window.document)) {
      throw new Error("proicons.replace() only works in a browser environment");
    }
    rootElm != null ? rootElm : rootElm = document.body;
    const useAttrs = (_a = config == null ? void 0 : config.useAttributes) != null ? _a : true;
    const attr = (_b = config == null ? void 0 : config.attributeName) != null ? _b : "proicon";
    for (const element of rootElm.querySelectorAll(`[${attr}]`)) {
      let toReplace;
      switch ((_c = config == null ? void 0 : config.overwrite) != null ? _c : "auto") {
        case true:
          toReplace = true;
          break;
        case false:
          toReplace = false;
          break;
        case "auto":
          toReplace = !element.hasChildNodes();
          break;
      }
      let iconName = element.getAttribute(attr).trim();
      const iconInfo = getIconInfo(iconName);
      if (!iconInfo) {
        continue;
      }
      let iconElement = document.createElement("svg");
      const propMap = {
        color: "color",
        "stroke-width": "strokeWidth",
        join: "strokeJoin",
        caps: "strokeCaps",
        "corner-radius": "cornerRadius",
        outline: "strokeFilledElements",
        size: "size"
      };
      const elementConfig = {};
      if (useAttrs) {
        for (const [htmlAttr, optionKey] of Object.entries(propMap)) {
          if (element.hasAttribute(htmlAttr)) {
            elementConfig[optionKey] = element.getAttribute(htmlAttr);
            element.removeAttribute(htmlAttr);
          }
        }
        for (const { name, value } of element.attributes) {
          if (!Object.hasOwn(propMap, name)) {
            (_d = elementConfig.attributes) != null ? _d : elementConfig.attributes = {};
            elementConfig.attributes[name] = value;
          }
        }
        Object.assign(structuredClone(config != null ? config : {}), elementConfig);
      }
      iconElement.innerHTML = getIconInfo(iconName).toSvg(elementConfig);
      iconElement = iconElement.children[0];
      iconElement.classList.add("proicon");
      iconElement.setAttribute("data-proicon-id", getIconInfo(iconName).kebabCase);
      toReplace == true ? element.replaceWith(iconElement) : element.insertBefore(iconElement, element.childNodes[0]);
    }
  }
  function search(query) {
    const mappedIcons = Object.values(icons);
    const filtered = mappedIcons.filter((item) => {
      return Object.entries(item).some(
        ([key, value]) => {
          if (!Array.isArray(value) && typeof value != "string" || key == "raw")
            return;
          return Array.isArray(value) ? value.some(
            (tag) => tag.toLowerCase().includes(query.toLowerCase())
          ) : value.toLowerCase().includes(query.toLowerCase());
        }
      );
    });
    return filtered;
  }
  exports2.AccessibilityIcon = AccessibilityIcon;
  exports2.AddCircularIcon = AddCircularIcon;
  exports2.AddIcon = AddIcon;
  exports2.AddRhombusIcon = AddRhombusIcon;
  exports2.AddSquareIcon = AddSquareIcon;
  exports2.AddSquareMultipleIcon = AddSquareMultipleIcon;
  exports2.AddSquareMultipleVarIcon = AddSquareMultipleIcon;
  exports2.AdditionIcon = AddIcon;
  exports2.AirplaneIcon = AirplaneIcon;
  exports2.AirplaneLandingIcon = AirplaneLandingIcon;
  exports2.AirplaneTakeoffIcon = AirplaneTakeoffIcon;
  exports2.AlertCircleIcon = AlertCircleIcon;
  exports2.AlertTriangleIcon = AlertTriangleIcon;
  exports2.AlignBottomIcon = AlignBottomIcon;
  exports2.AlignHorizontalCentersIcon = AlignHorizontalCentersIcon;
  exports2.AlignLeftIcon = AlignLeftIcon;
  exports2.AlignRightIcon = AlignRightIcon;
  exports2.AlignTopIcon = AlignTopIcon;
  exports2.AlignVerticalCentersIcon = AlignVerticalCentersIcon;
  exports2.AmazonIcon = AmazonIcon;
  exports2.AnchorIcon = AnchorIcon;
  exports2.AndroidIcon = AndroidIcon;
  exports2.AngleIcon = AngleIcon;
  exports2.AppRemoveIcon = AppRemoveIcon;
  exports2.AppStoreIcon = AppStoreIcon;
  exports2.AppleIcon = AppleIcon;
  exports2.AppsAddIcon = AppsAddIcon;
  exports2.AppsIcon = AppsIcon;
  exports2.AppsListIcon = AppsListIcon;
  exports2.ArcIcon = ArcIcon;
  exports2.ArchiveAdd2Icon = ArchiveAdd2Icon;
  exports2.ArchiveIcon = ArchiveIcon;
  exports2.ArrowClockwiseIcon = ArrowClockwiseIcon;
  exports2.ArrowCounterclockwiseIcon = ArrowCounterclockwiseIcon;
  exports2.ArrowDownIcon = ArrowDownIcon;
  exports2.ArrowDownloadIcon = ArrowDownloadIcon;
  exports2.ArrowEnterIcon = ArrowEnterIcon;
  exports2.ArrowExportIcon = ArrowExportIcon;
  exports2.ArrowFowardIcon = ArrowFowardIcon;
  exports2.ArrowImportIcon = ArrowImportIcon;
  exports2.ArrowLeftIcon = ArrowLeftIcon;
  exports2.ArrowLeftRightIcon = ArrowLeftRightIcon;
  exports2.ArrowMaximizeIcon = ArrowMaximizeIcon;
  exports2.ArrowMinimizeIcon = ArrowMinimizeIcon;
  exports2.ArrowMoveIcon = ArrowMoveIcon;
  exports2.ArrowRedo2Icon = ArrowRedo2Icon;
  exports2.ArrowRedoIcon = ArrowRedoIcon;
  exports2.ArrowReplyIcon = ArrowReplyIcon;
  exports2.ArrowRightIcon = ArrowRightIcon;
  exports2.ArrowRotateClockwiseIcon = ArrowRotateClockwiseIcon;
  exports2.ArrowRotateCounterclockwiseIcon = ArrowRotateCounterclockwiseIcon;
  exports2.ArrowSortIcon = ArrowSortIcon;
  exports2.ArrowSwapIcon = ArrowSwapIcon;
  exports2.ArrowSync2Icon = ArrowSync2Icon;
  exports2.ArrowSyncIcon = ArrowSyncIcon;
  exports2.ArrowTrendingIcon = ArrowTrendingIcon;
  exports2.ArrowUndo2Icon = ArrowUndo2Icon;
  exports2.ArrowUndoIcon = ArrowUndoIcon;
  exports2.ArrowUpDownIcon = ArrowUpDownIcon;
  exports2.ArrowUpIcon = ArrowUpIcon;
  exports2.ArrowUploadIcon = ArrowUploadIcon;
  exports2.AttatchIcon = AttatchIcon;
  exports2.BackgroundColorAccentIcon = BackgroundColorAccentIcon;
  exports2.BackgroundColorIcon = BackgroundColorIcon;
  exports2.BackspaceIcon = BackspaceIcon;
  exports2.BadgeIcon = BadgeIcon;
  exports2.BarGraphIcon = BarGraphIcon;
  exports2.BatteryFullIcon = BatteryFullIcon;
  exports2.BatteryIcon = BatteryIcon;
  exports2.BeachIcon = BeachIcon;
  exports2.BeakerIcon = BeakerIcon;
  exports2.BellDotIcon = BellDotIcon;
  exports2.BellIcon = BellIcon;
  exports2.BellOffIcon = BellOffIcon;
  exports2.BluetoothIcon = BluetoothIcon;
  exports2.BoardIcon = BoardIcon;
  exports2.BoltIcon = BoltIcon;
  exports2.Book2Icon = Book2Icon;
  exports2.BookAdd2Icon = BookAdd2Icon;
  exports2.BookAddIcon = BookAddIcon;
  exports2.BookIcon = BookIcon;
  exports2.BookInfo2Icon = BookInfo2Icon;
  exports2.BookInfoIcon = BookInfoIcon;
  exports2.BookOpenIcon = BookOpenIcon;
  exports2.BookmarkAddIcon = BookmarkAddIcon;
  exports2.BookmarkIcon = BookmarkIcon;
  exports2.BookmarkMultipleIcon = BookmarkMultipleIcon;
  exports2.BookmarkMultipleVarIcon = BookmarkMultipleIcon;
  exports2.BorderAllIcon = BorderAllIcon;
  exports2.BoxDragIcon = BoxDragIcon;
  exports2.BoxIcon = BoxIcon;
  exports2.BoxMarginsIcon = BoxMarginsIcon;
  exports2.BracesIcon = BracesIcon;
  exports2.BracesVariableIcon = BracesVariableIcon;
  exports2.BracketsIcon = BracketsIcon;
  exports2.BranchCompareIcon = BranchCompareIcon;
  exports2.BranchFork2Icon = BranchFork2Icon;
  exports2.BranchForkIcon = BranchForkIcon;
  exports2.BranchIcon = BranchIcon;
  exports2.BranchPullRequestIcon = BranchPullRequestIcon;
  exports2.Briefcase2Icon = Briefcase2Icon;
  exports2.BriefcaseIcon = BriefcaseIcon;
  exports2.BrightnessIcon = BrightnessIcon;
  exports2.BroomIcon = BroomIcon;
  exports2.BugIcon = BugIcon;
  exports2.BuildingMultipleIcon = BuildingMultipleIcon;
  exports2.ButtonIcon = ButtonIcon;
  exports2.CakeIcon = CakeIcon;
  exports2.CalculatorIcon = CalculatorIcon;
  exports2.CalendarIcon = CalendarIcon;
  exports2.CalligraphyPenIcon = CalligraphyPenIcon;
  exports2.CameraIcon = CameraIcon;
  exports2.CancelCircleIcon = CancelCircleIcon;
  exports2.CancelIcon = CancelIcon;
  exports2.CancelSquareIcon = CancelSquareIcon;
  exports2.CandyIcon = CandyIcon;
  exports2.CartIcon = CartIcon;
  exports2.CentIcon = CentIcon;
  exports2.CenterHorizontalIcon = CenterHorizontalIcon;
  exports2.CenterVerticalIcon = CenterVerticalIcon;
  exports2.ChatIcon = ChatIcon;
  exports2.CheckboxCheckedIcon = CheckboxCheckedIcon;
  exports2.CheckboxIndeterminate2Icon = CheckboxIndeterminate2Icon;
  exports2.CheckboxIndeterminateIcon = CheckboxIndeterminateIcon;
  exports2.CheckboxIntermediate2Icon = CheckboxIndeterminate2Icon;
  exports2.CheckboxUncheckedIcon = CheckboxUncheckedIcon;
  exports2.CheckmarkCheckedIcon = CheckboxCheckedIcon;
  exports2.CheckmarkCircleIcon = CheckmarkCircleIcon;
  exports2.CheckmarkIcon = CheckmarkIcon;
  exports2.CheckmarkIntermediateIcon = CheckboxIndeterminateIcon;
  exports2.CheckmarkStarburstIcon = CheckmarkStarburstIcon;
  exports2.ChevronDownIcon = ChevronDownIcon;
  exports2.ChevronLeftIcon = ChevronLeftIcon;
  exports2.ChevronRightIcon = ChevronRightIcon;
  exports2.ChevronUpIcon = ChevronUpIcon;
  exports2.ChromeRestoreIcon = ChromeRestoreIcon;
  exports2.ChromeRestoreVarIcon = ChromeRestoreIcon;
  exports2.CircleIcon = CircleIcon;
  exports2.CircleSmallIcon = CircleSmallIcon;
  exports2.ClipboardIcon = ClipboardIcon;
  exports2.ClipboardPasteIcon = ClipboardPasteIcon;
  exports2.ClipboardSearchIcon = ClipboardSearchIcon;
  exports2.ClockIcon = ClockIcon;
  exports2.CloseIcon = CancelIcon;
  exports2.ClosedCaptionsIcon = ClosedCaptionsIcon;
  exports2.CloudIcon = CloudIcon;
  exports2.CodeIcon = CodeIcon;
  exports2.CoffeeHotIcon = CoffeeHotIcon;
  exports2.ColorPaletteIcon = ColorPaletteIcon;
  exports2.CommentExclamationIcon = CommentExclamationIcon;
  exports2.CommentIcon = CommentIcon;
  exports2.CommentMultipleIcon = CommentMultipleIcon;
  exports2.CommentMultipleVarIcon = CommentMultipleIcon;
  exports2.CompareSizeIcon = CompareSizeIcon;
  exports2.CompassIcon = CompassIcon;
  exports2.ComponentIcon = ComponentIcon;
  exports2.ComposeIcon = ComposeIcon;
  exports2.ComputerIcon = ComputerIcon;
  exports2.ComputerMacIcon = ComputerMacIcon;
  exports2.ContractDownIcon = ContractDownIcon;
  exports2.CookiesIcon = CookiesIcon;
  exports2.CopyIcon = CopyIcon;
  exports2.CopyVarIcon = CopyIcon;
  exports2.CopyleftIcon = CopyleftIcon;
  exports2.CopyrightIcon = CopyrightIcon;
  exports2.CornerRadiusIcon = CornerRadiusIcon;
  exports2.CreateIcon = AddIcon;
  exports2.CreditCardIcon = CreditCardIcon;
  exports2.CropIcon = CropIcon;
  exports2.CssIcon = CssIcon;
  exports2.CursorClickIcon = CursorClickIcon;
  exports2.CursorDragIcon = CursorDragIcon;
  exports2.CursorIcon = CursorIcon;
  exports2.CutIcon = CutIcon;
  exports2.DarkThemeIcon = DarkThemeIcon;
  exports2.DatabaseAddIcon = DatabaseAddIcon;
  exports2.DatabaseIcon = DatabaseIcon;
  exports2.DeleteIcon = DeleteIcon;
  exports2.DiamondIcon = DiamondIcon;
  exports2.DirectionsIcon = DirectionsIcon;
  exports2.DismissIcon = CancelIcon;
  exports2.DoNotDisturbIcon = DoNotDisturbIcon;
  exports2.DocumentIcon = DocumentIcon;
  exports2.DollarCircleIcon = DollarCircleIcon;
  exports2.DollarIcon = DollarIcon;
  exports2.DoorIcon = DoorIcon;
  exports2.DoorOpenIcon = DoorOpenIcon;
  exports2.DrawTextIcon = DrawTextIcon;
  exports2.DropIcon = DropIcon;
  exports2.EmojiFrownIcon = EmojiFrownIcon;
  exports2.EmojiGrinIcon = EmojiGrinIcon;
  exports2.EmojiIcon = EmojiIcon;
  exports2.EmojiLaughterIcon = EmojiLaughterIcon;
  exports2.EraserIcon = EraserIcon;
  exports2.ExpandIcon = ExpandIcon;
  exports2.ExtensionIcon = ExtensionIcon;
  exports2.EyeIcon = EyeIcon;
  exports2.EyeOffIcon = EyeOffIcon;
  exports2.EyedropperColorAccentIcon = EyedropperColorAccentIcon;
  exports2.EyedropperColorIcon = EyedropperColorIcon;
  exports2.EyedropperIcon = EyedropperIcon;
  exports2.FacebookIcon = FacebookIcon;
  exports2.FastFowardIcon = FastFowardIcon;
  exports2.FigmaIcon = FigmaIcon;
  exports2.FileAddIcon = FileAddIcon;
  exports2.FileIcon = FileIcon;
  exports2.FileSyncIcon = FileSyncIcon;
  exports2.Filter2Icon = Filter2Icon;
  exports2.FilterCancel2Icon = FilterCancel2Icon;
  exports2.FilterCancelIcon = FilterCancelIcon;
  exports2.FilterIcon = FilterIcon;
  exports2.Flag2Icon = Flag2Icon;
  exports2.FlagIcon = FlagIcon;
  exports2.FlashlightIcon = FlashlightIcon;
  exports2.FoldableHorizontalHalfIcon = FoldableHorizontalHalfIcon;
  exports2.FoldableHorizontalIcon = FoldableHorizontalIcon;
  exports2.FoldableVerticalHalfIcon = FoldableVerticalHalfIcon;
  exports2.FoldableVerticalIcon = FoldableVerticalIcon;
  exports2.FolderAddIcon = FolderAddIcon;
  exports2.FolderIcon = FolderIcon;
  exports2.FolderOpenIcon = FolderOpenIcon;
  exports2.FullScreenMaximizeIcon = FullScreenMaximizeIcon;
  exports2.FullScreenMinimizeIcon = FullScreenMinimizeIcon;
  exports2.GameIcon = GameIcon;
  exports2.GiftIcon = GiftIcon;
  exports2.GitCommitIcon = GitCommitIcon;
  exports2.GithubIcon = GithubIcon;
  exports2.GitlabIcon = GitlabIcon;
  exports2.GlobeIcon = GlobeIcon;
  exports2.Google2Icon = Google2Icon;
  exports2.GoogleChromeIcon = GoogleChromeIcon;
  exports2.GoogleIcon = GoogleIcon;
  exports2.GooglePlayIcon = GooglePlayIcon;
  exports2.GraphIcon = GraphIcon;
  exports2.GridDotsIcon = GridDotsIcon;
  exports2.GridIcon = GridIcon;
  exports2.HamburgerIcon = HamburgerIcon;
  exports2.HandIcon = HandIcon;
  exports2.HardDriveIcon = HardDriveIcon;
  exports2.HashIcon = HashIcon;
  exports2.HatGraduationIcon = HatGraduationIcon;
  exports2.HeadphonesIcon = HeadphonesIcon;
  exports2.HeadphonesOffIcon = HeadphonesOffIcon;
  exports2.HeartIcon = HeartIcon;
  exports2.HeartStylisticIcon = HeartStylisticIcon;
  exports2.HexagonIcon = HexagonIcon;
  exports2.HighlighterAccentIcon = HighlighterAccentIcon;
  exports2.HighlighterIcon = HighlighterIcon;
  exports2.HistoryIcon = HistoryIcon;
  exports2.Home2Icon = Home2Icon;
  exports2.HomeIcon = HomeIcon;
  exports2.HourglassIcon = HourglassIcon;
  exports2.HtmlIcon = HtmlIcon;
  exports2.InfinityIcon = InfinityIcon;
  exports2.InfoIcon = InfoIcon;
  exports2.InstagramIcon = InstagramIcon;
  exports2.JavascriptIcon = JavascriptIcon;
  exports2.KeyboardCommandIcon = KeyboardCommandIcon;
  exports2.KeyboardIcon = KeyboardIcon;
  exports2.KeyboardShiftIcon = KeyboardShiftIcon;
  exports2.LaptopIcon = LaptopIcon;
  exports2.LayersIcon = LayersIcon;
  exports2.LayoutIcon = LayoutIcon;
  exports2.LeafIcon = LeafIcon;
  exports2.LeafThreeIcon = LeafThreeIcon;
  exports2.LeafTwoIcon = LeafTwoIcon;
  exports2.LibraryIcon = LibraryIcon;
  exports2.LightbulbIcon = LightbulbIcon;
  exports2.LineDiagonalIcon = LineDiagonalIcon;
  exports2.LinkIcon = LinkIcon;
  exports2.LinuxIcon = LinuxIcon;
  exports2.LocationIcon = LocationIcon;
  exports2.LockIcon = LockIcon;
  exports2.LockOpenIcon = LockOpenIcon;
  exports2.MailIcon = MailIcon;
  exports2.MailOpenIcon = MailOpenIcon;
  exports2.MapIcon = MapIcon;
  exports2.MaskIcon = MaskIcon;
  exports2.MathIcon = MathIcon;
  exports2.MegaphoneIcon = MegaphoneIcon;
  exports2.MegaphoneLoudIcon = MegaphoneLoudIcon;
  exports2.MentionIcon = MentionIcon;
  exports2.MenuIcon = MenuIcon;
  exports2.MicrophoneIcon = MicrophoneIcon;
  exports2.MicrophoneOffIcon = MicrophoneOffIcon;
  exports2.MicrosoftEdgeIcon = MicrosoftEdgeIcon;
  exports2.MicrosoftIcon = MicrosoftIcon;
  exports2.MoonIcon = MoonIcon;
  exports2.MoreIcon = MoreIcon;
  exports2.MoreVerticalIcon = MoreVerticalIcon;
  exports2.MotherboardIcon = MotherboardIcon;
  exports2.MovieIcon = MovieIcon;
  exports2.MuseumIcon = MuseumIcon;
  exports2.MusicNote2Icon = MusicNote2Icon;
  exports2.MusicNoteIcon = MusicNoteIcon;
  exports2.NarratorIcon = NarratorIcon;
  exports2.NodejsIcon = NodejsIcon;
  exports2.NoteAddIcon = NoteAddIcon;
  exports2.NoteIcon = NoteIcon;
  exports2.NpmIcon = NpmIcon;
  exports2.OctagonIcon = OctagonIcon;
  exports2.OpenIcon = OpenIcon;
  exports2.OpenSourceIcon = OpenSourceIcon;
  exports2.PageMarginsIcon = PageMarginsIcon;
  exports2.PaintBucketAccentIcon = PaintBucketAccentIcon;
  exports2.PaintBucketIcon = PaintBucketIcon;
  exports2.Paintbrush2Icon = Paintbrush2Icon;
  exports2.PaintbrushIcon = PaintbrushIcon;
  exports2.PanelLeftContractIcon = PanelLeftContractIcon;
  exports2.PanelLeftExpandIcon = PanelLeftExpandIcon;
  exports2.PanelLeftIcon = PanelLeftIcon;
  exports2.PanelLeftOpenIcon = PanelLeftOpenIcon;
  exports2.PanelRightContractIcon = PanelRightContractIcon;
  exports2.PanelRightExpandIcon = PanelRightExpandIcon;
  exports2.PanelRightIcon = PanelRightIcon;
  exports2.PanelRightOpenIcon = PanelRightOpenIcon;
  exports2.PauseIcon = PauseIcon;
  exports2.Pdf2Icon = Pdf2Icon;
  exports2.PdfIcon = PdfIcon;
  exports2.PencilIcon = PencilIcon;
  exports2.PentagonIcon = PentagonIcon;
  exports2.Person2Icon = Person2Icon;
  exports2.PersonAdd2Icon = PersonAdd2Icon;
  exports2.PersonAddIcon = PersonAddIcon;
  exports2.PersonCircleIcon = PersonCircleIcon;
  exports2.PersonIcon = PersonIcon;
  exports2.PersonMultipleIcon = PersonMultipleIcon;
  exports2.PhoneAcceptIcon = PhoneAcceptIcon;
  exports2.PhoneHangUpIcon = PhoneHangUpIcon;
  exports2.PhoneIcon = PhoneIcon;
  exports2.PhotoFilterIcon = PhotoFilterIcon;
  exports2.PhotoIcon = PhotoIcon;
  exports2.PictureInPicture2Icon = PictureInPicture2Icon;
  exports2.PictureInPictureEnterIcon = PictureInPictureEnterIcon;
  exports2.PictureInPictureExitIcon = PictureInPictureExitIcon;
  exports2.PictureInPictureIcon = PictureInPictureIcon;
  exports2.PinIcon = PinIcon;
  exports2.PinOffIcon = PinOffIcon;
  exports2.PlayCircularIcon = PlayCircularIcon;
  exports2.PlayIcon = PlayIcon;
  exports2.PlusIcon = AddIcon;
  exports2.PrinterIcon = PrinterIcon;
  exports2.ProhibitedIcon = ProhibitedIcon;
  exports2.PythonIcon = PythonIcon;
  exports2.QrCodeIcon = QrCodeIcon;
  exports2.QuestionCircleIcon = QuestionCircleIcon;
  exports2.QuestionIcon = QuestionIcon;
  exports2.QuoteIcon = QuoteIcon;
  exports2.ReactjsIcon = ReactjsIcon;
  exports2.RecordIcon = RecordIcon;
  exports2.RecordStopIcon = RecordStopIcon;
  exports2.RectangleWideIcon = RectangleWideIcon;
  exports2.RegularExpressionIcon = RegularExpressionIcon;
  exports2.ReverseIcon = ReverseIcon;
  exports2.RhombusIcon = RhombusIcon;
  exports2.RibbonIcon = RibbonIcon;
  exports2.RibbonStarIcon = RibbonStarIcon;
  exports2.RobloxIcon = RobloxIcon;
  exports2.RulerDiagonalIcon = RulerDiagonalIcon;
  exports2.RulerIcon = RulerIcon;
  exports2.SaveAsIcon = SaveAsIcon;
  exports2.SaveIcon = SaveIcon;
  exports2.ScreenSizeIcon = ScreenSizeIcon;
  exports2.Script2Icon = Script2Icon;
  exports2.ScriptIcon = ScriptIcon;
  exports2.SearchCancelIcon = SearchCancelIcon;
  exports2.SearchIcon = SearchIcon;
  exports2.SectionBreakIcon = SectionBreakIcon;
  exports2.SendIcon = SendIcon;
  exports2.ServerIcon = ServerIcon;
  exports2.SettingsIcon = SettingsIcon;
  exports2.ShapeDifferenceIcon = ShapeDifferenceIcon;
  exports2.ShapeIntersectIcon = ShapeIntersectIcon;
  exports2.ShapeSubtractIcon = ShapeSubtractIcon;
  exports2.ShapeUnionIcon = ShapeUnionIcon;
  exports2.ShieldCancelIcon = ShieldCancelIcon;
  exports2.ShieldCheckmarkIcon = ShieldCheckmarkIcon;
  exports2.ShieldIcon = ShieldIcon;
  exports2.ShieldKeyholeIcon = ShieldKeyholeIcon;
  exports2.SkullIcon = SkullIcon;
  exports2.SlashBoxIcon = SlashBoxIcon;
  exports2.SoundwaveIcon = SoundwaveIcon;
  exports2.SpacebarIcon = SpacebarIcon;
  exports2.SparkleIcon = SparkleIcon;
  exports2.SpinnerIcon = SpinnerIcon;
  exports2.SquareIcon = SquareIcon;
  exports2.StarIcon = StarIcon;
  exports2.StrokeThicknessIcon = StrokeThicknessIcon;
  exports2.SubtractIcon = SubtractIcon;
  exports2.SvelteIcon = SvelteIcon;
  exports2.SymbolsIcon = SymbolsIcon;
  exports2.TableIcon = TableIcon;
  exports2.TableSimpleIcon = TableSimpleIcon;
  exports2.TabletIcon = TabletIcon;
  exports2.TagAccentIcon = TagAccentIcon;
  exports2.TagIcon = TagIcon;
  exports2.TagMultipleIcon = TagMultipleIcon;
  exports2.TagMultipleVarIcon = TagMultipleIcon;
  exports2.TaskListIcon = TaskListIcon;
  exports2.TerminalIcon = TerminalIcon;
  exports2.TextAddIcon = TextAddIcon;
  exports2.TextAlignCenterIcon = TextAlignCenterIcon;
  exports2.TextAlignJustifyIcon = TextAlignJustifyIcon;
  exports2.TextAlignLeftIcon = TextAlignLeftIcon;
  exports2.TextAlignRightIcon = TextAlignRightIcon;
  exports2.TextBoldIcon = TextBoldIcon;
  exports2.TextBulletListIcon = TextBulletListIcon;
  exports2.TextBulletListSquareAddIcon = TextBulletListSquareAddIcon;
  exports2.TextBulletListSquareIcon = TextBulletListSquareIcon;
  exports2.TextCaseLowercaseIcon = TextCaseLowercaseIcon;
  exports2.TextCaseTitleIcon = TextCaseTitleIcon;
  exports2.TextCaseUppercaseIcon = TextCaseUppercaseIcon;
  exports2.TextClearFormattingIcon = TextClearFormattingIcon;
  exports2.TextCollapseIcon = TextCollapseIcon;
  exports2.TextColorAccentIcon = TextColorAccentIcon;
  exports2.TextColorIcon = TextColorIcon;
  exports2.TextEditStyleIcon = TextEditStyleIcon;
  exports2.TextEffectsIcon = TextEffectsIcon;
  exports2.TextExpandIcon = TextExpandIcon;
  exports2.TextFontIcon = TextFontIcon;
  exports2.TextFontSizeIcon = TextFontSizeIcon;
  exports2.TextFootnoteIcon = TextFootnoteIcon;
  exports2.TextHighlightColorAccentIcon = TextHighlightColorAccentIcon;
  exports2.TextHighlightColorIcon = TextHighlightColorIcon;
  exports2.TextIcon = TextIcon;
  exports2.TextIndentDecreaseIcon = TextIndentDecreaseIcon;
  exports2.TextIndentIncreaseIcon = TextIndentIncreaseIcon;
  exports2.TextItalicIcon = TextItalicIcon;
  exports2.TextLargeIcon = TextLargeIcon;
  exports2.TextLetterSpacingIcon = TextLetterSpacingIcon;
  exports2.TextLineHeightIcon = TextLineHeightIcon;
  exports2.TextLineSpacingIcon = TextLineSpacingIcon;
  exports2.TextNumberListIcon = TextNumberListIcon;
  exports2.TextPositionBottomIcon = TextPositionBottomIcon;
  exports2.TextPositionMiddleIcon = TextPositionMiddleIcon;
  exports2.TextPositionTopIcon = TextPositionTopIcon;
  exports2.TextSmallIcon = TextSmallIcon;
  exports2.TextStrikethroughIcon = TextStrikethroughIcon;
  exports2.TextSubscriptIcon = TextSubscriptIcon;
  exports2.TextSuperscriptIcon = TextSuperscriptIcon;
  exports2.TextTypographyIcon = TextTypographyIcon;
  exports2.TextUnderlineIcon = TextUnderlineIcon;
  exports2.ThumbsDownIcon = ThumbsDownIcon;
  exports2.ThumbsUpIcon = ThumbsUpIcon;
  exports2.TiktokIcon = TiktokIcon;
  exports2.TimerIcon = TimerIcon;
  exports2.ToolboxIcon = ToolboxIcon;
  exports2.TriangleIcon = TriangleIcon;
  exports2.TuneIcon = TuneIcon;
  exports2.TvIcon = TvIcon;
  exports2.TwitterIcon = XTwitterIcon;
  exports2.TypescriptIcon = TypescriptIcon;
  exports2.UbuntuIcon = UbuntuIcon;
  exports2.VehicleCarIcon = VehicleCarIcon;
  exports2.VideoClipIcon = VideoClipIcon;
  exports2.VideoIcon = VideoIcon;
  exports2.VisualStudioCodeIcon = VisualStudioCodeIcon;
  exports2.Volume0Icon = Volume0Icon;
  exports2.Volume1Icon = Volume1Icon;
  exports2.VolumeIcon = VolumeIcon;
  exports2.VolumeMuteIcon = VolumeMuteIcon;
  exports2.VuejsIcon = VuejsIcon;
  exports2.WatchIcon = WatchIcon;
  exports2.WeatherCloudyIcon = WeatherCloudyIcon;
  exports2.WebpackIcon = WebpackIcon;
  exports2.WiFiIcon = WiFiIcon;
  exports2.WindowIcon = WindowIcon;
  exports2.WindowMultipleIcon = WindowMultipleIcon;
  exports2.WindowMultipleVarIcon = WindowMultipleIcon;
  exports2.WrenchIcon = WrenchIcon;
  exports2.XIcon = CancelIcon;
  exports2.XTwitterIcon = XTwitterIcon;
  exports2.YoutubeIcon = YoutubeIcon;
  exports2.YoutubeShortsIcon = YoutubeShortsIcon;
  exports2.ZoomInIcon = ZoomInIcon;
  exports2.ZoomOutIcon = ZoomOutIcon;
  exports2.accessibility = AccessibilityIcon;
  exports2.add = AddIcon;
  exports2.addCircular = AddCircularIcon;
  exports2.addRhombus = AddRhombusIcon;
  exports2.addSquare = AddSquareIcon;
  exports2.addSquareMultiple = AddSquareMultipleIcon;
  exports2.addSquareMultipleVar = AddSquareMultipleIcon;
  exports2.addition = AddIcon;
  exports2.airplane = AirplaneIcon;
  exports2.airplaneLanding = AirplaneLandingIcon;
  exports2.airplaneTakeoff = AirplaneTakeoffIcon;
  exports2.alertCircle = AlertCircleIcon;
  exports2.alertTriangle = AlertTriangleIcon;
  exports2.alignBottom = AlignBottomIcon;
  exports2.alignHorizontalCenters = AlignHorizontalCentersIcon;
  exports2.alignLeft = AlignLeftIcon;
  exports2.alignRight = AlignRightIcon;
  exports2.alignTop = AlignTopIcon;
  exports2.alignVerticalCenters = AlignVerticalCentersIcon;
  exports2.amazon = AmazonIcon;
  exports2.anchor = AnchorIcon;
  exports2.android = AndroidIcon;
  exports2.angle = AngleIcon;
  exports2.appRemove = AppRemoveIcon;
  exports2.appStore = AppStoreIcon;
  exports2.apple = AppleIcon;
  exports2.apps = AppsIcon;
  exports2.appsAdd = AppsAddIcon;
  exports2.appsList = AppsListIcon;
  exports2.arc = ArcIcon;
  exports2.archive = ArchiveIcon;
  exports2.archiveAdd2 = ArchiveAdd2Icon;
  exports2.arrowClockwise = ArrowClockwiseIcon;
  exports2.arrowCounterclockwise = ArrowCounterclockwiseIcon;
  exports2.arrowDown = ArrowDownIcon;
  exports2.arrowDownload = ArrowDownloadIcon;
  exports2.arrowEnter = ArrowEnterIcon;
  exports2.arrowExport = ArrowExportIcon;
  exports2.arrowFoward = ArrowFowardIcon;
  exports2.arrowImport = ArrowImportIcon;
  exports2.arrowLeft = ArrowLeftIcon;
  exports2.arrowLeftRight = ArrowLeftRightIcon;
  exports2.arrowMaximize = ArrowMaximizeIcon;
  exports2.arrowMinimize = ArrowMinimizeIcon;
  exports2.arrowMove = ArrowMoveIcon;
  exports2.arrowRedo = ArrowRedoIcon;
  exports2.arrowRedo2 = ArrowRedo2Icon;
  exports2.arrowReply = ArrowReplyIcon;
  exports2.arrowRight = ArrowRightIcon;
  exports2.arrowRotateClockwise = ArrowRotateClockwiseIcon;
  exports2.arrowRotateCounterclockwise = ArrowRotateCounterclockwiseIcon;
  exports2.arrowSort = ArrowSortIcon;
  exports2.arrowSwap = ArrowSwapIcon;
  exports2.arrowSync = ArrowSyncIcon;
  exports2.arrowSync2 = ArrowSync2Icon;
  exports2.arrowTrending = ArrowTrendingIcon;
  exports2.arrowUndo = ArrowUndoIcon;
  exports2.arrowUndo2 = ArrowUndo2Icon;
  exports2.arrowUp = ArrowUpIcon;
  exports2.arrowUpDown = ArrowUpDownIcon;
  exports2.arrowUpload = ArrowUploadIcon;
  exports2.attatch = AttatchIcon;
  exports2.backgroundColor = BackgroundColorIcon;
  exports2.backgroundColorAccent = BackgroundColorAccentIcon;
  exports2.backspace = BackspaceIcon;
  exports2.badge = BadgeIcon;
  exports2.barGraph = BarGraphIcon;
  exports2.battery = BatteryIcon;
  exports2.batteryFull = BatteryFullIcon;
  exports2.beach = BeachIcon;
  exports2.beaker = BeakerIcon;
  exports2.bell = BellIcon;
  exports2.bellDot = BellDotIcon;
  exports2.bellOff = BellOffIcon;
  exports2.bluetooth = BluetoothIcon;
  exports2.board = BoardIcon;
  exports2.bolt = BoltIcon;
  exports2.book = BookIcon;
  exports2.book2 = Book2Icon;
  exports2.bookAdd = BookAddIcon;
  exports2.bookAdd2 = BookAdd2Icon;
  exports2.bookInfo = BookInfoIcon;
  exports2.bookInfo2 = BookInfo2Icon;
  exports2.bookOpen = BookOpenIcon;
  exports2.bookmark = BookmarkIcon;
  exports2.bookmarkAdd = BookmarkAddIcon;
  exports2.bookmarkMultiple = BookmarkMultipleIcon;
  exports2.bookmarkMultipleVar = BookmarkMultipleIcon;
  exports2.borderAll = BorderAllIcon;
  exports2.box = BoxIcon;
  exports2.boxDrag = BoxDragIcon;
  exports2.boxMargins = BoxMarginsIcon;
  exports2.braces = BracesIcon;
  exports2.bracesVariable = BracesVariableIcon;
  exports2.brackets = BracketsIcon;
  exports2.branch = BranchIcon;
  exports2.branchCompare = BranchCompareIcon;
  exports2.branchFork = BranchForkIcon;
  exports2.branchFork2 = BranchFork2Icon;
  exports2.branchPullRequest = BranchPullRequestIcon;
  exports2.briefcase = BriefcaseIcon;
  exports2.briefcase2 = Briefcase2Icon;
  exports2.brightness = BrightnessIcon;
  exports2.broom = BroomIcon;
  exports2.bug = BugIcon;
  exports2.buildingMultiple = BuildingMultipleIcon;
  exports2.button = ButtonIcon;
  exports2.cake = CakeIcon;
  exports2.calculator = CalculatorIcon;
  exports2.calendar = CalendarIcon;
  exports2.calligraphyPen = CalligraphyPenIcon;
  exports2.camera = CameraIcon;
  exports2.cancel = CancelIcon;
  exports2.cancelCircle = CancelCircleIcon;
  exports2.cancelSquare = CancelSquareIcon;
  exports2.candy = CandyIcon;
  exports2.cart = CartIcon;
  exports2.categories = categories;
  exports2.cent = CentIcon;
  exports2.centerHorizontal = CenterHorizontalIcon;
  exports2.centerVertical = CenterVerticalIcon;
  exports2.chat = ChatIcon;
  exports2.checkboxChecked = CheckboxCheckedIcon;
  exports2.checkboxIndeterminate = CheckboxIndeterminateIcon;
  exports2.checkboxIndeterminate2 = CheckboxIndeterminate2Icon;
  exports2.checkboxIntermediate2 = CheckboxIndeterminate2Icon;
  exports2.checkboxUnchecked = CheckboxUncheckedIcon;
  exports2.checkmark = CheckmarkIcon;
  exports2.checkmarkChecked = CheckboxCheckedIcon;
  exports2.checkmarkCircle = CheckmarkCircleIcon;
  exports2.checkmarkIntermediate = CheckboxIndeterminateIcon;
  exports2.checkmarkStarburst = CheckmarkStarburstIcon;
  exports2.chevronDown = ChevronDownIcon;
  exports2.chevronLeft = ChevronLeftIcon;
  exports2.chevronRight = ChevronRightIcon;
  exports2.chevronUp = ChevronUpIcon;
  exports2.chromeRestore = ChromeRestoreIcon;
  exports2.chromeRestoreVar = ChromeRestoreIcon;
  exports2.circle = CircleIcon;
  exports2.circleSmall = CircleSmallIcon;
  exports2.clipboard = ClipboardIcon;
  exports2.clipboardPaste = ClipboardPasteIcon;
  exports2.clipboardSearch = ClipboardSearchIcon;
  exports2.clock = ClockIcon;
  exports2.close = CancelIcon;
  exports2.closedCaptions = ClosedCaptionsIcon;
  exports2.cloud = CloudIcon;
  exports2.code = CodeIcon;
  exports2.coffeeHot = CoffeeHotIcon;
  exports2.colorPalette = ColorPaletteIcon;
  exports2.comment = CommentIcon;
  exports2.commentExclamation = CommentExclamationIcon;
  exports2.commentMultiple = CommentMultipleIcon;
  exports2.commentMultipleVar = CommentMultipleIcon;
  exports2.compareSize = CompareSizeIcon;
  exports2.compass = CompassIcon;
  exports2.component = ComponentIcon;
  exports2.compose = ComposeIcon;
  exports2.computer = ComputerIcon;
  exports2.computerMac = ComputerMacIcon;
  exports2.contractDown = ContractDownIcon;
  exports2.cookies = CookiesIcon;
  exports2.copy = CopyIcon;
  exports2.copyVar = CopyIcon;
  exports2.copyleft = CopyleftIcon;
  exports2.copyright = CopyrightIcon;
  exports2.cornerRadius = CornerRadiusIcon;
  exports2.create = AddIcon;
  exports2.creditCard = CreditCardIcon;
  exports2.crop = CropIcon;
  exports2.css = CssIcon;
  exports2.cursor = CursorIcon;
  exports2.cursorClick = CursorClickIcon;
  exports2.cursorDrag = CursorDragIcon;
  exports2.cut = CutIcon;
  exports2.darkTheme = DarkThemeIcon;
  exports2.database = DatabaseIcon;
  exports2.databaseAdd = DatabaseAddIcon;
  exports2.delete = DeleteIcon;
  exports2.diamond = DiamondIcon;
  exports2.directions = DirectionsIcon;
  exports2.dismiss = CancelIcon;
  exports2.doNotDisturb = DoNotDisturbIcon;
  exports2.document = DocumentIcon;
  exports2.dollar = DollarIcon;
  exports2.dollarCircle = DollarCircleIcon;
  exports2.door = DoorIcon;
  exports2.doorOpen = DoorOpenIcon;
  exports2.drawText = DrawTextIcon;
  exports2.drop = DropIcon;
  exports2.emoji = EmojiIcon;
  exports2.emojiFrown = EmojiFrownIcon;
  exports2.emojiGrin = EmojiGrinIcon;
  exports2.emojiLaughter = EmojiLaughterIcon;
  exports2.eraser = EraserIcon;
  exports2.expand = ExpandIcon;
  exports2.extension = ExtensionIcon;
  exports2.eye = EyeIcon;
  exports2.eyeOff = EyeOffIcon;
  exports2.eyedropper = EyedropperIcon;
  exports2.eyedropperColor = EyedropperColorIcon;
  exports2.eyedropperColorAccent = EyedropperColorAccentIcon;
  exports2.facebook = FacebookIcon;
  exports2.fastFoward = FastFowardIcon;
  exports2.figma = FigmaIcon;
  exports2.file = FileIcon;
  exports2.fileAdd = FileAddIcon;
  exports2.fileSync = FileSyncIcon;
  exports2.filter = FilterIcon;
  exports2.filter2 = Filter2Icon;
  exports2.filterCancel = FilterCancelIcon;
  exports2.filterCancel2 = FilterCancel2Icon;
  exports2.flag = FlagIcon;
  exports2.flag2 = Flag2Icon;
  exports2.flashlight = FlashlightIcon;
  exports2.foldableHorizontal = FoldableHorizontalIcon;
  exports2.foldableHorizontalHalf = FoldableHorizontalHalfIcon;
  exports2.foldableVertical = FoldableVerticalIcon;
  exports2.foldableVerticalHalf = FoldableVerticalHalfIcon;
  exports2.folder = FolderIcon;
  exports2.folderAdd = FolderAddIcon;
  exports2.folderOpen = FolderOpenIcon;
  exports2.fullScreenMaximize = FullScreenMaximizeIcon;
  exports2.fullScreenMinimize = FullScreenMinimizeIcon;
  exports2.game = GameIcon;
  exports2.getIconInfo = getIconInfo;
  exports2.gift = GiftIcon;
  exports2.gitCommit = GitCommitIcon;
  exports2.github = GithubIcon;
  exports2.gitlab = GitlabIcon;
  exports2.globe = GlobeIcon;
  exports2.google = GoogleIcon;
  exports2.google2 = Google2Icon;
  exports2.googleChrome = GoogleChromeIcon;
  exports2.googlePlay = GooglePlayIcon;
  exports2.graph = GraphIcon;
  exports2.grid = GridIcon;
  exports2.gridDots = GridDotsIcon;
  exports2.hamburger = HamburgerIcon;
  exports2.hand = HandIcon;
  exports2.hardDrive = HardDriveIcon;
  exports2.hash = HashIcon;
  exports2.hatGraduation = HatGraduationIcon;
  exports2.headphones = HeadphonesIcon;
  exports2.headphonesOff = HeadphonesOffIcon;
  exports2.heart = HeartIcon;
  exports2.heartStylistic = HeartStylisticIcon;
  exports2.hexagon = HexagonIcon;
  exports2.highlighter = HighlighterIcon;
  exports2.highlighterAccent = HighlighterAccentIcon;
  exports2.history = HistoryIcon;
  exports2.home = HomeIcon;
  exports2.home2 = Home2Icon;
  exports2.hourglass = HourglassIcon;
  exports2.html = HtmlIcon;
  exports2.iconList = iconList;
  exports2.icons = icons;
  exports2.infinity = InfinityIcon;
  exports2.info = InfoIcon;
  exports2.instagram = InstagramIcon;
  exports2.javascript = JavascriptIcon;
  exports2.keyboard = KeyboardIcon;
  exports2.keyboardCommand = KeyboardCommandIcon;
  exports2.keyboardShift = KeyboardShiftIcon;
  exports2.laptop = LaptopIcon;
  exports2.layers = LayersIcon;
  exports2.layout = LayoutIcon;
  exports2.leaf = LeafIcon;
  exports2.leafThree = LeafThreeIcon;
  exports2.leafTwo = LeafTwoIcon;
  exports2.library = LibraryIcon;
  exports2.lightbulb = LightbulbIcon;
  exports2.lineDiagonal = LineDiagonalIcon;
  exports2.link = LinkIcon;
  exports2.linux = LinuxIcon;
  exports2.location = LocationIcon;
  exports2.lock = LockIcon;
  exports2.lockOpen = LockOpenIcon;
  exports2.mail = MailIcon;
  exports2.mailOpen = MailOpenIcon;
  exports2.map = MapIcon;
  exports2.mask = MaskIcon;
  exports2.math = MathIcon;
  exports2.megaphone = MegaphoneIcon;
  exports2.megaphoneLoud = MegaphoneLoudIcon;
  exports2.mention = MentionIcon;
  exports2.menu = MenuIcon;
  exports2.microphone = MicrophoneIcon;
  exports2.microphoneOff = MicrophoneOffIcon;
  exports2.microsoft = MicrosoftIcon;
  exports2.microsoftEdge = MicrosoftEdgeIcon;
  exports2.moon = MoonIcon;
  exports2.more = MoreIcon;
  exports2.moreVertical = MoreVerticalIcon;
  exports2.motherboard = MotherboardIcon;
  exports2.movie = MovieIcon;
  exports2.museum = MuseumIcon;
  exports2.musicNote = MusicNoteIcon;
  exports2.musicNote2 = MusicNote2Icon;
  exports2.narrator = NarratorIcon;
  exports2.nodejs = NodejsIcon;
  exports2.note = NoteIcon;
  exports2.noteAdd = NoteAddIcon;
  exports2.npm = NpmIcon;
  exports2.octagon = OctagonIcon;
  exports2.open = OpenIcon;
  exports2.openSource = OpenSourceIcon;
  exports2.pageMargins = PageMarginsIcon;
  exports2.paintBucket = PaintBucketIcon;
  exports2.paintBucketAccent = PaintBucketAccentIcon;
  exports2.paintbrush = PaintbrushIcon;
  exports2.paintbrush2 = Paintbrush2Icon;
  exports2.panelLeft = PanelLeftIcon;
  exports2.panelLeftContract = PanelLeftContractIcon;
  exports2.panelLeftExpand = PanelLeftExpandIcon;
  exports2.panelLeftOpen = PanelLeftOpenIcon;
  exports2.panelRight = PanelRightIcon;
  exports2.panelRightContract = PanelRightContractIcon;
  exports2.panelRightExpand = PanelRightExpandIcon;
  exports2.panelRightOpen = PanelRightOpenIcon;
  exports2.pause = PauseIcon;
  exports2.pdf = PdfIcon;
  exports2.pdf2 = Pdf2Icon;
  exports2.pencil = PencilIcon;
  exports2.pentagon = PentagonIcon;
  exports2.person = PersonIcon;
  exports2.person2 = Person2Icon;
  exports2.personAdd = PersonAddIcon;
  exports2.personAdd2 = PersonAdd2Icon;
  exports2.personCircle = PersonCircleIcon;
  exports2.personMultiple = PersonMultipleIcon;
  exports2.phone = PhoneIcon;
  exports2.phoneAccept = PhoneAcceptIcon;
  exports2.phoneHangUp = PhoneHangUpIcon;
  exports2.photo = PhotoIcon;
  exports2.photoFilter = PhotoFilterIcon;
  exports2.pictureInPicture = PictureInPictureIcon;
  exports2.pictureInPicture2 = PictureInPicture2Icon;
  exports2.pictureInPictureEnter = PictureInPictureEnterIcon;
  exports2.pictureInPictureExit = PictureInPictureExitIcon;
  exports2.pin = PinIcon;
  exports2.pinOff = PinOffIcon;
  exports2.play = PlayIcon;
  exports2.playCircular = PlayCircularIcon;
  exports2.plus = AddIcon;
  exports2.printer = PrinterIcon;
  exports2.prohibited = ProhibitedIcon;
  exports2.python = PythonIcon;
  exports2.qrCode = QrCodeIcon;
  exports2.question = QuestionIcon;
  exports2.questionCircle = QuestionCircleIcon;
  exports2.quote = QuoteIcon;
  exports2.reactjs = ReactjsIcon;
  exports2.record = RecordIcon;
  exports2.recordStop = RecordStopIcon;
  exports2.rectangleWide = RectangleWideIcon;
  exports2.regularExpression = RegularExpressionIcon;
  exports2.replace = replace;
  exports2.reverse = ReverseIcon;
  exports2.rhombus = RhombusIcon;
  exports2.ribbon = RibbonIcon;
  exports2.ribbonStar = RibbonStarIcon;
  exports2.roblox = RobloxIcon;
  exports2.ruler = RulerIcon;
  exports2.rulerDiagonal = RulerDiagonalIcon;
  exports2.save = SaveIcon;
  exports2.saveAs = SaveAsIcon;
  exports2.screenSize = ScreenSizeIcon;
  exports2.script = ScriptIcon;
  exports2.script2 = Script2Icon;
  exports2.search = search;
  exports2.searchCancel = SearchCancelIcon;
  exports2.sectionBreak = SectionBreakIcon;
  exports2.send = SendIcon;
  exports2.server = ServerIcon;
  exports2.settings = SettingsIcon;
  exports2.shapeDifference = ShapeDifferenceIcon;
  exports2.shapeIntersect = ShapeIntersectIcon;
  exports2.shapeSubtract = ShapeSubtractIcon;
  exports2.shapeUnion = ShapeUnionIcon;
  exports2.shield = ShieldIcon;
  exports2.shieldCancel = ShieldCancelIcon;
  exports2.shieldCheckmark = ShieldCheckmarkIcon;
  exports2.shieldKeyhole = ShieldKeyholeIcon;
  exports2.skull = SkullIcon;
  exports2.slashBox = SlashBoxIcon;
  exports2.soundwave = SoundwaveIcon;
  exports2.spacebar = SpacebarIcon;
  exports2.sparkle = SparkleIcon;
  exports2.spinner = SpinnerIcon;
  exports2.square = SquareIcon;
  exports2.star = StarIcon;
  exports2.strokeThickness = StrokeThicknessIcon;
  exports2.subtract = SubtractIcon;
  exports2.svelte = SvelteIcon;
  exports2.symbols = SymbolsIcon;
  exports2.table = TableIcon;
  exports2.tableSimple = TableSimpleIcon;
  exports2.tablet = TabletIcon;
  exports2.tag = TagIcon;
  exports2.tagAccent = TagAccentIcon;
  exports2.tagMultiple = TagMultipleIcon;
  exports2.tagMultipleVar = TagMultipleIcon;
  exports2.taskList = TaskListIcon;
  exports2.terminal = TerminalIcon;
  exports2.text = TextIcon;
  exports2.textAdd = TextAddIcon;
  exports2.textAlignCenter = TextAlignCenterIcon;
  exports2.textAlignJustify = TextAlignJustifyIcon;
  exports2.textAlignLeft = TextAlignLeftIcon;
  exports2.textAlignRight = TextAlignRightIcon;
  exports2.textBold = TextBoldIcon;
  exports2.textBulletList = TextBulletListIcon;
  exports2.textBulletListSquare = TextBulletListSquareIcon;
  exports2.textBulletListSquareAdd = TextBulletListSquareAddIcon;
  exports2.textCaseLowercase = TextCaseLowercaseIcon;
  exports2.textCaseTitle = TextCaseTitleIcon;
  exports2.textCaseUppercase = TextCaseUppercaseIcon;
  exports2.textClearFormatting = TextClearFormattingIcon;
  exports2.textCollapse = TextCollapseIcon;
  exports2.textColor = TextColorIcon;
  exports2.textColorAccent = TextColorAccentIcon;
  exports2.textEditStyle = TextEditStyleIcon;
  exports2.textEffects = TextEffectsIcon;
  exports2.textExpand = TextExpandIcon;
  exports2.textFont = TextFontIcon;
  exports2.textFontSize = TextFontSizeIcon;
  exports2.textFootnote = TextFootnoteIcon;
  exports2.textHighlightColor = TextHighlightColorIcon;
  exports2.textHighlightColorAccent = TextHighlightColorAccentIcon;
  exports2.textIndentDecrease = TextIndentDecreaseIcon;
  exports2.textIndentIncrease = TextIndentIncreaseIcon;
  exports2.textItalic = TextItalicIcon;
  exports2.textLarge = TextLargeIcon;
  exports2.textLetterSpacing = TextLetterSpacingIcon;
  exports2.textLineHeight = TextLineHeightIcon;
  exports2.textLineSpacing = TextLineSpacingIcon;
  exports2.textNumberList = TextNumberListIcon;
  exports2.textPositionBottom = TextPositionBottomIcon;
  exports2.textPositionMiddle = TextPositionMiddleIcon;
  exports2.textPositionTop = TextPositionTopIcon;
  exports2.textSmall = TextSmallIcon;
  exports2.textStrikethrough = TextStrikethroughIcon;
  exports2.textSubscript = TextSubscriptIcon;
  exports2.textSuperscript = TextSuperscriptIcon;
  exports2.textTypography = TextTypographyIcon;
  exports2.textUnderline = TextUnderlineIcon;
  exports2.thumbsDown = ThumbsDownIcon;
  exports2.thumbsUp = ThumbsUpIcon;
  exports2.tiktok = TiktokIcon;
  exports2.timer = TimerIcon;
  exports2.toolbox = ToolboxIcon;
  exports2.triangle = TriangleIcon;
  exports2.tune = TuneIcon;
  exports2.tv = TvIcon;
  exports2.twitter = XTwitterIcon;
  exports2.typescript = TypescriptIcon;
  exports2.ubuntu = UbuntuIcon;
  exports2.vehicleCar = VehicleCarIcon;
  exports2.video = VideoIcon;
  exports2.videoClip = VideoClipIcon;
  exports2.visualStudioCode = VisualStudioCodeIcon;
  exports2.volume = VolumeIcon;
  exports2.volume0 = Volume0Icon;
  exports2.volume1 = Volume1Icon;
  exports2.volumeMute = VolumeMuteIcon;
  exports2.vuejs = VuejsIcon;
  exports2.watch = WatchIcon;
  exports2.weatherCloudy = WeatherCloudyIcon;
  exports2.webpack = WebpackIcon;
  exports2.wiFi = WiFiIcon;
  exports2.window = WindowIcon;
  exports2.windowMultiple = WindowMultipleIcon;
  exports2.windowMultipleVar = WindowMultipleIcon;
  exports2.wrench = WrenchIcon;
  exports2.x = CancelIcon;
  exports2.xTwitter = XTwitterIcon;
  exports2.youtube = YoutubeIcon;
  exports2.youtubeShorts = YoutubeShortsIcon;
  exports2.zoomIn = ZoomInIcon;
  exports2.zoomOut = ZoomOutIcon;
  Object.defineProperty(exports2, Symbol.toStringTag, { value: "Module" });
});
